/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.pointers.FacetPointersManagerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetPointerImpl<F extends Facet>
implements FacetPointer<F> {
    private final FacetPointersManagerImpl myManager;
    private String myModuleName;
    private String myFacetTypeId;
    private String myFacetName;
    private F myFacet;

    public FacetPointerImpl(FacetPointersManagerImpl manager, String id) {
        this.myManager = manager;
        int i2 = id.indexOf(47);
        this.myModuleName = id.substring(0, i2);
        int j = id.lastIndexOf(47);
        this.myFacetTypeId = id.substring(i2 + 1, j);
        this.myFacetName = id.substring(j + 1);
    }

    public FacetPointerImpl(FacetPointersManagerImpl manager, @NotNull F facet) {
        if (facet == null) {
            FacetPointerImpl.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
        this.myFacet = facet;
        this.updateInfo(this.myFacet);
        this.registerDisposable();
    }

    public void refresh() {
        this.findAndSetFacet();
        if (this.myFacet != null) {
            this.updateInfo(this.myFacet);
        }
    }

    private void findAndSetFacet() {
        if (this.myFacet == null) {
            this.myFacet = this.findFacet();
            if (this.myFacet != null) {
                this.registerDisposable();
            }
        }
    }

    private void registerDisposable() {
        Disposer.register(this.myFacet, new Disposable(){

            @Override
            public void dispose() {
                FacetPointerImpl.this.myManager.dispose(FacetPointerImpl.this);
                FacetPointerImpl.this.myFacet = null;
            }
        });
    }

    private void updateInfo(@NotNull F facet) {
        if (facet == null) {
            FacetPointerImpl.$$$reportNull$$$0(1);
        }
        this.myModuleName = facet.getModule().getName();
        this.myFacetTypeId = facet.getType().getStringId();
        this.myFacetName = facet.getName();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myManager.getProject();
        if (project2 == null) {
            FacetPointerImpl.$$$reportNull$$$0(2);
        }
        return project2;
    }

    @Override
    public F getFacet() {
        this.findAndSetFacet();
        return this.myFacet;
    }

    @Nullable
    private F findFacet() {
        Module module2 = ModuleManager.getInstance(this.myManager.getProject()).findModuleByName(this.myModuleName);
        if (module2 == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)FacetManager.getInstance((Module)module2).findFacet(type.getId(), this.myFacetName);
    }

    @Override
    @Nullable
    public F findFacet(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        Module module2;
        if (modulesProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(3);
        }
        if (facetsProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(4);
        }
        if ((module2 = modulesProvider.getModule(this.myModuleName)) == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)facetsProvider.findFacet(module2, type.getId(), this.myFacetName);
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string2 = this.myModuleName;
        if (string2 == null) {
            FacetPointerImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFacetName() {
        String string2 = this.myFacetName;
        if (string2 == null) {
            FacetPointerImpl.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getId() {
        String string2 = FacetPointersManager.constructId(this.myModuleName, this.myFacetTypeId, this.myFacetName);
        if (string2 == null) {
            FacetPointerImpl.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFacetTypeId() {
        String string2 = this.myFacetTypeId;
        if (string2 == null) {
            FacetPointerImpl.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getModuleName(@Nullable ModifiableModuleModel moduleModel) {
        String newName2;
        if (moduleModel != null && this.myFacet != null && (newName2 = moduleModel.getNewName(this.myFacet.getModule())) != null) {
            String string2 = newName2;
            if (string2 == null) {
                FacetPointerImpl.$$$reportNull$$$0(9);
            }
            return string2;
        }
        String string3 = this.myModuleName;
        if (string3 == null) {
            FacetPointerImpl.$$$reportNull$$$0(10);
        }
        return string3;
    }

    @Override
    @NotNull
    public String getFacetName(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        if (modulesProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(11);
        }
        if (facetsProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(12);
        }
        if (this.myFacet != null) {
            String string2 = modulesProvider.getFacetModel(this.myFacet.getModule()).getFacetName(this.myFacet);
            if (string2 == null) {
                FacetPointerImpl.$$$reportNull$$$0(13);
            }
            return string2;
        }
        String string3 = this.myFacetName;
        if (string3 == null) {
            FacetPointerImpl.$$$reportNull$$$0(14);
        }
        return string3;
    }

    @Override
    @Nullable
    public FacetType<F, ?> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetTypeId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9, 10, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/pointers/FacetPointerImpl";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateInfo";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFacet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5, 6, 7, 8, 9, 10, 13, 14 -> new IllegalStateException(string2);
        };
    }
}

