/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.toolWindow.RegisterToolWindowTaskProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class FacetDependentToolWindowManager
implements RegisterToolWindowTaskProvider {
    FacetDependentToolWindowManager() {
    }

    @NotNull
    public Collection<ToolWindowEP> getTasks(@NotNull Project project2) {
        List<FacetDependentToolWindow> facetDependentToolWindows;
        if (project2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(0);
        }
        if ((facetDependentToolWindows = FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList()).isEmpty()) {
            List<ToolWindowEP> list2 = Collections.emptyList();
            if (list2 == null) {
                FacetDependentToolWindowManager.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<ToolWindowEP> result2 = new ArrayList<ToolWindowEP>();
        ProjectFacetManager projectFacetManager = ProjectFacetManager.getInstance(project2);
        block0: for (FacetDependentToolWindow extension2 : facetDependentToolWindows) {
            for (FacetType<?, ?> type : extension2.getFacetTypes()) {
                if (!projectFacetManager.hasFacets(type.getId())) continue;
                result2.add(extension2);
                continue block0;
            }
        }
        FacetDependentToolWindowManager.projectOpened(project2);
        ArrayList<ToolWindowEP> arrayList = result2;
        if (arrayList == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void projectOpened(final @NotNull Project project2) {
        if (project2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(3);
        }
        ProjectWideFacetListenersRegistry.getInstance(project2).registerListener((ProjectWideFacetListener<Facet>)new ProjectWideFacetAdapter<Facet>(){

            @Override
            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.checkIfToolwindowMustBeAdded(facet.getType());
            }

            @Override
            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.checkIfToolwindowMustBeRemoved(facet.getType());
            }

            private void checkIfToolwindowMustBeAdded(FacetType<?, ?> facetType) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (FacetDependentToolWindow extension2 : FacetDependentToolWindowManager.getDependentExtensions(facetType)) {
                        FacetDependentToolWindowManager.ensureToolWindowExists(extension2, project2);
                    }
                }, ModalityState.NON_MODAL, project2.getDisposed());
            }

            private void checkIfToolwindowMustBeRemoved(FacetType<?, ?> removedFacetType) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    ProjectFacetManager facetManager = ProjectFacetManager.getInstance(project2);
                    if (facetManager.hasFacets(removedFacetType.getId())) {
                        return;
                    }
                    ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                    for (FacetDependentToolWindow extension2 : FacetDependentToolWindowManager.getDependentExtensions(removedFacetType)) {
                        ToolWindow toolWindow = toolWindowManager.getToolWindow(extension2.id);
                        if (toolWindow == null) continue;
                        for (FacetType<?, ?> facetType : extension2.getFacetTypes()) {
                            if (!facetManager.hasFacets(facetType.getId())) continue;
                            return;
                        }
                        toolWindow.remove();
                    }
                }, ModalityState.NON_MODAL, project2.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project2);
        FacetDependentToolWindow.EXTENSION_POINT_NAME.addExtensionPointListener(new ExtensionPointListener<FacetDependentToolWindow>(){

            @Override
            public void extensionAdded(@NotNull FacetDependentToolWindow extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                FacetDependentToolWindowManager.initToolWindowIfNeeded(extension2, project2);
            }

            @Override
            public void extensionRemoved(@NotNull FacetDependentToolWindow extension2, @NotNull PluginDescriptor pluginDescriptor) {
                ToolWindow window;
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((window = ToolWindowManager.getInstance((Project)project2).getToolWindow(extension2.id)) != null) {
                    window.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project2);
    }

    private static void initToolWindowIfNeeded(@NotNull FacetDependentToolWindow extension2, @NotNull Project project2) {
        if (extension2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(5);
        }
        ProjectFacetManager projectFacetManager = ProjectFacetManager.getInstance(project2);
        for (FacetType<?, ?> type : extension2.getFacetTypes()) {
            if (!projectFacetManager.hasFacets(type.getId())) continue;
            FacetDependentToolWindowManager.ensureToolWindowExists(extension2, project2);
            return;
        }
    }

    private static void ensureToolWindowExists(@NotNull FacetDependentToolWindow extension2, @NotNull Project project2) {
        ToolWindowManagerEx toolWindowManager;
        ToolWindow toolWindow;
        if (extension2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(7);
        }
        if ((toolWindow = (toolWindowManager = ToolWindowManagerEx.getInstanceEx((Project)project2)).getToolWindow(extension2.id)) == null) {
            WindowInfoImpl windowInfo;
            toolWindowManager.initToolWindow((ToolWindowEP)extension2);
            if (!extension2.showOnStripeByDefault && (toolWindow = toolWindowManager.getToolWindow(extension2.id)) != null && (windowInfo = toolWindowManager.getLayout().getInfo(extension2.id)) != null && !windowInfo.isFromPersistentSettings()) {
                toolWindow.setShowStripeButton(false);
            }
        }
    }

    @NotNull
    private static List<FacetDependentToolWindow> getDependentExtensions(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(8);
        }
        List<FacetDependentToolWindow> list2 = ContainerUtil.filter(FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList(), toolWindowEP -> ArrayUtil.contains(facetType.getStringId(), toolWindowEP.getFacetIds()));
        if (list2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTasks";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "projectOpened";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindowIfNeeded";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowExists";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDependentExtensions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 9 -> new IllegalStateException(string2);
        };
    }
}

