/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetEditorHelper;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public class MultipleFacetEditorHelperImpl
implements MultipleFacetEditorHelper {
    private static final Logger LOG = Logger.getInstance(MultipleFacetSettingsEditor.class);
    private final List<AbstractBinding> myBindings = new ArrayList<AbstractBinding>();

    @Override
    public void bind(@NotNull ThreeStateCheckBox common, FacetEditor @NotNull [] editors2, @NotNull NotNullFunction<? super FacetEditor, ? extends JCheckBox> fun) {
        if (common == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(0);
        }
        if (fun == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(1);
        }
        if (editors2 == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(2);
        }
        ArrayList<JCheckBox> checkBoxesList = new ArrayList<JCheckBox>();
        for (FacetEditor editor2 : editors2) {
            checkBoxesList.add(fun.fun((FacetEditor)editor2));
        }
        CheckBoxBinding checkBoxBinding = new CheckBoxBinding(common, checkBoxesList);
        this.myBindings.add(checkBoxBinding);
    }

    @Override
    public void bind(@NotNull JTextField common, FacetEditor @NotNull [] editors2, @NotNull NotNullFunction<? super FacetEditor, ? extends JTextField> fun) {
        if (common == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(3);
        }
        if (fun == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(4);
        }
        if (editors2 == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(5);
        }
        ArrayList<JTextField> componentsList = new ArrayList<JTextField>();
        for (FacetEditor editor2 : editors2) {
            componentsList.add(fun.fun((FacetEditor)editor2));
        }
        TextFieldBinding binding = new TextFieldBinding(common, componentsList);
        this.myBindings.add(binding);
    }

    @Override
    public void bind(@NotNull JComboBox common, FacetEditor @NotNull [] editors2, @NotNull NotNullFunction<? super FacetEditor, ? extends JComboBox> fun) {
        if (common == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(6);
        }
        if (fun == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(7);
        }
        if (editors2 == null) {
            MultipleFacetEditorHelperImpl.$$$reportNull$$$0(8);
        }
        ArrayList<JComboBox> componentsList = new ArrayList<JComboBox>();
        for (FacetEditor editor2 : editors2) {
            componentsList.add(fun.fun((FacetEditor)editor2));
        }
        CombobBoxBinding binding = new CombobBoxBinding(common, componentsList);
        this.myBindings.add(binding);
    }

    @Override
    public void unbind() {
        for (AbstractBinding binding : this.myBindings) {
            binding.unbind();
        }
        this.myBindings.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "common";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "fun";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "editors";
                break;
            }
        }
        objectArray[1] = "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl";
        objectArray[2] = "bind";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CheckBoxBinding
    extends AbstractBinding
    implements ActionListener {
        private final ThreeStateCheckBox myCommon;
        private final List<? extends JCheckBox> myCheckBoxesList;
        private final List<Boolean> myInitialValues;

        CheckBoxBinding(ThreeStateCheckBox common, List<? extends JCheckBox> checkBoxesList) {
            LOG.assertTrue(!checkBoxesList.isEmpty());
            this.myCommon = common;
            this.myCheckBoxesList = checkBoxesList;
            Boolean initialValue = checkBoxesList.get(0).isSelected();
            this.myInitialValues = new ArrayList<Boolean>();
            for (JCheckBox jCheckBox : checkBoxesList) {
                boolean value = jCheckBox.isSelected();
                this.myInitialValues.add(value);
                if (initialValue == null || value == initialValue) continue;
                initialValue = null;
            }
            if (initialValue != null) {
                common.setThirdStateEnabled(false);
                common.setSelected(initialValue);
            } else {
                common.setThirdStateEnabled(true);
                common.setState(ThreeStateCheckBox.State.DONT_CARE);
            }
            this.myCommon.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThreeStateCheckBox.State state = this.myCommon.getState();
            for (int i2 = 0; i2 < this.myCheckBoxesList.size(); ++i2) {
                JCheckBox checkBox;
                boolean value = state == ThreeStateCheckBox.State.SELECTED ? true : (state == ThreeStateCheckBox.State.NOT_SELECTED ? false : this.myInitialValues.get(i2));
                if (value == (checkBox = this.myCheckBoxesList.get(i2)).isSelected()) continue;
                ButtonModel model2 = checkBox.getModel();
                model2.setArmed(true);
                model2.setPressed(true);
                model2.setPressed(false);
                model2.setArmed(false);
            }
        }

        @Override
        public void unbind() {
            this.myCommon.removeActionListener(this);
        }
    }

    private static final class TextFieldBinding
    extends AbstractBinding {
        private final JTextField myCommon;
        private final List<JTextField> myTextFields;
        private final List<String> myInitialValues;
        private final DocumentAdapter myListener;

        private TextFieldBinding(JTextField common, List<JTextField> textFields) {
            LOG.assertTrue(!textFields.isEmpty());
            this.myCommon = common;
            this.myTextFields = textFields;
            String initialValue = this.myTextFields.get(0).getText();
            this.myInitialValues = new ArrayList<String>();
            for (JTextField field : this.myTextFields) {
                String value = field.getText();
                this.myInitialValues.add(value);
                if (initialValue == null || initialValue.equals(value)) continue;
                initialValue = null;
            }
            common.setText(initialValue != null ? initialValue : "");
            this.myListener = new DocumentAdapter(){

                @Override
                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.textChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl$TextFieldBinding$1", "textChanged"));
                }
            };
            this.myCommon.getDocument().addDocumentListener(this.myListener);
        }

        private void textChanged() {
            String value = this.myCommon.getText();
            for (int i2 = 0; i2 < this.myTextFields.size(); ++i2) {
                this.myTextFields.get(i2).setText(value.length() == 0 ? this.myInitialValues.get(i2) : value);
            }
        }

        @Override
        public void unbind() {
            this.myCommon.getDocument().removeDocumentListener(this.myListener);
        }
    }

    private static class CombobBoxBinding
    extends AbstractBinding
    implements ItemListener {
        private final JComboBox myCommon;
        private final List<? extends JComboBox> myComponentsList;
        private final List<Object> myInitialValues;

        CombobBoxBinding(JComboBox common, List<? extends JComboBox> componentsList) {
            LOG.assertTrue(!componentsList.isEmpty());
            this.myCommon = common;
            this.myComponentsList = componentsList;
            JComboBox first2 = componentsList.get(0);
            Object initialValue = first2.getSelectedItem();
            this.myInitialValues = new ArrayList<Object>();
            for (JComboBox jComboBox : componentsList) {
                Object item = jComboBox.getSelectedItem();
                this.myInitialValues.add(item);
                if (initialValue == null || initialValue.equals(item)) continue;
                initialValue = null;
            }
            common.setSelectedItem(initialValue);
            common.addItemListener(this);
        }

        @Override
        public void unbind() {
            this.myCommon.removeItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object item = this.myCommon.getSelectedItem();
            for (int i2 = 0; i2 < this.myComponentsList.size(); ++i2) {
                this.myComponentsList.get(i2).setSelectedItem(item != null ? item : this.myInitialValues.get(i2));
            }
        }
    }

    private static abstract class AbstractBinding {
        private AbstractBinding() {
        }

        public abstract void unbind();
    }
}

