/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filename;

import com.intellij.openapi.util.text.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class UniqueNameBuilder<T> {
    private static final String VFS_SEPARATOR = "/";
    private final Map<T, String> myPaths = new HashMap<T, String>();
    private final String mySeparator;
    private final String myRoot;
    private final Node myRootNode = new Node("", null);

    public UniqueNameBuilder(String root, String separator) {
        this.myRoot = root;
        this.mySeparator = separator;
    }

    public boolean contains(T file2) {
        return this.myPaths.containsKey(file2);
    }

    public int size() {
        return this.myPaths.size();
    }

    public void addPath(T key, String path2) {
        path2 = Strings.trimStart(path2, this.myRoot);
        this.myPaths.put(key, path2);
        Node current = this.myRootNode;
        PathComponentsIterator pathComponentsIterator = new PathComponentsIterator(path2);
        while (pathComponentsIterator.hasNext()) {
            String word2 = (String)pathComponentsIterator.next();
            current = current.findOrAddChild(word2);
        }
        Node c2 = current;
        while (c2 != null) {
            ++c2.myNestedChildrenCount;
            c2 = c2.myParentNode;
        }
    }

    public String getShortPath(T key) {
        String path2 = this.myPaths.get(key);
        if (path2 == null) {
            return key.toString();
        }
        Node current = this.myRootNode;
        Node firstNodeWithBranches = null;
        Node firstNodeBeforeNodeWithBranches = null;
        Node fileNameNode = null;
        PathComponentsIterator pathComponentsIterator = new PathComponentsIterator(path2);
        while (pathComponentsIterator.hasNext()) {
            String pathComponent = (String)pathComponentsIterator.next();
            current = current.findOrAddChild(pathComponent);
            if (fileNameNode == null) {
                fileNameNode = current;
            }
            if (firstNodeBeforeNodeWithBranches == null && firstNodeWithBranches != null && current.myChildren.size() <= 1 && current.myParentNode.myNestedChildrenCount - current.myParentNode.myChildren.size() < 1) {
                firstNodeBeforeNodeWithBranches = current;
            }
            if (current.myChildren.size() == 1 || firstNodeWithBranches != null) continue;
            firstNodeWithBranches = current;
        }
        StringBuilder b = new StringBuilder();
        if (firstNodeBeforeNodeWithBranches == null) {
            firstNodeBeforeNodeWithBranches = current;
        }
        boolean skipFirstSeparator = true;
        Node c2 = firstNodeBeforeNodeWithBranches;
        while (c2 != this.myRootNode) {
            if (c2 != fileNameNode && c2 != firstNodeBeforeNodeWithBranches && c2.myParentNode.myChildren.size() == 1) {
                b.append(this.mySeparator);
                b.append("\u2026");
                while (c2.myParentNode != fileNameNode && c2.myParentNode.myChildren.size() == 1) {
                    c2 = c2.myParentNode;
                }
            } else if (c2.myText.startsWith(VFS_SEPARATOR)) {
                if (!skipFirstSeparator) {
                    b.append(this.mySeparator);
                }
                skipFirstSeparator = false;
                b.append(c2.myText, VFS_SEPARATOR.length(), c2.myText.length());
            } else {
                b.append(c2.myText);
            }
            c2 = c2.myParentNode;
        }
        return b.toString();
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    private static final class Node {
        final String myText;
        final HashMap<String, Node> myChildren;
        final Node myParentNode;
        int myNestedChildrenCount;

        Node(String text2, Node parentNode) {
            this.myText = text2;
            this.myParentNode = parentNode;
            this.myChildren = new HashMap();
        }

        Node findOrAddChild(String word2) {
            Node node2 = this.myChildren.get(word2);
            if (node2 == null) {
                node2 = new Node(word2, this);
                this.myChildren.put(word2, node2);
            }
            return node2;
        }
    }

    private static final class PathComponentsIterator
    implements Iterator<String> {
        private final String myPath;
        private int myLastPos;
        private int mySeparatorPos;

        PathComponentsIterator(String path2) {
            this.myPath = path2;
            this.myLastPos = path2.length();
            this.mySeparatorPos = path2.lastIndexOf(UniqueNameBuilder.VFS_SEPARATOR);
        }

        @Override
        public boolean hasNext() {
            return this.myLastPos != 0;
        }

        @Override
        public String next() {
            String pathComponent;
            if (this.myLastPos == 0) {
                throw new NoSuchElementException();
            }
            if (this.mySeparatorPos != -1) {
                pathComponent = this.myPath.substring(this.mySeparatorPos, this.myLastPos);
                this.myLastPos = this.mySeparatorPos;
                this.mySeparatorPos = this.myPath.lastIndexOf(UniqueNameBuilder.VFS_SEPARATOR, this.myLastPos - 1);
            } else {
                pathComponent = this.myPath.substring(0, this.myLastPos);
                if (!pathComponent.startsWith(UniqueNameBuilder.VFS_SEPARATOR)) {
                    pathComponent = UniqueNameBuilder.VFS_SEPARATOR + pathComponent;
                }
                this.myLastPos = 0;
            }
            return pathComponent;
        }

        @Override
        public void remove() {
            Iterator.super.remove();
        }
    }
}

