/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindAllAction
extends AnAction
implements ShortcutProvider,
DumbAware {
    private static final Icon FIND_ICON = ExperimentalUI.isNewUI() ? IconManager.getInstance().getIcon("expui/general/openInToolWindow.svg", AllIcons.class) : AllIcons.General.Pin_tab;

    public FindAllAction() {
        super(IdeBundle.messagePointer((String)(ExperimentalUI.isNewUI() ? "show.in.find.window.button.name.newui" : "show.in.find.window.button.name"), (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.description", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FindAllAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        EditorSearchSession search2 = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        Editor editor2 = search2 != null ? search2.getEditor() : null;
        e.getPresentation().setIcon(FindAllAction.getIcon(project2));
        e.getPresentation().setEnabled(editor2 != null && project2 != null && !project2.isDisposed() && search2.hasMatches() && PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument()) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FindAllAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindAllAction.$$$reportNull$$$0(2);
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        EditorSearchSession search2 = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        if (project2.isDisposed()) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(search2.getEditor().getDocument());
        if (file2 == null) {
            return;
        }
        FindModel oldModel = FindManager.getInstance((Project)project2).getFindInFileModel();
        FindModel newModel = oldModel.clone();
        String text2 = search2.getTextInField();
        if (StringUtil.isEmpty(text2)) {
            return;
        }
        newModel.setStringToFind(text2);
        FindUtil.findAllAndShow(project2, file2, newModel);
    }

    @Override
    @Nullable
    public ShortcutSet getShortcut() {
        AnAction findUsages2 = ActionManager.getInstance().getAction("FindUsages");
        return findUsages2 != null ? findUsages2.getShortcutSet() : null;
    }

    @NotNull
    private static Icon getIcon(@Nullable Project project2) {
        ToolWindowManager toolWindowManager;
        ToolWindowManager toolWindowManager2 = toolWindowManager = project2 != null ? ToolWindowManager.getInstance((Project)project2) : null;
        if (toolWindowManager != null) {
            Icon icon2 = toolWindowManager.getLocationIcon("Find", FIND_ICON);
            if (icon2 == null) {
                FindAllAction.$$$reportNull$$$0(3);
            }
            return icon2;
        }
        Icon icon3 = FIND_ICON;
        if (icon3 == null) {
            FindAllAction.$$$reportNull$$$0(4);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/FindAllAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/FindAllAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

