/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.find.FindBundle;
import com.intellij.find.actions.ResolverKt;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.EmptyFindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindUsagesInFileAction
extends AnAction
implements PossiblyDumbAware {
    public FindUsagesInFileAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isDumbAware() {
        return Registry.is("ide.find.in.file.highlight.usages");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(0);
        }
        if (Registry.is("ide.find.in.file.highlight.usages")) {
            ActionManager.getInstance().getAction("HighlightUsagesInFile").actionPerformed(e);
            return;
        }
        DataContext dataContext2 = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        UsageTarget[] usageTargets = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataContext2);
        if (usageTargets != null) {
            FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext2);
            if (fileEditor != null) {
                usageTargets[0].findUsagesInEditor(fileEditor);
            }
        } else if (editor2 == null) {
            Messages.showMessageDialog((Project)project2, (String)FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            HintManager.getInstance().showErrorHint(editor2, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = Registry.is("ide.find.in.file.highlight.usages") ? ActionManager.getInstance().getAction("HighlightUsagesInFile").getActionUpdateThread() : ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(2);
        }
        if (Registry.is("ide.find.in.file.highlight.usages")) {
            ActionManager.getInstance().getAction("HighlightUsagesInFile").update(event);
            return;
        }
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    private static boolean isEnabled(DataContext dataContext2) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null || EditorGutter.KEY.getData(dataContext2) != null || Boolean.TRUE.equals(dataContext2.getData(CommonDataKeys.EDITOR_VIRTUAL_SPACE))) {
            return false;
        }
        return FindUsagesInFileAction.canFindUsages(project2, dataContext2) || !ResolverKt.allTargets(dataContext2).isEmpty();
    }

    private static boolean canFindUsages(@NotNull Project project2, @NotNull DataContext dataContext2) {
        Editor editor2;
        if (project2 == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(4);
        }
        if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2)) == null) {
            return false;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            return false;
        }
        Language language = PsiUtilBase.getLanguageInEditor(editor2, project2);
        if (language == null) {
            language = file2.getLanguage();
        }
        return !(LanguageFindUsages.INSTANCE.forLanguage(language) instanceof EmptyFindUsagesProvider);
    }

    public static void updateFindUsagesAction(@NotNull AnActionEvent event) {
        if (event == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(5);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        boolean enabled = FindUsagesInFileAction.isEnabled(dataContext2);
        presentation2.setVisible(enabled || !ActionPlaces.isPopupPlace((String)event.getPlace()));
        presentation2.setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/FindUsagesInFileAction";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/FindUsagesInFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateFindUsagesAction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

