/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.FindSettings;
import com.intellij.find.actions.SearchOptionsService;
import com.intellij.find.actions.SearchOptionsServiceKt;
import com.intellij.find.actions.SearchTarget2UsageTarget;
import com.intellij.find.actions.UsageOptionsDialog;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0000\u001a&\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0001\u001a\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"displayString", "", "Lcom/intellij/find/usages/api/SearchTarget;", "getDisplayString", "(Lcom/intellij/find/usages/api/SearchTarget;)Ljava/lang/String;", "canReuseTab", "", "project", "Lcom/intellij/openapi/project/Project;", "findUsages", "", "target", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "showDialog", "selectedScope", "Lcom/intellij/psi/search/SearchScope;", "getSearchString", "Lcom/intellij/find/usages/api/UsageHandler;", "showScopeChooser", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nfindUsages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findUsages.kt\ncom/intellij/find/actions/FindUsagesKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,88:1\n29#2,3:89\n*S KotlinDebug\n*F\n+ 1 findUsages.kt\ncom/intellij/find/actions/FindUsagesKt\n*L\n57#1:89,3\n*E\n"})
public final class FindUsagesKt {
    public static final void findUsages(boolean showDialog, @NotNull Project project2, @NotNull SearchScope selectedScope, @NotNull SearchTarget target2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectedScope, (String)"selectedScope");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        AllSearchOptions allOptions = SearchOptionsServiceKt.getSearchOptions(SearchOptionsService.SearchVariant.FIND_USAGES, target2, selectedScope);
        if (showDialog) {
            boolean canReuseTab = FindUsagesKt.canReuseTab(project2);
            UsageOptionsDialog dialog = new UsageOptionsDialog(project2, FindUsagesKt.getDisplayString(target2), allOptions, FindUsagesKt.showScopeChooser(target2), canReuseTab);
            if (!dialog.showAndGet()) {
                return;
            }
            AllSearchOptions dialogResult = dialog.result();
            SearchOptionsServiceKt.setSearchOptions(SearchOptionsService.SearchVariant.FIND_USAGES, target2, dialogResult);
            FindUsagesKt.findUsages(project2, target2, dialogResult);
        } else {
            FindUsagesKt.findUsages(project2, target2, allOptions);
        }
    }

    public static final void findUsages(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull AllSearchOptions allOptions) {
        SearchTarget2UsageTarget[] searchTarget2UsageTargetArray;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        Query<? extends Usage> query2 = ImplKt.buildUsageViewQuery(project2, target2, allOptions);
        Factory<UsageSearcher> factory2 = () -> FindUsagesKt.findUsages$lambda$1(project2, query2);
        SearchTarget2UsageTarget[] $this$findUsages_u24lambda_u242 = searchTarget2UsageTargetArray = new UsageViewPresentation();
        boolean bl = false;
        $this$findUsages_u24lambda_u242.setSearchString(FindUsagesKt.getSearchString(target2.getUsageHandler(), allOptions));
        $this$findUsages_u24lambda_u242.setScopeText(allOptions.getOptions().getSearchScope().getDisplayName());
        Object[] objectArray = new Object[]{$this$findUsages_u24lambda_u242.getSearchString(), $this$findUsages_u24lambda_u242.getScopeText()};
        $this$findUsages_u24lambda_u242.setTabText(UsageViewBundle.message((String)"search.title.0.in.1", (Object[])objectArray));
        $this$findUsages_u24lambda_u242.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView() || !FindUsagesKt.canReuseTab(project2));
        SearchTarget2UsageTarget[] usageViewPresentation = searchTarget2UsageTargetArray;
        ComponentManager $this$service$iv = project2;
        boolean $i$f$service = false;
        Class<UsageViewManager> serviceClass$iv = UsageViewManager.class;
        objectArray = $this$service$iv.getService(serviceClass$iv);
        if (objectArray == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        searchTarget2UsageTargetArray = new SearchTarget2UsageTarget[]{new SearchTarget2UsageTarget(project2, target2, allOptions)};
        objectArray.searchAndShowUsages((UsageTarget[])searchTarget2UsageTargetArray, factory2, false, true, (UsageViewPresentation)usageViewPresentation, null);
    }

    private static final boolean canReuseTab(Project project2) {
        UsageViewContentManager contentManager = UsageViewContentManager.getInstance((Project)project2);
        Content selectedContent = contentManager.getSelectedContent(true);
        return selectedContent == null ? contentManager.getReusableContentsCount() != 0 : !selectedContent.isPinned();
    }

    @NotNull
    public static final String getDisplayString(@NotNull SearchTarget $this$displayString) {
        Intrinsics.checkNotNullParameter((Object)$this$displayString, (String)"<this>");
        return $this$displayString.presentation().getPresentableText();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public static final String getSearchString(@NotNull UsageHandler $this$getSearchString, @NotNull AllSearchOptions allOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$getSearchString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        String string2 = $this$getSearchString.getSearchString(allOptions.getOptions());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSearchString(allOptions.options)");
        return string2;
    }

    public static final boolean showScopeChooser(@NotNull SearchTarget $this$showScopeChooser) {
        Intrinsics.checkNotNullParameter((Object)$this$showScopeChooser, (String)"<this>");
        return !($this$showScopeChooser.getMaximalSearchScope() instanceof LocalSearchScope);
    }

    private static final void findUsages$lambda$1$lambda$0(Project $project, Query $query, Processor it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HelperKt.runSearch((Project)$project, (Query)$query, (Processor)it);
    }

    private static final UsageSearcher findUsages$lambda$1(Project $project, Query $query) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        return arg_0 -> FindUsagesKt.findUsages$lambda$1$lambda$0($project, $query, arg_0);
    }
}

