/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class PingEDT {
    private final String myName;
    private final Runnable pingAction;
    private volatile boolean stopped;
    private volatile boolean pinged;
    @NotNull
    private final BooleanSupplier myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final AtomicBoolean invokeLaterScheduled;
    private final Runnable myUpdateRunnable;

    PingEDT(@NotNull @NonNls String name, @NotNull BooleanSupplier shutUpCondition, int maxUnitOfWorkThresholdMs, @NotNull Runnable pingAction) {
        if (name == null) {
            PingEDT.$$$reportNull$$$0(0);
        }
        if (shutUpCondition == null) {
            PingEDT.$$$reportNull$$$0(1);
        }
        if (pingAction == null) {
            PingEDT.$$$reportNull$$$0(2);
        }
        this.invokeLaterScheduled = new AtomicBoolean();
        this.myUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                boolean b = PingEDT.this.invokeLaterScheduled.compareAndSet(true, false);
                assert (b);
                if (PingEDT.this.stopped || PingEDT.this.myShutUpCondition.getAsBoolean()) {
                    PingEDT.this.stop();
                    return;
                }
                long start = System.currentTimeMillis();
                int processed2 = 0;
                while (PingEDT.this.processNext()) {
                    ++processed2;
                    long finish = System.currentTimeMillis();
                    if (PingEDT.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start <= (long)PingEDT.this.myMaxUnitOfWorkThresholdMs) continue;
                    break;
                }
                if (!PingEDT.this.isEmpty()) {
                    PingEDT.this.scheduleUpdate();
                }
            }
        };
        this.myName = name;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
        this.pingAction = pingAction;
    }

    private boolean isEmpty() {
        return !this.pinged;
    }

    private boolean processNext() {
        this.pinged = false;
        this.pingAction.run();
        return this.pinged;
    }

    public boolean ping() {
        this.pinged = true;
        return this.scheduleUpdate();
    }

    private boolean scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(this.myUpdateRunnable);
            return true;
        }
        return false;
    }

    public void stop() {
        this.stopped = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "shutUpCondition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pingAction";
                break;
            }
        }
        objectArray[1] = "com/intellij/find/actions/PingEDT";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

