/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.find.actions.PersistedSearchOptions;
import com.intellij.find.actions.SearchOptionsService;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"defaultOptions", "Lcom/intellij/find/actions/PersistedSearchOptions;", "getSearchOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "variant", "Lcom/intellij/find/actions/SearchOptionsService$SearchVariant;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "selectedScope", "Lcom/intellij/psi/search/SearchScope;", "searchOptionsService", "Lcom/intellij/find/actions/SearchOptionsService;", "setSearchOptions", "", "allOptions", "targetKey", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSearchOptionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchOptionsService.kt\ncom/intellij/find/actions/SearchOptionsServiceKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,117:1\n39#2,3:118\n*S KotlinDebug\n*F\n+ 1 SearchOptionsService.kt\ncom/intellij/find/actions/SearchOptionsServiceKt\n*L\n114#1:118,3\n*E\n"})
public final class SearchOptionsServiceKt {
    @NotNull
    private static final PersistedSearchOptions defaultOptions = new PersistedSearchOptions(true, true);

    @NotNull
    public static final AllSearchOptions getSearchOptions(@NotNull SearchOptionsService.SearchVariant variant, @NotNull SearchTarget target2, @NotNull SearchScope selectedScope) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)selectedScope, (String)"selectedScope");
        PersistedSearchOptions persistedOptions = SearchOptionsServiceKt.searchOptionsService().getSearchOptions(variant, SearchOptionsServiceKt.targetKey(target2));
        SearchScope searchScope2 = target2.getMaximalSearchScope();
        LocalSearchScope localSearchScope = searchScope2 instanceof LocalSearchScope ? (LocalSearchScope)searchScope2 : null;
        SearchScope scopeToUse = localSearchScope != null ? (SearchScope)localSearchScope : selectedScope;
        UsageOptions usageOptions = UsageOptions.createOptions(persistedOptions.getUsages(), scopeToUse);
        Intrinsics.checkNotNullExpressionValue((Object)usageOptions, (String)"createOptions(persistedOptions.usages, scopeToUse)");
        return new AllSearchOptions(usageOptions, ImplKt.hasTextSearchStrings(target2) ? Boolean.valueOf(persistedOptions.getTextSearch()) : null);
    }

    public static final void setSearchOptions(@NotNull SearchOptionsService.SearchVariant variant, @NotNull SearchTarget target2, @NotNull AllSearchOptions allOptions) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        Boolean bl = allOptions.getTextSearch();
        PersistedSearchOptions newOptions = new PersistedSearchOptions(allOptions.getOptions().isUsages(), bl != null ? bl : true);
        SearchOptionsServiceKt.searchOptionsService().setSearchOptions(variant, SearchOptionsServiceKt.targetKey(target2), newOptions);
    }

    private static final SearchOptionsService searchOptionsService() {
        boolean $i$f$service = false;
        Class<SearchOptionsService> serviceClass$iv = SearchOptionsService.class;
        SearchOptionsService searchOptionsService = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (searchOptionsService == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return searchOptionsService;
    }

    private static final String targetKey(SearchTarget $this$targetKey) {
        String string2 = $this$targetKey.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
        return string2;
    }

    public static final /* synthetic */ PersistedSearchOptions access$getDefaultOptions$p() {
        return defaultOptions;
    }
}

