/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.FindUsagesKt;
import com.intellij.find.actions.UsageOptionsDialog;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.model.Pointer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\r\u0010\u001c\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J \u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\u0010H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0010H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016J\b\u0010,\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/find/actions/SearchTarget2UsageTarget;", "Lcom/intellij/usages/UsageTarget;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/usages/ConfigurableUsageTarget;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/find/usages/api/SearchTarget;Lcom/intellij/find/usages/impl/AllSearchOptions;)V", "myItemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "myPointer", "Lcom/intellij/model/Pointer;", "canNavigate", "", "canNavigateToSource", "findUsages", "", "findUsagesInEditor", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getData", "", "dataId", "", "getItemPresentation", "getLongDescriptiveName", "Lorg/jetbrains/annotations/Nls;", "getName", "getPresentation", "getShortcut", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "highlightUsages", "file", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/editor/Editor;", "clearHighlights", "isReadOnly", "isValid", "navigate", "requestFocus", "showSettings", "update", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class SearchTarget2UsageTarget
implements UsageTarget,
DataProvider,
ConfigurableUsageTarget {
    @NotNull
    private final Project project;
    @NotNull
    private final AllSearchOptions allOptions;
    @NotNull
    private final Pointer<? extends SearchTarget> myPointer;
    @NotNull
    private ItemPresentation myItemPresentation;

    public SearchTarget2UsageTarget(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull AllSearchOptions allOptions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        this.project = project2;
        this.allOptions = allOptions;
        this.myPointer = target2.createPointer();
        this.myItemPresentation = this.getItemPresentation(target2);
    }

    public boolean isValid() {
        return this.myPointer.dereference() != null;
    }

    public void update() {
        SearchTarget searchTarget = this.myPointer.dereference();
        if (searchTarget == null) {
            return;
        }
        SearchTarget target2 = searchTarget;
        this.myItemPresentation = this.getItemPresentation(target2);
    }

    private final ItemPresentation getItemPresentation(SearchTarget target2) {
        TargetPresentation presentation2 = target2.presentation();
        return new ItemPresentation(presentation2){
            final /* synthetic */ TargetPresentation $presentation;
            {
                this.$presentation = $presentation;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return this.$presentation.getIcon();
            }

            @NotNull
            public String getPresentableText() {
                return this.$presentation.getPresentableText();
            }

            @NotNull
            public String getLocationString() {
                String string2 = this.$presentation.getLocationText();
                if (string2 == null) {
                    string2 = "";
                }
                return string2;
            }
        };
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this.myItemPresentation;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    public String getName() {
        return null;
    }

    public void navigate(boolean requestFocus) {
    }

    @Nullable
    public KeyboardShortcut getShortcut() {
        return UsageViewUtil.getShowUsagesWithSettingsShortcut();
    }

    @NotNull
    public String getLongDescriptiveName() {
        SearchTarget searchTarget = this.myPointer.dereference();
        if (searchTarget == null) {
            String string2 = UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"node.invalid\")");
            return string2;
        }
        SearchTarget target2 = searchTarget;
        Object[] objectArray = new Object[]{FindUsagesKt.getSearchString(target2.getUsageHandler(), this.allOptions), this.allOptions.getOptions().getSearchScope().getDisplayName()};
        String string3 = UsageViewBundle.message((String)"search.title.0.in.1", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\n      \"search.t\u2026chScope.displayName\n    )");
        return string3;
    }

    public void showSettings() {
        SearchTarget searchTarget = this.myPointer.dereference();
        if (searchTarget == null) {
            return;
        }
        SearchTarget target2 = searchTarget;
        UsageOptionsDialog dialog = new UsageOptionsDialog(this.project, FindUsagesKt.getDisplayString(target2), this.allOptions, FindUsagesKt.showScopeChooser(target2), true);
        if (!dialog.showAndGet()) {
            return;
        }
        AllSearchOptions newOptions = dialog.result();
        FindUsagesKt.findUsages(this.project, target2, newOptions);
    }

    public void findUsages() {
        throw new IllegalStateException("must not be called".toString());
    }

    public void findUsagesInEditor(@NotNull FileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        throw new IllegalStateException("must not be called".toString());
    }

    public void highlightUsages(@NotNull PsiFile file2, @NotNull Editor editor2, boolean clearHighlights) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        throw new IllegalStateException("must not be called".toString());
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (UsageView.USAGE_SCOPE.is(dataId)) {
            return this.allOptions.getOptions().getSearchScope();
        }
        return null;
    }
}

