/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.FindUsagesKt;
import com.intellij.find.actions.SearchOptionsService;
import com.intellij.find.actions.SearchOptionsServiceKt;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.find.actions.UsageOptionsDialog;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearchPresentation;
import com.intellij.usages.UsageSearcher;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\f\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001J\b\u0010&\u001a\u00020\u0015H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0001H\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/find/actions/ShowTargetUsagesActionHandler;", "Lcom/intellij/find/actions/ShowUsagesActionHandler;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/find/usages/api/SearchTarget;Lcom/intellij/find/usages/impl/AllSearchOptions;)V", "buildFinishEventData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "selectedUsageInfo", "Lcom/intellij/usageView/UsageInfo;", "component1", "component2", "component3", "copy", "createUsageSearcher", "Lcom/intellij/usages/UsageSearcher;", "equals", "", "other", "", "findUsages", "", "getEventData", "getMaximalScope", "Lcom/intellij/psi/search/SearchScope;", "getPresentation", "Lcom/intellij/usages/UsageSearchPresentation;", "getSelectedScope", "getTargetClass", "Ljava/lang/Class;", "getTargetLanguage", "Lcom/intellij/lang/Language;", "hashCode", "", "isValid", "showDialog", "toString", "", "withScope", "searchScope", "Companion", "intellij.platform.lang.impl"})
public final class ShowTargetUsagesActionHandler
implements ShowUsagesActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SearchTarget target;
    @NotNull
    private final AllSearchOptions allOptions;

    public ShowTargetUsagesActionHandler(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull AllSearchOptions allOptions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        this.project = project2;
        this.target = target2;
        this.allOptions = allOptions;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @NotNull
    public UsageSearchPresentation getPresentation() {
        return new UsageSearchPresentation(this){
            final /* synthetic */ ShowTargetUsagesActionHandler this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getSearchTargetString() {
                return FindUsagesKt.getSearchString(ShowTargetUsagesActionHandler.access$getTarget$p(this.this$0).getUsageHandler(), ShowTargetUsagesActionHandler.access$getAllOptions$p(this.this$0));
            }

            @NotNull
            public String getOptionsString() {
                ArrayList<String> optionsList = new ArrayList<String>();
                if (ShowTargetUsagesActionHandler.access$getAllOptions$p(this.this$0).getOptions().isUsages()) {
                    optionsList.add(LangBundle.message("target.usages.option", new Object[0]));
                }
                if (Intrinsics.areEqual((Object)ShowTargetUsagesActionHandler.access$getAllOptions$p(this.this$0).getTextSearch(), (Object)true)) {
                    optionsList.add(LangBundle.message("target.text.occurrences.option", new Object[0]));
                }
                String string2 = StringUtil.capitalize(NlsMessages.formatOrList((Collection)optionsList));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(NlsMessages.formatOrList(optionsList))");
                return string2;
            }
        };
    }

    @Override
    @NotNull
    public UsageSearcher createUsageSearcher() {
        Query<? extends Usage> query2 = ImplKt.buildUsageViewQuery(this.project, this.target, this.allOptions);
        return arg_0 -> ShowTargetUsagesActionHandler.createUsageSearcher$lambda$0(query2, arg_0);
    }

    @Override
    @Nullable
    public ShowUsagesActionHandler showDialog() {
        UsageOptionsDialog dialog = new UsageOptionsDialog(this.project, FindUsagesKt.getDisplayString(this.target), this.allOptions, FindUsagesKt.showScopeChooser(this.target), false);
        if (!dialog.showAndGet()) {
            return null;
        }
        AllSearchOptions dialogResult = dialog.result();
        SearchOptionsServiceKt.setSearchOptions(SearchOptionsService.SearchVariant.SHOW_USAGES, this.target, dialogResult);
        return ShowTargetUsagesActionHandler.copy$default(this, null, null, dialogResult, 3, null);
    }

    @Override
    @NotNull
    public ShowUsagesActionHandler withScope(@NotNull SearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        UsageOptions usageOptions = UsageOptions.createOptions(this.allOptions.getOptions().isUsages(), searchScope2);
        Intrinsics.checkNotNullExpressionValue((Object)usageOptions, (String)"createOptions(allOptions\u2026ns.isUsages, searchScope)");
        return ShowTargetUsagesActionHandler.copy$default(this, null, null, AllSearchOptions.copy$default(this.allOptions, usageOptions, null, 2, null), 3, null);
    }

    @Override
    public void findUsages() {
        FindUsagesKt.findUsages(this.project, this.target, this.allOptions);
    }

    @Override
    @NotNull
    public SearchScope getSelectedScope() {
        SearchScope searchScope2 = this.allOptions.getOptions().getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"allOptions.options.searchScope");
        return searchScope2;
    }

    @Override
    @NotNull
    public SearchScope getMaximalScope() {
        SearchScope searchScope2 = this.target.getMaximalSearchScope();
        if (searchScope2 == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
            searchScope2 = globalSearchScope;
        }
        return searchScope2;
    }

    @Override
    @Nullable
    public Language getTargetLanguage() {
        return null;
    }

    @Override
    @NotNull
    public Class<?> getTargetClass() {
        return this.target.getClass();
    }

    @Override
    @NotNull
    public List<EventPair<?>> getEventData() {
        return new ArrayList();
    }

    @Override
    @NotNull
    public List<EventPair<?>> buildFinishEventData(@Nullable UsageInfo selectedUsageInfo) {
        return new ArrayList();
    }

    private final Project component1() {
        return this.project;
    }

    private final SearchTarget component2() {
        return this.target;
    }

    private final AllSearchOptions component3() {
        return this.allOptions;
    }

    @NotNull
    public final ShowTargetUsagesActionHandler copy(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull AllSearchOptions allOptions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        return new ShowTargetUsagesActionHandler(project2, target2, allOptions);
    }

    public static /* synthetic */ ShowTargetUsagesActionHandler copy$default(ShowTargetUsagesActionHandler showTargetUsagesActionHandler, Project project2, SearchTarget searchTarget, AllSearchOptions allSearchOptions, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = showTargetUsagesActionHandler.project;
        }
        if ((n & 2) != 0) {
            searchTarget = showTargetUsagesActionHandler.target;
        }
        if ((n & 4) != 0) {
            allSearchOptions = showTargetUsagesActionHandler.allOptions;
        }
        return showTargetUsagesActionHandler.copy(project2, searchTarget, allSearchOptions);
    }

    @NotNull
    public String toString() {
        return "ShowTargetUsagesActionHandler(project=" + this.project + ", target=" + this.target + ", allOptions=" + this.allOptions + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + ((Object)this.target).hashCode();
        result2 = result2 * 31 + this.allOptions.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShowTargetUsagesActionHandler)) {
            return false;
        }
        ShowTargetUsagesActionHandler showTargetUsagesActionHandler = (ShowTargetUsagesActionHandler)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)showTargetUsagesActionHandler.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.target, (Object)showTargetUsagesActionHandler.target)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.allOptions, (Object)showTargetUsagesActionHandler.allOptions);
    }

    private static final void createUsageSearcher$lambda$0(Query $query, Processor it) {
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $query.forEach(it);
    }

    @JvmStatic
    public static final void showUsages(@NotNull Project project2, @NotNull SearchScope searchScope2, @NotNull SearchTarget target2, @NotNull ShowUsagesParameters parameters2) {
        Companion.showUsages(project2, searchScope2, target2, parameters2);
    }

    public static final /* synthetic */ SearchTarget access$getTarget$p(ShowTargetUsagesActionHandler $this) {
        return $this.target;
    }

    public static final /* synthetic */ AllSearchOptions access$getAllOptions$p(ShowTargetUsagesActionHandler $this) {
        return $this.allOptions;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/find/actions/ShowTargetUsagesActionHandler$Companion;", "", "()V", "showUsages", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "parameters", "Lcom/intellij/find/actions/ShowUsagesParameters;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void showUsages(@NotNull Project project2, @NotNull SearchScope searchScope2, @NotNull SearchTarget target2, @NotNull ShowUsagesParameters parameters2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
            ShowTargetUsagesActionHandler showTargetUsagesActionHandler = new ShowTargetUsagesActionHandler(project2, target2, SearchOptionsServiceKt.getSearchOptions(SearchOptionsService.SearchVariant.SHOW_USAGES, target2, searchScope2));
            ShowUsagesAction.showElementUsages(parameters2, showTargetUsagesActionHandler);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

