/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.ShowTargetUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.find.actions.ShowUsagesPopupData;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.TargetVariant;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesHandlerUi;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.impl.Psi2UsageInfo2UsageAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.ide.util.scopeChooser.ScopeChooserGroup;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.ShowUsageViewSettings;
import com.intellij.usages.ShowUsagesSettings;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoAdapter;
import com.intellij.usages.UsageSearchPresentation;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SpeedSearchAdvertiser;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ShowUsagesAction
extends AnAction
implements PopupAction,
HintManagerImpl.ActionToIgnore {
    public static final String ID = "ShowUsages";
    private static final String DIMENSION_SERVICE_KEY = "ShowUsagesActions.dimensionServiceKey";
    private static final String SPLITTER_SERVICE_KEY = "ShowUsagesActions.splitterServiceKey";
    private static final String PREVIEW_PROPERTY_KEY = "ShowUsagesActions.previewPropertyKey";
    private static int ourPopupDelayTimeout = 300;

    public ShowUsagesAction() {
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowUsagesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public static int getUsagesPageSize() {
        return Math.max(1, AdvancedSettings.getInt((String)"ide.usages.page.size"));
    }

    public void update(@NotNull AnActionEvent e) {
        UsageTarget[] usageTargets;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(1);
        }
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement(usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        ShowUsagesActionState state = ShowUsagesAction.getState(project2);
        Runnable continuation = state.continuation;
        if (continuation != null) {
            state.continuation = null;
            ShowUsagesAction.hideHints();
            continuation.run();
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        DataContext dataContext2 = e.getDataContext();
        ShowUsagesAction.showUsages(project2, dataContext2, ResolverKt.allTargets(dataContext2));
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project2, @NotNull DataContext dataContext2, @NotNull @NotNull List<? extends @NotNull TargetVariant> targetVariants) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(4);
        }
        if (targetVariants == null) {
            ShowUsagesAction.$$$reportNull$$$0(5);
        }
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext2);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project2, dataContext2, FindSettings.getInstance().getDefaultScopeName());
        try (AccessToken ignored = SlowOperations.startSection("action.perform");){
            ResolverKt.findShowUsages(project2, dataContext2, targetVariants, FindBundle.message("show.usages.ambiguous.title", new Object[0]), ShowUsagesAction.createVariantHandler(project2, editor2, popupPosition, searchScope2));
        }
    }

    @NotNull
    private static UsageVariantHandler createVariantHandler(final @NotNull Project project2, final @Nullable Editor editor2, final @NotNull RelativePoint popupPosition, final @NotNull SearchScope searchScope2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(6);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(7);
        }
        if (searchScope2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(8);
        }
        return new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                if (target2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowTargetUsagesActionHandler.showUsages(project2, searchScope2, target2, ShowUsagesParameters.initial(project2, editor2, popupPosition));
            }

            @Override
            public void handlePsi(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                ShowUsagesAction.startFindUsages(element, popupPosition, editor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleTarget";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePsi";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project2, @NotNull DataContext dataContext2, @NotNull RelativePoint popupPosition, @NotNull SearchTarget target2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(9);
        }
        if (dataContext2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(10);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(11);
        }
        if (target2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(12);
        }
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project2, dataContext2, FindSettings.getInstance().getDefaultScopeName());
        ShowTargetUsagesActionHandler.showUsages(project2, searchScope2, target2, ShowUsagesParameters.initial(project2, editor2, popupPosition));
    }

    static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public static void startFindUsages(@NotNull PsiElement element, @NotNull RelativePoint popupPosition, @Nullable Editor editor2) {
        Project project2;
        FindUsagesManager findUsagesManager;
        FindUsagesHandler handler2;
        if (element == null) {
            ShowUsagesAction.$$$reportNull$$$0(13);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(14);
        }
        if ((handler2 = (findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)(project2 = element.getProject()))).getFindUsagesManager()).getFindUsagesHandler(element, FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS)) == null) {
            return;
        }
        FindUsagesOptions options2 = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        ShowUsagesAction.showElementUsages(ShowUsagesParameters.initial(project2, editor2, popupPosition), ShowUsagesAction.createActionHandler(handler2, options2));
    }

    private static void rulesChanged(@NotNull UsageViewImpl usageView, @NotNull PingEDT pingEDT, JBPopup popup2) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(15);
        }
        if (pingEDT == null) {
            ShowUsagesAction.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                usageView.waitForUpdateRequestsCompletion();
                if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                    pingEDT.ping();
                }
            }
        }));
    }

    @Nls
    @NotNull
    private static String getUsagesTitle(@NotNull PsiElement element) {
        ItemPresentation itemPresentation;
        if (element == null) {
            ShowUsagesAction.$$$reportNull$$$0(17);
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        HtmlChunk type = HtmlChunk.text(StringUtil.capitalize(UsageViewUtil.getType((PsiElement)element)));
        if (ExperimentalUI.isNewUI()) {
            type = type.bold();
        }
        builder2.append(type).nbsp().append(HtmlChunk.text(UsageViewUtil.getLongName((PsiElement)element)).bold());
        if (element instanceof NavigationItem && (itemPresentation = ((NavigationItem)((Object)element)).getPresentation()) != null && StringUtil.isNotEmpty(itemPresentation.getLocationString())) {
            builder2.nbsp().append(ShowUsagesAction.getLocationString(itemPresentation.getLocationString()));
        }
        String string2 = builder2.toString();
        if (string2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NotNull
    private static HtmlChunk getLocationString(@Nls @NotNull String locationString) {
        if (locationString == null) {
            ShowUsagesAction.$$$reportNull$$$0(19);
        }
        Color color = ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.ContextHelp.FOREGROUND : SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor();
        HtmlChunk.Element element = HtmlChunk.text(locationString).wrapWith("font").attr("color", "#" + ColorUtil.toHex(color));
        if (element == null) {
            ShowUsagesAction.$$$reportNull$$$0(20);
        }
        return element;
    }

    @NotNull
    private static ShowUsagesActionHandler createActionHandler(final @NotNull FindUsagesHandlerBase handler2, final @NotNull FindUsagesOptions options2) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(21);
        }
        if (options2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(22);
        }
        final PsiElement[] primaryElements = handler2.getPrimaryElements();
        final PsiElement[] secondaryElements = handler2.getSecondaryElements();
        final String title = ShowUsagesAction.getUsagesTitle(handler2.getPsiElement());
        final String optionsString = options2.generateUsagesString();
        return new ShowUsagesActionHandler(){

            @Override
            public boolean isValid() {
                return handler2.getPsiElement().isValid();
            }

            @Override
            @NotNull
            public UsageSearchPresentation getPresentation() {
                return new UsageSearchPresentation(){

                    @Nls
                    @NotNull
                    public String getSearchTargetString() {
                        String string2 = title;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string2;
                    }

                    @Nls
                    @NotNull
                    public String getOptionsString() {
                        String string2 = optionsString;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/find/actions/ShowUsagesAction$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getSearchTargetString";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getOptionsString";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }

            @Override
            @NotNull
            public UsageSearcher createUsageSearcher() {
                UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(handler2, primaryElements, secondaryElements, options2);
                if (usageSearcher == null) {
                    2.$$$reportNull$$$0(0);
                }
                return usageSearcher;
            }

            @Override
            @NotNull
            public SearchScope getSelectedScope() {
                SearchScope searchScope2 = options2.searchScope;
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return searchScope2;
            }

            @Override
            @NotNull
            public GlobalSearchScope getMaximalScope() {
                GlobalSearchScope globalSearchScope = FindUsagesManager.getMaximalScope(handler2);
                if (globalSearchScope == null) {
                    2.$$$reportNull$$$0(2);
                }
                return globalSearchScope;
            }

            @Override
            public ShowUsagesActionHandler showDialog() {
                FindUsagesOptions newOptions = ShowUsagesAction.showDialog(handler2);
                if (newOptions == null) {
                    return null;
                }
                return ShowUsagesAction.createActionHandler(handler2, newOptions);
            }

            @Override
            public void findUsages() {
                Project project2 = handler2.getProject();
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options2, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }

            @Override
            @NotNull
            public ShowUsagesActionHandler withScope(@NotNull SearchScope searchScope2) {
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                FindUsagesOptions newOptions = options2.clone();
                newOptions.searchScope = searchScope2;
                ShowUsagesActionHandler showUsagesActionHandler = ShowUsagesAction.createActionHandler(handler2, newOptions);
                if (showUsagesActionHandler == null) {
                    2.$$$reportNull$$$0(4);
                }
                return showUsagesActionHandler;
            }

            @Override
            public Language getTargetLanguage() {
                return handler2.getPsiElement().getLanguage();
            }

            @Override
            @NotNull
            public Class<?> getTargetClass() {
                Class<?> clazz = handler2.getPsiElement().getClass();
                if (clazz == null) {
                    2.$$$reportNull$$$0(5);
                }
                return clazz;
            }

            @Override
            @NotNull
            public List<EventPair<?>> getEventData() {
                ArrayList eventData = new ArrayList();
                PsiElement target2 = handler2.getPsiElement();
                eventData.add(UsageViewStatisticsCollector.TARGET_ELEMENT_DATA.with((Object)UsageViewStatisticsCollector.calculateElementData((PsiElement)target2)));
                eventData.add(UsageViewStatisticsCollector.NUMBER_OF_TARGETS.with((Object)(primaryElements.length + secondaryElements.length)));
                ArrayList arrayList = eventData;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(6);
                }
                return arrayList;
            }

            @Override
            @NotNull
            public List<EventPair<?>> buildFinishEventData(@Nullable UsageInfo selectedUsage) {
                PsiElement selectedUsagesElement;
                List<EventPair<?>> eventData = this.getEventData();
                PsiElement target2 = handler2.getPsiElement();
                PsiElement psiElement = selectedUsagesElement = selectedUsage != null ? selectedUsage.getElement() : null;
                if (selectedUsagesElement != null) {
                    PsiFile containingFile = selectedUsagesElement.getContainingFile();
                    PsiManager manager = selectedUsagesElement.getManager();
                    eventData.add(UsageViewStatisticsCollector.IS_THE_SAME_FILE.with((Object)(manager != null && manager.areElementsEquivalent(target2.getContainingFile(), containingFile) ? 1 : 0)));
                    eventData.add(UsageViewStatisticsCollector.SELECTED_ELEMENT_DATA.with((Object)UsageViewStatisticsCollector.calculateElementData((PsiElement)selectedUsagesElement)));
                    eventData.add(UsageViewStatisticsCollector.IS_SELECTED_ELEMENT_AMONG_RECENT_FILES.with((Object)ContainerUtil.exists(ContainerUtil.reverse(EditorHistoryManager.getInstance((Project)target2.getProject()).getFileList()), e -> e.equals(containingFile.getVirtualFile()))));
                }
                List<EventPair<?>> list2 = eventData;
                if (list2 == null) {
                    2.$$$reportNull$$$0(7);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createUsageSearcher";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedScope";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMaximalScope";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "withScope";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTargetClass";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEventData";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildFinishEventData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "withScope";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 3 -> new IllegalArgumentException(string2);
                };
            }
        };
    }

    static void showElementUsages(final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(23);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Project project2 = parameters2.project;
        final UsageViewImpl usageView = ShowUsagesAction.createUsageView(project2);
        UsageViewStatisticsCollector.logSearchStarted((Project)project2, (UsageView)usageView, (CodeNavigateSource)CodeNavigateSource.ShowUsagesPopup, actionHandler.getEventData());
        SearchScope searchScope2 = actionHandler.getSelectedScope();
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        AtomicBoolean manuallyResized = new AtomicBoolean();
        final Ref preselectedRow = new Ref();
        Predicate<? super Usage> originUsageCheck = ShowUsagesAction.originUsageCheck(parameters2.editor);
        ShowUsagesTableCellRenderer renderer = new ShowUsagesTableCellRenderer(originUsageCheck, outOfScopeUsages, searchScope2);
        final ShowUsagesTable table = new ShowUsagesTable(renderer, (UsageView)usageView);
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList());
        ArrayList usages = new ArrayList();
        final LinkedHashSet visibleUsages = new LinkedHashSet();
        table.setTableModel(new SmartList<UsageNode>(new StringNode(UsageViewBundle.message((String)"progress.searching", (Object[])new Object[0]))));
        Runnable itemChosenCallback = table.prepareTable(ShowUsagesAction.showMoreUsagesRunnable(parameters2, actionHandler), ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler), actionHandler);
        Consumer<AbstractPopup> tableResizer = popup2 -> {
            if (popup2 != null && popup2.isVisible() && !manuallyResized.get()) {
                PropertiesComponent properties = PropertiesComponent.getInstance(project2);
                int dataSize = table.getModel().getRowCount();
                ShowUsagesAction.setPopupSize((JTable)((Object)table), popup2, parameters2.popupPosition, parameters2.minWidth, properties.isValueSet(PREVIEW_PROPERTY_KEY), dataSize);
            }
        };
        ShowUsagesPopupData showUsagesPopupData = new ShowUsagesPopupData(parameters2, (JTable)((Object)table), actionHandler, (UsageView)usageView);
        AbstractPopup popup3 = ShowUsagesAction.createUsagePopup(usageView, showUsagesPopupData, itemChosenCallback, tableResizer);
        popup3.addResizeListener(() -> manuallyResized.set(true), (Disposable)popup3);
        final Ref popupShownTime = new Ref();
        popup3.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                UsageNode node2;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                Usage usage2 = (node2 = ShowUsagesAction.getSelectedUsageNode(table)) != null ? node2.getUsage() : null;
                UsageInfo2UsageAdapter usageAdapter = ObjectUtils.tryCast(usage2, UsageInfo2UsageAdapter.class);
                UsageInfo usageInfo = usageAdapter != null ? usageAdapter.getUsageInfo() : null;
                UsageViewStatisticsCollector.logPopupClosed((Project)project2, (UsageView)usageView, (boolean)event.isOk(), (int)ShowUsagesAction.getRowNumber((UsageNode)preselectedRow.get(), table), (Integer)ShowUsagesAction.getRowNumber(node2, table), (int)visibleUsages.size(), (Long)((Long)popupShownTime.get()), actionHandler.buildFinishEventData(usageInfo));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/actions/ShowUsagesAction$3", "onClosed"));
            }
        });
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        if (!popup3.isDisposed()) {
            Disposer.register((Disposable)popup3, (Disposable)usageView);
            Disposer.register((Disposable)popup3, indicator::cancel);
            EdtScheduledExecutorService.getInstance().schedule(() -> {
                if (!usageView.isDisposed()) {
                    ShowUsagesAction.showPopupIfNeedTo((JBPopup)popup3, parameters2.popupPosition, popupShownTime);
                }
            }, (long)ourPopupDelayTimeout, TimeUnit.MILLISECONDS);
        }
        UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
        UsageNode MORE_USAGES_SEPARATOR_NODE = new UsageNode(null, table.MORE_USAGES_SEPARATOR);
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", () -> popup3.isDisposed(), 100, () -> {
            boolean hasOutsideScopeUsages;
            ArrayList copy2;
            if (popup3.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes2 = new ArrayList<UsageNode>(usages.size());
            List list2 = usages;
            synchronized (list2) {
                if (!(popup3.isVisible() || !usages.isEmpty() && ShowUsagesAction.showPopupIfNeedTo((JBPopup)popup3, parameters2.popupPosition, popupShownTime))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes2);
                copy2 = new ArrayList(usages);
            }
            boolean shouldShowMoreSeparator = copy2.contains(table.MORE_USAGES_SEPARATOR);
            if (shouldShowMoreSeparator) {
                nodes2.add(MORE_USAGES_SEPARATOR_NODE);
            }
            if ((hasOutsideScopeUsages = copy2.contains(table.USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
                nodes2.add(USAGES_OUTSIDE_SCOPE_NODE);
            }
            ArrayList<UsageNode> data2 = new ArrayList<UsageNode>(nodes2);
            int filteredOutCount = ShowUsagesAction.getFilteredOutNodeCount(copy2, usageView);
            if (filteredOutCount != 0) {
                DefaultActionGroup filteringActions = (DefaultActionGroup)popup3.getUserData(DefaultActionGroup.class);
                if (filteringActions == null) {
                    return;
                }
                final List unselectedActions = Arrays.stream(filteringActions.getChildren(null)).filter(action2 -> action2 instanceof ToggleAction).map(action2 -> (ToggleAction)action2).filter(ta -> !ta.isSelected(ShowUsagesAction.fakeEvent(ta))).filter(ta -> !StringUtil.isEmpty(ta.getTemplatePresentation().getText())).collect(Collectors.toList());
                data2.add(new FilteredOutUsagesNode(table.USAGES_FILTERED_OUT_SEPARATOR, UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filteredOutCount}), UsageViewBundle.message((String)"usages.were.filtered.out.tooltip", (Object[])new Object[0])){

                    @Override
                    public void onSelected() {
                        ShowUsagesAction.toggleFilters(unselectedActions);
                        ShowUsagesAction.showElementUsages(parameters2, actionHandler);
                    }
                });
            }
            data2.sort(new UsageNodeComparator(table));
            boolean hasMore = shouldShowMoreSeparator || hasOutsideScopeUsages;
            int totalCount = copy2.size();
            int visibleCount = totalCount - filteredOutCount;
            showUsagesPopupData.header.setStatusText(hasMore, visibleCount, totalCount);
            ShowUsagesAction.rebuildTable(project2, originUsageCheck, data2, table, popup3, parameters2.popupPosition, parameters2.minWidth, manuallyResized);
            preselectedRow.set(ShowUsagesAction.getSelectedUsageNode(table));
        });
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> ShowUsagesAction.rulesChanged(usageView, pingEDT, (JBPopup)popup3));
        AtomicLong firstUsageAddedTS = new AtomicLong();
        AtomicBoolean tooManyResults = new AtomicBoolean();
        Processor<Usage> collect2 = usage2 -> {
            if (!UsageViewManagerImpl.isInScope((Usage)usage2, (SearchScope)searchScope2)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleUsages.add(USAGES_OUTSIDE_SCOPE_NODE.getUsage());
                    usages.add(table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.size() >= parameters2.maxUsages) {
                    tooManyResults.set(true);
                    return false;
                }
                UsageNode nodes2 = ReadAction.compute(() -> usageView.doAppendUsage(usage2));
                usages.add(usage2);
                firstUsageAddedTS.compareAndSet(0L, System.nanoTime());
                if (nodes2 != null) {
                    visibleUsages.add(nodes2.getUsage());
                    boolean continueSearch = true;
                    if (visibleUsages.size() == parameters2.maxUsages) {
                        visibleUsages.add(MORE_USAGES_SEPARATOR_NODE.getUsage());
                        usages.add(table.MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        UsageSearcher usageSearcher = actionHandler.createUsageSearcher();
        long searchStarted = System.nanoTime();
        FindUsagesManager.startProcessUsages(indicator, project2, usageSearcher, collect2, () -> ApplicationManager.getApplication().invokeLater(() -> {
            showUsagesPopupData.header.disposeProcessIcon();
            pingEDT.ping();
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.isEmpty()) {
                    if (usages.isEmpty()) {
                        String hint = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{searchScope2.getDisplayName()});
                        ShowUsagesAction.hint(false, hint, parameters2, actionHandler);
                        ShowUsagesAction.cancel((JBPopup)popup3);
                    }
                } else if (visibleUsages.size() == 1) {
                    if (usages.size() == 1) {
                        Usage usage2 = (Usage)visibleUsages.iterator().next();
                        if (usage2 == table.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                            String hint = UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)searchScope2);
                            ShowUsagesAction.hint(true, hint, parameters2, actionHandler);
                        } else {
                            String hint = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(usage2, hint, parameters2, actionHandler);
                        }
                        ShowUsagesAction.cancel((JBPopup)popup3);
                    } else {
                        assert (usages.size() > 1) : usages;
                        Usage visibleUsage = (Usage)visibleUsages.iterator().next();
                        if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                            String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(visibleUsage, hint, parameters2, actionHandler);
                            ShowUsagesAction.cancel((JBPopup)popup3);
                        }
                    }
                }
            }
            long current = System.nanoTime();
            UsageViewStatisticsCollector.logSearchFinished((Project)project2, (UsageView)usageView, actionHandler.getTargetClass(), (SearchScope)searchScope2, (Language)actionHandler.getTargetLanguage(), (int)visibleUsages.size(), (long)TimeUnit.NANOSECONDS.toMillis(current - firstUsageAddedTS.get()), (long)TimeUnit.NANOSECONDS.toMillis(current - searchStarted), (boolean)tooManyResults.get(), (boolean)indicator.isCanceled(), (CodeNavigateSource)CodeNavigateSource.ShowUsagesPopup);
        }, project2.getDisposed()));
    }

    private static void toggleFilters(@NotNull List<? extends ToggleAction> unselectedActions) {
        if (unselectedActions == null) {
            ShowUsagesAction.$$$reportNull$$$0(25);
        }
        for (ToggleAction toggleAction : unselectedActions) {
            toggleAction.actionPerformed(ShowUsagesAction.fakeEvent(toggleAction));
        }
    }

    @NotNull
    private static AnActionEvent fakeEvent(@NotNull ToggleAction action2) {
        if (action2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(26);
        }
        return new AnActionEvent(null, DataContext.EMPTY_CONTEXT, "", action2.getTemplatePresentation(), ActionManager.getInstance(), 0);
    }

    @NotNull
    private static UsageViewImpl createUsageView(@NotNull Project project2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(27);
        }
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setDetachedMode(true);
        return new UsageViewImpl(project2, usageViewPresentation, UsageTarget.EMPTY_ARRAY, null){

            @NotNull
            public UsageViewSettings getUsageViewSettings() {
                ShowUsageViewSettings showUsageViewSettings = ShowUsagesSettings.getInstance().getState();
                if (showUsageViewSettings == null) {
                    5.$$$reportNull$$$0(0);
                }
                return showUsageViewSettings;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$5", "getUsageViewSettings"));
            }
        };
    }

    @NotNull
    private static Predicate<? super Usage> originUsageCheck(@Nullable Editor editor2) {
        if (editor2 != null) {
            PsiReference reference2 = TargetElementUtil.findReference(editor2);
            if (reference2 != null) {
                UsageInfo originUsageInfo = new UsageInfo(reference2);
                Predicate<Usage> predicate2 = usage2 -> usage2 instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage2).getUsageInfo().equals(originUsageInfo);
                if (predicate2 == null) {
                    ShowUsagesAction.$$$reportNull$$$0(28);
                }
                return predicate2;
            }
            int offset2 = editor2.getCaretModel().getOffset();
            Predicate<Usage> predicate3 = usage2 -> {
                if (usage2 instanceof Psi2UsageInfo2UsageAdapter) {
                    Psi2UsageInfo2UsageAdapter adapter = (Psi2UsageInfo2UsageAdapter)((Object)usage2);
                    for (UsageInfo info2 : adapter.getMergedInfos()) {
                        Segment range = ObjectUtils.doIfNotNull(info2.getPsiFileRange(), SmartPsiFileRange::getRange);
                        if (range == null || range.getStartOffset() > offset2 || offset2 > range.getEndOffset()) continue;
                        return true;
                    }
                }
                return false;
            };
            if (predicate3 == null) {
                ShowUsagesAction.$$$reportNull$$$0(29);
            }
            return predicate3;
        }
        Predicate<Usage> predicate4 = __ -> false;
        if (predicate4 == null) {
            ShowUsagesAction.$$$reportNull$$$0(30);
        }
        return predicate4;
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition, Ref<Long> popupShownTime) {
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(31);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(32);
        }
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            popupShownTime.set(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    @NotNull
    private static JComponent createHintComponent(@NotNull @NlsContexts.HintText String secondInvocationTitle, boolean isWarning, @NotNull JComponent button2) {
        if (secondInvocationTitle == null) {
            ShowUsagesAction.$$$reportNull$$$0(33);
        }
        if (button2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(34);
        }
        JComponent label2 = HintUtil.createInformationLabel((String)secondInvocationTitle);
        if (isWarning) {
            label2.setBackground(MessageType.WARNING.getPopupBackground());
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        button2.setBackground(label2.getBackground());
        panel2.setBackground(label2.getBackground());
        label2.setOpaque(false);
        label2.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label2, "Center");
        panel2.add((Component)button2, "East");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(35);
        }
        return jPanel;
    }

    @NotNull
    private static InplaceButton createSettingsButton(@NotNull Project project2, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAndFindUsagesRunnable) {
        KeyboardShortcut shortcut;
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(36);
        }
        if (cancelAction == null) {
            ShowUsagesAction.$$$reportNull$$$0(37);
        }
        if (showDialogAndFindUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(38);
        }
        String tooltip = (shortcut = UsageViewUtil.getShowUsagesWithSettingsShortcut()) == null ? FindBundle.message("show.usages.settings.tooltip", new Object[0]) : FindBundle.message("show.usages.settings.tooltip.shortcut", KeymapUtil.getShortcutText((Shortcut)shortcut));
        return new InplaceButton(tooltip, AllIcons.General.Settings, __ -> {
            ApplicationManager.getApplication().invokeLater(showDialogAndFindUsagesRunnable, project2.getDisposed());
            cancelAction.run();
        });
    }

    @Nullable
    private static FindUsagesOptions showDialog(@NotNull FindUsagesHandlerBase handler2) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(39);
        }
        UIEventLogger.ShowUsagesPopupShowSettings.log(handler2.getProject());
        AbstractFindUsagesDialog dialog = handler2 instanceof FindUsagesHandlerUi ? ((FindUsagesHandlerUi)((Object)handler2)).getFindUsagesDialog(false, false, false) : FindUsagesHandler.createDefaultFindUsagesDialog(false, false, false, handler2);
        if (dialog.showAndGet()) {
            dialog.calcFindUsagesOptions();
            return handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        }
        return null;
    }

    @NotNull
    private static AbstractPopup createUsagePopup(@NotNull UsageViewImpl usageView, @NotNull ShowUsagesPopupData showUsagesPopupData, final @NotNull Runnable itemChoseCallback, @NotNull Consumer<? super AbstractPopup> tableResizer) {
        boolean speedSearchAdded;
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(40);
        }
        if (showUsagesPopupData == null) {
            ShowUsagesAction.$$$reportNull$$$0(41);
        }
        if (itemChoseCallback == null) {
            ShowUsagesAction.$$$reportNull$$$0(42);
        }
        if (tableResizer == null) {
            ShowUsagesAction.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final @NotNull JTable table = showUsagesPopupData.table;
        final @NotNull AtomicReference<AbstractPopup> popupRef = showUsagesPopupData.popupRef;
        final @NotNull ShowUsagesActionHandler actionHandler = showUsagesPopupData.actionHandler;
        final @NotNull ShowUsagesParameters parameters2 = showUsagesPopupData.parameters;
        @NotNull Project project2 = parameters2.project;
        @NotNull DialogPanel headerPanel = showUsagesPopupData.header.panel;
        SpeedSearchAdvertiser advertiser = new SpeedSearchAdvertiser();
        String hint = ShowUsagesActionHandler.getSecondInvocationHint(actionHandler);
        JPanel advertiserComponent = null;
        boolean hintAdded = advertiser.addAdvertisement(hint);
        boolean bl = speedSearchAdded = advertiser.addSpeedSearchAdvertisement() != null;
        if (hintAdded || speedSearchAdded) {
            advertiserComponent = advertiser.getComponent();
        }
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(table).setTitle(showUsagesPopupData.header.getTitle()).setAdvertiser((JComponent)advertiserComponent).setMovable(true).setResizable(true).setCancelKeyEnabled(true).setDimensionServiceKey(DIMENSION_SERVICE_KEY);
        final PropertiesComponent properties = PropertiesComponent.getInstance(project2);
        boolean addCodePreview = properties.isValueSet(PREVIEW_PROPERTY_KEY);
        OnePixelSplitter contentSplitter = null;
        if (addCodePreview) {
            contentSplitter = new OnePixelSplitter(true, 0.6f);
            contentSplitter.setSplitterProportionKey(SPLITTER_SERVICE_KEY);
            contentSplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_SECOND_SIZE);
            contentSplitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
            builder2.setContentSplitter((JBSplitter)contentSplitter);
        }
        Disposable contentDisposable = Disposer.newDisposable();
        KeyboardShortcut shortcut = UsageViewUtil.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$6", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$7", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        DefaultActionGroup filteringGroup = new DefaultActionGroup();
        usageView.addFilteringActions(filteringGroup);
        filteringGroup.add(ActionManager.getInstance().getAction("UsageGrouping.FileStructure"));
        filteringGroup.add((AnAction)new ToggleAction(UsageViewBundle.message((String)"preview.usages.action.text", (Object[])new Object[0]), null, AllIcons.Actions.PreviewDetailsVertically){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                return properties.isValueSet(ShowUsagesAction.PREVIEW_PROPERTY_KEY);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    8.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(2);
                }
                if (e.getDataContext() != DataContext.EMPTY_CONTEXT) {
                    properties.setValue(ShowUsagesAction.PREVIEW_PROPERTY_KEY, state);
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    WindowStateService.getInstance().putSize(ShowUsagesAction.DIMENSION_SERVICE_KEY, null);
                    ShowUsagesAction.showElementUsages(parameters2, actionHandler);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        });
        JPanel northPanel = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine();
        ActionToolbar actionToolbar = ShowUsagesAction.createActionToolbar(table, filteringGroup);
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        northPanel.add((Component)toolbarComponent, gc.next());
        if (!(actionHandler.getMaximalScope() instanceof LocalSearchScope)) {
            DefaultActionGroup scopeChooserGroup = new DefaultActionGroup(new AnAction[]{ShowUsagesAction.createScopeChooser(project2, contentDisposable, usageView, showUsagesPopupData)});
            ActionToolbar scopeChooserToolbar = ActionManager.getInstance().createActionToolbar("ShowUsagesPopupToolbar", (ActionGroup)scopeChooserGroup, true);
            scopeChooserToolbar.setTargetComponent((JComponent)table);
            scopeChooserToolbar.setLayoutPolicy(0);
            ((ActionToolbarImpl)scopeChooserToolbar).setForceMinimumSize(true);
            JComponent component2 = scopeChooserToolbar.getComponent();
            component2.setBorder(JBUI.Borders.empty());
            component2.setOpaque(false);
            northPanel.add((Component)component2, gc.next());
        }
        JBDimension fillerSize = JBUI.size(8, 0);
        northPanel.add((Component)new Box.Filler(fillerSize, fillerSize, fillerSize), gc.next().weightx(1.0));
        DefaultActionGroup settingsGroup = new DefaultActionGroup(new AnAction[]{new SettingsAction(project2, () -> ShowUsagesAction.cancel((JBPopup)popupRef.get()), ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler))});
        actionToolbar = ShowUsagesAction.createActionToolbar(table, settingsGroup);
        ((ActionToolbarImpl)actionToolbar).setForceMinimumSize(true);
        JComponent settingsToolbarComponent = actionToolbar.getComponent();
        settingsToolbarComponent.setOpaque(false);
        if (Registry.is("ide.usages.popup.show.options.string")) {
            JLabel optionsLabel = new JLabel(actionHandler.getPresentation().getOptionsString());
            if (ExperimentalUI.isNewUI()) {
                optionsLabel.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
            }
            northPanel.add((Component)optionsLabel, gc.next());
        }
        northPanel.add((Component)settingsToolbarComponent, gc.next());
        builder2.setNorthComponent((JComponent)northPanel);
        PopupUpdateProcessor processor = new PopupUpdateProcessor(usageView.getProject()){

            public void updatePopup(Object lookupItemObject) {
            }
        };
        builder2.addListener((JBPopupListener)processor);
        if (addCodePreview) {
            SimpleColoredComponent previewTitle = new SimpleColoredComponent();
            PopupUtil.applyPreviewTitleInsets((JComponent)previewTitle);
            UsagePreviewPanel usagePreviewPanel = new UsagePreviewPanel(project2, usageView.getPresentation(), false){

                public Dimension getPreferredSize() {
                    return new Dimension(table.getWidth(), Math.max(this.getHeight(), this.getLineHeight() * 5));
                }

                public Dimension getMinimumSize() {
                    Dimension size = super.getMinimumSize();
                    size.height = this.getLineHeight() * 5;
                    return size;
                }
            };
            PropertyChangeListener lineHeightListener = e -> {
                if ((Integer)e.getNewValue() > 0) {
                    tableResizer.accept((AbstractPopup)popupRef.get());
                }
            };
            usagePreviewPanel.addPropertyChangeListener("UsageViewPanel.lineHeightProperty", lineHeightListener);
            Disposer.register(contentDisposable, () -> usagePreviewPanel.removePropertyChangeListener(lineHeightListener));
            Disposer.register(contentDisposable, (Disposable)usagePreviewPanel);
            JPanel previewPanel = new JPanel(new BorderLayout());
            previewPanel.add((Component)previewTitle, "North");
            previewPanel.add((Component)usagePreviewPanel.createComponent(), "Center");
            contentSplitter.setSecondComponent((JComponent)previewPanel);
            if (ExperimentalUI.isNewUI()) {
                previewPanel.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
                previewTitle.setOpaque(false);
            }
            new DoubleClickListener(){

                protected boolean onDoubleClick(@NotNull MouseEvent event) {
                    if (event == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    if (event.getSource() != table) {
                        return false;
                    }
                    itemChoseCallback.run();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/actions/ShowUsagesAction$11", "onDoubleClick"));
                }
            }.installOn((Component)table);
            builder2.setAutoselectOnMouseMove(false).setCloseOnEnter(false).registerKeyboardAction(KeyStroke.getKeyStroke(10, 0), __ -> itemChoseCallback.run());
            Runnable updatePreviewRunnable = () -> {
                if (((AbstractPopup)popupRef.get()).isDisposed()) {
                    return;
                }
                int[] selectedRows = table.getSelectedRows();
                SmartList<CompletableFuture> selectedUsagePromises = new SmartList<CompletableFuture>();
                String file2 = null;
                for (int row : selectedRows) {
                    Usage usage2;
                    Object value = table.getModel().getValueAt(row, 0);
                    if (!(value instanceof UsageNode) || !((usage2 = ((UsageNode)value).getUsage()) instanceof UsageInfoAdapter)) continue;
                    UsageInfoAdapter adapter = (UsageInfoAdapter)usage2;
                    file2 = adapter.getPath();
                    if (!adapter.isValid()) continue;
                    selectedUsagePromises.add(adapter.getMergedInfosAsync());
                }
                @NotNull String selectedFile = file2;
                CompletableFuture.allOf(selectedUsagePromises.toArray(new CompletableFuture[0])).thenAccept(__ -> {
                    ArrayList selectedUsages = new ArrayList(selectedUsagePromises.size());
                    for (CompletableFuture f : selectedUsagePromises) {
                        try {
                            UsageInfo[] usageInfos2 = (UsageInfo[])f.get();
                            Collections.addAll(selectedUsages, usageInfos2);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    usagePreviewPanel.updateLayout(selectedUsages);
                    previewTitle.clear();
                    if (usagePreviewPanel.getCannotPreviewMessage(selectedUsages) == null && selectedFile != null) {
                        previewTitle.append(PathUtil.getFileName(selectedFile), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                });
            };
            Alarm previewUpdater = new Alarm(contentDisposable);
            table.getSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting() && !previewUpdater.isDisposed()) {
                    previewUpdater.addRequest(updatePreviewRunnable, 50);
                }
            });
        } else {
            builder2.setAutoselectOnMouseMove(true).setItemChoosenCallback(itemChoseCallback).setCloseOnEnter(true);
        }
        AbstractPopup popup2 = (AbstractPopup)builder2.createPopup();
        JComponent content2 = popup2.getContent();
        Disposer.register((Disposable)popup2, contentDisposable);
        CaptionPanel captionPanel = popup2.getTitle();
        Container parent2 = captionPanel.getParent();
        if (parent2 != null) {
            parent2.remove(captionPanel);
            parent2.add((Component)headerPanel);
            WindowMoveListener windowListener2 = new WindowMoveListener((Component)headerPanel);
            headerPanel.addMouseListener((MouseListener)windowListener2);
            headerPanel.addMouseMotionListener((MouseMotionListener)windowListener2);
        }
        if (ExperimentalUI.isNewUI()) {
            headerPanel.setBorder(JBUI.Borders.compound(JBUI.Borders.customLineBottom(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()), PopupUtil.getComplexPopupHorizontalHeaderBorder()));
            headerPanel.setBackground(JBUI.CurrentTheme.ComplexPopup.HEADER_BACKGROUND);
            Color background = JBUI.CurrentTheme.Popup.BACKGROUND;
            northPanel.setBackground(background);
            table.setBackground(background);
            northPanel.setBorder(ShowUsagesAction.createComplexPopupToolbarBorder());
            toolbarComponent.setBorder(JBUI.Borders.empty());
            settingsToolbarComponent.setBorder(JBUI.Borders.emptyLeft(8));
            if (contentSplitter != null) {
                contentSplitter.setBackground(background);
                contentSplitter.setOpaque(true);
                JBInsets textFieldBorderInsets = JBUI.CurrentTheme.ComplexPopup.textFieldBorderInsets();
                contentSplitter.setBlindZone(() -> new Insets(0, textFieldBorderInsets.left, 0, textFieldBorderInsets.right));
            }
        } else {
            headerPanel.setBorder((Border)JBUI.Borders.empty(2, 15, 2, 2));
            headerPanel.setBackground(JBUI.CurrentTheme.Popup.headerBackground(true));
        }
        parameters2.minWidth.set(-1);
        for (AnAction action2 : filteringGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        for (AnAction action2 : showUsagesPopupData.pinGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        popup2.setUserData(addCodePreview ? Arrays.asList(filteringGroup, contentSplitter) : Collections.singletonList(filteringGroup));
        popup2.setDataProvider(dataId -> {
            if (UsageView.USAGE_VIEW_SETTINGS_KEY.is(dataId)) {
                return usageView.getUsageViewSettings();
            }
            return null;
        });
        popupRef.set(popup2);
        AbstractPopup abstractPopup = popup2;
        if (abstractPopup == null) {
            ShowUsagesAction.$$$reportNull$$$0(44);
        }
        return abstractPopup;
    }

    private static Border createComplexPopupToolbarBorder() {
        JBInsets lineInsets = JBUI.CurrentTheme.ComplexPopup.textFieldBorderInsets();
        return JBUI.Borders.compound(new EmptyBorder(0, lineInsets.left, 4, lineInsets.right), JBUI.Borders.customLineBottom(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()), JBUI.Borders.empty(JBUI.CurrentTheme.ComplexPopup.innerBorderInsets()));
    }

    @NotNull
    static ActionToolbar createActionToolbar(@NotNull JTable table, @NotNull DefaultActionGroup group2) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(45);
        }
        if (group2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(46);
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ShowUsagesPopupToolbar", (ActionGroup)group2, true);
        actionToolbar.setTargetComponent((JComponent)table);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar actionToolbar2 = actionToolbar;
        if (actionToolbar2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(47);
        }
        return actionToolbar2;
    }

    static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @NotNull
    private static ScopeChooserGroup createScopeChooser(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull UsageViewImpl usageView, @NotNull ShowUsagesPopupData showUsagesPopupData) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(48);
        }
        if (parentDisposable == null) {
            ShowUsagesAction.$$$reportNull$$$0(49);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(50);
        }
        if (showUsagesPopupData == null) {
            ShowUsagesAction.$$$reportNull$$$0(51);
        }
        ShowUsagesActionHandler actionHandler = showUsagesPopupData.actionHandler;
        ScopeChooserGroup result2 = new ScopeChooserGroup(project2, parentDisposable, actionHandler.getSelectedScope());
        result2.addChangeListener(scope -> {
            UsageViewStatisticsCollector.logScopeChanged((Project)project2, (UsageView)usageView, (SearchScope)actionHandler.getSelectedScope(), (SearchScope)scope, actionHandler.getTargetClass());
            ShowUsagesAction.cancel((JBPopup)showUsagesPopupData.popupRef.get());
            ShowUsagesAction.showElementUsages(showUsagesPopupData.parameters, actionHandler.withScope((SearchScope)scope));
        });
        ScopeChooserGroup scopeChooserGroup = result2;
        if (scopeChooserGroup == null) {
            ShowUsagesAction.$$$reportNull$$$0(52);
        }
        return scopeChooserGroup;
    }

    @Nls
    @NotNull
    private static String suggestSecondInvocation(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String text2, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String hint) {
        if (text2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(53);
        }
        HtmlBuilder builder2 = new HtmlBuilder().append(text2);
        if (hint != null) {
            builder2.br().append(HtmlChunk.text(hint).wrapWith("small"));
        }
        String string2 = builder2.wrapWithHtmlBody().toString();
        if (string2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(54);
        }
        return string2;
    }

    @Nullable
    static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int getFilteredOutNodeCount(@NotNull List<? extends Usage> usages, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(55);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(56);
        }
        return (int)usages.stream().filter(usage2 -> !usageView.isVisible(usage2)).count();
    }

    @Nullable
    private static UsageNode getSelectedUsageNode(@NotNull ShowUsagesTable table) {
        int selectedRowNumber;
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(57);
        }
        if ((selectedRowNumber = table.getSelectedRow()) != -1) {
            Object selectedNode = table.getModel().getValueAt(selectedRowNumber, 0);
            return ObjectUtils.tryCast(selectedNode, UsageNode.class);
        }
        return null;
    }

    private static int getRowNumber(@Nullable UsageNode node2, @NotNull ShowUsagesTable table) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(58);
        }
        for (int i2 = 0; i2 < table.getRowCount(); ++i2) {
            if (table.getValueAt(i2, 0) != node2) continue;
            return i2;
        }
        return -1;
    }

    private static int getUsageOffset(@NotNull Usage usage2) {
        if (usage2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(59);
        }
        if (!(usage2 instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element = ((UsageInfo2UsageAdapter)usage2).getElement();
        if (element == null) {
            return -1;
        }
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance(element.getProject());
        if (injectionManager.isInjectedFragment(element.getContainingFile())) {
            return injectionManager.injectedToHost(element, element.getTextRange().getStartOffset());
        }
        return element.getTextRange().getStartOffset();
    }

    static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<? extends Usage> usages) {
        Editor editor2;
        if (visibleUsage == null) {
            ShowUsagesAction.$$$reportNull$$$0(60);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(61);
        }
        if ((editor2 = ShowUsagesAction.getEditorFor(visibleUsage)) == null) {
            return false;
        }
        int offset2 = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset2 == -1) {
            return false;
        }
        int lineNumber = editor2.getDocument().getLineNumber(offset2);
        for (Usage usage2 : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(usage2);
            if (otherEditor != editor2) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(usage2);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    private static int calcMaxWidth(@NotNull JTable table) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(62);
        }
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(63);
        }
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            Component component2 = table.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component2.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private static void rebuildTable(@NotNull Project project2, @NotNull Predicate<? super Usage> originUsageCheck, @NotNull List<UsageNode> data2, @NotNull ShowUsagesTable table, @Nullable AbstractPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, @NotNull AtomicBoolean manuallyResized) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(64);
        }
        if (originUsageCheck == null) {
            ShowUsagesAction.$$$reportNull$$$0(65);
        }
        if (data2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(66);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(67);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(68);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(69);
        }
        if (manuallyResized == null) {
            ShowUsagesAction.$$$reportNull$$$0(70);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ShowUsagesTable.MyModel tableModel = table.setTableModel(data2);
        List existingData = tableModel.getItems();
        int row = table.getSelectedRow();
        int newSelection = ShowUsagesAction.updateModel(tableModel, existingData, data2, row == -1 ? 0 : row);
        if (newSelection < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)((Object)table));
            newSelection = table.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table.getModel().getRowCount() > 1 && (valueInTopRow = table.getModel().getValueAt(0, 0)) instanceof UsageNode && originUsageCheck.test((Usage)((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)((Object)table), (int)newSelection, (int)0);
        if (popup2 != null) {
            if (manuallyResized.get()) {
                ShowUsagesAction.calcMaxWidth((JTable)((Object)table));
            } else {
                PropertiesComponent properties = PropertiesComponent.getInstance(project2);
                ShowUsagesAction.setPopupSize((JTable)((Object)table), popup2, popupPosition, minWidth, properties.isValueSet(PREVIEW_PROPERTY_KEY), data2.size());
            }
        }
    }

    private static int updateModel(@NotNull ShowUsagesTable.MyModel tableModel, @NotNull List<? extends UsageNode> listOld, @NotNull List<? extends UsageNode> listNew, int oldSelection) {
        if (tableModel == null) {
            ShowUsagesAction.$$$reportNull$$$0(71);
        }
        if (listOld == null) {
            ShowUsagesAction.$$$reportNull$$$0(72);
        }
        if (listNew == null) {
            ShowUsagesAction.$$$reportNull$$$0(73);
        }
        UsageNode[] oa = listOld.toArray(new UsageNode[0]);
        UsageNode[] na = listNew.toArray(new UsageNode[0]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private static void setPopupSize(@NotNull JTable table, @NotNull AbstractPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, boolean showCodePreview, int dataSize) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(74);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(75);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(76);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(77);
        }
        if (ShowUsagesAction.isCodeWithMeClientInstance((JBPopup)popup2)) {
            return;
        }
        Dimension d = popup2.getSize();
        Insets contentInsets = popup2.getContent().getInsets();
        JBInsets.removeFrom(d, contentInsets);
        Component toolbarComponent = ((BorderLayout)popup2.getComponent().getLayout()).getLayoutComponent("North");
        Dimension toolbarSize = toolbarComponent != null ? toolbarComponent.getPreferredSize() : JBUI.emptySize();
        Dimension headerSize = popup2.getHeaderPreferredSize();
        int width = Math.max(d.width, ShowUsagesAction.calcMaxWidth(table));
        width = Math.max(Math.max(headerSize.width, width), toolbarSize.width);
        width = Math.max(minWidth.get(), width);
        int delta = minWidth.get() == -1 ? 0 : width - minWidth.get();
        int newWidth = Math.max(width, d.width + delta);
        minWidth.set(newWidth);
        int minHeight = headerSize.height + toolbarSize.height;
        Rectangle rectangle = ShowUsagesAction.getPreferredBounds(table, popupPosition.getScreenPoint(), newWidth, minHeight, dataSize, showCodePreview);
        table.setSize(rectangle.width, rectangle.height - minHeight);
        if (dataSize > 0) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
        }
        Dimension savedSize = WindowStateService.getInstance().getSize(DIMENSION_SERVICE_KEY);
        JBSplitter splitter = (JBSplitter)popup2.getUserData(JBSplitter.class);
        if (savedSize != null) {
            rectangle.width = Math.min(savedSize.width, rectangle.width);
        }
        if (splitter != null) {
            int newHeight = rectangle.height + splitter.getDividerWidth() + splitter.getSecondComponent().getMinimumSize().height;
            if (savedSize != null) {
                savedSize.height -= popup2.getAdComponentHeight();
                newHeight = Math.max(newHeight, savedSize.height);
            }
            rectangle.height = newHeight;
        }
        popup2.setSize(rectangle.getSize());
    }

    private static boolean isCodeWithMeClientInstance(@NotNull JBPopup popup2) {
        JComponent content2;
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(78);
        }
        return (content2 = popup2.getContent()).getClientProperty("THIN_CLIENT") != null;
    }

    @NotNull
    private static Rectangle getPreferredBounds(@NotNull JTable table, @NotNull Point point, int width, int minHeight, int modelRows, boolean showCodePreview) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(79);
        }
        if (point == null) {
            ShowUsagesAction.$$$reportNull$$$0(80);
        }
        boolean addExtraSpace = Registry.is("ide.preferred.scrollable.viewport.extra.space");
        int visibleRows = Math.min(showCodePreview ? 20 : 30, modelRows);
        int rowHeight = table.getRowHeight();
        int space = addExtraSpace && visibleRows < modelRows ? rowHeight / 2 : 0;
        int height = visibleRows * rowHeight + minHeight + space;
        if (ExperimentalUI.isNewUI() && space == 0 && visibleRows == modelRows) {
            height += JBUIScale.scale(4);
        }
        Rectangle bounds = new Rectangle(point.x, point.y, width, height);
        ScreenUtil.fitToScreen(bounds);
        if (bounds.height != height) {
            bounds.height = Math.max(1, (bounds.height - (minHeight += addExtraSpace && space == 0 ? rowHeight / 2 : space)) / rowHeight) * rowHeight + minHeight;
        }
        Rectangle rectangle = bounds;
        if (rectangle == null) {
            ShowUsagesAction.$$$reportNull$$$0(81);
        }
        return rectangle;
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<? super UsageNode> outNodes) {
        if (root == null) {
            ShowUsagesAction.$$$reportNull$$$0(82);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(83);
        }
        if (outNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(84);
        }
        for (UsageNode node2 : root.getUsageNodes()) {
            Usage usage2 = node2.getUsage();
            if (!usageView.isVisible(usage2)) continue;
            node2.setParent((MutableTreeNode)root);
            outNodes.add((UsageNode)node2);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private static void navigateAndHint(@NotNull Usage usage2, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (usage2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(85);
        }
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(86);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(87);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(88);
        }
        usage2.navigate(true);
        Editor newEditor = ShowUsagesAction.getEditorFor(usage2);
        if (newEditor == null) {
            return;
        }
        ShowUsagesAction.hint(false, hint, parameters2.withEditor(newEditor), actionHandler);
    }

    private static void hint(boolean isWarning, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(89);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(90);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(91);
        }
        Project project2 = parameters2.project;
        Editor editor2 = parameters2.editor;
        Runnable runnable = () -> {
            if (!actionHandler.isValid()) {
                return;
            }
            ReadAction.nonBlocking(() -> ShowUsagesAction.suggestSecondInvocation(hint, ShowUsagesActionHandler.getSecondInvocationHint(actionHandler))).finishOnUiThread(ModalityState.NON_MODAL, secondInvocationHintHtml -> {
                if (!actionHandler.isValid()) {
                    return;
                }
                JComponent label2 = ShowUsagesAction.createHintComponent(secondInvocationHintHtml, isWarning, (JComponent)ShowUsagesAction.createSettingsButton(project2, ShowUsagesAction::hideHints, ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler)));
                ShowUsagesActionState state = ShowUsagesAction.getState(project2);
                state.continuation = ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler);
                Runnable clearContinuation = () -> {
                    state.continuation = null;
                };
                if (editor2 == null || editor2.isDisposed() || !UIUtil.isShowing(editor2.getContentComponent())) {
                    int flags = 42;
                    HintManager.getInstance().showHint(label2, parameters2.popupPosition, flags, 0, clearContinuation);
                } else {
                    HintManager.getInstance().showInformationHint(editor2, label2, clearContinuation);
                }
            }).submit(AppExecutorUtil.getAppExecutorService());
        };
        if (editor2 == null) {
            IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(runnable));
        } else {
            IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> editor2.getScrollingModel().runActionOnScrollingFinished(() -> IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> AsyncEditorLoader.performWhenLoaded((Editor)editor2, (Runnable)runnable))));
        }
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage2) {
        FileEditorLocation location2;
        if (usage2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(92);
        }
        FileEditor newFileEditor = (location2 = usage2.getLocation()) == null ? null : location2.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    @NotNull
    private static Runnable showMoreUsagesRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(93);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(94);
        }
        Runnable runnable = () -> ShowUsagesAction.showElementUsages(parameters2.moreUsages(), actionHandler);
        if (runnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(95);
        }
        return runnable;
    }

    @NotNull
    private static Runnable showUsagesInMaximalScopeRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(96);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(97);
        }
        Runnable runnable = () -> ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
        if (runnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(98);
        }
        return runnable;
    }

    private static void showUsagesInMaximalScope(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(99);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(100);
        }
        ShowUsagesAction.showElementUsages(parameters2, actionHandler.withScope(actionHandler.getMaximalScope()));
    }

    @NotNull
    private static Runnable showDialogAndRestartRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(101);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(102);
        }
        Runnable runnable = () -> ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
        if (runnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(103);
        }
        return runnable;
    }

    private static void showDialogAndRestart(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        ShowUsagesActionHandler newActionHandler;
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(104);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(105);
        }
        if ((newActionHandler = actionHandler.showDialog()) != null) {
            ShowUsagesAction.showElementUsages(parameters2, newActionHandler);
        }
    }

    @NotNull
    private static ShowUsagesActionState getState(@NotNull Project project2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(106);
        }
        ShowUsagesActionState showUsagesActionState = project2.getService(ShowUsagesActionState.class);
        if (showUsagesActionState == null) {
            ShowUsagesAction.$$$reportNull$$$0(107);
        }
        return showUsagesActionState;
    }

    @TestOnly
    public static void setPopupDelayTimeout(int timeout) {
        ourPopupDelayTimeout = timeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 23, 24, 25, 26, 27, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 53, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 96, 97, 99, 100, 101, 102, 104, 105, 106 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 27: 
            case 36: 
            case 48: 
            case 64: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetVariants";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 32: 
            case 68: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPosition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 40: 
            case 50: 
            case 56: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pingEDT";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationString";
                break;
            }
            case 21: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 24: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unselectedActions";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 31: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondInvocationTitle";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showDialogAndFindUsagesRunnable";
                break;
            }
            case 41: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showUsagesPopupData";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemChoseCallback";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableResizer";
                break;
            }
            case 45: 
            case 57: 
            case 58: 
            case 62: 
            case 63: 
            case 67: 
            case 74: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 59: 
            case 85: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleUsage";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originUsageCheck";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 69: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minWidth";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manuallyResized";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOld";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNew";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNodes";
                break;
            }
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsagesTitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationString";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "originUsageCheck";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsagePopup";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeChooser";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSecondInvocation";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredBounds";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "showMoreUsagesRunnable";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialogAndRestartRunnable";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createVariantHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rulesChanged";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUsagesTitle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createActionHandler";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showElementUsages";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toggleFilters";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fakeEvent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createUsageView";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showPopupIfNeedTo";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsButton";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createUsagePopup";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createScopeChooser";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "suggestSecondInvocation";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredOutNodeCount";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedUsageNode";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getRowNumber";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getUsageOffset";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "areAllUsagesInOneLine";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "calcMaxWidth";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "columnMaxWidth";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTable";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "setPopupSize";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isCodeWithMeClientInstance";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredBounds";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "addUsageNodes";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndHint";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "hint";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFor";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "showMoreUsagesRunnable";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScope";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestartRunnable";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestart";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 23, 24, 25, 26, 27, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 53, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 96, 97, 99, 100, 101, 102, 104, 105, 106 -> new IllegalArgumentException(string2);
        };
    }

    @Service
    private static final class ShowUsagesActionState {
        Runnable continuation;

        private ShowUsagesActionState() {
        }
    }

    static final class StringNode
    extends UsageNode {
        @Nls
        @NotNull
        private final String myString;

        private StringNode(@Nls @NotNull String string2) {
            if (string2 == null) {
                StringNode.$$$reportNull$$$0(0);
            }
            super(null, (Usage)NullUsage.INSTANCE);
            this.myString = string2;
        }

        @Nls
        @NotNull
        String getString() {
            String string2 = this.myString;
            if (string2 == null) {
                StringNode.$$$reportNull$$$0(1);
            }
            return string2;
        }

        public String toString() {
            return this.myString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$StringNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$StringNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class SettingsAction
    extends DumbAwareAction
    implements CustomComponentAction {
        private final Project project;
        private final Runnable cancelAction;
        private final Runnable showDialogAction;

        private SettingsAction(@NotNull Project project2, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAction) {
            if (project2 == null) {
                SettingsAction.$$$reportNull$$$0(0);
            }
            if (cancelAction == null) {
                SettingsAction.$$$reportNull$$$0(1);
            }
            if (showDialogAction == null) {
                SettingsAction.$$$reportNull$$$0(2);
            }
            super(FindBundle.message("show.usages.settings.tooltip", new Object[0]), null, AllIcons.General.GearPlain);
            this.project = project2;
            this.cancelAction = cancelAction;
            this.showDialogAction = showDialogAction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SettingsAction.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().invokeLater(this.showDialogAction, this.project.getDisposed());
            this.cancelAction.run();
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                SettingsAction.$$$reportNull$$$0(4);
            }
            if (place == null) {
                SettingsAction.$$$reportNull$$$0(5);
            }
            return new ActionButton((AnAction)this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Nullable
                protected String getShortcutText() {
                    KeyboardShortcut shortcut = UsageViewUtil.getShowUsagesWithSettingsShortcut();
                    return shortcut != null ? KeymapUtil.getShortcutText((Shortcut)shortcut) : null;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancelAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "showDialogAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$SettingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCustomComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UsageNodeComparator
    implements Comparator<UsageNode> {
        private final ShowUsagesTable myTable;

        private UsageNodeComparator(@NotNull ShowUsagesTable table) {
            if (table == null) {
                UsageNodeComparator.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public int compare(UsageNode c1, UsageNode c2) {
            int weight2;
            int weight1;
            if (c1 instanceof StringNode || c2 instanceof StringNode) {
                if (c1 instanceof StringNode && c2 instanceof StringNode) {
                    return Comparing.compare(c1.toString(), c2.toString());
                }
                return c1 instanceof StringNode ? 1 : -1;
            }
            Usage o1 = c1.getUsage();
            Usage o2 = c2.getUsage();
            int n = o1 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o1 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            int n2 = o2 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o2 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            return UsageViewImpl.USAGE_COMPARATOR_BY_FILE_AND_OFFSET.compare(o1, o2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction$UsageNodeComparator", "<init>"));
        }
    }

    static abstract class FilteredOutUsagesNode
    extends UsageNode {
        @Nls
        @NotNull
        private final String myString;
        @Nls
        @NotNull
        private final String myToolTip;

        private FilteredOutUsagesNode(@NotNull Usage fakeUsage, @Nls @NotNull String string2, @Nls @NotNull String toolTip) {
            if (fakeUsage == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(0);
            }
            if (string2 == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(1);
            }
            if (toolTip == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(2);
            }
            super(null, fakeUsage);
            this.myString = string2;
            this.myToolTip = toolTip;
        }

        @Nls
        @NotNull
        String getString() {
            String string2 = this.myString;
            if (string2 == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Nls
        @NotNull
        String getTooltip() {
            String string2 = this.myToolTip;
            if (string2 == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public String toString() {
            return this.myString;
        }

        public abstract void onSelected();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fakeUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolTip";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4 -> new IllegalStateException(string2);
            };
        }
    }
}

