/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.GapsKt;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ-\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0007J\u001e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/find/actions/ShowUsagesHeader;", "", "pinButton", "Ljavax/swing/JComponent;", "title", "", "(Ljavax/swing/JComponent;Ljava/lang/String;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "processIcon", "Lcom/intellij/util/ui/AsyncProcessIcon;", "statusLabel", "Ljavax/swing/JLabel;", "titleLabel", "disposeProcessIcon", "", "getStatusString", "Lorg/jetbrains/annotations/Nls;", "findUsagesInProgress", "", "hasMore", "visibleCount", "", "totalCount", "getTitle", "setStatusText", "intellij.platform.lang.impl"})
public final class ShowUsagesHeader {
    @JvmField
    @NotNull
    public final DialogPanel panel;
    private JLabel titleLabel;
    private AsyncProcessIcon processIcon;
    private JLabel statusLabel;

    public ShowUsagesHeader(final @NotNull JComponent pinButton, final @NlsContexts.PopupTitle @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)pinButton, (String)"pinButton");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new IntelliJSpacingConfiguration(){

                    public int getVerticalComponentGap() {
                        return 0;
                    }
                }, (Function1)new Function1<Panel, Unit>(){

                    public final void invoke(@NotNull Panel $this$customizeSpacingConfiguration) {
                        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
                        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(){

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Cell titleCell = $this$row.cell((JComponent)new JLabel(XmlStringUtil.wrapInHtml("<body><nobr>" + title + "</nobr></body>"))).resizableColumn().gap(RightGap.SMALL);
                                titleLabel = (JLabel)titleCell.getComponent();
                                processIcon = (AsyncProcessIcon)$this$row.cell((JComponent)new AsyncProcessIcon("xxx")).gap(RightGap.SMALL).getComponent();
                                Cell statusCell = $this$row.label("");
                                statusLabel = (JLabel)statusCell.getComponent();
                                Cell pinCell = $this$row.cell(pinButton);
                                if (ExperimentalUI.isNewUI()) {
                                    JBInsets headerInsets = JBUI.CurrentTheme.ComplexPopup.headerInsets();
                                    titleCell.customize(new Gaps(headerInsets.top, 0, headerInsets.bottom, JBUI.scale(12), 2, null));
                                    ((JLabel)statusCell.getComponent()).setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
                                    statusCell.customize(GapsKt.JBGaps$default((int)0, (int)0, (int)0, (int)8, (int)7, null));
                                    pinCell.customize(GapsKt.JBGaps$default((int)2, (int)0, (int)0, (int)0, (int)14, null));
                                } else {
                                    statusCell.gap(RightGap.SMALL);
                                }
                            }
                        }), (int)1, null);
                    }
                });
            }
        }));
    }

    public final void setStatusText(boolean hasMore, int visibleCount, int totalCount) {
        AsyncProcessIcon asyncProcessIcon;
        JLabel jLabel = this.statusLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            jLabel = null;
        }
        if ((asyncProcessIcon = this.processIcon) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processIcon");
            asyncProcessIcon = null;
        }
        jLabel.setText(this.getStatusString(!asyncProcessIcon.isDisposed(), hasMore, visibleCount, totalCount));
    }

    public final void disposeProcessIcon() {
        block3: {
            Container container;
            AsyncProcessIcon asyncProcessIcon = this.processIcon;
            if (asyncProcessIcon == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processIcon");
                asyncProcessIcon = null;
            }
            Disposer.dispose((Disposable)asyncProcessIcon);
            AsyncProcessIcon asyncProcessIcon2 = this.processIcon;
            if (asyncProcessIcon2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processIcon");
                asyncProcessIcon2 = null;
            }
            Container container2 = asyncProcessIcon2.getParent();
            if (container2 == null) break block3;
            Container $this$disposeProcessIcon_u24lambda_u240 = container = container2;
            boolean bl = false;
            AsyncProcessIcon asyncProcessIcon3 = this.processIcon;
            if (asyncProcessIcon3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processIcon");
                asyncProcessIcon3 = null;
            }
            $this$disposeProcessIcon_u24lambda_u240.remove((Component)asyncProcessIcon3);
            $this$disposeProcessIcon_u24lambda_u240.repaint();
        }
    }

    @NlsContexts.PopupTitle
    @NotNull
    public final String getTitle() {
        JLabel jLabel = this.titleLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleLabel");
            jLabel = null;
        }
        String string2 = jLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"titleLabel.text");
        return string2;
    }

    private final String getStatusString(boolean findUsagesInProgress, boolean hasMore, int visibleCount, int totalCount) {
        String string2;
        if (findUsagesInProgress || hasMore) {
            Object[] objectArray = new Object[]{visibleCount - (hasMore ? 1 : 0)};
            String string3 = UsageViewBundle.message((String)"showing.0.usages", (Object[])objectArray);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n      UsageViewBundle.\u2026(hasMore) 1 else 0)\n    }");
        } else if (visibleCount != totalCount) {
            Object[] objectArray = new Object[]{visibleCount, totalCount};
            String string4 = UsageViewBundle.message((String)"showing.0.of.1.usages", (Object[])objectArray);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n      UsageViewBundle.\u2026eCount, totalCount)\n    }");
        } else {
            Object[] objectArray = new Object[]{totalCount};
            String string5 = UsageViewBundle.message((String)"found.0.usages", (Object[])objectArray);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n      UsageViewBundle.\u2026sages\", totalCount)\n    }");
        }
        return string2;
    }
}

