/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesHeader;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/find/actions/ShowUsagesPopupData;", "", "parameters", "Lcom/intellij/find/actions/ShowUsagesParameters;", "table", "Ljavax/swing/JTable;", "actionHandler", "Lcom/intellij/find/actions/ShowUsagesActionHandler;", "usageView", "Lcom/intellij/usages/UsageView;", "(Lcom/intellij/find/actions/ShowUsagesParameters;Ljavax/swing/JTable;Lcom/intellij/find/actions/ShowUsagesActionHandler;Lcom/intellij/usages/UsageView;)V", "header", "Lcom/intellij/find/actions/ShowUsagesHeader;", "pinGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "popupRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ui/popup/AbstractPopup;", "createPinButton", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "findUsagesRunnable", "Ljava/lang/Runnable;", "intellij.platform.lang.impl"})
public final class ShowUsagesPopupData {
    @JvmField
    @NotNull
    public final ShowUsagesParameters parameters;
    @JvmField
    @NotNull
    public final JTable table;
    @JvmField
    @NotNull
    public final ShowUsagesActionHandler actionHandler;
    @JvmField
    @NotNull
    public final UsageView usageView;
    @JvmField
    @NotNull
    public final AtomicReference<AbstractPopup> popupRef;
    @JvmField
    @NotNull
    public final DefaultActionGroup pinGroup;
    @JvmField
    @NotNull
    public final ShowUsagesHeader header;

    public ShowUsagesPopupData(@NotNull ShowUsagesParameters parameters2, @NotNull JTable table, @NotNull ShowUsagesActionHandler actionHandler, @NotNull UsageView usageView) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)actionHandler, (String)"actionHandler");
        Intrinsics.checkNotNullParameter((Object)usageView, (String)"usageView");
        this.parameters = parameters2;
        this.table = table;
        this.actionHandler = actionHandler;
        this.usageView = usageView;
        this.popupRef = new AtomicReference();
        this.pinGroup = new DefaultActionGroup();
        Project project2 = this.parameters.project;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"parameters.project");
        JComponent jComponent = this.createPinButton(project2, this.popupRef, this.pinGroup, this.table, () -> this.actionHandler.findUsages());
        String string2 = this.actionHandler.getPresentation().getSearchTargetString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"actionHandler.presentation.searchTargetString");
        this.header = new ShowUsagesHeader(jComponent, string2);
    }

    private final JComponent createPinButton(Project project2, AtomicReference<AbstractPopup> popupRef, DefaultActionGroup pinGroup, JTable table, Runnable findUsagesRunnable) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        Icon icon2 = AllIcons.General.Pin_tab;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Pin_tab");
        Icon icon3 = toolWindowManager.getLocationIcon("Find", icon2);
        Supplier supplier2 = IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]);
        Supplier supplier3 = IdeBundle.messagePointer((String)"show.in.find.window.button.pin.description", (Object[])new Object[0]);
        AnAction pinAction2 = new AnAction(icon3, project2, this, popupRef, findUsagesRunnable, supplier2, supplier3){
            final /* synthetic */ Project $project;
            final /* synthetic */ ShowUsagesPopupData this$0;
            final /* synthetic */ AtomicReference<AbstractPopup> $popupRef;
            final /* synthetic */ Runnable $findUsagesRunnable;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$popupRef = $popupRef;
                this.$findUsagesRunnable = $findUsagesRunnable;
                super($super_call_param$1, $super_call_param$2, $icon);
                AnAction action2 = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action2.getShortcutSet());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                UsageViewStatisticsCollector.Companion.logOpenInFindToolWindow(this.$project, this.this$0.usageView);
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel((JBPopup)this.$popupRef.get());
                this.$findUsagesRunnable.run();
            }
        };
        pinGroup.add(pinAction2);
        ActionToolbar actionToolbar = ShowUsagesAction.createActionToolbar(table, pinGroup);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(table, pinGroup)");
        ActionToolbar pinToolbar = actionToolbar;
        JComponent jComponent = pinToolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"pinToolbar.component");
        JComponent result2 = jComponent;
        result2.setBorder(null);
        result2.setOpaque(false);
        return result2;
    }
}

