/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesTable
extends JBTable
implements DataProvider {
    final Usage MORE_USAGES_SEPARATOR;
    final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR;
    final Usage USAGES_FILTERED_OUT_SEPARATOR;
    private final ShowUsagesTableCellRenderer myRenderer;
    private final UsageView myUsageView;

    ShowUsagesTable(@NotNull ShowUsagesTableCellRenderer renderer, UsageView usageView) {
        if (renderer == null) {
            ShowUsagesTable.$$$reportNull$$$0(0);
        }
        this.MORE_USAGES_SEPARATOR = new UsageAdapter();
        this.USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
        this.USAGES_FILTERED_OUT_SEPARATOR = new UsageAdapter();
        this.myRenderer = renderer;
        this.myUsageView = usageView;
        ScrollingUtil.installActions((JTable)((Object)this));
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ShowUsagesTable.$$$reportNull$$$0(1);
        }
        if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
            return PopupUtil.getPopupContainerFor((Component)((Object)this));
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            List selection = Arrays.stream(this.getSelectedRows()).mapToObj(o -> this.getValueAt(o, 0)).collect(Collectors.toList());
            return slowId -> ShowUsagesTable.getSlowData(slowId, selection);
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull List<Object> selection) {
        if (dataId == null) {
            ShowUsagesTable.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            ShowUsagesTable.$$$reportNull$$$0(3);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            Object single2 = ContainerUtil.getOnlyItem(selection);
            return single2 == null ? null : ShowUsagesTable.getPsiElementForHint(single2);
        }
        return null;
    }

    public int getRowHeight() {
        if (ExperimentalUI.isNewUI()) {
            Insets innerInsets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
            return JBUI.CurrentTheme.List.rowHeight() + innerInsets.top + innerInsets.bottom;
        }
        return super.getRowHeight() + 4;
    }

    @NotNull
    Runnable prepareTable(@NotNull Runnable appendMoreUsageRunnable, @NotNull Runnable showInMaximalScopeRunnable, @NotNull ShowUsagesActionHandler actionHandler) {
        if (appendMoreUsageRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(4);
        }
        if (showInMaximalScopeRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(5);
        }
        if (actionHandler == null) {
            ShowUsagesTable.$$$reportNull$$$0(6);
        }
        MySpeedSearch speedSearch = new MySpeedSearch(this);
        speedSearch.setComparator(new SpeedSearchComparator(false));
        this.setRowHeight(IconManager.getInstance().getPlatformIcon(PlatformIcons.Class).getIconHeight() + 2);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setTableHeader(null);
        this.setAutoResizeMode(3);
        this.setIntercellSpacing(new Dimension(0, 0));
        AtomicReference selectedUsages = new AtomicReference();
        AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        AtomicReference filteredOutUsagesSelected = new AtomicReference();
        this.getSelectionModel().addListSelectionListener(e -> {
            selectedUsages.set(null);
            outsideScopeUsagesSelected.set(false);
            moreUsagesSelected.set(false);
            filteredOutUsagesSelected.set(null);
            ArrayList<Usage> usages = null;
            for (int i2 : this.getSelectedRows()) {
                Object value = this.getValueAt(i2, 0);
                if (!(value instanceof UsageNode)) continue;
                Usage usage2 = ((UsageNode)value).getUsage();
                if (usage2 == this.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                    outsideScopeUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage2 == this.MORE_USAGES_SEPARATOR) {
                    moreUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage2 == this.USAGES_FILTERED_OUT_SEPARATOR) {
                    filteredOutUsagesSelected.set((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)value)));
                    usages = null;
                    break;
                }
                if (usages == null) {
                    usages = new ArrayList<Usage>();
                }
                usages.add((Usage)(usage2 instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage2).getUsageInfo().copy() : usage2));
            }
            selectedUsages.set(usages);
        });
        Runnable runnable = () -> {
            if (moreUsagesSelected.get()) {
                appendMoreUsageRunnable.run();
                return;
            }
            if (outsideScopeUsagesSelected.get()) {
                showInMaximalScopeRunnable.run();
                return;
            }
            if (filteredOutUsagesSelected.get() != null) {
                ((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)filteredOutUsagesSelected.get()))).onSelected();
                return;
            }
            List usages = (List)selectedUsages.get();
            if (usages != null) {
                for (Object usage2 : usages) {
                    if (usage2 instanceof UsageInfo) {
                        UsageInfo usageInfo = (UsageInfo)usage2;
                        PsiElement selectedElement = usageInfo.getElement();
                        if (selectedElement != null) {
                            String recentSearchText = speedSearch.getComparator().getRecentSearchText();
                            int numberOfLettersTyped = recentSearchText != null ? recentSearchText.length() : 0;
                            Project project2 = selectedElement.getProject();
                            UsageViewStatisticsCollector.logItemChosenInPopupFeatures((Project)project2, (UsageView)this.myUsageView, (PsiElement)selectedElement, actionHandler.buildFinishEventData(usageInfo));
                            UsageViewStatisticsCollector.logItemChosen((Project)project2, (UsageView)this.myUsageView, (CodeNavigateSource)CodeNavigateSource.ShowUsagesPopup, (Integer)this.getSelectedRow(), (Integer)this.getRowCount(), (Integer)numberOfLettersTyped, (Language)selectedElement.getLanguage(), (boolean)false);
                        }
                        UsageViewUtil.navigateTo((UsageInfo)usageInfo, (boolean)true);
                        continue;
                    }
                    if (!(usage2 instanceof Navigatable)) continue;
                    ((Navigatable)usage2).navigate(true);
                }
            }
        };
        if (runnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(7);
        }
        return runnable;
    }

    public boolean isSeparatorNode(@Nullable Usage node2) {
        return node2 == this.USAGES_OUTSIDE_SCOPE_SEPARATOR || node2 == this.MORE_USAGES_SEPARATOR || node2 == this.USAGES_FILTERED_OUT_SEPARATOR;
    }

    @Nullable
    private static PsiElement getPsiElementForHint(Object selectedValue) {
        PsiElement element;
        Usage usage2;
        if (selectedValue instanceof UsageNode && (usage2 = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element = ((UsageInfo2UsageAdapter)usage2).getElement()) != null) {
            PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element);
            return view == null ? element : view;
        }
        return null;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data2) {
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(8);
        }
        return data2.isEmpty() || data2.get(0) instanceof ShowUsagesAction.StringNode ? 1 : 4;
    }

    @NotNull
    MyModel setTableModel(@NotNull List<UsageNode> data2) {
        MyModel model2;
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesTable.calcColumnCount(data2);
        MyModel myModel = model2 = this.getModel() instanceof MyModel ? (MyModel)((Object)this.getModel()) : null;
        if (model2 == null || model2.getColumnCount() != columnCount) {
            model2 = new MyModel(data2, columnCount);
            this.setModel((TableModel)((Object)model2));
            for (int i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
                TableColumn column = this.getColumnModel().getColumn(i2);
                column.setPreferredWidth(0);
                column.setCellRenderer(this.myRenderer);
            }
        }
        MyModel myModel2 = model2;
        if (myModel2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(10);
        }
        return myModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendMoreUsageRunnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showInMaximalScopeRunnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandler";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareTable";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcColumnCount";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTableModel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 10 -> new IllegalStateException(string2);
        };
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        MySpeedSearch(@NotNull ShowUsagesTable table) {
            if (table == null) {
                MySpeedSearch.$$$reportNull$$$0(0);
            }
            super((JComponent)((Object)table));
        }

        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        protected int getElementCount() {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().size();
        }

        protected Object getElementAt(int viewIndex) {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().get(this.getTable().convertRowIndexToModel(viewIndex));
        }

        protected String getElementText(@NotNull Object element) {
            if (element == null) {
                MySpeedSearch.$$$reportNull$$$0(1);
            }
            if (!(element instanceof UsageNode)) {
                return element.toString();
            }
            UsageNode node2 = (UsageNode)element;
            if (node2 instanceof ShowUsagesAction.StringNode) {
                return "";
            }
            Usage usage2 = node2.getUsage();
            if (usage2 == this.getTable().MORE_USAGES_SEPARATOR || usage2 == this.getTable().USAGES_OUTSIDE_SCOPE_SEPARATOR || usage2 == this.getTable().USAGES_FILTERED_OUT_SEPARATOR) {
                return "";
            }
            GroupNode group2 = (GroupNode)node2.getParent();
            String groupText = group2 == null ? "" : group2.getGroup().getPresentableGroupText();
            return groupText + usage2.getPresentation().getPlainText();
        }

        protected void selectElement(Object element, String selectedText) {
            List data2 = ((MyModel)((Object)this.getTable().getModel())).getItems();
            int i2 = data2.indexOf(element);
            if (i2 == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i2);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible((JTable)((Object)this.getTable()));
        }

        private ShowUsagesTable getTable() {
            return (ShowUsagesTable)((Object)this.myComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MySpeedSearch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<UsageNode> {
        private MyModel(@NotNull List<UsageNode> data2, int cols) {
            if (data2 == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super(MyModel.cols(cols), data2, 0);
        }

        private static ColumnInfo<UsageNode, UsageNode> @NotNull [] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o = new ColumnInfo<UsageNode, UsageNode>(""){

                @Nullable
                public UsageNode valueOf(UsageNode node2) {
                    return node2;
                }
            };
            List<1> list2 = Collections.nCopies(cols, o);
            ColumnInfo[] columnInfoArray = list2.toArray(ColumnInfo.emptyArray());
            if (columnInfoArray == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return columnInfoArray;
        }

        @Override
        public void addToModel(int idx, UsageNode element) {
            if (idx < this.getRowCount()) {
                this.insertRow(idx, element);
            } else {
                this.addRow(element);
            }
        }

        @Override
        public void removeRangeFromModel(int start, int end) {
            for (int i2 = end; i2 >= start; --i2) {
                this.removeRow(i2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

