/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.FindBundle;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageNodePresentation;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    static final int MARGIN = 2;
    @NotNull
    private final Predicate<? super Usage> myOriginUsageCheck;
    @NotNull
    private final AtomicInteger myOutOfScopeUsages;
    @NotNull
    private final SearchScope mySearchScope;
    private static final int CURRENT_ASTERISK_COL = 0;
    private static final int FILE_GROUP_COL = 1;
    private static final int LINE_NUMBER_COL = 2;
    private static final int USAGE_TEXT_COL = 3;
    private static final int ARC = 8;
    private static final int LEFT_OFFSET = 6;

    ShowUsagesTableCellRenderer(@NotNull Predicate<? super Usage> originUsageCheck, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope2) {
        if (originUsageCheck == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(0);
        }
        if (outOfScopeUsages == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(1);
        }
        if (searchScope2 == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(2);
        }
        this.myOriginUsageCheck = originUsageCheck;
        this.myOutOfScopeUsages = outOfScopeUsages;
        this.mySearchScope = searchScope2;
    }

    @Override
    @DirtyUI
    public Component getTableCellRendererComponent(JTable list2, Object value, boolean isSelected, boolean hasFocus, int row, @UsageTableColumn int column) {
        Color rowForeground;
        UsageNode usageNode = (UsageNode)value;
        Usage usage2 = usageNode == null ? null : usageNode.getUsage();
        Color selectionBg = UIUtil.getListSelectionBackground(true);
        Color selectionFg = NamedColorUtil.getListSelectionForeground(true);
        Color rowSelectionBackground = isSelected ? selectionBg : null;
        Color color = rowForeground = isSelected ? selectionFg : list2.getForeground();
        if (usageNode == null || usageNode instanceof ShowUsagesAction.StringNode) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            if (usageNode == null) {
                textChunks.append("", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                textChunks.append(((ShowUsagesAction.StringNode)((Object)value)).getString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, list2.getBackground(), rowSelectionBackground, rowForeground, column, list2);
        }
        if (usage2 == ((ShowUsagesTable)((Object)list2)).MORE_USAGES_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append(FindBundle.message("show.usages.more.usages.label", new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, list2.getBackground(), rowSelectionBackground, rowForeground, column, list2);
        }
        if (usage2 == ((ShowUsagesTable)((Object)list2)).USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            String message = UsageViewManagerImpl.outOfScopeMessage((int)this.myOutOfScopeUsages.get(), (SearchScope)this.mySearchScope);
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append(message, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, list2.getBackground(), rowSelectionBackground, rowForeground, column, list2);
        }
        if (usage2 == ((ShowUsagesTable)((Object)list2)).USAGES_FILTERED_OUT_SEPARATOR) {
            ShowUsagesAction.FilteredOutUsagesNode filtered = (ShowUsagesAction.FilteredOutUsagesNode)usageNode;
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append(filtered.getString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            JComponent component2 = ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, list2.getBackground(), rowSelectionBackground, rowForeground, column, list2);
            component2.setToolTipText(filtered.getTooltip());
            return component2;
        }
        LayoutManager layout = column == 3 ? new BorderLayout() : new FlowLayout(column == 2 ? 2 : 0, 0, 0){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                for (Component component2 : container.getComponents()) {
                    Rectangle b = component2.getBounds();
                    Insets insets = container.getInsets();
                    component2.setBounds(b.x, b.y, b.width, container.getSize().height - insets.top - insets.bottom);
                }
            }
        };
        SelectablePanel panel2 = new SelectablePanel();
        panel2.setLayout(layout);
        panel2.setFont(null);
        UsagePresentation presentation2 = usage2.getPresentation();
        UsageNodePresentation cachedPresentation = presentation2.getCachedPresentation();
        Color fileBgColor = cachedPresentation == null ? presentation2.getBackgroundColor() : cachedPresentation.getBackgroundColor();
        Color rowBackground = fileBgColor == null ? list2.getBackground() : fileBgColor;
        boolean isOriginUsage = this.myOriginUsageCheck.test((Usage)usage2);
        if (isOriginUsage && !ExperimentalUI.isNewUI()) {
            rowBackground = ShowUsagesTableCellRenderer.slightlyDifferentColor(rowBackground);
            rowSelectionBackground = ShowUsagesTableCellRenderer.slightlyDifferentColor(rowSelectionBackground);
            fileBgColor = ShowUsagesTableCellRenderer.slightlyDifferentColor(fileBgColor);
            selectionBg = ShowUsagesTableCellRenderer.slightlyDifferentColor(selectionBg);
        }
        panel2.setForeground(rowForeground);
        ShowUsagesTableCellRenderer.applyBackground(panel2, column, rowBackground, rowSelectionBackground);
        TextChunk[] text2 = cachedPresentation == null ? presentation2.getText() : cachedPresentation.getText();
        switch (column) {
            case 0: {
                if (ExperimentalUI.isNewUI()) break;
                if (isOriginUsage) {
                    panel2.add((Component)new JLabel(isSelected ? AllIcons.General.ModifiedSelected : AllIcons.General.Modified));
                    panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.CURRENT_ASTERISK_COL", (Object[])new Object[0]));
                    break;
                }
                panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.OTHER_ASTERISK_COL", (Object[])new Object[0]));
                break;
            }
            case 1: {
                ShowUsagesTableCellRenderer.appendGroupText(list2, (GroupNode)usageNode.getParent(), (JPanel)panel2, fileBgColor, isSelected);
                break;
            }
            case 2: {
                SimpleColoredComponent textChunks = new SimpleColoredComponent();
                textChunks.setOpaque(false);
                if (text2.length != 0) {
                    TextChunk chunk = text2[0];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.LINE_NUMBER_COL", (Object[])new Object[]{textChunks.getAccessibleContext().getAccessibleName()}));
                break;
            }
            case 3: {
                SimpleColoredComponent origin;
                SimpleColoredComponent textChunks = new SimpleColoredComponent();
                textChunks.setOpaque(false);
                Icon icon2 = cachedPresentation == null ? presentation2.getIcon() : cachedPresentation.getIcon();
                textChunks.setIcon(icon2 == null ? EmptyIcon.ICON_16 : icon2);
                textChunks.append("").appendTextPadding(JBUIScale.scale(21));
                for (int i2 = 1; i2 < text2.length; ++i2) {
                    TextChunk chunk = text2[i2];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.USAGE_TEXT_COL", (Object[])new Object[]{textChunks.getAccessibleContext().getAccessibleName()}));
                if (!isOriginUsage) break;
                if (ExperimentalUI.isNewUI()) {
                    RoundedColoredComponent roundedOrigin = new RoundedColoredComponent(isSelected);
                    roundedOrigin.append(FindBundle.message("show.usages.current.usage.label", new Object[0]));
                    origin = roundedOrigin;
                } else {
                    origin = new SimpleColoredComponent();
                    origin.setOpaque(false);
                    origin.setIconTextGap(JBUIScale.scale(5));
                    SimpleTextAttributes attributes = text2.length == 0 ? SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, new Color(0x808080), null, null) : ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, text2[0]);
                    origin.append("| " + FindBundle.message("show.usages.current.usage.label", new Object[0]), attributes);
                    origin.appendTextPadding(JBUIScale.scale(45));
                }
                panel2.add((Component)origin, (Object)"East");
                panel2.getAccessibleContext().setAccessibleName(panel2.getAccessibleContext().getAccessibleName() + ", " + origin.getAccessibleContext().getAccessibleName());
                break;
            }
            default: {
                throw new IllegalStateException("unknown column: " + column);
            }
        }
        return panel2;
    }

    private static Color slightlyDifferentColor(Color back) {
        if (back == null) {
            return null;
        }
        return EditorColorsManager.getInstance().isDarkEditor() ? ColorUtil.brighter(back, 3) : ColorUtil.hackBrightness(back, 1, 0.952381f);
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(boolean isSelected, Color fileBgColor, Color selectionBg, Color selectionFg, @NotNull TextChunk chunk) {
        if (chunk == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(3);
        }
        SimpleTextAttributes background = chunk.getSimpleAttributesIgnoreBackground();
        return isSelected ? new SimpleTextAttributes(selectionBg, selectionFg, null, background.getStyle()) : ShowUsagesTableCellRenderer.deriveBgColor(background, fileBgColor);
    }

    @NotNull
    private static JComponent textComponentSpanningWholeRow(@NotNull SimpleColoredComponent chunks, Color rowBackground, Color rowSelectionBackground, Color rowForeground, final int column, final @NotNull JTable table) {
        if (chunks == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(4);
        }
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(5);
        }
        SimpleColoredComponent component2 = new SimpleColoredComponent(){

            protected void doPaint(Graphics2D g) {
                int leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get();
                Insets innerInsets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
                int offset2 = column > 0 && ExperimentalUI.isNewUI() ? -innerInsets.left - leftRightInset : 0;
                TableColumnModel columnModel = table.getColumnModel();
                for (int i2 = 0; i2 < column; ++i2) {
                    offset2 += columnModel.getColumn(i2).getWidth();
                }
                g.translate(-offset2, 0);
                this.setSize(this.getWidth() + offset2, this.getHeight());
                super.doPaint(g);
                g.translate(offset2, 0);
            }

            @NotNull
            public Dimension getPreferredSize() {
                return column == table.getColumnModel().getColumnCount() - 1 ? super.getPreferredSize() : new Dimension(0, 0);
            }
        };
        component2.setForeground(rowForeground);
        component2.setOpaque(false);
        SimpleColoredComponent.ColoredIterator iterator2 = chunks.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            String fragment = iterator2.getFragment();
            SimpleTextAttributes attributes = iterator2.getTextAttributes();
            attributes = attributes.derive(attributes.getStyle(), rowForeground, rowBackground, attributes.getWaveColor());
            component2.append(fragment, attributes);
        }
        SelectablePanel result2 = SelectablePanel.wrap((Component)component2);
        ShowUsagesTableCellRenderer.applyBackground(result2, column, rowBackground, rowSelectionBackground);
        SelectablePanel selectablePanel = result2;
        if (selectablePanel == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(6);
        }
        return selectablePanel;
    }

    @NotNull
    private static SimpleTextAttributes deriveBgColor(@NotNull SimpleTextAttributes attributes, @Nullable Color fileBgColor) {
        if (attributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(7);
        }
        if (fileBgColor != null) {
            attributes = attributes.derive(-1, null, fileBgColor, null);
        }
        SimpleTextAttributes simpleTextAttributes = attributes;
        if (simpleTextAttributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(8);
        }
        return simpleTextAttributes;
    }

    private static void appendGroupText(@NotNull JTable table, GroupNode node2, @NotNull JPanel panel2, Color fileBgColor, boolean isSelected) {
        UsageGroup group2;
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(9);
        }
        if (panel2 == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(10);
        }
        UsageGroup usageGroup = group2 = node2 == null ? null : node2.getGroup();
        if (group2 == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node2.getParent();
        ShowUsagesTableCellRenderer.appendGroupText(table, parentGroup, panel2, fileBgColor, isSelected);
        SimpleColoredComponent renderer = new SimpleColoredComponent();
        renderer.setOpaque(false);
        renderer.setIcon(group2.getIcon());
        SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveBgColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
        renderer.append(group2.getPresentableGroupText(), attributes);
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)renderer, (boolean)false, (boolean)isSelected);
        panel2.add((Component)renderer);
        panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.FILE_GROUP_COL", (Object[])new Object[]{renderer.getAccessibleContext().getAccessibleName()}));
    }

    private static void applyBackground(SelectablePanel panel2, int column, Color rowBackground, Color rowSelectionBackground) {
        if (ExperimentalUI.isNewUI()) {
            int leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get();
            Insets innerInsets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
            switch (column) {
                case 0: {
                    panel2.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
                    panel2.setSelectionArcCorners(SelectablePanel.SelectionArcCorners.LEFT);
                    panel2.setSelectionInsets(new Insets(0, leftRightInset, 0, 0));
                    panel2.setBorder((Border)new EmptyBorder(innerInsets.top, leftRightInset + innerInsets.left, innerInsets.bottom, 0));
                    break;
                }
                case 3: {
                    panel2.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
                    panel2.setSelectionArcCorners(SelectablePanel.SelectionArcCorners.RIGHT);
                    panel2.setSelectionInsets(new Insets(0, 0, 0, leftRightInset));
                    panel2.setBorder((Border)new EmptyBorder(innerInsets.top, 0, innerInsets.bottom, innerInsets.right + leftRightInset));
                    break;
                }
                default: {
                    panel2.setBorder((Border)new EmptyBorder(innerInsets.top, 0, innerInsets.bottom, 0));
                }
            }
            panel2.setBackground(rowBackground);
            panel2.setSelectionColor(rowSelectionBackground);
        } else {
            panel2.setBorder((Border)JBUI.Borders.empty(2, 2, 2, 0));
            panel2.setBackground(rowSelectionBackground == null ? rowBackground : rowSelectionBackground);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originUsageCheck";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outOfScopeUsages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "textComponentSpanningWholeRow";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveBgColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "textComponentSpanningWholeRow";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deriveBgColor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendGroupText";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 8 -> new IllegalStateException(string2);
        };
    }

    private static class RoundedColoredComponent
    extends SimpleColoredComponent {
        private RoundedColoredComponent(boolean isSelected) {
            if (isSelected) {
                this.setOpaque(false);
            }
            JBInsets insets = RoundedColoredComponent.rectInsets();
            this.setFont(JBFont.medium());
            this.setIpad(JBUI.insets(0, 6 + insets.left, 0, insets.right));
            this.setForeground(JBUI.CurrentTheme.List.Tag.FOREGROUND);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintBackground(Graphics2D g, int x, int width, int height) {
            super.paintBackground(g, x, width, height);
            int y = 0;
            int baseline = this.getBaseline(width, height);
            if (baseline >= 0) {
                JBInsets insets = RoundedColoredComponent.rectInsets();
                FontMetrics metrics = g.getFontMetrics(this.getBaseFont());
                y = baseline - metrics.getAscent() - insets.top;
                height = metrics.getHeight() + insets.height();
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                GraphicsUtil.setupAAPainting(g2);
                g2.setColor(JBUI.CurrentTheme.List.Tag.BACKGROUND);
                int arc = JBUIScale.scale(8);
                int offset2 = JBUIScale.scale(6);
                g2.fillRoundRect(x + offset2, y, width - offset2, height, arc, arc);
            }
            finally {
                g2.dispose();
            }
        }

        private static JBInsets rectInsets() {
            return JBUI.insets(1, 6);
        }
    }

    private static @interface UsageTableColumn {
    }
}

