/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsCompletionAction
extends DumbAwareAction
implements LightEditCompatible {
    private final PopupState<JBPopup> myPopupState = PopupState.forPopup();
    private final JTextComponent myTextField;

    public VariantsCompletionAction(JTextComponent textField) {
        this.myTextField = textField;
        AnAction action2 = ActionManager.getInstance().getAction("CodeCompletion");
        if (action2 != null) {
            this.registerCustomShortcutSet(action2.getShortcutSet(), this.myTextField);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            VariantsCompletionAction.$$$reportNull$$$0(0);
        }
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        if (editor2 == null) {
            return;
        }
        String prefix = this.myTextField.getText().substring(0, this.myTextField.getCaretPosition());
        if (StringUtil.isEmpty(prefix)) {
            return;
        }
        String[] array = VariantsCompletionAction.calcWords(prefix, editor2);
        if (array.length == 0) {
            return;
        }
        JBList<String> list2 = new JBList<String>(array){

            protected void paintComponent(Graphics g) {
                GraphicsUtil.setupAntialiasing(g);
                super.paintComponent(g);
            }
        };
        list2.setBackground((Color)new JBColor(new Color(235, 244, 254), new Color(5001041)));
        list2.setFont(editor2.getColorsScheme().getFont(EditorFontType.PLAIN));
        Utils.showCompletionPopup(e.getInputEvent() instanceof MouseEvent ? this.myTextField : null, (JList)list2, null, this.myTextField, null, this.myPopupState);
    }

    private static String[] calcWords(String prefix, Editor editor2) {
        final Matcher matcher = NameUtil.buildMatcher((String)prefix, (int)0, (boolean)true, (boolean)true);
        final HashSet words = new HashSet();
        CharSequence chars = editor2.getDocument().getCharsSequence();
        IdTableBuilding.scanWords((IdTableBuilding.ScanWordProcessor)new IdTableBuilding.ScanWordProcessor(){

            public void run(CharSequence chars, char @Nullable [] charsArray, int start, int end) {
                String word2 = chars.subSequence(start, end).toString();
                if (matcher.matches(word2)) {
                    words.add(word2);
                }
            }
        }, (CharSequence)chars, (int)0, (int)chars.length());
        List<String> sortedWords = ContainerUtil.sorted(words);
        return ArrayUtilRt.toStringArray(sortedWords);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/editorHeaderActions/VariantsCompletionAction", "actionPerformed"));
    }
}

