/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findInProject;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectManager {
    private final Project myProject;
    private volatile boolean myIsFindInProgress;

    public static FindInProjectManager getInstance(Project project2) {
        return project2.getService(FindInProjectManager.class);
    }

    public FindInProjectManager(Project project2) {
        this.myProject = project2;
    }

    public void findInProject(@NotNull DataContext dataContext2, @Nullable FindModel model2) {
        FindModel findModel;
        if (dataContext2 == null) {
            FindInProjectManager.$$$reportNull$$$0(0);
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        if (model2 != null) {
            findModel = model2.clone();
        } else {
            findModel = findManager.getFindInProjectModel().clone();
            findModel.setReplaceState(false);
            this.initModel(findModel, dataContext2);
        }
        findManager.showFindDialog(findModel, () -> {
            if (findModel.isReplaceState()) {
                ReplaceInProjectManager.getInstance(this.myProject).replaceInPath(findModel);
            } else {
                this.findInPath(findModel);
            }
        });
    }

    public void findInPath(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(1);
        }
        this.startFindInProject(findModel);
    }

    protected void initModel(@NotNull FindModel findModel, @NotNull DataContext dataContext2) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(2);
        }
        if (dataContext2 == null) {
            FindInProjectManager.$$$reportNull$$$0(3);
        }
        FindInProjectUtil.setDirectoryName(findModel, dataContext2);
        String text2 = (String)PlatformDataKeys.PREDEFINED_TEXT.getData(dataContext2);
        if (text2 != null) {
            FindModel.initStringToFind((FindModel)findModel, (String)text2);
        } else {
            FindInProjectUtil.initStringToFindFromDataContext(findModel, dataContext2);
        }
    }

    public void startFindInProject(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(4);
        }
        if (findModel.getDirectoryName() != null && FindInProjectUtil.getDirectory(findModel) == null) {
            return;
        }
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        if (manager == null) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        findManager.getFindInProjectModel().copyFrom(findModel);
        FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation2 = FindInProjectUtil.setupViewPresentation(findModelCopy);
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, presentation2);
        FindInProjectUtil.StringUsageTarget usageTarget = new FindInProjectUtil.StringUsageTarget(this.myProject, findModel);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(usageTarget);
        manager.searchAndShowUsages(new UsageTarget[]{usageTarget}, () -> processor -> {
            this.myIsFindInProgress = true;
            try {
                Processor<UsageInfo> consumer2 = info2 -> {
                    Usage usage2 = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info2);
                    usage2.getPresentation().getIcon();
                    return processor.process(usage2);
                };
                FindInProjectUtil.findUsages(findModelCopy, this.myProject, consumer2, processPresentation);
            }
            finally {
                this.myIsFindInProgress = false;
            }
        }, processPresentation, presentation2, null);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !ReplaceInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/findInProject/FindInProjectManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findInProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findInPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startFindInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

