/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesHandlerBase {
    @NotNull
    protected final PsiElement myPsiElement;
    private final Project myProject;

    public FindUsagesHandlerBase(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(0);
        }
        this(psiElement, psiElement.getProject());
    }

    public FindUsagesHandlerBase(@NotNull PsiElement psiElement, Project project2) {
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(1);
        }
        this.myPsiElement = psiElement;
        this.myProject = project2;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(3);
        }
        return project2;
    }

    public PsiElement @NotNull [] getPrimaryElements() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myPsiElement};
        if (psiElementArray == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    public PsiElement @NotNull [] getSecondaryElements() {
        if (PsiElement.EMPTY_ARRAY == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(5);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        FindUsagesOptions findUsagesOptions = this.getFindUsagesOptions(null);
        if (findUsagesOptions == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(6);
        }
        return findUsagesOptions;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext2) {
        FindUsagesOptions options2 = FindUsagesHandlerBase.createFindUsagesOptions(this.getProject(), dataContext2);
        options2.isSearchForTextOccurrences &= this.isSearchForTextOccurrencesAvailable(this.getPsiElement(), false);
        FindUsagesOptions findUsagesOptions = options2;
        if (findUsagesOptions == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(7);
        }
        return findUsagesOptions;
    }

    public boolean processElementUsages(@NotNull PsiElement element, final @NotNull Processor<? super UsageInfo> processor, @NotNull FindUsagesOptions options2) {
        boolean success;
        boolean searchText;
        if (element == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(9);
        }
        if (options2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(10);
        }
        ReadActionProcessor<PsiReference> refProcessor = new ReadActionProcessor<PsiReference>(){

            @Override
            public boolean processInReadAction(PsiReference ref) {
                return processor.process(new UsageInfo(ref));
            }
        };
        SearchScope scope = options2.searchScope;
        boolean bl = searchText = options2.isSearchForTextOccurrences && scope instanceof GlobalSearchScope;
        if (options2.isUsages && !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)this.createSearchParameters(element, scope, options2)).forEach(refProcessor))) {
            return false;
        }
        if (searchText) {
            if (options2.fastTrack != null) {
                options2.fastTrack.searchCustom(consumer2 -> this.processUsagesInText(element, processor, (GlobalSearchScope)scope));
            } else {
                return this.processUsagesInText(element, processor, (GlobalSearchScope)scope);
            }
        }
        return true;
    }

    public boolean processUsagesInText(@NotNull PsiElement element, @NotNull Processor<? super UsageInfo> processor, @NotNull GlobalSearchScope searchScope2) {
        Collection stringToSearch;
        if (element == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(12);
        }
        if (searchScope2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(13);
        }
        if ((stringToSearch = ReadAction.compute(() -> this.getStringsToSearch(element))) == null) {
            return true;
        }
        return FindUsagesHelper.processUsagesInText(element, stringToSearch, false, searchScope2, processor);
    }

    @Nullable
    protected Collection<String> getStringsToSearch(@NotNull PsiElement element) {
        if (element == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(14);
        }
        if (element instanceof PsiNamedElement) {
            return ContainerUtil.createMaybeSingletonList(((PsiNamedElement)element).getName());
        }
        return Collections.singleton(element.getText());
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(15);
        }
        return false;
    }

    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target2, @NotNull SearchScope searchScope2) {
        if (target2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(16);
        }
        if (searchScope2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(17);
        }
        Collection<PsiReference> collection = ReferencesSearch.search((ReferencesSearch.SearchParameters)this.createSearchParameters(target2, searchScope2, null)).findAll();
        if (collection == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    protected ReferencesSearch.SearchParameters createSearchParameters(@NotNull PsiElement target2, @NotNull SearchScope searchScope2, @Nullable FindUsagesOptions findUsagesOptions) {
        if (target2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(19);
        }
        if (searchScope2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(20);
        }
        return new ReferencesSearch.SearchParameters(target2, searchScope2, false, findUsagesOptions == null ? null : findUsagesOptions.fastTrack);
    }

    @NotNull
    public static FindUsagesOptions createFindUsagesOptions(@NotNull Project project2, @Nullable DataContext dataContext2) {
        if (project2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(21);
        }
        FindUsagesOptions findUsagesOptions = new FindUsagesOptions(project2, dataContext2);
        findUsagesOptions.isUsages = true;
        findUsagesOptions.isSearchForTextOccurrences = true;
        FindUsagesOptions findUsagesOptions2 = findUsagesOptions;
        if (findUsagesOptions2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(22);
        }
        return findUsagesOptions2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesHandlerBase";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesHandlerBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesToHighlight";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 22: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStringsToSearch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurrencesAvailable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findReferencesToHighlight";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSearchParameters";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesOptions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5, 6, 7, 18, 22 -> new IllegalStateException(string2);
        };
    }
}

