/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.find.FindSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
implements Cloneable {
    @NotNull
    public SearchScope searchScope;
    public boolean isSearchForTextOccurrences;
    public boolean isUsages;
    public SearchRequestCollector fastTrack;

    public FindUsagesOptions(@NotNull Project project2) {
        if (project2 == null) {
            FindUsagesOptions.$$$reportNull$$$0(0);
        }
        this(project2, null);
    }

    public FindUsagesOptions(@NotNull Project project2, @Nullable DataContext dataContext2) {
        if (project2 == null) {
            FindUsagesOptions.$$$reportNull$$$0(1);
        }
        this(FindUsagesOptions.findScopeByName(project2, dataContext2, FindSettings.getInstance().getDefaultScopeName()));
    }

    public FindUsagesOptions(@NotNull SearchScope searchScope2) {
        if (searchScope2 == null) {
            FindUsagesOptions.$$$reportNull$$$0(2);
        }
        this.isSearchForTextOccurrences = true;
        this.searchScope = searchScope2;
    }

    @ApiStatus.Internal
    @NotNull
    public static SearchScope findScopeByName(@NotNull Project project2, @Nullable DataContext dataContext2, @Nullable String scopeName) {
        if (project2 == null) {
            FindUsagesOptions.$$$reportNull$$$0(3);
        }
        List<? extends SearchScope> predefined = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project2, dataContext2, true, false, false, false, false);
        for (SearchScope searchScope2 : predefined) {
            if (!searchScope2.getDisplayName().equals(scopeName)) continue;
            SearchScope searchScope3 = searchScope2;
            if (searchScope3 == null) {
                FindUsagesOptions.$$$reportNull$$$0(4);
            }
            return searchScope3;
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project2);
        if (globalSearchScope == null) {
            FindUsagesOptions.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    public FindUsagesOptions clone() {
        try {
            return (FindUsagesOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isSearchForTextOccurrences != that.isSearchForTextOccurrences) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        return this.searchScope.equals(that.searchScope);
    }

    public int hashCode() {
        int result2 = this.searchScope.hashCode();
        result2 = 31 * result2 + (this.isSearchForTextOccurrences ? 1 : 0);
        result2 = 31 * result2 + (this.isUsages ? 1 : 0);
        return result2;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{searchScope=" + this.searchScope + ", isSearchForTextOccurrences=" + this.isSearchForTextOccurrences + ", isUsages=" + this.isUsages + "}";
    }

    @NotNull
    @Nls
    public String generateUsagesString() {
        String string2 = AnalysisBundle.message("find.usages.panel.title.usages", new Object[0]);
        if (string2 == null) {
            FindUsagesOptions.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUsagesString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

