/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSearchEngine;
import com.intellij.find.FindModel;
import com.intellij.find.FindModelExtension;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.ngrams.TrigramTextSearchService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilesScanExecutor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.ModuleRootOrigin;
import com.intellij.util.text.StringSearcher;
import com.intellij.util.ui.EDT;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FindInProjectTask {
    private static final Logger LOG = Logger.getInstance(FindInProjectTask.class);
    private static final Comparator<VirtualFile> SEARCH_RESULT_FILE_COMPARATOR = Comparator.comparing(f -> f instanceof VirtualFileWithId ? ((VirtualFileWithId)((Object)f)).getId() : 0).thenComparing(VirtualFile::getName).thenComparing(VirtualFile::getPath);
    private static final int FILES_SIZE_LIMIT = 0x4600000;
    private final FindModel myFindModel;
    private final Project myProject;
    private final PsiManager myPsiManager;
    @Nullable
    private final VirtualFile myDirectory;
    private final ProjectFileIndex myProjectFileIndex;
    private final Condition<VirtualFile> myFileMask;
    private final ProgressIndicator myProgress;
    @Nullable
    private final Module myModule;
    private final Set<VirtualFile> myLargeFiles;
    private final Set<? extends VirtualFile> myFilesToScanInitially;
    private final AtomicLong myTotalFilesSize;
    @NotNull
    private final @NotNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FindInProjectSearchEngine.FindInProjectSearcher> mySearchers;
    private long mySearchStartedAt;

    FindInProjectTask(@NotNull FindModel findModel, @NotNull Project project2, @NotNull Set<? extends VirtualFile> filesToScanInitially, boolean tooManyUsagesStatus) {
        if (findModel == null) {
            FindInProjectTask.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            FindInProjectTask.$$$reportNull$$$0(1);
        }
        if (filesToScanInitially == null) {
            FindInProjectTask.$$$reportNull$$$0(2);
        }
        this.myLargeFiles = Collections.synchronizedSet(new HashSet());
        this.myTotalFilesSize = new AtomicLong();
        this.myFindModel = findModel;
        this.myProject = project2;
        this.myFilesToScanInitially = filesToScanInitially;
        this.myDirectory = FindInProjectUtil.getDirectory(findModel);
        this.myPsiManager = PsiManager.getInstance(project2);
        String moduleName = findModel.getModuleName();
        this.myModule = moduleName == null ? null : ReadAction.compute(() -> ModuleManager.getInstance(project2).findModuleByName(moduleName));
        this.myProjectFileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        Condition<CharSequence> patternCondition = FindInProjectUtil.createFileMaskCondition(findModel.getFileFilter());
        this.myFileMask = file2 -> file2 != null && patternCondition.value(file2.getNameSequence());
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        ProgressIndicator progressIndicator = this.myProgress = progress != null ? progress : new EmptyProgressIndicator();
        if (tooManyUsagesStatus) {
            TooManyUsagesStatus.createFor(this.myProgress);
        }
        this.mySearchers = ContainerUtil.mapNotNull((FindInProjectSearchEngine[])FindInProjectSearchEngine.EP_NAME.getExtensions(), se -> se.createSearcher(findModel, project2));
    }

    void findUsages(@NotNull FindUsagesProcessPresentation processPresentation, @NotNull Processor<? super UsageInfo> usageProcessor) {
        if (processPresentation == null) {
            FindInProjectTask.$$$reportNull$$$0(3);
        }
        if (usageProcessor == null) {
            FindInProjectTask.$$$reportNull$$$0(4);
        }
        if (!EDT.isCurrentThreadEdt()) {
            ApplicationManager.getApplication().assertReadAccessNotAllowed();
        }
        CoreProgressManager.assertUnderProgress(this.myProgress);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for '" + this.myFindModel.getStringToFind() + "'");
        }
        this.mySearchStartedAt = System.nanoTime();
        try {
            Processor<VirtualFile> fileProcessor = this.wrapUsageProcessor(processPresentation, usageProcessor);
            this.myProgress.setIndeterminate(true);
            this.myProgress.setText(FindBundle.message("progress.text.scanning.indexed.files", new Object[0]));
            Set<VirtualFile> filesForFastWordSearch = this.getFilesForFastWordSearch();
            this.myProgress.setIndeterminate(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Search found " + filesForFastWordSearch.size() + " indexed files");
            }
            ConcurrentLinkedDeque<VirtualFile> deque = new ConcurrentLinkedDeque<VirtualFile>(ContainerUtil.sorted(filesForFastWordSearch, SEARCH_RESULT_FILE_COMPARATOR));
            AtomicInteger processedFastFiles = new AtomicInteger();
            FilesScanExecutor.processOnAllThreadsInReadActionWithRetries(deque, o -> {
                boolean result2 = fileProcessor.process((VirtualFile)o);
                if (this.myProgress.isRunning()) {
                    double fraction = (double)processedFastFiles.incrementAndGet() / (double)filesForFastWordSearch.size();
                    this.myProgress.setFraction(fraction);
                }
                return result2;
            });
            this.myProgress.setIndeterminate(true);
            this.myProgress.setText(FindBundle.message("progress.text.scanning.non.indexed.files", new Object[0]));
            boolean canRelyOnIndices = this.canRelyOnSearchers();
            AtomicInteger otherFilesCount = new AtomicInteger();
            this.processFilesInScope(filesForFastWordSearch, canRelyOnIndices, file2 -> {
                boolean result2 = fileProcessor.process((VirtualFile)file2);
                otherFilesCount.incrementAndGet();
                return result2;
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("Search processed " + otherFilesCount.get() + " non-indexed files");
                LOG.debug("Search completed in " + TimeoutUtil.getDurationMillis(this.mySearchStartedAt) + " ms");
            }
        }
        catch (ProcessCanceledException e) {
            processPresentation.setCanceled(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Search canceled after " + TimeoutUtil.getDurationMillis(this.mySearchStartedAt) + " ms", e);
            }
        }
        catch (Throwable th2) {
            LOG.error(th2);
        }
        if (!this.myLargeFiles.isEmpty()) {
            processPresentation.setLargeFilesWereNotScanned(this.myLargeFiles);
        }
        if (!this.myProgress.isCanceled()) {
            this.myProgress.setText(FindBundle.message("find.progress.search.completed", new Object[0]));
        }
    }

    @NotNull
    private Processor<VirtualFile> wrapUsageProcessor(@NotNull FindUsagesProcessPresentation processPresentation, @NotNull Processor<? super UsageInfo> usageConsumer) {
        if (processPresentation == null) {
            FindInProjectTask.$$$reportNull$$$0(5);
        }
        if (usageConsumer == null) {
            FindInProjectTask.$$$reportNull$$$0(6);
        }
        AtomicInteger occurrenceCount = new AtomicInteger();
        ConcurrentHashMap usagesBeingProcessed = new ConcurrentHashMap();
        AtomicBoolean reportedFirst = new AtomicBoolean();
        StringSearcher searcher2 = this.myFindModel.isRegularExpressions() || StringUtil.isEmpty(this.myFindModel.getStringToFind()) ? null : new StringSearcher(this.myFindModel.getStringToFind(), this.myFindModel.isCaseSensitive(), true);
        ClientId currentClientId = ClientId.getCurrent();
        Processor<VirtualFile> processor = virtualFile2 -> {
            try (AccessToken ignored = ClientId.withClientId(currentClientId);){
                boolean bl = this.processFindInFilesUsagesInFile(processPresentation, usageConsumer, occurrenceCount, usagesBeingProcessed, reportedFirst, searcher2, (VirtualFile)virtualFile2);
                return bl;
            }
        };
        if (processor == null) {
            FindInProjectTask.$$$reportNull$$$0(7);
        }
        return processor;
    }

    private boolean processFindInFilesUsagesInFile(@NotNull FindUsagesProcessPresentation processPresentation, @NotNull Processor<? super UsageInfo> usageConsumer, @NotNull AtomicInteger occurrenceCount, @NotNull Map<? super VirtualFile, Set<UsageInfo>> usagesBeingProcessed, @NotNull AtomicBoolean reportedFirst, @Nullable StringSearcher searcher2, @NotNull VirtualFile virtualFile2) {
        long totalSize;
        AtomicBoolean projectFileUsagesFound;
        boolean processedSuccessfully;
        boolean skipProjectFile;
        if (processPresentation == null) {
            FindInProjectTask.$$$reportNull$$$0(8);
        }
        if (usageConsumer == null) {
            FindInProjectTask.$$$reportNull$$$0(9);
        }
        if (occurrenceCount == null) {
            FindInProjectTask.$$$reportNull$$$0(10);
        }
        if (usagesBeingProcessed == null) {
            FindInProjectTask.$$$reportNull$$$0(11);
        }
        if (reportedFirst == null) {
            FindInProjectTask.$$$reportNull$$$0(12);
        }
        if (virtualFile2 == null) {
            FindInProjectTask.$$$reportNull$$$0(13);
        }
        if (!virtualFile2.isValid()) {
            return true;
        }
        long fileLength = UsageViewManagerImpl.getFileLength((VirtualFile)virtualFile2);
        if (fileLength == -1L) {
            return true;
        }
        boolean bl = skipProjectFile = ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile2) && !this.myFindModel.isSearchInProjectFiles();
        if (skipProjectFile && !Registry.is("find.search.in.project.files")) {
            return true;
        }
        if (fileLength > (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
            this.myLargeFiles.add(virtualFile2);
            return true;
        }
        this.myProgress.checkCanceled();
        String text2 = FindBundle.message("find.searching.for.string.in.file.progress", this.myFindModel.getStringToFind(), virtualFile2.getPresentableUrl());
        this.myProgress.setText(text2);
        this.myProgress.setText2(FindBundle.message("find.searching.for.string.in.file.occurrences.progress", occurrenceCount));
        Pair.NonNull pair = ReadAction.compute(() -> this.findFile(virtualFile2));
        if (pair == null) {
            return true;
        }
        Set processedUsages = usagesBeingProcessed.computeIfAbsent(virtualFile2, __ -> ContainerUtil.newConcurrentSet());
        PsiFile psiFile = (PsiFile)pair.first;
        VirtualFile sourceVirtualFile = (VirtualFile)pair.second;
        if (searcher2 != null) {
            CharSequence s;
            Document document = FileDocumentManager.getInstance().getCachedDocument(sourceVirtualFile);
            CharSequence charSequence = s = document != null ? document.getCharsSequence() : (CharSequence)DiskQueryRelay.compute(() -> LoadTextUtil.loadText(sourceVirtualFile, -1));
            if (s.length() == 0 || searcher2.scan(s) < 0) {
                return true;
            }
        }
        if (!(processedSuccessfully = FindInProjectUtil.processUsagesInFile(psiFile, sourceVirtualFile, this.myFindModel, arg_0 -> this.lambda$processFindInFilesUsagesInFile$10(skipProjectFile, projectFileUsagesFound = new AtomicBoolean(), reportedFirst, processedUsages, usageConsumer, arg_0)))) {
            return false;
        }
        usagesBeingProcessed.remove(virtualFile2);
        if (projectFileUsagesFound.get()) {
            processPresentation.projectFileUsagesFound(() -> {
                FindModel model2 = this.myFindModel.clone();
                model2.setSearchInProjectFiles(true);
                FindInProjectManager.getInstance(this.myProject).startFindInProject(model2);
            });
            return true;
        }
        if (processedUsages.isEmpty()) {
            totalSize = this.myTotalFilesSize.get();
        } else {
            occurrenceCount.addAndGet(processedUsages.size());
            totalSize = this.myTotalFilesSize.addAndGet(fileLength);
        }
        if (totalSize > 0x4600000L) {
            TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(this.myProgress);
            if (tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                UsageViewManagerImpl.showTooManyUsagesWarningLater((Project)this.myProject, (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)this.myProgress, null, () -> FindBundle.message("find.excessive.total.size.prompt", UsageViewManagerImpl.presentableSize((long)this.myTotalFilesSize.longValue()), ApplicationNamesInfo.getInstance().getProductName()), null);
            }
            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
            this.myProgress.checkCanceled();
        }
        return true;
    }

    private void processFilesInScope(@NotNull Set<? extends VirtualFile> alreadySearched, boolean checkCoveredBySearchers, @NotNull Processor<? super VirtualFile> fileProcessor) {
        if (alreadySearched == null) {
            FindInProjectTask.$$$reportNull$$$0(14);
        }
        if (fileProcessor == null) {
            FindInProjectTask.$$$reportNull$$$0(15);
        }
        SearchScope customScope = this.myFindModel.isCustomScope() ? this.myFindModel.getCustomScope() : null;
        GlobalSearchScope globalCustomScope = customScope == null ? null : GlobalSearchScopeUtil.toGlobalSearchScope(customScope, this.myProject);
        boolean ignoreExcluded = this.myDirectory != null && !Registry.is("find.search.in.excluded.dirs") && ReadAction.compute(() -> this.myProjectFileIndex.isExcluded(this.myDirectory)) == false;
        boolean withSubdirs = this.myDirectory != null && this.myFindModel.isWithSubdirectories();
        boolean locateClassSources = this.myDirectory != null && ActionsKt.runReadAction(() -> this.myProjectFileIndex.getClassRootForFile(this.myDirectory)) != null;
        boolean searchInLibs = globalCustomScope != null && globalCustomScope.isSearchInLibraries();
        ConcurrentLinkedDeque<VirtualFile> deque = new ConcurrentLinkedDeque<VirtualFile>();
        if (customScope instanceof LocalSearchScope) {
            deque.addAll(GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)customScope));
        } else if (customScope instanceof VirtualFileEnumeration) {
            ContainerUtil.addAll(deque, FileBasedIndexEx.toFileIterable((int[])((VirtualFileEnumeration)((Object)customScope)).asArray()));
        } else if (this.myDirectory != null) {
            deque.addAll(withSubdirs ? List.of(this.myDirectory) : List.of(this.myDirectory.getChildren()));
        } else if (this.myModule != null) {
            EntityStorageSnapshot storage = WorkspaceModel.getInstance(this.myProject).getCurrentSnapshot();
            ModuleEntity moduleEntity = Objects.requireNonNull((ModuleEntity)storage.resolve((SymbolicEntityId)new ModuleId(this.myModule.getName())));
            deque.addAll(IndexableEntityProviderMethods.INSTANCE.createIterators(moduleEntity, (EntityStorage)storage, this.myProject));
        } else {
            deque.addAll(((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndexableFilesProviders(this.myProject));
        }
        deque.addAll(FindModelExtension.EP_NAME.getExtensionList());
        ConcurrentBitSet visitedFiles = ConcurrentBitSet.create();
        Processor<Object> consumer2 = obj -> {
            ProgressManager.checkCanceled();
            if (obj instanceof IndexableFilesIterator) {
                IndexableSetOrigin origin = ((IndexableFilesIterator)obj).getOrigin();
                if (!searchInLibs && !(origin instanceof ModuleRootOrigin)) {
                    return true;
                }
                ((IndexableFilesIterator)obj).iterateFiles(this.myProject, file2 -> {
                    if (file2.isDirectory()) {
                        return true;
                    }
                    deque.add(file2);
                    return true;
                }, VirtualFileFilter.ALL);
                return true;
            } else if (obj instanceof FindModelExtension) {
                ((FindModelExtension)obj).iterateAdditionalFiles(this.myFindModel, this.myProject, o -> {
                    if (o.isDirectory()) {
                        return true;
                    }
                    if (!alreadySearched.contains(o)) {
                        return fileProcessor.process((VirtualFile)o);
                    }
                    return true;
                });
                return true;
            } else {
                VirtualFile adjustedFile;
                if (!(obj instanceof VirtualFile)) throw new AssertionError((Object)("unknown item: " + obj));
                VirtualFile file3 = (VirtualFile)obj;
                if (file3 instanceof VirtualFileWithId && visitedFiles.set(((VirtualFileWithId)((Object)file3)).getId())) {
                    return true;
                }
                if (!file3.isValid()) {
                    return true;
                }
                if (ignoreExcluded && this.myProjectFileIndex.isExcluded(file3)) {
                    return true;
                }
                if (((VirtualFile)obj).isDirectory()) {
                    if (!withSubdirs) return true;
                    ContainerUtil.addAll(deque, ((VirtualFile)obj).getChildren());
                    return true;
                }
                if (!this.myFileMask.value(file3) || globalCustomScope != null && !globalCustomScope.contains(file3) || checkCoveredBySearchers && ContainerUtil.find(this.mySearchers, p -> p.isCovered(file3)) != null) {
                    return true;
                }
                if (file3.getFileType().isBinary()) {
                    if (!locateClassSources) return true;
                    Pair.NonNull<PsiFile, VirtualFile> pair = this.findFile(file3);
                    if (pair == null) {
                        return true;
                    }
                    adjustedFile = Objects.requireNonNull((VirtualFile)pair.second);
                } else {
                    adjustedFile = file3;
                }
                if (!alreadySearched.contains(adjustedFile)) return fileProcessor.process(adjustedFile);
                return true;
            }
        };
        FilesScanExecutor.processOnAllThreadsInReadActionWithRetries(deque, consumer2::process);
    }

    private boolean canRelyOnSearchers() {
        if (!TrigramTextSearchService.useIndexingSearchExtensions()) {
            return false;
        }
        return ContainerUtil.find(this.mySearchers, s -> s.isReliable()) != null;
    }

    @NotNull
    private Set<VirtualFile> getFilesForFastWordSearch() {
        VirtualFileSet resultFiles = VfsUtilCore.createCompactVirtualFileSet();
        for (VirtualFile virtualFile2 : this.myFilesToScanInitially) {
            if (!this.myFileMask.value(virtualFile2)) continue;
            resultFiles.add(virtualFile2);
        }
        if (!TrigramTextSearchService.useIndexingSearchExtensions()) {
            VirtualFileSet virtualFileSet = resultFiles;
            if (virtualFileSet == null) {
                FindInProjectTask.$$$reportNull$$$0(16);
            }
            return virtualFileSet;
        }
        for (FindInProjectSearchEngine.FindInProjectSearcher findInProjectSearcher : this.mySearchers) {
            Collection virtualFiles = findInProjectSearcher.searchForOccurrences();
            for (VirtualFile file3 : virtualFiles) {
                if (!this.myFileMask.value(file3)) continue;
                resultFiles.add(file3);
            }
        }
        VirtualFileSet virtualFileSet = resultFiles;
        if (virtualFileSet == null) {
            FindInProjectTask.$$$reportNull$$$0(17);
        }
        return virtualFileSet;
    }

    private Pair.NonNull<PsiFile, VirtualFile> findFile(@NotNull VirtualFile virtualFile2) {
        PsiFile psiFile;
        if (virtualFile2 == null) {
            FindInProjectTask.$$$reportNull$$$0(18);
        }
        if ((psiFile = this.myPsiManager.findFile(virtualFile2)) != null) {
            PsiElement sourceFile = psiFile.getNavigationElement();
            if (sourceFile instanceof PsiFile) {
                psiFile = (PsiFile)sourceFile;
            }
            if (psiFile.getFileType().isBinary()) {
                psiFile = null;
            }
        }
        VirtualFile sourceVirtualFile = PsiUtilCore.getVirtualFile(psiFile);
        if (psiFile == null || psiFile.getFileType().isBinary() || sourceVirtualFile == null || sourceVirtualFile.getFileType().isBinary()) {
            return null;
        }
        return Pair.createNonNull(psiFile, sourceVirtualFile);
    }

    private /* synthetic */ boolean lambda$processFindInFilesUsagesInFile$10(boolean skipProjectFile, AtomicBoolean projectFileUsagesFound, AtomicBoolean reportedFirst, Set processedUsages, Processor usageConsumer, UsageInfo info2) {
        if (skipProjectFile) {
            projectFileUsagesFound.set(true);
            return true;
        }
        if (reportedFirst.compareAndSet(false, true) && LOG.isDebugEnabled()) {
            LOG.debug("First usage found in " + TimeoutUtil.getDurationMillis(this.mySearchStartedAt) + " ms");
        }
        if (processedUsages.contains(info2)) {
            return true;
        }
        boolean success = usageConsumer.process(info2);
        processedUsages.add(info2);
        return success;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToScanInitially";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageProcessor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageConsumer";
                break;
            }
            case 7: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindInProjectTask";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrenceCount";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesBeingProcessed";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedFirst";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadySearched";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindInProjectTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapUsageProcessor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForFastWordSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapUsageProcessor";
                break;
            }
            case 7: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processFindInFilesUsagesInFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 16, 17 -> new IllegalStateException(string2);
        };
    }
}

