/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindModelListener;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindResultImpl;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.PreserveCaseUtil;
import com.intellij.find.impl.RegExReplacementBuilder;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.navigation.NavigationItem;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.impl.SyntaxHighlighterOverEditorHighlighter;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.StringSearcher;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindManagerImpl
extends FindManager {
    private static final Logger LOG = Logger.getInstance(FindManagerImpl.class);
    private static final Key<ThreadLocal<SoftReference<CommentsLiteralsSearchData>>> ourCommentsLiteralsSearchDataKey = KeyWithDefaultValue.create("comments.literals.search.data", () -> new ThreadLocal());
    private static final Key<ThreadLocal<SoftReference<FindExceptCommentsOrLiteralsData>>> ourExceptCommentsOrLiteralsDataKey = KeyWithDefaultValue.create("except.comments.literals.search.data", () -> new ThreadLocal());
    private static final Key<Boolean> HIGHLIGHTER_WAS_NOT_FOUND_KEY = Key.create("com.intellij.find.impl.FindManagerImpl.HighlighterNotFoundKey");
    private static final NotificationGroup GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Find Problems");
    private static final FindResultImpl NOT_FOUND_RESULT = new FindResultImpl();
    private static final IntObjectMap<Boolean> ourReportedPatterns = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private final FindUsagesManager myFindUsagesManager;
    private boolean isFindWasPerformed;
    private boolean isSelectNextOccurrenceWasPerformed;
    private Point myReplaceInFilePromptPos;
    private Point myReplaceInProjectPromptPos;
    private final FindModel myFindInProjectModel;
    private final FindModel myFindInFileModel;
    private FindModel myFindNextModel;
    private FindModel myPreviousFindModel;
    private final Project myProject;
    private FindUIHelper myHelper;

    public FindManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            FindManagerImpl.$$$reportNull$$$0(0);
        }
        this.myReplaceInFilePromptPos = new Point(-1, -1);
        this.myReplaceInProjectPromptPos = new Point(-1, -1);
        this.myFindInProjectModel = new FindModel();
        this.myFindInFileModel = new FindModel();
        this.myProject = project2;
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.initModelBySetings(this.myFindInProjectModel);
        this.myFindInFileModel.setCaseSensitive(findSettings.isLocalCaseSensitive());
        this.myFindInFileModel.setWholeWordsOnly(findSettings.isLocalWholeWordsOnly());
        this.myFindInFileModel.setRegularExpressions(findSettings.isLocalRegularExpressions());
        this.myFindUsagesManager = new FindUsagesManager(this.myProject);
        this.myFindInProjectModel.setMultipleFiles(true);
        NotificationsConfigurationImpl.remove((String[])new String[]{"FindInPath"});
        Disposer.register(project2, () -> {
            if (this.myHelper != null) {
                Disposer.dispose(this.myHelper);
            }
        });
    }

    public FindModel createReplaceInFileModel() {
        FindModel model2 = new FindModel();
        model2.copyFrom(this.getFindInFileModel());
        model2.setReplaceState(true);
        model2.setPromptOnReplace(false);
        return model2;
    }

    public int showPromptDialog(@NotNull FindModel model2, String title) {
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(1);
        }
        return this.showPromptDialogImpl(model2, title, null);
    }

    @FindManager.PromptResultValue
    private int showPromptDialogImpl(final @NotNull FindModel model2, @NlsContexts.DialogTitle String title, @Nullable FindManager.MalformedReplacementStringException exception) {
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(2);
        }
        ReplacePromptDialog replacePromptDialog = new ReplacePromptDialog(model2.isMultipleFiles(), title, this.myProject, exception){

            @Nullable
            public Point getInitialLocation() {
                if (model2.isMultipleFiles() && FindManagerImpl.this.myReplaceInProjectPromptPos.x >= 0 && FindManagerImpl.this.myReplaceInProjectPromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInProjectPromptPos;
                }
                if (!model2.isMultipleFiles() && FindManagerImpl.this.myReplaceInFilePromptPos.x >= 0 && FindManagerImpl.this.myReplaceInFilePromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInFilePromptPos;
                }
                return null;
            }
        };
        replacePromptDialog.show();
        if (model2.isMultipleFiles()) {
            this.myReplaceInProjectPromptPos = replacePromptDialog.getLocation();
        } else {
            this.myReplaceInFilePromptPos = replacePromptDialog.getLocation();
        }
        return replacePromptDialog.getExitCode();
    }

    void changeGlobalSettings(FindModel findModel) {
        String stringToFind = findModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)this.myProject);
        if (!StringUtil.isEmpty(stringToFind)) {
            findInProjectSettings.addStringToFind(stringToFind);
        }
        if (!findModel.isMultipleFiles()) {
            this.setFindWasPerformed();
        }
        if (findModel.isReplaceState()) {
            findInProjectSettings.addStringToReplace(findModel.getStringToReplace());
        }
        if (findModel.isMultipleFiles() && !findModel.isProjectScope() && findModel.getDirectoryName() != null) {
            findInProjectSettings.addDirectory(findModel.getDirectoryName());
            this.myFindInProjectModel.setWithSubdirectories(findModel.isWithSubdirectories());
        }
    }

    public void showFindDialog(@NotNull FindModel model2, @NotNull Runnable okHandler) {
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(3);
        }
        if (okHandler == null) {
            FindManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.myHelper == null || Disposer.isDisposed(this.myHelper)) {
            this.myHelper = new FindUIHelper(this.myProject, model2, okHandler);
            Disposer.register(this.myHelper, () -> {
                this.myHelper = null;
            });
        } else {
            this.myHelper.setModel(model2);
            this.myHelper.setOkHandler(okHandler);
        }
        this.myHelper.showUI();
    }

    public void closeFindDialog() {
        if (this.myHelper != null) {
            this.myHelper.closeUI();
        }
    }

    @NotNull
    public FindModel getFindInFileModel() {
        FindModel findModel = this.myFindInFileModel;
        if (findModel == null) {
            FindManagerImpl.$$$reportNull$$$0(5);
        }
        return findModel;
    }

    @NotNull
    public FindModel getFindInProjectModel() {
        this.myFindInProjectModel.setFromCursor(false);
        this.myFindInProjectModel.setForward(true);
        this.myFindInProjectModel.setGlobal(true);
        this.myFindInProjectModel.setSearchInProjectFiles(false);
        FindModel findModel = this.myFindInProjectModel;
        if (findModel == null) {
            FindManagerImpl.$$$reportNull$$$0(6);
        }
        return findModel;
    }

    public boolean findWasPerformed() {
        return this.isFindWasPerformed;
    }

    public void setFindWasPerformed() {
        this.isFindWasPerformed = true;
        this.isSelectNextOccurrenceWasPerformed = false;
    }

    public boolean selectNextOccurrenceWasPerformed() {
        return this.isSelectNextOccurrenceWasPerformed;
    }

    public void setSelectNextOccurrenceWasPerformed() {
        this.isSelectNextOccurrenceWasPerformed = true;
        this.isFindWasPerformed = false;
    }

    public FindModel getFindNextModel() {
        return this.myFindNextModel;
    }

    public FindModel getFindNextModel(@NotNull Editor editor2) {
        String textInField;
        if (editor2 == null) {
            FindManagerImpl.$$$reportNull$$$0(7);
        }
        if (this.myFindNextModel == null) {
            return null;
        }
        EditorSearchSession search2 = EditorSearchSession.get(editor2);
        if (!(search2 == null || this.isSelectNextOccurrenceWasPerformed || Objects.equals(textInField = search2.getTextInField(), this.myFindInFileModel.getStringToFind()) || textInField.isEmpty())) {
            FindModel patched = new FindModel();
            patched.copyFrom(this.myFindNextModel);
            patched.setStringToFind(textInField);
            return patched;
        }
        return this.myFindNextModel;
    }

    public void setFindNextModel(FindModel findNextModel) {
        this.myFindNextModel = findNextModel;
        ((FindModelListener)this.myProject.getMessageBus().syncPublisher(FIND_MODEL_TOPIC)).findNextModelChanged();
    }

    @NotNull
    public FindResult findString(@NotNull CharSequence text2, int offset2, @NotNull FindModel model2) {
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(8);
        }
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(9);
        }
        FindResult findResult = this.findString(text2, offset2, model2, null);
        if (findResult == null) {
            FindManagerImpl.$$$reportNull$$$0(10);
        }
        return findResult;
    }

    @NotNull
    public FindResult findString(@NotNull CharSequence text2, int offset2, @NotNull FindModel model2, @Nullable VirtualFile file2) {
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(11);
        }
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(12);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("offset=" + offset2);
            LOG.debug("textlength=" + text2.length());
            LOG.debug(model2.toString());
        }
        FindResult findResult = this.findStringLoop(text2, offset2, model2, file2, this.getFindContextPredicate(model2, file2, text2));
        if (findResult == null) {
            FindManagerImpl.$$$reportNull$$$0(13);
        }
        return findResult;
    }

    private FindResult findStringLoop(CharSequence text2, int offset2, FindModel model2, VirtualFile file2, @Nullable Predicate<? super FindResult> filter2) {
        char[] textArray = CharArrayUtil.fromSequenceWithoutCopying(text2);
        do {
            FindResult result2 = this.doFindString(text2, textArray, offset2, model2, file2);
            if (!(filter2 != null && !filter2.test((FindResult)result2) || model2.isWholeWordsOnly() && result2.isStringFound() && !FindManagerImpl.isWholeWord(text2, result2.getStartOffset(), result2.getEndOffset()))) {
                return result2;
            }
            int n = offset2 = model2.isForward() ? result2.getStartOffset() + 1 : result2.getEndOffset() - 1;
        } while (offset2 <= text2.length() && offset2 >= 0);
        return NOT_FOUND_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Predicate<FindResult> getFindContextPredicate(@NotNull FindModel model2, @Nullable VirtualFile file2, @NotNull CharSequence text2) {
        FindExceptCommentsOrLiteralsData currentThreadData;
        ThreadLocal data2;
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            return null;
        }
        FindModel.SearchContext context2 = model2.getSearchContext();
        if (context2 == FindModel.SearchContext.ANY || context2 == FindModel.SearchContext.IN_COMMENTS || context2 == FindModel.SearchContext.IN_STRING_LITERALS) {
            return null;
        }
        FindModel findModel = model2;
        synchronized (findModel) {
            data2 = (ThreadLocal)model2.getUserData(ourExceptCommentsOrLiteralsDataKey);
            assert (data2 != null);
        }
        SoftReference currentThreadDataRef = (SoftReference)data2.get();
        FindExceptCommentsOrLiteralsData findExceptCommentsOrLiteralsData = currentThreadData = currentThreadDataRef == null ? null : (FindExceptCommentsOrLiteralsData)currentThreadDataRef.get();
        if (currentThreadData == null || !currentThreadData.isAcceptableFor(model2, file2, text2)) {
            currentThreadData = FindExceptCommentsOrLiteralsData.create(file2, model2, text2, this);
            data2.set(new SoftReference<FindExceptCommentsOrLiteralsData>(currentThreadData));
        }
        return currentThreadData;
    }

    public int showMalformedReplacementPrompt(@NotNull FindModel model2, String title, FindManager.MalformedReplacementStringException exception) {
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(16);
        }
        return this.showPromptDialogImpl(model2, title, exception);
    }

    public FindModel getPreviousFindModel() {
        return this.myPreviousFindModel;
    }

    public void setPreviousFindModel(FindModel previousFindModel) {
        this.myPreviousFindModel = previousFindModel;
    }

    private static boolean isWholeWord(CharSequence text2, int startOffset, int endOffset) {
        boolean isWordEnd;
        boolean isWordStart;
        if (startOffset != 0) {
            boolean previousCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(startOffset - 1)) && (startOffset <= 1 || text2.charAt(startOffset - 2) != '\\');
            boolean previousCharacterIsSameAsNext = text2.charAt(startOffset - 1) == text2.charAt(startOffset);
            boolean firstCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(startOffset));
            isWordStart = firstCharacterIsIdentifier ? !previousCharacterIsIdentifier : !previousCharacterIsSameAsNext;
        } else {
            isWordStart = true;
        }
        if (endOffset != text2.length()) {
            boolean lastSearchedCharacterIsIdentifier;
            boolean nextCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(endOffset));
            boolean nextCharacterIsSameAsPrevious = endOffset > 0 && text2.charAt(endOffset) == text2.charAt(endOffset - 1);
            boolean bl = lastSearchedCharacterIsIdentifier = endOffset > 0 && Character.isJavaIdentifierPart(text2.charAt(endOffset - 1));
            isWordEnd = lastSearchedCharacterIsIdentifier ? !nextCharacterIsIdentifier : !nextCharacterIsSameAsPrevious;
        } else {
            isWordEnd = true;
        }
        return isWordStart && isWordEnd;
    }

    @NotNull
    private FindResult doFindString(@NotNull CharSequence text2, char @Nullable [] textArray, int offset2, @NotNull FindModel model2, @Nullable VirtualFile file2) {
        int index2;
        String toFind;
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(17);
        }
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(18);
        }
        if ((toFind = model2.getStringToFind()).isEmpty()) {
            FindResultImpl findResultImpl = NOT_FOUND_RESULT;
            if (findResultImpl == null) {
                FindManagerImpl.$$$reportNull$$$0(19);
            }
            return findResultImpl;
        }
        if (model2.isInCommentsOnly() || model2.isInStringLiteralsOnly()) {
            if (file2 == null) {
                FindResultImpl findResultImpl = NOT_FOUND_RESULT;
                if (findResultImpl == null) {
                    FindManagerImpl.$$$reportNull$$$0(20);
                }
                return findResultImpl;
            }
            return this.findInCommentsAndLiterals(text2, textArray, offset2, model2, file2);
        }
        if (model2.isRegularExpressions()) {
            FindResult findResult = this.findStringByRegularExpression(text2, offset2, model2, file2);
            if (findResult == null) {
                FindManagerImpl.$$$reportNull$$$0(21);
            }
            return findResult;
        }
        StringSearcher searcher2 = FindManagerImpl.createStringSearcher(model2);
        if (model2.isForward()) {
            int res = searcher2.scan(text2, textArray, offset2, text2.length());
            index2 = res < 0 ? -1 : res;
        } else {
            int n = index2 = offset2 == 0 ? -1 : searcher2.scan(text2, textArray, 0, offset2 - 1);
        }
        if (index2 < 0) {
            FindResultImpl findResultImpl = NOT_FOUND_RESULT;
            if (findResultImpl == null) {
                FindManagerImpl.$$$reportNull$$$0(22);
            }
            return findResultImpl;
        }
        return new FindResultImpl(index2, index2 + toFind.length());
    }

    @NotNull
    private static StringSearcher createStringSearcher(@NotNull FindModel model2) {
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(23);
        }
        return new StringSearcher(model2.getStringToFind(), model2.isCaseSensitive(), model2.isForward());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearPreviousFindData(FindModel model2) {
        FindModel findModel = model2;
        synchronized (findModel) {
            model2.putUserData(ourCommentsLiteralsSearchDataKey, null);
            model2.putUserData(ourExceptCommentsOrLiteralsDataKey, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FindResult findInCommentsAndLiterals(@NotNull CharSequence text2, char[] textArray, int offset2, @NotNull FindModel model2, @NotNull VirtualFile file2) {
        CommentsLiteralsSearchData currentThreadData;
        ThreadLocal data2;
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(24);
        }
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(25);
        }
        if (file2 == null) {
            FindManagerImpl.$$$reportNull$$$0(26);
        }
        FindModel findModel = model2;
        synchronized (findModel) {
            data2 = (ThreadLocal)model2.getUserData(ourCommentsLiteralsSearchDataKey);
            assert (data2 != null);
        }
        FileType ftype = file2.getFileType();
        Language lang = LanguageUtil.getLanguageForPsi(this.myProject, file2, ftype);
        SoftReference currentThreadDataRef = (SoftReference)data2.get();
        CommentsLiteralsSearchData commentsLiteralsSearchData = currentThreadData = currentThreadDataRef == null ? null : (CommentsLiteralsSearchData)currentThreadDataRef.get();
        if (currentThreadData == null || !Comparing.equal(currentThreadData.lastFile, file2) || !currentThreadData.model.equals((Object)model2)) {
            Set<Language> relevantLanguages;
            SyntaxHighlighter highlighter = FindManagerImpl.getHighlighter(file2, lang);
            if (highlighter == null) {
                FindResultImpl findResultImpl = NOT_FOUND_RESULT;
                if (findResultImpl == null) {
                    FindManagerImpl.$$$reportNull$$$0(27);
                }
                return findResultImpl;
            }
            TokenSet tokensOfInterest = TokenSet.EMPTY;
            if (lang != null) {
                Language finalLang = lang;
                relevantLanguages = ReadAction.compute(() -> {
                    HashSet<Language> result2 = new HashSet<Language>();
                    FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(file2);
                    if (viewProvider != null) {
                        result2.addAll(viewProvider.getLanguages());
                    }
                    if (result2.isEmpty()) {
                        result2.add(finalLang);
                    }
                    return result2;
                });
                for (Language relevantLanguage : relevantLanguages) {
                    tokensOfInterest = FindManagerImpl.addTokenTypesForLanguage(model2, relevantLanguage, tokensOfInterest);
                }
            } else {
                relevantLanguages = new HashSet();
                if (ftype instanceof AbstractFileType) {
                    if (model2.isInCommentsOnly()) {
                        tokensOfInterest = TokenSet.create(CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT);
                    }
                    if (model2.isInStringLiteralsOnly()) {
                        tokensOfInterest = TokenSet.orSet(tokensOfInterest, TokenSet.create(CustomHighlighterTokenType.STRING, CustomHighlighterTokenType.SINGLE_QUOTED_STRING));
                    }
                }
            }
            Matcher matcher = model2.isRegularExpressions() ? FindManagerImpl.compileRegExp(model2, "") : null;
            StringSearcher searcher2 = matcher != null ? null : new StringSearcher(model2.getStringToFind(), model2.isCaseSensitive(), true);
            LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
            try {
                SyntaxHighlighterOverEditorHighlighter highlighterAdapter = ReadAction.compute(() -> new SyntaxHighlighterOverEditorHighlighter(highlighter, file2, this.myProject));
                currentThreadData = new CommentsLiteralsSearchData(file2, relevantLanguages, highlighterAdapter, tokensOfInterest, searcher2, matcher, model2.clone());
                currentThreadData.highlighter.restart(text2);
            }
            finally {
                LayeredLexer.ourDisableLayersFlag.set(null);
            }
            data2.set(new SoftReference<CommentsLiteralsSearchData>(currentThreadData));
        }
        int initialStartOffset = model2.isForward() && currentThreadData.startOffset < offset2 ? currentThreadData.startOffset : 0;
        currentThreadData.highlighter.resetPosition(initialStartOffset);
        Lexer lexer = currentThreadData.highlighter.getHighlightingLexer();
        TokenSet tokens = currentThreadData.tokensOfInterest;
        int lastGoodOffset = 0;
        boolean scanningForward = model2.isForward();
        FindResultImpl prevFindResult = NOT_FOUND_RESULT;
        while (true) {
            block44: {
                int end;
                int start;
                block43: {
                    block41: {
                        IElementType tokenType;
                        block42: {
                            char c2;
                            if ((tokenType = lexer.getTokenType()) == null) break block41;
                            if (lexer.getState() == 0) {
                                lastGoodOffset = lexer.getTokenStart();
                            }
                            TextAttributesKey[] keys2 = currentThreadData.highlighter.getTokenHighlights(tokenType);
                            if (!tokens.contains(tokenType) && (!model2.isInStringLiteralsOnly() || !ChunkExtractor.isHighlightedAsString((TextAttributesKey[])keys2)) && (!model2.isInCommentsOnly() || !ChunkExtractor.isHighlightedAsComment((TextAttributesKey[])keys2))) break block42;
                            start = lexer.getTokenStart();
                            end = lexer.getTokenEnd();
                            if (model2.isInStringLiteralsOnly() && ((c2 = text2.charAt(start)) == '\"' || c2 == '\'')) {
                                while (start < end && c2 == text2.charAt(start)) {
                                    if (c2 != text2.charAt(end - 1) || ++start >= end) continue;
                                    --end;
                                }
                            }
                            break block43;
                        }
                        Language tokenLang = tokenType.getLanguage();
                        if (tokenLang != lang && tokenLang != Language.ANY && !currentThreadData.relevantLanguages.contains(tokenLang)) {
                            currentThreadData.tokensOfInterest = tokens = FindManagerImpl.addTokenTypesForLanguage(model2, tokenLang, tokens);
                            currentThreadData.relevantLanguages.add(tokenLang);
                        }
                        break block44;
                    }
                    FindResultImpl findResultImpl = prevFindResult;
                    if (findResultImpl == null) {
                        FindManagerImpl.$$$reportNull$$$0(30);
                    }
                    return findResultImpl;
                }
                int tokenContentStart = start;
                while (true) {
                    FindResultImpl findResult = null;
                    if (currentThreadData.searcher != null) {
                        int matchStart = currentThreadData.searcher.scan(text2, textArray, start, end);
                        if (matchStart != -1 && matchStart >= start) {
                            int matchEnd = matchStart + model2.getStringToFind().length();
                            if (matchStart >= offset2 || !scanningForward) {
                                findResult = new FindResultImpl(matchStart, matchEnd);
                            } else {
                                start = matchEnd;
                                continue;
                            }
                        }
                    } else if (start <= end) {
                        currentThreadData.matcher.reset(StringPattern.newBombedCharSequence(text2.subSequence(tokenContentStart, end)));
                        currentThreadData.matcher.region(start - tokenContentStart, end - tokenContentStart);
                        currentThreadData.matcher.useTransparentBounds(true);
                        if (currentThreadData.matcher.find()) {
                            int matchEnd = tokenContentStart + currentThreadData.matcher.end();
                            int matchStart = tokenContentStart + currentThreadData.matcher.start();
                            if (matchStart >= offset2 || !scanningForward) {
                                findResult = new FindResultImpl(matchStart, matchEnd);
                            } else {
                                int diff = 0;
                                if (start == end || start == matchEnd) {
                                    diff = 1;
                                }
                                start = matchEnd + diff;
                                continue;
                            }
                        }
                    }
                    if (findResult == null) break;
                    if (scanningForward) {
                        currentThreadData.startOffset = lastGoodOffset;
                        FindResultImpl findResultImpl = findResult;
                        if (findResultImpl == null) {
                            FindManagerImpl.$$$reportNull$$$0(28);
                        }
                        return findResultImpl;
                    }
                    if (findResult.getEndOffset() >= offset2) {
                        FindResultImpl findResultImpl = prevFindResult;
                        if (findResultImpl == null) {
                            FindManagerImpl.$$$reportNull$$$0(29);
                        }
                        return findResultImpl;
                    }
                    prevFindResult = findResult;
                    start = findResult.getEndOffset();
                }
            }
            lexer.advance();
        }
    }

    private static TokenSet addTokenTypesForLanguage(FindModel model2, Language lang, TokenSet tokensOfInterest) {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (definition != null) {
            tokensOfInterest = TokenSet.orSet(tokensOfInterest, model2.isInCommentsOnly() ? definition.getCommentTokens() : TokenSet.EMPTY);
            tokensOfInterest = TokenSet.orSet(tokensOfInterest, model2.isInStringLiteralsOnly() ? definition.getStringLiteralElements() : TokenSet.EMPTY);
        }
        return tokensOfInterest;
    }

    private static SyntaxHighlighter getHighlighter(VirtualFile file2, @Nullable Language lang) {
        SyntaxHighlighter syntaxHighlighter;
        SyntaxHighlighter syntaxHighlighter2 = syntaxHighlighter = lang != null ? SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, null, (VirtualFile)file2) : null;
        if (lang == null || syntaxHighlighter instanceof PlainSyntaxHighlighter) {
            syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)file2.getFileType(), null, (VirtualFile)file2);
        }
        return syntaxHighlighter;
    }

    private FindResult findStringByRegularExpression(CharSequence text2, int startOffset, FindModel model2, VirtualFile file2) {
        Matcher matcher = FindManagerImpl.compileRegExp(model2, text2);
        if (matcher == null) {
            return NOT_FOUND_RESULT;
        }
        try {
            if (model2.isForward()) {
                if (matcher.find(startOffset) && matcher.end() <= text2.length()) {
                    return new FindResultImpl(matcher.start(), matcher.end());
                }
                return NOT_FOUND_RESULT;
            }
            int start = -1;
            int end = -1;
            while (matcher.find() && matcher.end() < startOffset) {
                start = matcher.start();
                end = matcher.end();
            }
            if (start < 0) {
                return NOT_FOUND_RESULT;
            }
            return new FindResultImpl(start, end);
        }
        catch (StackOverflowError soe) {
            String stringToFind = model2.getStringToFind();
            if (!ApplicationManager.getApplication().isHeadlessEnvironment() && ourReportedPatterns.put(stringToFind.hashCode(), Boolean.TRUE) == null) {
                String content2 = FindBundle.message("notification.content.regular.expression.soe", stringToFind, file2.getPresentableUrl());
                LOG.info(content2);
                GROUP.createNotification(FindBundle.message("notification.title.regular.expression.failed.to.match", new Object[0]), content2, NotificationType.ERROR).notify(this.myProject);
            }
            return NOT_FOUND_RESULT;
        }
    }

    private static Matcher compileRegExp(FindModel model2, CharSequence text2) {
        Pattern pattern = model2.compileRegExp();
        return pattern == null ? null : pattern.matcher(StringPattern.newBombedCharSequence(text2));
    }

    public String getStringToReplace(@NotNull String foundString, @NotNull FindModel model2, int startOffset, @NotNull CharSequence documentText) throws FindManager.MalformedReplacementStringException {
        if (foundString == null) {
            FindManagerImpl.$$$reportNull$$$0(31);
        }
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(32);
        }
        if (documentText == null) {
            FindManagerImpl.$$$reportNull$$$0(33);
        }
        String replacement = model2.getStringToReplace();
        if (model2.isRegularExpressions()) {
            replacement = FindManagerImpl.getStringToReplaceByRegexp(model2, documentText, startOffset);
        }
        if (model2.isPreserveCase()) {
            replacement = Registry.is("ide.find.word.based.preserve.case") ? PreserveCaseUtil.applyCase(foundString, replacement) : PreserveCaseUtil.replaceWithCaseRespect(replacement, foundString);
        }
        return replacement;
    }

    private static String getStringToReplaceByRegexp(@NotNull FindModel model2, @NotNull CharSequence text2, int startOffset) throws FindManager.MalformedReplacementStringException {
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(34);
        }
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(35);
        }
        Matcher matcher = FindManagerImpl.compileRegexAndFindFirst(model2, text2, startOffset);
        return FindManagerImpl.getStringToReplaceByRegexp(model2, matcher);
    }

    private static String getStringToReplaceByRegexp(@NotNull FindModel model2, Matcher matcher) throws FindManager.MalformedReplacementStringException {
        if (model2 == null) {
            FindManagerImpl.$$$reportNull$$$0(36);
        }
        if (matcher == null) {
            return null;
        }
        try {
            String toReplace = model2.getStringToReplace();
            return new RegExReplacementBuilder(matcher).createReplacement(toReplace);
        }
        catch (Exception e) {
            throw FindManagerImpl.createMalformedReplacementException(model2, e);
        }
    }

    private static Matcher compileRegexAndFindFirst(FindModel model2, CharSequence text2, int startOffset) {
        Matcher matcher = FindManagerImpl.compileRegExp(model2, text2);
        assert (matcher != null);
        if (model2.isForward()) {
            if (!matcher.find(startOffset)) {
                return null;
            }
            if (matcher.end() > text2.length()) {
                return null;
            }
        } else {
            int start = -1;
            while (matcher.find() && matcher.end() < startOffset) {
                start = matcher.start();
            }
            if (start < 0) {
                return null;
            }
        }
        return matcher;
    }

    private static FindManager.MalformedReplacementStringException createMalformedReplacementException(FindModel model2, Exception e) {
        return new FindManager.MalformedReplacementStringException(FindBundle.message("find.replace.invalid.replacement.string", model2.getStringToReplace()), (Throwable)e);
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            FindManagerImpl.$$$reportNull$$$0(37);
        }
        return element.isValid() && this.myFindUsagesManager.canFindUsages(element);
    }

    public void findUsages(@NotNull PsiElement element) {
        if (element == null) {
            FindManagerImpl.$$$reportNull$$$0(38);
        }
        this.findUsages(element, false);
    }

    public void findUsagesInScope(@NotNull PsiElement element, @NotNull SearchScope searchScope2) {
        if (element == null) {
            FindManagerImpl.$$$reportNull$$$0(39);
        }
        if (searchScope2 == null) {
            FindManagerImpl.$$$reportNull$$$0(40);
        }
        this.myFindUsagesManager.findUsages(element, null, null, false, searchScope2);
    }

    public void findUsages(@NotNull PsiElement element, boolean showDialog) {
        if (element == null) {
            FindManagerImpl.$$$reportNull$$$0(41);
        }
        this.myFindUsagesManager.findUsages(element, null, null, showDialog, null);
    }

    public void showSettingsAndFindUsages(NavigationItem @NotNull [] targets2) {
        if (targets2 == null) {
            FindManagerImpl.$$$reportNull$$$0(42);
        }
        FindUsagesManager.showSettingsAndFindUsages(targets2);
    }

    public void clearFindingNextUsageInFile() {
        this.myFindUsagesManager.clearFindingNextUsageInFile();
    }

    public void findUsagesInEditor(@NotNull PsiElement element, @NotNull FileEditor fileEditor) {
        if (element == null) {
            FindManagerImpl.$$$reportNull$$$0(43);
        }
        if (fileEditor == null) {
            FindManagerImpl.$$$reportNull$$$0(44);
        }
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor2 = textEditor.getEditor();
            Document document = editor2.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
            this.myFindUsagesManager.findUsages(element, psiFile, fileEditor, false, null);
        }
    }

    private static boolean tryToFindNextUsageViaEditorSearchComponent(Editor editor2, SearchResults.Direction forwardOrBackward) {
        EditorSearchSession search2 = EditorSearchSession.get(editor2);
        if (search2 != null && search2.hasMatches()) {
            if (!search2.isSearchInProgress()) {
                if (forwardOrBackward == SearchResults.Direction.UP) {
                    search2.searchBackward();
                } else {
                    search2.searchForward();
                }
            }
            return true;
        }
        return false;
    }

    public boolean findNextUsageInEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            FindManagerImpl.$$$reportNull$$$0(45);
        }
        return this.findNextUsageInFile(editor2, SearchResults.Direction.DOWN);
    }

    public boolean findPreviousUsageInEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            FindManagerImpl.$$$reportNull$$$0(46);
        }
        return this.findNextUsageInFile(editor2, SearchResults.Direction.UP);
    }

    private boolean findNextUsageInFile(@NotNull Editor editor2, @NotNull SearchResults.Direction direction) {
        if (editor2 == null) {
            FindManagerImpl.$$$reportNull$$$0(47);
        }
        if (direction == null) {
            FindManagerImpl.$$$reportNull$$$0(48);
        }
        editor2.getCaretModel().removeSecondaryCarets();
        if (FindManagerImpl.tryToFindNextUsageViaEditorSearchComponent(editor2, direction)) {
            return true;
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)this.myProject)).getHighlighters(editor2);
        if (highlighters.length > 0) {
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor2, editor2.getCaretModel().getOffset(), direction == SearchResults.Direction.DOWN, false);
        }
        if (direction == SearchResults.Direction.DOWN) {
            return this.myFindUsagesManager.findNextUsageInFile(editor2);
        }
        return this.myFindUsagesManager.findPreviousUsageInFile(editor2);
    }

    private static boolean highlightNextHighlighter(RangeHighlighter[] highlighters, Editor editor2, int offset2, boolean isForward, boolean secondPass) {
        RangeHighlighter highlighterToSelect = null;
        Object wasNotFound = editor2.getUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY);
        for (RangeHighlighter highlighter : highlighters) {
            int start = highlighter.getStartOffset();
            int end = highlighter.getEndOffset();
            if (!highlighter.isValid() || start >= end) continue;
            if (isForward && (start > offset2 || start == offset2 && secondPass) && (highlighterToSelect == null || highlighterToSelect.getStartOffset() > start)) {
                highlighterToSelect = highlighter;
            }
            if (isForward || end >= offset2 && (end != offset2 || !secondPass) || highlighterToSelect != null && highlighterToSelect.getEndOffset() >= end) continue;
            highlighterToSelect = highlighter;
        }
        if (highlighterToSelect != null) {
            FindManagerImpl.expandFoldRegionsIfNecessary(editor2, highlighterToSelect.getStartOffset(), highlighterToSelect.getEndOffset());
            editor2.getSelectionModel().setSelection(highlighterToSelect.getStartOffset(), highlighterToSelect.getEndOffset());
            editor2.getCaretModel().moveToOffset(highlighterToSelect.getStartOffset());
            ScrollType scrollType = secondPass ? (isForward ? ScrollType.CENTER_UP : ScrollType.CENTER_DOWN) : (isForward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP);
            editor2.getScrollingModel().scrollToCaret(scrollType);
            editor2.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, null);
            EditorSearchSession.logSelectionUpdate();
            return true;
        }
        if (wasNotFound == null) {
            AnAction action2;
            String shortcutsText;
            editor2.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, (Object)Boolean.TRUE);
            String message = FindBundle.message("find.highlight.no.more.highlights.found", new Object[0]);
            message = isForward ? ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message("find.search.again.from.top.action.message", message) : FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindPrevious")))).isEmpty() ? FindBundle.message("find.search.again.from.bottom.action.message", message) : FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText));
            JComponent component2 = HintUtil.createInformationLabel((String)message);
            LightweightHint hint = new LightweightHint(component2);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)2, 42, 0, false);
            return true;
        }
        if (!secondPass) {
            offset2 = isForward ? 0 : editor2.getDocument().getTextLength();
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor2, offset2, isForward, true);
        }
        return false;
    }

    private static void expandFoldRegionsIfNecessary(@NotNull Editor editor2, int startOffset, int endOffset) {
        FoldRegion region;
        FoldingModel foldingModel;
        FoldRegion[] regions;
        if (editor2 == null) {
            FindManagerImpl.$$$reportNull$$$0(49);
        }
        if ((regions = (foldingModel = editor2.getFoldingModel()) instanceof FoldingModelEx ? ((FoldingModelEx)foldingModel).fetchTopLevel() : foldingModel.getAllFoldRegions()) == null) {
            return;
        }
        int i2 = Arrays.binarySearch(regions, null, (o1, o2) -> {
            if (o1 == null) {
                return startOffset - o2.getEndOffset();
            }
            return o1.getEndOffset() - startOffset;
        });
        i2 = i2 < 0 ? -i2 - 1 : ++i2;
        if (i2 >= regions.length) {
            return;
        }
        ArrayList<FoldRegion> toExpand = new ArrayList<FoldRegion>();
        while (i2 < regions.length && (region = regions[i2]).getStartOffset() < endOffset) {
            if (!region.isExpanded()) {
                toExpand.add(region);
            }
            ++i2;
        }
        if (toExpand.isEmpty()) {
            return;
        }
        foldingModel.runBatchFoldingOperation(() -> {
            for (FoldRegion region : toExpand) {
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public FindUsagesManager getFindUsagesManager() {
        FindUsagesManager findUsagesManager = this.myFindUsagesManager;
        if (findUsagesManager == null) {
            FindManagerImpl.$$$reportNull$$$0(50);
        }
        return findUsagesManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 10, 13, 19, 20, 21, 22, 27, 28, 29, 30, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 25: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okHandler";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindManagerImpl";
                break;
            }
            case 7: 
            case 45: 
            case 46: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundString";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindInFileModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindInProjectModel";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findString";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindString";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findInCommentsAndLiterals";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showPromptDialog";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showPromptDialogImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showFindDialog";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 50: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFindNextModel";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFindContextPredicate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showMalformedReplacementPrompt";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doFindString";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createStringSearcher";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findInCommentsAndLiterals";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStringToReplace";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getStringToReplaceByRegexp";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 38: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInScope";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsAndFindUsages";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findNextUsageInEditor";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousUsageInEditor";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findNextUsageInFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "expandFoldRegionsIfNecessary";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 10, 13, 19, 20, 21, 22, 27, 28, 29, 30, 50 -> new IllegalStateException(string2);
        };
    }

    private static class FindExceptCommentsOrLiteralsData
    implements Predicate<FindResult> {
        private final VirtualFile myFile;
        private final FindModel myFindModel;
        private final TreeMap<Integer, Integer> mySkipRangesSet;
        private final CharSequence myText;

        static FindExceptCommentsOrLiteralsData create(@NotNull VirtualFile file2, @NotNull FindModel model2, @NotNull CharSequence text2, @NotNull FindManagerImpl manager) {
            if (file2 == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(0);
            }
            if (model2 == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(2);
            }
            if (manager == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(3);
            }
            TreeMap<Integer, Integer> skipRangesSet = new TreeMap<Integer, Integer>();
            if (model2.isExceptComments() || model2.isExceptCommentsAndStringLiterals()) {
                FindExceptCommentsOrLiteralsData.addRanges(file2, model2, text2, skipRangesSet, FindModel.SearchContext.IN_COMMENTS, manager);
            }
            if (model2.isExceptStringLiterals() || model2.isExceptCommentsAndStringLiterals()) {
                FindExceptCommentsOrLiteralsData.addRanges(file2, model2, text2, skipRangesSet, FindModel.SearchContext.IN_STRING_LITERALS, manager);
            }
            return new FindExceptCommentsOrLiteralsData(file2, model2.clone(), ImmutableCharSequence.asImmutable(text2), skipRangesSet);
        }

        FindExceptCommentsOrLiteralsData(@NotNull VirtualFile file2, @NotNull FindModel model2, @NotNull CharSequence text2, @NotNull TreeMap<Integer, Integer> skipRangesSet) {
            if (file2 == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(4);
            }
            if (model2 == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(5);
            }
            if (text2 == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(6);
            }
            if (skipRangesSet == null) {
                FindExceptCommentsOrLiteralsData.$$$reportNull$$$0(7);
            }
            this.myFile = file2;
            this.myFindModel = model2.clone();
            this.myText = ImmutableCharSequence.asImmutable(text2);
            this.mySkipRangesSet = skipRangesSet;
        }

        private static void addRanges(VirtualFile file2, FindModel model2, CharSequence text2, Map<Integer, Integer> result2, FindModel.SearchContext searchContext, FindManagerImpl manager) {
            FindResult customResult;
            FindModel clonedModel = model2.clone();
            clonedModel.setSearchContext(searchContext);
            clonedModel.setForward(true);
            int offset2 = 0;
            while ((customResult = manager.findStringLoop(text2, offset2, clonedModel, file2, null)).isStringFound()) {
                result2.put(customResult.getStartOffset(), customResult.getEndOffset());
                offset2 = Math.max(customResult.getEndOffset(), offset2 + 1);
                if (offset2 < text2.length()) continue;
                break;
            }
        }

        boolean isAcceptableFor(FindModel model2, VirtualFile file2, CharSequence text2) {
            return Comparing.equal(this.myFile, file2) && this.myFindModel.equals((Object)model2) && this.myText.length() == text2.length();
        }

        @Override
        public boolean test(@Nullable FindResult input) {
            if (input == null || !input.isStringFound()) {
                return true;
            }
            NavigableMap<Integer, Integer> map2 = this.mySkipRangesSet.headMap(input.getStartOffset(), true);
            for (Map.Entry e : map2.descendingMap().entrySet()) {
                if ((Integer)e.getKey() <= input.getStartOffset() && (input.getStartOffset() <= (Integer)e.getValue() || (Integer)e.getValue() >= input.getEndOffset())) {
                    return false;
                }
                if ((Integer)e.getValue() > input.getStartOffset()) continue;
                break;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "skipRangesSet";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/impl/FindManagerImpl$FindExceptCommentsOrLiteralsData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CommentsLiteralsSearchData {
        final VirtualFile lastFile;
        int startOffset;
        final SyntaxHighlighterOverEditorHighlighter highlighter;
        TokenSet tokensOfInterest;
        final StringSearcher searcher;
        final Matcher matcher;
        final Set<Language> relevantLanguages;
        final FindModel model;

        CommentsLiteralsSearchData(VirtualFile lastFile, Set<Language> relevantLanguages, SyntaxHighlighterOverEditorHighlighter highlighter, TokenSet tokensOfInterest, StringSearcher searcher2, Matcher matcher, FindModel model2) {
            this.lastFile = lastFile;
            this.highlighter = highlighter;
            this.tokensOfInterest = tokensOfInterest;
            this.searcher = searcher2;
            this.matcher = matcher;
            this.relevantLanguages = relevantLanguages;
            this.model = model2;
        }
    }
}

