/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindUsagesCollector;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010&\u001a\u00020'H\u0002R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u0010\u0010\u001f\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0019\"\u0004\b#\u0010\u001b\u00a8\u0006("}, d2={"Lcom/intellij/find/impl/FindPopupHeader;", "", "project", "Lcom/intellij/openapi/project/Project;", "filterContextButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "pinAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/actionSystem/impl/ActionButton;Lcom/intellij/openapi/actionSystem/ToggleAction;)V", "cbFileFilter", "Lcom/intellij/ui/StateRestoringCheckBox;", "getCbFileFilter", "()Lcom/intellij/ui/StateRestoringCheckBox;", "setCbFileFilter", "(Lcom/intellij/ui/StateRestoringCheckBox;)V", "fileMaskField", "Lcom/intellij/openapi/ui/ComboBox;", "", "getFileMaskField", "()Lcom/intellij/openapi/ui/ComboBox;", "setFileMaskField", "(Lcom/intellij/openapi/ui/ComboBox;)V", "infoLabel", "Ljavax/swing/JLabel;", "getInfoLabel", "()Ljavax/swing/JLabel;", "setInfoLabel", "(Ljavax/swing/JLabel;)V", "loadingIcon", "getLoadingIcon", "setLoadingIcon", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "titleLabel", "getTitleLabel", "setTitleLabel", "createCheckBox", "createFileFilter", "createSeparator", "Ljavax/swing/JComponent;", "intellij.platform.lang.impl"})
public final class FindPopupHeader {
    @JvmField
    @NotNull
    public final DialogPanel panel;
    public JLabel titleLabel;
    public JLabel infoLabel;
    public JLabel loadingIcon;
    public StateRestoringCheckBox cbFileFilter;
    public ComboBox<String> fileMaskField;

    public FindPopupHeader(final @NotNull Project project2, final @NotNull ActionButton filterContextButton, final @NotNull ToggleAction pinAction2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterContextButton, (String)"filterContextButton");
        Intrinsics.checkNotNullParameter((Object)pinAction2, (String)"pinAction");
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new IntelliJSpacingConfiguration(){

                    public int getVerticalComponentGap() {
                        return ExperimentalUI.isNewUI() ? 0 : super.getVerticalComponentGap();
                    }
                }, (Function1)new Function1<Panel, Unit>(){

                    public final void invoke(@NotNull Panel $this$customizeSpacingConfiguration) {
                        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
                        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(){

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string2 = FindBundle.message("find.in.path.dialog.title", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"find.in.path.dialog.title\")");
                                Cell titleCell = $this$row.label(string2).bold();
                                this.setTitleLabel((JLabel)titleCell.getComponent());
                                this.setInfoLabel((JLabel)$this$row.label("").gap(RightGap.SMALL).getComponent());
                                if (ExperimentalUI.isNewUI()) {
                                    JBInsets headerInsets = JBUI.CurrentTheme.ComplexPopup.headerInsets();
                                    titleCell.customize(new Gaps(headerInsets.top, 0, headerInsets.bottom, JBUI.scale(12), 2, null));
                                    this.getInfoLabel().setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
                                } else {
                                    titleCell.gap(RightGap.SMALL);
                                    UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, this.getInfoLabel());
                                }
                                Icon icon2 = EmptyIcon.ICON_16;
                                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ICON_16");
                                this.setLoadingIcon((JLabel)$this$row.icon(icon2).resizableColumn().getComponent());
                                this.setCbFileFilter((StateRestoringCheckBox)$this$row.cell((JComponent)this.createCheckBox(project2)).gap(RightGap.SMALL).getComponent());
                                this.setFileMaskField((ComboBox<String>)((ComboBox)$this$row.cell((JComponent)this.createFileFilter()).getComponent()));
                                $this$row.cell((JComponent)filterContextButton).gap(RightGap.SMALL);
                                if (!ExperimentalUI.isNewUI()) {
                                    $this$row.cell(this.createSeparator()).gap(RightGap.SMALL);
                                }
                                Row.actionButton$default((Row)$this$row, (AnAction)((AnAction)pinAction2), null, (int)2, null);
                            }
                        }), (int)1, null);
                    }
                });
            }
        }));
    }

    @NotNull
    public final JLabel getTitleLabel() {
        JLabel jLabel = this.titleLabel;
        if (jLabel != null) {
            return jLabel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"titleLabel");
        return null;
    }

    public final void setTitleLabel(@NotNull JLabel jLabel) {
        Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
        this.titleLabel = jLabel;
    }

    @NotNull
    public final JLabel getInfoLabel() {
        JLabel jLabel = this.infoLabel;
        if (jLabel != null) {
            return jLabel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"infoLabel");
        return null;
    }

    public final void setInfoLabel(@NotNull JLabel jLabel) {
        Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
        this.infoLabel = jLabel;
    }

    @NotNull
    public final JLabel getLoadingIcon() {
        JLabel jLabel = this.loadingIcon;
        if (jLabel != null) {
            return jLabel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"loadingIcon");
        return null;
    }

    public final void setLoadingIcon(@NotNull JLabel jLabel) {
        Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
        this.loadingIcon = jLabel;
    }

    @NotNull
    public final StateRestoringCheckBox getCbFileFilter() {
        StateRestoringCheckBox stateRestoringCheckBox = this.cbFileFilter;
        if (stateRestoringCheckBox != null) {
            return stateRestoringCheckBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cbFileFilter");
        return null;
    }

    public final void setCbFileFilter(@NotNull StateRestoringCheckBox stateRestoringCheckBox) {
        Intrinsics.checkNotNullParameter((Object)stateRestoringCheckBox, (String)"<set-?>");
        this.cbFileFilter = stateRestoringCheckBox;
    }

    @NotNull
    public final ComboBox<String> getFileMaskField() {
        ComboBox<String> comboBox = this.fileMaskField;
        if (comboBox != null) {
            return comboBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileMaskField");
        return null;
    }

    public final void setFileMaskField(@NotNull ComboBox<String> comboBox) {
        Intrinsics.checkNotNullParameter(comboBox, (String)"<set-?>");
        this.fileMaskField = comboBox;
    }

    private final StateRestoringCheckBox createCheckBox(Project project2) {
        StateRestoringCheckBox checkBox = new StateRestoringCheckBox(FindBundle.message("find.popup.filemask", new Object[0]));
        checkBox.addActionListener(arg_0 -> FindPopupHeader.createCheckBox$lambda$0(project2, checkBox, arg_0));
        return checkBox;
    }

    private final ComboBox<String> createFileFilter() {
        ComboBox<String> result2 = new ComboBox<String>(){

            @NotNull
            public Dimension getPreferredSize() {
                Component editorComponent;
                int width = 0;
                int buttonWidth = 0;
                Component[] components = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)components, (String)"components");
                for (Component component2 : components) {
                    int w;
                    Dimension size;
                    Dimension dimension = size = component2.getPreferredSize();
                    int n = w = dimension != null ? dimension.width : 0;
                    if (component2 instanceof JButton) {
                        buttonWidth = w;
                    }
                    width += w;
                }
                ComboBoxEditor editor2 = this.getEditor();
                if (editor2 != null && (editorComponent = editor2.getEditorComponent()) != null) {
                    FontMetrics fontMetrics = editorComponent.getFontMetrics(editorComponent.getFont());
                    Object item = this.getSelectedItem();
                    width = Math.max(width, fontMetrics.stringWidth(String.valueOf(item)) + buttonWidth);
                    width += fontMetrics.stringWidth("m");
                }
                Dimension size = super.getPreferredSize();
                Insets insets = this.getInsets();
                size.width = MathUtil.clamp(width += insets.left + insets.right, JBUIScale.scale(80), JBUIScale.scale(500));
                Intrinsics.checkNotNullExpressionValue((Object)size, (String)"size");
                return size;
            }
        };
        result2.setEditable(true);
        result2.setMaximumRowCount(8);
        return (ComboBox)result2;
    }

    private final JComponent createSeparator() {
        Component component2 = Box.createRigidArea(new JBDimension(1, 24));
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent result2 = (JComponent)component2;
        result2.setOpaque(true);
        result2.setBackground(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        return result2;
    }

    private static final void createCheckBox$lambda$0(Project $project, StateRestoringCheckBox $checkBox, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$checkBox, (String)"$checkBox");
        FindUsagesCollector.CHECK_BOX_TOGGLED.log($project, (Object)"FindInPath", (Object)FindPopupPanel.ToggleOptionName.FileFilter, (Object)$checkBox.isSelected());
    }
}

