/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.accessibility.TextFieldWithListAccessibleContext;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUsagesCollector;
import com.intellij.find.SearchTextArea;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.impl.FindInProjectExecutor;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindPopupHeader;
import com.intellij.find.impl.FindPopupItem;
import com.intellij.find.impl.FindPopupScopeUI;
import com.intellij.find.impl.FindPopupScopeUIImpl;
import com.intellij.find.impl.FindPopupScopeUIProvider;
import com.intellij.find.impl.FindUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.find.impl.RegExReplacementBuilder;
import com.intellij.find.impl.UiModelKt;
import com.intellij.find.impl.UsagePresentation;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.ex.TooltipLinkProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListFocusTraversalPolicy;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowResizeListener;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.gridLayout.builders.RowBuilder;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.render.RendererPanelsUtilsKt;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Alarm;
import com.intellij.util.FontUtil;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PatternUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import kotlin.jvm.functions.Function1;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupPanel
extends JBPanel<FindPopupPanel>
implements FindUI,
DataProvider {
    private static final KeyStroke ENTER = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke ENTER_WITH_MODIFIERS = KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128);
    private static final KeyStroke REPLACE_ALL = KeyStroke.getKeyStroke(10, 576);
    private static final KeyStroke RESET_FILTERS = KeyStroke.getKeyStroke(8, 576);
    private static final String SERVICE_KEY = "find.popup";
    private static final String SPLITTER_SERVICE_KEY = "find.popup.splitter";
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    private final Alarm myPreviewUpdater;
    @NotNull
    private final FindPopupScopeUI myScopeUI;
    private JComponent myCodePreviewComponent;
    private SearchTextArea mySearchTextArea;
    private SearchTextArea myReplaceTextArea;
    private ActionListener myOkActionListener;
    private final AtomicBoolean myCanClose;
    private final AtomicBoolean myIsPinned;
    private JBLabel myOKHintLabel;
    private JBLabel myNavigationHintLabel;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;
    private FindPopupHeader header;
    private final AtomicBoolean myCaseSensitiveState;
    private final AtomicBoolean myPreserveCaseState;
    private final AtomicBoolean myWholeWordsState;
    private final AtomicBoolean myRegexState;
    private JCheckBox myNewTabCheckbox;
    private ActionToolbarImpl myScopeSelectionToolbar;
    private ActionButton myFilterContextButton;
    private JButton myOKButton;
    private JButton myReplaceAllButton;
    private JButton myReplaceSelectedButton;
    private JTextArea mySearchComponent;
    private JTextArea myReplaceComponent;
    private String mySelectedContextName;
    private FindPopupScopeUI.ScopeType mySelectedScope;
    private JPanel myScopeDetailsPanel;
    private JBTable myResultsPreviewTable;
    private DefaultTableModel myResultsPreviewTableModel;
    private SimpleColoredComponent myUsagePreviewTitle;
    private UsagePreviewPanel myUsagePreviewPanel;
    private DialogWrapper myDialog;
    private int myLoadingHash;
    private final AtomicBoolean myNeedReset;
    private String myUsagesCount;
    private String myFilesCount;
    private UsageViewPresentation myUsageViewPresentation;
    private final ComponentValidator myComponentValidator;
    private AnAction myCaseSensitiveAction;
    private AnAction myWholeWordsAction;
    private AnAction myRegexAction;
    private AnAction myResetFiltersAction;
    private boolean mySuggestRegexHintForEmptyResults;
    private OnePixelSplitter myPreviewSplitter;
    private final BadgeIconSupplier filterIcon;

    FindPopupPanel(@NotNull FindUIHelper helper) {
        if (helper == null) {
            FindPopupPanel.$$$reportNull$$$0(0);
        }
        this.myCanClose = new AtomicBoolean(true);
        this.myIsPinned = new AtomicBoolean(false);
        this.myCaseSensitiveState = new AtomicBoolean();
        this.myPreserveCaseState = new AtomicBoolean();
        this.myWholeWordsState = new AtomicBoolean();
        this.myRegexState = new AtomicBoolean();
        this.mySelectedContextName = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        this.myNeedReset = new AtomicBoolean(true);
        this.mySuggestRegexHintForEmptyResults = true;
        this.filterIcon = new BadgeIconSupplier(AllIcons.General.Filter);
        this.myHelper = helper;
        this.myProject = this.myHelper.getProject();
        this.myDisposable = Disposer.newDisposable();
        this.myPreviewUpdater = new Alarm(this.myDisposable);
        this.myScopeUI = FindPopupScopeUIProvider.getInstance().create(this);
        this.myComponentValidator = new ComponentValidator(this.myDisposable){

            public void updateInfo(@Nullable ValidationInfo info2) {
                if (info2 != null && info2.component == FindPopupPanel.this.mySearchComponent) {
                    super.updateInfo(null);
                } else {
                    super.updateInfo(info2);
                }
            }
        };
        Disposer.register(this.myDisposable, () -> {
            this.finishPreviousPreviewSearch();
            if (this.mySearchRescheduleOnCancellationsAlarm != null) {
                Disposer.dispose((Disposable)this.mySearchRescheduleOnCancellationsAlarm);
            }
            if (this.myUsagePreviewPanel != null) {
                Disposer.dispose((Disposable)this.myUsagePreviewPanel);
            }
        });
        this.initComponents();
        this.initByModel();
        FindUsagesCollector.triggerUsedOptionsStats(this.myProject, "FindInPath", this.myHelper.getModel());
    }

    @Override
    public void showUI() {
        if (this.myDialog != null && this.myDialog.isVisible()) {
            return;
        }
        if (this.myDialog != null && !this.myDialog.isDisposed()) {
            this.myDialog.doCancelAction();
        }
        if (this.myDialog == null || this.myDialog.isDisposed()) {
            this.myDialog = new DialogWrapper(this.myHelper.getProject(), null, true, DialogWrapper.IdeModalityType.MODELESS, false){
                {
                    this.init();
                    this.getRootPane().setDefaultButton(null);
                }

                protected void doOKAction() {
                    FindPopupPanel.this.myOkActionListener.actionPerformed(null);
                }

                protected void dispose() {
                    FindPopupPanel.this.saveSettings();
                    super.dispose();
                }

                @Nullable
                protected Border createContentPaneBorder() {
                    return null;
                }

                protected JComponent createCenterPanel() {
                    return FindPopupPanel.this;
                }

                protected String getDimensionServiceKey() {
                    return FindPopupPanel.SERVICE_KEY;
                }
            };
            this.myDialog.setUndecorated(true);
            if (WindowRoundedCornersManager.isAvailable()) {
                WindowRoundedCornersManager.setRoundedCorners((Window)this.myDialog.getWindow());
            }
            ApplicationManager.getApplication().getMessageBus().connect(this.myDialog.getDisposable()).subscribe(ProjectCloseListener.TOPIC, new ProjectCloseListener(){

                @Override
                public void projectClosed(@NotNull Project project2) {
                    if (project2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.closeImmediately();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindPopupPanel$3", "projectClosed"));
                }
            });
            Disposer.register(this.myDialog.getDisposable(), this.myDisposable);
            Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
            Component parent2 = UIUtil.findUltimateParent(window);
            RelativePoint showPoint = null;
            Point screenPoint = DimensionService.getInstance().getLocation(SERVICE_KEY, this.myProject);
            if (screenPoint != null) {
                if (parent2 != null) {
                    SwingUtilities.convertPointFromScreen(screenPoint, parent2);
                    showPoint = new RelativePoint(parent2, screenPoint);
                } else {
                    showPoint = new RelativePoint(screenPoint);
                }
            }
            if (parent2 != null && showPoint == null) {
                int height;
                int n = height = UISettings.getInstance().getShowNavigationBar() ? 135 : 115;
                if (parent2 instanceof IdeFrameImpl && ((IdeFrameImpl)parent2).isInFullScreen()) {
                    height -= 20;
                }
                showPoint = new RelativePoint(parent2, new Point((parent2.getSize().width - this.getPreferredSize().width) / 2, height));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.mySearchComponent.getCaret() != null) {
                    this.mySearchComponent.selectAll();
                }
            });
            WindowMoveListener windowListener2 = new WindowMoveListener((Component)this);
            this.header.panel.addMouseListener((MouseListener)windowListener2);
            this.header.panel.addMouseMotionListener((MouseMotionListener)windowListener2);
            this.addMouseListener((MouseListener)windowListener2);
            this.addMouseMotionListener((MouseMotionListener)windowListener2);
            Dimension panelSize = this.getPreferredSize();
            Dimension prev = DimensionService.getInstance().getSize(SERVICE_KEY, this.myProject);
            panelSize.width += JBUIScale.scale(24);
            panelSize.height *= 2;
            if (prev != null && prev.height < panelSize.height) {
                prev.height = panelSize.height;
            }
            Window dialogWindow = this.myDialog.getPeer().getWindow();
            AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
            JRootPane root = ((RootPaneContainer)((Object)dialogWindow)).getRootPane();
            final IdeGlassPaneEx glass = (IdeGlassPaneEx)this.myDialog.getRootPane().getGlassPane();
            WindowResizeListener resizeListener = new WindowResizeListener(root, JBUI.insets(4), null){
                private Cursor myCursor;

                protected void setCursor(@NotNull Component content2, Cursor cursor) {
                    if (content2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (this.myCursor != cursor || this.myCursor != Cursor.getDefaultCursor()) {
                        glass.setCursor(cursor, (Object)this);
                        this.myCursor = cursor;
                        if (content2 instanceof JComponent) {
                            IdeGlassPaneImpl.savePreProcessedCursor((JComponent)((JComponent)content2), (Cursor)content2.getCursor());
                        }
                        super.setCursor(content2, cursor);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/find/impl/FindPopupPanel$4", "setCursor"));
                }
            };
            glass.addMousePreprocessor((MouseListener)resizeListener, this.myDisposable);
            glass.addMouseMotionPreprocessor((MouseMotionListener)resizeListener, this.myDisposable);
            DumbAwareAction.create(e -> this.closeImmediately()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)root, this.myDisposable);
            root.setWindowDecorationStyle(0);
            root.setBorder(PopupBorder.Factory.create(true, true));
            UIUtil.markAsPossibleOwner((Dialog)dialogWindow);
            dialogWindow.setBackground(UIUtil.getPanelBackground());
            dialogWindow.setMinimumSize(panelSize);
            if (prev == null) {
                panelSize.height = (int)((double)panelSize.height * 1.5);
                panelSize.width = (int)((double)panelSize.width * 1.15);
            }
            dialogWindow.setSize(prev != null ? prev : panelSize);
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            if (showPoint != null) {
                this.myDialog.setLocation(showPoint.getScreenPoint());
            } else {
                dialogWindow.setLocationRelativeTo(null);
            }
            this.mySuggestRegexHintForEmptyResults = true;
            this.myDialog.show();
            this.myDialog.setOnDeactivationAction(() -> this.closeIfPossible());
            JRootPane rootPane = this.getRootPane();
            if (rootPane != null) {
                if (this.myHelper.isReplaceState()) {
                    rootPane.setDefaultButton(this.myReplaceSelectedButton);
                }
                rootPane.getInputMap(2).put(ENTER_WITH_MODIFIERS, "openInFindWindow");
                rootPane.getActionMap().put("openInFindWindow", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindPopupPanel.this.myOkActionListener.actionPerformed(null);
                    }
                });
            }
            ApplicationManager.getApplication().invokeLater(this::scheduleResultsUpdate, ModalityState.any());
        }
    }

    @Override
    public void closeIfPossible() {
        if (this.canBeClosed() && !this.myIsPinned.get()) {
            this.myDialog.doCancelAction();
        }
    }

    protected boolean canBeClosed() {
        if (this.myProject.isDisposed()) {
            return true;
        }
        if (!this.myCanClose.get()) {
            return false;
        }
        if (this.myIsPinned.get()) {
            return false;
        }
        if (!ApplicationManager.getApplication().isActive()) {
            return false;
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null) {
            return false;
        }
        if (this.header.fileMaskField.isPopupVisible()) {
            this.header.fileMaskField.setPopupVisible(false);
            return false;
        }
        List<JBPopup> popups = ContainerUtil.filter(JBPopupFactory.getInstance().getChildPopups((Component)this), popup2 -> !popup2.isDisposed());
        if (!popups.isEmpty()) {
            for (JBPopup popup3 : popups) {
                popup3.cancel();
            }
            return false;
        }
        return !this.myScopeUI.hideAllPopups();
    }

    @Override
    public void saveSettings() {
        Window window = this.myDialog.getWindow();
        if (!window.isShowing()) {
            return;
        }
        DimensionService.getInstance().setSize(SERVICE_KEY, this.myDialog.getSize(), this.myHelper.getProject());
        DimensionService.getInstance().setLocation(SERVICE_KEY, window.getLocationOnScreen(), this.myHelper.getProject());
        FindSettings findSettings = FindSettings.getInstance();
        this.myScopeUI.applyTo(findSettings, this.mySelectedScope);
        this.myHelper.updateFindSettings();
        this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel());
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            FindPopupPanel.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FindPopupPanel.$$$reportNull$$$0(2);
        }
        return project2;
    }

    @NotNull
    public FindUIHelper getHelper() {
        FindUIHelper findUIHelper = this.myHelper;
        if (findUIHelper == null) {
            FindPopupPanel.$$$reportNull$$$0(3);
        }
        return findUIHelper;
    }

    @NotNull
    public AtomicBoolean getCanClose() {
        AtomicBoolean atomicBoolean = this.myCanClose;
        if (atomicBoolean == null) {
            FindPopupPanel.$$$reportNull$$$0(4);
        }
        return atomicBoolean;
    }

    private void initComponents() {
        Keymap activeKeymap;
        JComponent[] tableAware;
        KeyStroke editSourceKeyStroke;
        MyShowFilterPopupAction myShowFilterPopupAction = new MyShowFilterPopupAction();
        this.myFilterContextButton = new ActionButton((AnAction)myShowFilterPopupAction, null, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public Icon getIcon() {
                return FindPopupPanel.this.filterIcon.getLiveIndicatorIcon(!FindPopupPanel.this.mySelectedContextName.equals(FindInProjectUtil.getPresentableName(FindModel.SearchContext.ANY)));
            }
        };
        myShowFilterPopupAction.registerCustomShortcutSet(myShowFilterPopupAction.getShortcutSet(), this);
        this.header = new FindPopupHeader(this.myProject, this.myFilterContextButton, new MyPinAction());
        ItemListener liveResultsPreviewUpdateListener = __ -> this.scheduleResultsUpdate();
        this.header.cbFileFilter.addItemListener(__ -> {
            if (this.header.cbFileFilter.isSelected()) {
                this.header.fileMaskField.setEnabled(true);
                if (this.header.cbFileFilter.getClientProperty((Object)"dontRequestFocus") == null) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.header.fileMaskField, true);
                    this.header.fileMaskField.getEditor().selectAll();
                }
            } else {
                this.header.fileMaskField.setEnabled(false);
                if (this.header.cbFileFilter.getClientProperty((Object)"dontRequestFocus") == null) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchComponent, true);
                }
            }
        });
        this.header.cbFileFilter.addItemListener(liveResultsPreviewUpdateListener);
        this.header.fileMaskField.addActionListener(__ -> this.scheduleResultsUpdate());
        Component editorComponent = this.header.fileMaskField.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            EditorTextField etf = (EditorTextField)editorComponent;
            etf.addDocumentListener(new DocumentListener(){

                @Override
                public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                    if (event == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.onFileMaskChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/impl/FindPopupPanel$7", "documentChanged"));
                }
            });
        } else if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).getDocument().addDocumentListener(new DocumentAdapter(){

                @Override
                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.onFileMaskChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$8", "textChanged"));
                }
            });
        } else assert (false);
        this.myResetFiltersAction = DumbAwareAction.create(event -> this.resetAllFilters());
        this.myResetFiltersAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(RESET_FILTERS), (JComponent)this);
        this.myOKButton = new JButton(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myReplaceAllButton = new JButton(FindBundle.message("find.popup.replace.all.button", new Object[0]));
        this.myReplaceSelectedButton = new JButton(FindBundle.message("find.popup.replace.selected.button", 0));
        this.myOkActionListener = __ -> this.doOK(true);
        this.myReplaceAllButton.setOpaque(false);
        this.myReplaceAllButton.addActionListener(__ -> this.doOK(false));
        this.myReplaceSelectedButton.setOpaque(false);
        this.myReplaceSelectedButton.addActionListener(e -> {
            int rowToSelect = this.myResultsPreviewTable.getSelectionModel().getMinSelectionIndex();
            Map<Integer, Usage> usages = this.getSelectedUsages();
            if (usages == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                for (Map.Entry entry : usages.entrySet()) {
                    try {
                        ReplaceInProjectManager.getInstance(this.myProject).replaceUsage((Usage)entry.getValue(), this.myHelper.getModel(), Collections.emptySet(), false);
                        ((DefaultTableModel)this.myResultsPreviewTable.getModel()).removeRow((Integer)entry.getKey());
                    }
                    catch (FindManager.MalformedReplacementStringException ex) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) break;
                        Messages.showErrorDialog((Component)this, (String)ex.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                        break;
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myResultsPreviewTable.getRowCount() > rowToSelect) {
                        this.myResultsPreviewTable.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
                    }
                    ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
                });
            }, FindBundle.message("find.replace.command", new Object[0]), null);
        });
        this.myOKButton.setOpaque(false);
        this.myOKButton.addActionListener(this.myOkActionListener);
        boolean enterAsOK = false;
        AnAction openInRightSplit = ActionManager.getInstance().getAction("OpenInRightSplit");
        if (openInRightSplit != null) {
            ShortcutSet set2 = openInRightSplit.getShortcutSet();
            new MyEnterAction(false).registerCustomShortcutSet(set2, this);
        }
        new MyEnterAction(enterAsOK).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER), this);
        DumbAwareAction.create(__ -> this.myOkActionListener.actionPerformed(null)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER_WITH_MODIFIERS), (JComponent)this);
        DumbAwareAction.create(__ -> this.myReplaceAllButton.doClick()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(REPLACE_ALL), (JComponent)this);
        this.myReplaceAllButton.setToolTipText(KeymapUtil.getKeystrokeText((KeyStroke)REPLACE_ALL));
        ArrayList<KeyboardShortcut> navigationKeyStrokes = new ArrayList<KeyboardShortcut>();
        KeyStroke viewSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getViewSource());
        if (viewSourceKeyStroke != null && !Comparing.equal(viewSourceKeyStroke, ENTER_WITH_MODIFIERS) && !Comparing.equal(viewSourceKeyStroke, ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(viewSourceKeyStroke, null));
        }
        if ((editSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource())) != null && !Comparing.equal(editSourceKeyStroke, ENTER_WITH_MODIFIERS) && !Comparing.equal(editSourceKeyStroke, ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(editSourceKeyStroke, null));
        }
        if (!navigationKeyStrokes.isEmpty()) {
            DumbAwareAction.create(e -> this.navigateToSelectedUsage((AnActionEvent)e)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(navigationKeyStrokes.toArray(Shortcut.EMPTY_ARRAY)), (JComponent)this);
        }
        this.myResultsPreviewTableModel = this.createTableModel();
        this.myResultsPreviewTable = new JBTable(this.myResultsPreviewTableModel){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.getWidth(), 1 + this.getRowHeight() * 4);
            }
        };
        this.myResultsPreviewTable.setFocusable(false);
        this.myResultsPreviewTable.putClientProperty(RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, (Object)true);
        this.myResultsPreviewTable.getEmptyText().setShowAboveCenter(false);
        this.myResultsPreviewTable.setShowColumns(false);
        this.myResultsPreviewTable.getSelectionModel().setSelectionMode(2);
        this.myResultsPreviewTable.setShowGrid(false);
        this.myResultsPreviewTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.mySearchComponent = new JBTextAreaWithMixedAccessibleContext(this.myResultsPreviewTable.getAccessibleContext(), FindBundle.message("find.popup.search.empty.text", new Object[0]));
        this.mySearchComponent.setColumns(25);
        this.mySearchComponent.setRows(1);
        this.mySearchComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.search.accessible.name", new Object[0]));
        this.myReplaceComponent = new JBTextAreaWithMixedAccessibleContext(this.myResultsPreviewTable.getAccessibleContext(), FindBundle.message("find.popup.replace.empty.text", new Object[0]));
        this.myReplaceComponent.setColumns(25);
        this.myReplaceComponent.setRows(1);
        this.myReplaceComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.replace.accessible.name", new Object[0]));
        this.mySearchTextArea = new SearchTextArea(this.mySearchComponent, true);
        this.myReplaceTextArea = new SearchTextArea(this.myReplaceComponent, false);
        this.myCaseSensitiveAction = new MySwitchStateToggleAction(this, "find.popup.case.sensitive", ToggleOptionName.CaseSensitive, AllIcons.Actions.MatchCase, AllIcons.Actions.MatchCaseHovered, AllIcons.Actions.MatchCaseSelected, this.myCaseSensitiveState);
        this.myWholeWordsAction = new MySwitchStateToggleAction(this, "find.whole.words", ToggleOptionName.WholeWords, AllIcons.Actions.Words, AllIcons.Actions.WordsHovered, AllIcons.Actions.WordsSelected, this.myWholeWordsState);
        this.myRegexAction = new MySwitchStateToggleAction(this, "find.regex", ToggleOptionName.Regex, AllIcons.Actions.Regex, AllIcons.Actions.RegexHovered, AllIcons.Actions.RegexSelected, this.myRegexState, new TooltipLinkProvider.TooltipLink(FindBundle.message("find.regex.help.link", new Object[0]), RegExHelpPopup.createRegExLinkRunnable(this.mySearchTextArea)));
        List<Component> searchExtraButtons = this.mySearchTextArea.setExtraActions(this.myCaseSensitiveAction, this.myWholeWordsAction, this.myRegexAction);
        MySwitchStateToggleAction preserveCaseAction = new MySwitchStateToggleAction(this, "find.options.replace.preserve.case", ToggleOptionName.PreserveCase, AllIcons.Actions.PreserveCase, AllIcons.Actions.PreserveCaseHover, AllIcons.Actions.PreserveCaseSelected, this.myPreserveCaseState);
        List<Component> replaceExtraButtons = this.myReplaceTextArea.setExtraActions(new AnAction[]{preserveCaseAction});
        Pair<FindPopupScopeUI.ScopeType, JComponent>[] scopeComponents = this.myScopeUI.getComponents();
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        ArrayList<MySelectScopeToggleAction> scopeActions = new ArrayList<MySelectScopeToggleAction>(scopeComponents.length);
        for (Pair<FindPopupScopeUI.ScopeType, JComponent> scopeComponent : scopeComponents) {
            JComponent[] scopeType = (JComponent[])scopeComponent.first;
            scopeActions.add(new MySelectScopeToggleAction((FindPopupScopeUI.ScopeType)scopeType));
            this.myScopeDetailsPanel.add(scopeType.name, (Component)scopeComponent.second);
        }
        this.myScopeSelectionToolbar = FindPopupPanel.createScopeToolbar(scopeActions.toArray(AnAction.EMPTY_ARRAY));
        this.myScopeSelectionToolbar.setMinimumButtonSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.mySelectedScope = (FindPopupScopeUI.ScopeType)scopeComponents[0].first;
        TableHoverListener.DEFAULT.removeFrom((JComponent)this.myResultsPreviewTable);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (event.getSource() != FindPopupPanel.this.myResultsPreviewTable) {
                    return false;
                }
                FindPopupPanel.this.navigateToSelectedUsage(null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/impl/FindPopupPanel$10", "onDoubleClick"));
            }
        }.installOn((Component)this.myResultsPreviewTable);
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup copyGroup = (ActionGroup)actionManager.getAction("FindInFiles.Results.ContextMenu");
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("popup", copyGroup);
        this.myResultsPreviewTable.setComponentPopupMenu(popupMenu.getComponent());
        this.myResultsPreviewTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FindPopupPanel.this.myResultsPreviewTable.transferFocus();
            }
        });
        FindPopupPanel.applyFont(JBFont.label(), new Component[]{this.myResultsPreviewTable});
        for (JComponent component2 : tableAware = new JComponent[]{this.mySearchComponent, this.myReplaceComponent, this.myReplaceSelectedButton}) {
            ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, (JComponent)component2);
        }
        ActionListener helpAction = __ -> HelpManager.getInstance().invokeHelp("reference.dialogs.findinpath");
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 2);
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        KeymapManager keymapManager = KeymapManager.getInstance();
        Keymap keymap = activeKeymap = keymapManager != null ? keymapManager.getActiveKeymap() : null;
        if (activeKeymap != null) {
            CustomShortcutSet findNextShortcutSet = new CustomShortcutSet(activeKeymap.getShortcuts("FindNext"));
            CustomShortcutSet findPreviousShortcutSet = new CustomShortcutSet(activeKeymap.getShortcuts("FindPrevious"));
            DumbAwareAction findNextAction = DumbAwareAction.create(event -> {
                int selectedRow = this.myResultsPreviewTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < this.myResultsPreviewTable.getRowCount() - 1) {
                    this.myResultsPreviewTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                    ScrollingUtil.ensureIndexIsVisible((JTable)this.myResultsPreviewTable, (int)(selectedRow + 1), (int)1);
                }
            });
            DumbAwareAction findPreviousAction = DumbAwareAction.create(event -> {
                int selectedRow = this.myResultsPreviewTable.getSelectedRow();
                if (selectedRow > 0 && selectedRow <= this.myResultsPreviewTable.getRowCount() - 1) {
                    this.myResultsPreviewTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                    ScrollingUtil.ensureIndexIsVisible((JTable)this.myResultsPreviewTable, (int)(selectedRow - 1), (int)1);
                }
            });
            for (JComponent component3 : tableAware) {
                findNextAction.registerCustomShortcutSet((ShortcutSet)findNextShortcutSet, component3);
                findPreviousAction.registerCustomShortcutSet((ShortcutSet)findPreviousShortcutSet, component3);
            }
        }
        this.myUsagePreviewTitle = new SimpleColoredComponent();
        this.myUsageViewPresentation = new UsageViewPresentation();
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, this.myUsageViewPresentation, true){

            public Dimension getPreferredSize() {
                return new Dimension(FindPopupPanel.this.myResultsPreviewTable.getWidth(), Math.max(this.getHeight(), this.getLineHeight() * 15));
            }
        };
        Disposer.register(this.myDisposable, (Disposable)this.myUsagePreviewPanel);
        final Runnable updatePreviewRunnable = () -> {
            if (Disposer.isDisposed(this.myDisposable)) {
                return;
            }
            int[] selectedRows = this.myResultsPreviewTable.getSelectedRows();
            SmartList<CompletableFuture> selectedUsagePromises = new SmartList<CompletableFuture>();
            String file2 = null;
            for (int row : selectedRows) {
                Object value = this.myResultsPreviewTable.getModel().getValueAt(row, 0);
                UsageInfoAdapter adapter = ((FindPopupItem)value).getUsage();
                file2 = adapter.getPath();
                if (!adapter.isValid()) continue;
                selectedUsagePromises.add(adapter.getMergedInfosAsync());
            }
            String selectedFile = file2;
            CompletableFuture.allOf(selectedUsagePromises.toArray(new CompletableFuture[0])).thenAccept(__ -> {
                SmartList selectedUsages = new SmartList();
                for (CompletableFuture f : selectedUsagePromises) {
                    try {
                        UsageInfo[] usageInfos2 = (UsageInfo[])f.get();
                        Collections.addAll(selectedUsages, usageInfos2);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.myReplaceSelectedButton.setText(FindBundle.message("find.popup.replace.selected.button", selectedUsages.size()));
                FindInProjectUtil.setupViewPresentation(this.myUsageViewPresentation, this.myHelper.getModel().clone());
                this.myUsagePreviewPanel.updateLayout(selectedUsages);
                this.myUsagePreviewTitle.clear();
                if (this.myUsagePreviewPanel.getCannotPreviewMessage(selectedUsages) == null && selectedFile != null) {
                    String locationPath;
                    this.myUsagePreviewTitle.append(PathUtil.getFileName(selectedFile), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    VirtualFile virtualFile2 = VfsUtil.findFileByIoFile(new File(selectedFile), true);
                    String string2 = locationPath = virtualFile2 == null ? null : FindPopupPanel.getPresentablePath(this.myProject, virtualFile2.getParent(), 120);
                    if (locationPath != null) {
                        this.myUsagePreviewTitle.append(FontUtil.spaceAndThinSpace() + locationPath, new SimpleTextAttributes(0, UIUtil.getContextHelpForeground()));
                    }
                }
            });
        };
        this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting() || Disposer.isDisposed((Disposable)this.myPreviewUpdater)) {
                return;
            }
            this.myPreviewUpdater.addRequest(updatePreviewRunnable, 50);
        });
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                if (FindPopupPanel.this.myDialog == null) {
                    return;
                }
                if (e.getDocument() == FindPopupPanel.this.mySearchComponent.getDocument()) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
                if (e.getDocument() == FindPopupPanel.this.myReplaceComponent.getDocument()) {
                    FindPopupPanel.this.applyTo(FindPopupPanel.this.myHelper.getModel());
                    if (FindPopupPanel.this.myHelper.getModel().isRegularExpressions()) {
                        FindPopupPanel.this.myComponentValidator.updateInfo(FindPopupPanel.this.getValidationInfo(FindPopupPanel.this.myHelper.getModel()));
                    }
                    ApplicationManager.getApplication().invokeLater(updatePreviewRunnable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$13", "textChanged"));
            }
        };
        this.mySearchComponent.getDocument().addDocumentListener(documentAdapter);
        this.myReplaceComponent.getDocument().addDocumentListener(documentAdapter);
        this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
        this.myPreviewSplitter = new OnePixelSplitter(true, 0.33f);
        this.myPreviewSplitter.setSplitterProportionKey(SPLITTER_SERVICE_KEY);
        this.myPreviewSplitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myResultsPreviewTable){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.height = FindPopupPanel.this.myResultsPreviewTable.getPreferredScrollableViewportSize().height;
                return size;
            }
        };
        this.myPreviewSplitter.setFirstComponent((JComponent)scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 0 0 0 0, fillx, hidemode 3, gap 0"));
        this.myNewTabCheckbox = new JBCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]), FindSettings.getInstance().isShowResultsInSeparateView());
        this.myNewTabCheckbox.setOpaque(false);
        bottomPanel.add(this.myNewTabCheckbox);
        this.myNewTabCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindSettings.getInstance().setShowResultsInSeparateView(FindPopupPanel.this.myNewTabCheckbox.isSelected());
            }
        });
        this.myOKHintLabel = new JBLabel("");
        this.myOKHintLabel.setEnabled(false);
        this.myNavigationHintLabel = new JBLabel("");
        this.myNavigationHintLabel.setEnabled(false);
        this.myNavigationHintLabel.setFont((Font)JBUI.Fonts.smallFont());
        Insets insets = this.myOKButton.getInsets();
        String btnGapLeft = "gapleft " + Math.max(0, JBUIScale.scale(12) - insets.left - insets.right) + "px";
        bottomPanel.add((Component)this.myNavigationHintLabel, btnGapLeft);
        bottomPanel.add(Box.createHorizontalGlue(), "growx, pushx");
        bottomPanel.add((Component)this.myOKHintLabel);
        bottomPanel.add((Component)this.myOKButton, btnGapLeft);
        bottomPanel.add((Component)this.myReplaceAllButton, btnGapLeft);
        bottomPanel.add((Component)this.myReplaceSelectedButton, btnGapLeft);
        this.myCodePreviewComponent = this.myUsagePreviewPanel.createComponent();
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)this.myUsagePreviewTitle, "North");
        previewPanel.add((Component)this.myCodePreviewComponent, "Center");
        this.myPreviewSplitter.setSecondComponent((JComponent)previewPanel);
        JPanel scopesPanel = new JPanel();
        new RowBuilder(scopesPanel).gap(26).add(new JComponent[]{this.myScopeSelectionToolbar.getComponent()}).addResizable((JComponent)this.myScopeDetailsPanel);
        this.setLayout((LayoutManager)new MigLayout("flowx, ins 0, gap 0, fillx, hidemode 3"));
        this.myIsPinned.set(UISettings.getInstance().getPinFindInPath());
        if (ExperimentalUI.isNewUI()) {
            Color background = JBUI.CurrentTheme.Popup.BACKGROUND;
            this.header.panel.setBorder(JBUI.Borders.compound(JBUI.Borders.customLineBottom(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()), PopupUtil.getComplexPopupHorizontalHeaderBorder()));
            this.header.panel.setBackground(JBUI.CurrentTheme.ComplexPopup.HEADER_BACKGROUND);
            this.header.cbFileFilter.setOpaque(false);
            this.setBackground(background);
            this.mySearchTextArea.setOpaque(false);
            this.mySearchTextArea.setBorder(PopupUtil.createComplexPopupTextFieldBorder());
            this.myReplaceTextArea.setOpaque(false);
            this.myReplaceTextArea.setBorder(PopupUtil.createComplexPopupTextFieldBorder());
            scopesPanel.setOpaque(false);
            this.myScopeSelectionToolbar.getComponent().setOpaque(false);
            this.myScopeDetailsPanel.setOpaque(false);
            UIUtil.setOpaqueRecursively(this.myScopeDetailsPanel, false);
            this.myResultsPreviewTable.setBackground(background);
            previewPanel.setBackground(background);
            scopesPanel.setBorder(JBUI.Borders.empty(JBUI.CurrentTheme.FindPopup.scopesPanelInsets()));
            this.myScopeSelectionToolbar.setBorder((Border)JBUI.Borders.empty());
            JBInsets textFieldBorderInsets = JBUI.CurrentTheme.ComplexPopup.textFieldBorderInsets();
            this.myPreviewSplitter.setBlindZone(() -> new Insets(0, textFieldBorderInsets.left, 0, textFieldBorderInsets.right));
            bottomPanel.setBorder(JBUI.Borders.empty(JBUI.CurrentTheme.FindPopup.bottomPanelInsets()));
            bottomPanel.setBackground(JBUI.CurrentTheme.Advertiser.background());
            scrollPane.setBorder((Border)JBUI.Borders.emptyBottom(4));
        } else {
            this.header.panel.setBorder((Border)JBUI.Borders.empty(2, 5));
            this.mySearchTextArea.setBorder(JBUI.Borders.compound(JBUI.Borders.customLine(JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), 1, 0, 1, 0), (Border)JBUI.Borders.empty(1, 0, 2, 0)));
            this.myReplaceTextArea.setBorder(JBUI.Borders.compound(JBUI.Borders.customLine(JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), 0, 0, 1, 0), (Border)JBUI.Borders.empty(1, 0, 2, 0)));
            scopesPanel.setBorder(JBUI.Borders.empty(3, 5));
            bottomPanel.setBorder(JBUI.Borders.empty(5));
            scrollPane.setBorder((Border)JBUI.Borders.empty());
        }
        PopupUtil.applyPreviewTitleInsets((JComponent)this.myUsagePreviewTitle);
        this.add((Component)this.header.panel, "growx, pushx, wrap");
        this.add((Component)this.mySearchTextArea, "pushx, growx, wrap");
        this.add((Component)this.myReplaceTextArea, "pushx, growx, wrap");
        this.add((Component)scopesPanel, "pushx, growx, ax left, wrap");
        this.add((Component)this.myPreviewSplitter, "pushx, growx, growy, pushy, wrap");
        this.add((Component)bottomPanel, "pushx, growx, dock south");
        ArrayList<Component> focusOrder = new ArrayList<Component>();
        focusOrder.add(this.mySearchComponent);
        focusOrder.add(this.myReplaceComponent);
        focusOrder.addAll(searchExtraButtons);
        focusOrder.addAll(replaceExtraButtons);
        focusOrder.add((Component)this.header.cbFileFilter);
        ContainerUtil.addAll(focusOrder, FindPopupPanel.focusableComponents(this.myScopeDetailsPanel));
        focusOrder.add(editorComponent);
        ContainerUtil.addAll(focusOrder, FindPopupPanel.focusableComponents(bottomPanel));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new ListFocusTraversalPolicy(focusOrder));
        if (SystemInfo.isMac) {
            ArrayList<JButton> principalButtons = new ArrayList<JButton>();
            principalButtons.add(this.myOKButton);
            Touchbar.setButtonActions((JComponent)bottomPanel, null, principalButtons, (JButton)this.myOKButton, (ActionGroup)new DefaultActionGroup(new AnAction[]{this.myCaseSensitiveAction, this.myWholeWordsAction, this.myRegexAction}));
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FindPopupPanel.$$$reportNull$$$0(5);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            Map<Integer, Usage> usages = this.getSelectedUsages();
            if (usages == null) {
                return null;
            }
            return slowId -> FindPopupPanel.getSlowData(slowId, usages);
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull Map<Integer, Usage> usages) {
        if (dataId == null) {
            FindPopupPanel.$$$reportNull$$$0(6);
        }
        if (usages == null) {
            FindPopupPanel.$$$reportNull$$$0(7);
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return usages.values().stream().filter(usage2 -> usage2 instanceof UsageInfoAdapter).flatMap(usage2 -> Arrays.stream(((UsageInfoAdapter)usage2).getMergedInfos())).map(info2 -> info2.getElement()).filter(Objects::nonNull).toArray(PsiElement[]::new);
        }
        return null;
    }

    @Contract(value="_,!null,_->!null")
    @NlsSafe
    static String getPresentablePath(@NotNull Project project2, @Nullable VirtualFile virtualFile2, int maxChars) {
        String path2;
        if (project2 == null) {
            FindPopupPanel.$$$reportNull$$$0(8);
        }
        if (virtualFile2 == null) {
            return null;
        }
        String string2 = ScratchUtil.isScratch(virtualFile2) ? ScratchUtil.getRelativePath(project2, virtualFile2) : (path2 = VfsUtilCore.isAncestor(project2.getBaseDir(), virtualFile2, true) ? VfsUtilCore.getRelativeLocation(virtualFile2, project2.getBaseDir()) : FileUtil.getLocationRelativeToUserHome(virtualFile2.getPath()));
        return path2 == null ? null : (maxChars < 0 ? path2 : StringUtil.trimMiddle(path2, maxChars));
    }

    @NotNull
    private DefaultTableModel createTableModel() {
        DefaultTableModel model2 = new DefaultTableModel(){
            private String firstResultPath;
            private final Comparator<Vector<FindPopupItem>> COMPARATOR = (v1, v2) -> {
                FindPopupItem u1 = (FindPopupItem)v1.get(0);
                FindPopupItem u2 = (FindPopupItem)v2.get(0);
                String u2Path = u2.getPath();
                String u1Path = u1.getPath();
                if (u1Path.equals(this.firstResultPath) && !u2Path.equals(this.firstResultPath)) {
                    return -1;
                }
                if (!u1Path.equals(this.firstResultPath) && u2Path.equals(this.firstResultPath)) {
                    return 1;
                }
                int c2 = u1Path.compareTo(u2Path);
                if (c2 != 0) {
                    return c2;
                }
                c2 = Integer.compare(u1.getLine(), u2.getLine());
                if (c2 != 0) {
                    return c2;
                }
                return Integer.compare(u1.getNavigationOffset(), u2.getNavigationOffset());
            };

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void addRow(Object[] rowData) {
                if (FindPopupPanel.this.myNeedReset.compareAndSet(true, false)) {
                    this.dataVector.clear();
                    this.fireTableDataChanged();
                }
                Vector<Object> v = 16.convertToVector(rowData);
                if (this.dataVector.isEmpty()) {
                    this.addRow(v);
                    FindPopupPanel.this.myResultsPreviewTable.getSelectionModel().setSelectionInterval(0, 0);
                    this.firstResultPath = ((FindPopupItem)v.get(0)).getPath();
                } else {
                    int p = Collections.binarySearch(this.dataVector, v, this.COMPARATOR);
                    if (p < 0) {
                        int row = -(p + 1);
                        this.insertRow(row, v);
                    }
                }
            }
        };
        model2.addColumn("Usages");
        DefaultTableModel defaultTableModel = model2;
        if (defaultTableModel == null) {
            FindPopupPanel.$$$reportNull$$$0(9);
        }
        return defaultTableModel;
    }

    private void onFileMaskChanged() {
        Object item = this.header.fileMaskField.getEditor().getItem();
        if (item != null && !item.equals(this.header.fileMaskField.getSelectedItem())) {
            this.header.fileMaskField.setSelectedItem(item);
        }
        this.scheduleResultsUpdate();
    }

    private void closeImmediately() {
        if (this.canBeClosedImmediately() && this.myDialog != null && this.myDialog.isVisible()) {
            this.myIsPinned.set(false);
            this.myDialog.doCancelAction();
        }
    }

    private boolean canBeClosedImmediately() {
        boolean state = this.myIsPinned.get();
        this.myIsPinned.set(false);
        try {
            boolean bl = this.myDialog != null && this.canBeClosed();
            return bl;
        }
        finally {
            this.myIsPinned.set(state);
        }
    }

    private void doOK(boolean openInFindWindow) {
        if (!this.canBeClosedImmediately()) {
            return;
        }
        FindModel validateModel = this.myHelper.getModel().clone();
        this.applyTo(validateModel);
        ValidationInfo validationInfo = this.getValidationInfo(validateModel);
        if (validationInfo == null) {
            if (validateModel.isReplaceState() && !openInFindWindow && this.myResultsPreviewTable.getRowCount() > 1 && !ReplaceInProjectManager.getInstance(this.myProject).showReplaceAllConfirmDialog(this.myUsagesCount, this.getStringToFind(), this.myFilesCount, this.getStringToReplace())) {
                return;
            }
        } else {
            String message = validationInfo.message;
            Messages.showMessageDialog((Component)this, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.myHelper.getModel().copyFrom(validateModel);
        this.myHelper.getModel().setPromptOnReplace(openInFindWindow);
        this.myHelper.doOKAction();
        this.myIsPinned.set(false);
        this.myDialog.doCancelAction();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ApplicationManager.getApplication().invokeLater(() -> ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable), ModalityState.any());
        this.myScopeSelectionToolbar.updateActionsImmediately();
    }

    @Override
    public void initByModel() {
        FindModel myModel = this.myHelper.getModel();
        this.myCaseSensitiveState.set(myModel.isCaseSensitive());
        this.myWholeWordsState.set(myModel.isWholeWordsOnly());
        this.myRegexState.set(myModel.isRegularExpressions());
        this.mySelectedContextName = FindPopupPanel.getSearchContextName(myModel);
        this.myPreserveCaseState.set(myModel.isPreserveCase());
        this.mySelectedScope = this.myScopeUI.initByModel(myModel);
        boolean isThereFileFilter = myModel.getFileFilter() != null && !myModel.getFileFilter().isEmpty();
        try {
            this.header.cbFileFilter.putClientProperty((Object)"dontRequestFocus", (Object)Boolean.TRUE);
            this.header.cbFileFilter.setSelected(isThereFileFilter);
        }
        finally {
            this.header.cbFileFilter.putClientProperty((Object)"dontRequestFocus", null);
        }
        this.header.fileMaskField.removeAllItems();
        FindSettings findSettings = FindSettings.getInstance();
        @NlsSafe String[] fileMasks = findSettings.getRecentFileMasks();
        for (int i2 = fileMasks.length - 1; i2 >= 0; --i2) {
            this.header.fileMaskField.addItem((Object)fileMasks[i2]);
        }
        if (fileMasks.length > 0) {
            String fileMask = findSettings.getFileMask();
            this.header.fileMaskField.setSelectedItem((Object)(fileMask != null ? fileMask : fileMasks[fileMasks.length - 1]));
        }
        this.header.fileMaskField.setEnabled(isThereFileFilter);
        String toSearch = myModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)this.myProject);
        if (StringUtil.isEmpty(toSearch)) {
            String[] history = findInProjectSettings.getRecentFindStrings();
            toSearch = history.length > 0 ? history[history.length - 1] : "";
        }
        this.mySearchComponent.setText(toSearch);
        String toReplace = myModel.getStringToReplace();
        if (StringUtil.isEmpty(toReplace)) {
            String[] history = findInProjectSettings.getRecentReplaceStrings();
            toReplace = history.length > 0 ? history[history.length - 1] : "";
        }
        this.myReplaceComponent.setText(toReplace);
        this.updateControls();
        this.updateScopeDetailsPanel();
        boolean isReplaceState = this.myHelper.isReplaceState();
        this.header.titleLabel.setText(this.myHelper.getTitle());
        this.myReplaceTextArea.setVisible(isReplaceState);
        this.myOKHintLabel.setText(KeymapUtil.getKeystrokeText((KeyStroke)ENTER_WITH_MODIFIERS));
        this.myOKButton.setText(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myReplaceAllButton.setVisible(isReplaceState);
        this.myReplaceSelectedButton.setVisible(isReplaceState);
    }

    private void updateControls() {
        JRootPane pane;
        this.myReplaceAllButton.setVisible(this.myHelper.isReplaceState());
        this.myReplaceSelectedButton.setVisible(this.myHelper.isReplaceState());
        if (this.myHelper.isReplaceState() && (pane = this.getRootPane()) != null) {
            pane.setDefaultButton(this.myReplaceSelectedButton);
        }
        this.myNavigationHintLabel.setVisible(this.mySearchComponent.getText().contains("\n"));
        this.mySearchTextArea.updateExtraActions();
        this.myReplaceTextArea.updateExtraActions();
        if (this.myNavigationHintLabel.isVisible()) {
            Keymap activeKeymap;
            this.myNavigationHintLabel.setText("");
            KeymapManager keymapManager = KeymapManager.getInstance();
            Keymap keymap = activeKeymap = keymapManager != null ? keymapManager.getActiveKeymap() : null;
            if (activeKeymap != null) {
                String findNextText = KeymapUtil.getFirstKeyboardShortcutText((String)"FindNext");
                String findPreviousText = KeymapUtil.getFirstKeyboardShortcutText((String)"FindPrevious");
                if (!StringUtil.isEmpty(findNextText) && !StringUtil.isEmpty(findPreviousText)) {
                    this.myNavigationHintLabel.setText(FindBundle.message("label.use.0.and.1.to.select.usages", findNextText, findPreviousText));
                }
            }
        }
    }

    private void updateScopeDetailsPanel() {
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.mySelectedScope.name);
        Component firstFocusableComponent = FindPopupPanel.focusableComponents(this.myScopeDetailsPanel).find(c2 -> c2.isFocusable() && c2.isEnabled() && c2.isShowing());
        this.myScopeDetailsPanel.revalidate();
        this.myScopeDetailsPanel.repaint();
        if (firstFocusableComponent != null) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(firstFocusableComponent, true));
        }
        if (firstFocusableComponent == null && !this.mySearchComponent.isFocusOwner() && !this.myReplaceComponent.isFocusOwner()) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchComponent, true));
        }
    }

    public void scheduleResultsUpdate() {
        if (this.myDialog == null || !this.myDialog.isVisible()) {
            return;
        }
        if (this.mySearchRescheduleOnCancellationsAlarm == null || this.mySearchRescheduleOnCancellationsAlarm.isDisposed()) {
            return;
        }
        this.updateControls();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.mySearchRescheduleOnCancellationsAlarm.addRequest(this::findSettingsChanged, 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    private void findSettingsChanged() {
        ProgressIndicatorBase progressIndicatorWhenSearchStarted;
        if (this.isShowing()) {
            ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
        }
        final ModalityState state = ModalityState.current();
        this.finishPreviousPreviewSearch();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.applyTo(this.myHelper.getModel());
        final FindModel findModel = new FindModel();
        findModel.copyFrom(this.myHelper.getModel());
        if (findModel.getStringToFind().contains("\n")) {
            findModel.setMultiline(true);
        }
        ValidationInfo result2 = this.getValidationInfo(this.myHelper.getModel());
        this.myComponentValidator.updateInfo(result2);
        this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase(){

            @Override
            public void stop() {
                super.stop();
                FindPopupPanel.this.onStop(System.identityHashCode(this));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (FindPopupPanel.this.myNeedReset.compareAndSet(true, false)) {
                        FindPopupPanel.this.reset();
                    }
                });
            }
        };
        final int hash = System.identityHashCode(this.myResultsPreviewSearchProgress);
        final LinkedHashSet<VirtualFile> filesToScanInitially = new LinkedHashSet<VirtualFile>();
        if (this.myHelper.myPreviousModel != null && this.myHelper.myPreviousModel.getStringToFind().length() < this.myHelper.getModel().getStringToFind().length()) {
            DefaultTableModel previousModel = (DefaultTableModel)this.myResultsPreviewTable.getModel();
            int len = previousModel.getRowCount();
            for (int i2 = 0; i2 < len; ++i2) {
                VirtualFile file2;
                UsageInfoAdapter usage2;
                Object value = previousModel.getValueAt(i2, 0);
                if (!(value instanceof FindPopupItem) || !((usage2 = ((FindPopupItem)value).getUsage()) instanceof UsageInfo2UsageAdapter) || (file2 = ((UsageInfo2UsageAdapter)usage2).getFile()) == null) continue;
                filesToScanInitially.add(file2);
            }
        }
        this.myHelper.myPreviousModel = this.myHelper.getModel().clone();
        this.myReplaceAllButton.setEnabled(false);
        this.myReplaceSelectedButton.setEnabled(false);
        this.myReplaceSelectedButton.setText(FindBundle.message("find.popup.replace.selected.button", 0));
        this.onStart(hash);
        if (result2 != null && result2.component != this.myReplaceComponent) {
            this.onStop(hash, result2.message);
            this.reset();
            return;
        }
        final FindInProjectExecutor projectExecutor = FindInProjectExecutor.Companion.getInstance();
        TableCellRenderer renderer = projectExecutor.createTableCellRenderer();
        if (renderer == null) {
            renderer = new UsageTableCellRenderer();
        }
        this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        final AtomicInteger resultsCount = new AtomicInteger();
        final AtomicInteger resultsFilesCount = new AtomicInteger();
        FindInProjectUtil.setupViewPresentation(this.myUsageViewPresentation, findModel);
        final Project project2 = this.myProject;
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project2, FindBundle.message("find.usages.progress.title", new Object[0])){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    18.$$$reportNull$$$0(0);
                }
                GlobalSearchScope scope = ReadAction.nonBlocking(() -> GlobalSearchScopeUtil.toGlobalSearchScope(FindInProjectUtil.getScopeFromModel(project2, FindPopupPanel.this.myHelper.myPreviousModel), project2)).wrapProgress(indicator).executeSynchronously();
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(project2, FindPopupPanel.this.myUsageViewPresentation);
                ThreadLocal lastUsageFileRef = new ThreadLocal();
                ThreadLocal recentItemRef = new ThreadLocal();
                projectExecutor.findUsages(project2, FindPopupPanel.this.myResultsPreviewSearchProgress, processPresentation, findModel, filesToScanInitially, (Function1<? super UsageInfoAdapter, Boolean>)((Function1)usage2 -> {
                    if (this.isCancelled()) {
                        FindPopupPanel.this.onStop(hash);
                        return false;
                    }
                    if (resultsCount.getAndIncrement() >= ShowUsagesAction.getUsagesPageSize()) {
                        FindPopupPanel.this.onStop(hash);
                        return false;
                    }
                    String file2 = (String)lastUsageFileRef.get();
                    String usageFile = PathUtil.toSystemIndependentName(usage2.getPath());
                    if (!usageFile.equals(file2)) {
                        resultsFilesCount.incrementAndGet();
                        lastUsageFileRef.set(usageFile);
                    }
                    FindPopupItem recentItem = (FindPopupItem)SoftReference.dereference((Reference)recentItemRef.get());
                    boolean merged = !FindPopupPanel.this.myHelper.isReplaceState() && recentItem != null && recentItem.getUsage().merge((MergeableUsage)usage2);
                    FindPopupItem newItem = !merged ? new FindPopupItem((UsageInfoAdapter)usage2, UiModelKt.usagePresentation(project2, scope, usage2)) : recentItem.withPresentation(UiModelKt.usagePresentation(project2, scope, recentItem.getUsage()));
                    recentItemRef.set(new WeakReference<FindPopupItem>(newItem));
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isCancelled()) {
                            FindPopupPanel.this.onStop(hash);
                            return;
                        }
                        FindPopupPanel.this.myPreviewSplitter.getSecondComponent().setVisible(true);
                        DefaultTableModel model2 = (DefaultTableModel)FindPopupPanel.this.myResultsPreviewTable.getModel();
                        if (!merged) {
                            model2.addRow(new Object[]{newItem});
                        } else {
                            model2.fireTableRowsUpdated(model2.getRowCount() - 1, model2.getRowCount() - 1);
                        }
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(true);
                        if (model2.getRowCount() == 1) {
                            FindPopupPanel.this.myResultsPreviewTable.setRowSelectionInterval(0, 0);
                        }
                        int occurrences = resultsCount.get();
                        int filesWithOccurrences = resultsFilesCount.get();
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(occurrences > 0);
                        FindPopupPanel.this.myReplaceAllButton.setEnabled(occurrences > 0);
                        FindPopupPanel.this.myReplaceSelectedButton.setEnabled(occurrences > 0);
                        if (occurrences > 0) {
                            if (occurrences < ShowUsagesAction.getUsagesPageSize()) {
                                FindPopupPanel.this.myUsagesCount = String.valueOf(occurrences);
                                FindPopupPanel.this.myFilesCount = String.valueOf(filesWithOccurrences);
                                FindPopupPanel.this.header.infoLabel.setText(FindBundle.message("message.matches.in.files", occurrences, filesWithOccurrences));
                            } else {
                                FindPopupPanel.this.myUsagesCount = occurrences + "+";
                                FindPopupPanel.this.myFilesCount = filesWithOccurrences + "+";
                                FindPopupPanel.this.header.infoLabel.setText(FindBundle.message("message.matches.in.files.incomplete", occurrences, filesWithOccurrences));
                            }
                        } else {
                            FindPopupPanel.this.header.infoLabel.setText("");
                        }
                    }, state);
                    return true;
                }));
            }

            @Override
            public void onCancel() {
                if (FindPopupPanel.this.isShowing() && progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }

            boolean isCancelled() {
                return progressIndicatorWhenSearchStarted != FindPopupPanel.this.myResultsPreviewSearchProgress || progressIndicatorWhenSearchStarted.isCanceled();
            }

            @Override
            public void onFinished() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!this.isCancelled()) {
                        boolean isEmpty;
                        boolean bl = isEmpty = resultsCount.get() == 0;
                        if (isEmpty) {
                            FindPopupPanel.this.showEmptyText(FindBundle.message("message.nothingFound", new Object[0]));
                        }
                    }
                    FindPopupPanel.this.onStop(hash);
                }, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$18", "run"));
            }
        }, this.myResultsPreviewSearchProgress);
    }

    private void reset() {
        ((DefaultTableModel)this.myResultsPreviewTable.getModel()).getDataVector().clear();
        ((DefaultTableModel)this.myResultsPreviewTable.getModel()).fireTableDataChanged();
        this.myResultsPreviewTable.getSelectionModel().clearSelection();
        this.myPreviewSplitter.getSecondComponent().setVisible(false);
        this.header.infoLabel.setText(null);
    }

    private void showEmptyText(@NlsContexts.StatusText @NotNull String message) {
        String fileTypeMask;
        if (message == null) {
            FindPopupPanel.$$$reportNull$$$0(10);
        }
        StatusText emptyText = this.myResultsPreviewTable.getEmptyText();
        emptyText.clear();
        FindModel model2 = this.myHelper.getModel();
        boolean dotAdded = false;
        if (StringUtil.isEmpty(model2.getStringToFind())) {
            emptyText.setText(FindBundle.message("message.type.search.query", new Object[0]));
        } else {
            emptyText.setText(message);
        }
        if (this.mySelectedScope == FindPopupScopeUIImpl.DIRECTORY && !model2.isWithSubdirectories()) {
            emptyText.appendText(".");
            dotAdded = true;
            emptyText.appendSecondaryText(FindBundle.message("find.recursively.hint", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                model2.setWithSubdirectories(true);
                this.scheduleResultsUpdate();
            });
        }
        SmartList<Object> usedOptions = new SmartList<Object>();
        if (model2.isCaseSensitive() && this.isEnabled(this.myCaseSensitiveAction)) {
            usedOptions.add(this.myCaseSensitiveAction);
        }
        if (model2.isWholeWordsOnly() && this.isEnabled(this.myWholeWordsAction)) {
            usedOptions.add(this.myWholeWordsAction);
        }
        if (model2.isRegularExpressions() && this.isEnabled(this.myRegexAction)) {
            usedOptions.add(this.myRegexAction);
        }
        boolean couldBeRegexp = false;
        if (this.mySuggestRegexHintForEmptyResults) {
            String stringToFind = model2.getStringToFind();
            if (!model2.isRegularExpressions() && this.isEnabled(this.myRegexAction)) {
                String regexSymbols = ".$|()[]{}^?*+\\";
                for (int i2 = 0; i2 < stringToFind.length(); ++i2) {
                    if (regexSymbols.indexOf(stringToFind.charAt(i2)) == -1) continue;
                    couldBeRegexp = true;
                    break;
                }
            }
            if (couldBeRegexp) {
                try {
                    Pattern.compile(stringToFind);
                    usedOptions.add(this.myRegexAction);
                }
                catch (Exception e2) {
                    couldBeRegexp = false;
                }
            }
        }
        if ((fileTypeMask = this.getFileTypeMask()) != null && FindInProjectUtil.createFileMaskCondition(fileTypeMask) != Conditions.alwaysTrue()) {
            usedOptions.add(this.header.cbFileFilter);
        }
        if (model2.isInCommentsOnly() || model2.isInStringLiteralsOnly() || model2.isExceptComments() || model2.isExceptStringLiterals() || model2.isExceptCommentsAndStringLiterals()) {
            usedOptions.add(model2);
        }
        if (!usedOptions.isEmpty()) {
            if (!dotAdded) {
                emptyText.appendText(".");
            }
            emptyText.appendLine(" ");
            if (couldBeRegexp) {
                emptyText.appendLine(FindBundle.message("message.nothingFound.search.with.regex", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, __ -> {
                    this.toggleOption(this.myRegexAction);
                    this.mySuggestRegexHintForEmptyResults = false;
                }).appendText(" " + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)this.myRegexAction.getShortcutSet()));
            } else if (usedOptions.size() > 1) {
                emptyText.appendLine(FindBundle.message("message.nothingFound.used.options", new Object[0]));
                @NlsSafe StringBuilder sb = new StringBuilder();
                for (Object e2 : usedOptions) {
                    String optionText;
                    if (sb.length() > 0) {
                        sb.append("  ");
                    }
                    if ((optionText = FindPopupPanel.getOptionText(e2, true)) == null) continue;
                    sb.append(optionText);
                }
                emptyText.appendLine(sb.toString());
                emptyText.appendLine(FindBundle.message("message.nothingFound.clearAll", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, __ -> this.resetAllFilters()).appendText(" " + FindPopupPanel.getOptionText(this.myResetFiltersAction, true));
            } else {
                Object option = usedOptions.get(0);
                emptyText.appendLine(FindBundle.message("message.nothingFound.used.option", FindPopupPanel.getOptionText(option, false)));
                emptyText.appendLine(FindBundle.message("message.nothingFound.clearOption", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, __ -> this.resetAllFilters()).appendText(" " + FindPopupPanel.getOptionText(this.myResetFiltersAction, true));
            }
        }
    }

    private void resetAllFilters() {
        this.header.cbFileFilter.setSelected(false);
        this.mySelectedContextName = FindInProjectUtil.getPresentableName(FindModel.SearchContext.ANY);
        this.myFilterContextButton.repaint();
        this.myCaseSensitiveState.set(false);
        this.myWholeWordsState.set(false);
        this.myRegexState.set(false);
        this.scheduleResultsUpdate();
    }

    private boolean isEnabled(@NotNull AnAction action2) {
        if (action2 == null) {
            FindPopupPanel.$$$reportNull$$$0(11);
        }
        Presentation presentation2 = new Presentation();
        action2.update(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)this), "unknown", presentation2, ActionManager.getInstance(), 0));
        return presentation2.isEnabled();
    }

    @Nullable
    @NlsContexts.StatusText
    private static String getOptionText(Object option, boolean full) {
        if (option instanceof AnAction) {
            String text2 = ((AnAction)option).getTemplateText();
            if (text2 == null) {
                text2 = "";
            }
            return (text2 + (String)(full ? " " + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)((AnAction)option).getShortcutSet()) : "")).trim();
        }
        if (option instanceof JToggleButton) {
            CustomShortcutSet shortcutSet = KeymapUtil.getShortcutsForMnemonicCode((int)((JToggleButton)option).getMnemonic());
            return (((JToggleButton)option).getText().replace(":", "") + (String)(shortcutSet != null && full ? " " + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)shortcutSet) : "")).trim();
        }
        if (option instanceof FindModel) {
            return FindBundle.message("message.nothingFound.context.filter", new Object[0]);
        }
        return null;
    }

    private void toggleOption(@NotNull Object option) {
        if (option == null) {
            FindPopupPanel.$$$reportNull$$$0(12);
        }
        if (option instanceof AnAction) {
            ((AnAction)option).actionPerformed(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)this), "unknown", new Presentation(), ActionManager.getInstance(), 0));
        } else if (option instanceof JToggleButton) {
            ((JToggleButton)option).doClick();
        } else if (option instanceof FindModel) {
            this.mySelectedContextName = FindInProjectUtil.getPresentableName(FindModel.SearchContext.ANY);
            this.myFilterContextButton.repaint();
            this.scheduleResultsUpdate();
        }
    }

    private void onStart(int hash) {
        this.myNeedReset.set(true);
        this.myLoadingHash = hash;
        this.header.loadingIcon.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
        this.myResultsPreviewTable.getEmptyText().setText(FindBundle.message("empty.text.searching", new Object[0]));
    }

    private void onStop(int hash) {
        this.onStop(hash, FindBundle.message("message.nothingFound", new Object[0]));
    }

    private void onStop(int hash, @NotNull String message) {
        if (message == null) {
            FindPopupPanel.$$$reportNull$$$0(13);
        }
        if (hash != this.myLoadingHash) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            this.showEmptyText(message);
            this.header.loadingIcon.setIcon(EmptyIcon.ICON_16);
        });
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        String mask = null;
        if (this.header.cbFileFilter != null && this.header.cbFileFilter.isSelected()) {
            mask = (String)this.header.fileMaskField.getSelectedItem();
        }
        return mask;
    }

    @Nullable(value="null means OK")
    private @Nullable(value="null means OK") ValidationInfo getValidationInfo(@NotNull FindModel model2) {
        String mask;
        ValidationInfo scopeValidationInfo;
        if (model2 == null) {
            FindPopupPanel.$$$reportNull$$$0(14);
        }
        if ((scopeValidationInfo = this.myScopeUI.validate(model2, this.mySelectedScope)) != null) {
            return scopeValidationInfo;
        }
        if (!this.myHelper.canSearchThisString()) {
            return new ValidationInfo(FindBundle.message("find.empty.search.text.error", new Object[0]), (JComponent)this.mySearchComponent);
        }
        if (model2.isRegularExpressions()) {
            Pattern pattern;
            String toFind = model2.getStringToFind();
            try {
                pattern = Pattern.compile(toFind, model2.isCaseSensitive() ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.mySearchComponent);
                }
            }
            catch (PatternSyntaxException e) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e.getDescription()), (JComponent)this.mySearchComponent);
            }
            if (model2.isReplaceState()) {
                Object value;
                if (this.myResultsPreviewTable.getRowCount() > 0 && (value = this.myResultsPreviewTable.getModel().getValueAt(0, 0)) instanceof FindPopupItem) {
                    try {
                        ReplaceInProjectManager.getInstance(this.myProject).replaceUsage((Usage)((FindPopupItem)value).getUsage(), model2, Collections.emptySet(), true);
                    }
                    catch (FindManager.MalformedReplacementStringException e) {
                        return new ValidationInfo(e.getMessage(), (JComponent)this.myReplaceComponent);
                    }
                }
                try {
                    RegExReplacementBuilder.validate(pattern, this.getStringToReplace());
                }
                catch (IllegalArgumentException e) {
                    return new ValidationInfo(FindBundle.message("find.replace.invalid.replacement.string", e.getMessage()), (JComponent)this.myReplaceComponent);
                }
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), this.header.fileMaskField);
            }
            if (mask.contains(";")) {
                return new ValidationInfo(FindBundle.message("message.file.masks.should.be.comma.separated", new Object[0]), this.header.fileMaskField);
            }
            try {
                FindPopupPanel.createFileMaskRegExp(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), this.header.fileMaskField);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getStringToFind() {
        String string2 = this.mySearchComponent.getText();
        if (string2 == null) {
            FindPopupPanel.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    private String getStringToReplace() {
        String string2 = this.myReplaceComponent.getText();
        if (string2 == null) {
            FindPopupPanel.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private void applyTo(@NotNull FindModel model2) {
        if (model2 == null) {
            FindPopupPanel.$$$reportNull$$$0(17);
        }
        model2.setCaseSensitive(this.myCaseSensitiveState.get());
        model2.setPreserveCase(this.myPreserveCaseState.get());
        model2.setWholeWordsOnly(this.myWholeWordsState.get());
        FindModel.SearchContext searchContext = FindPopupPanel.parseSearchContext(this.mySelectedContextName);
        model2.setSearchContext(searchContext);
        model2.setRegularExpressions(this.myRegexState.get());
        model2.setStringToFind(this.getStringToFind());
        if (model2.isReplaceState()) {
            model2.setStringToReplace(StringUtil.convertLineSeparators(this.getStringToReplace()));
        }
        model2.setProjectScope(false);
        model2.setDirectoryName(null);
        model2.setModuleName(null);
        model2.setCustomScopeName(null);
        model2.setCustomScope(null);
        model2.setCustomScope(false);
        this.myScopeUI.applyTo(model2, this.mySelectedScope);
        model2.setFindAll(false);
        String mask = this.getFileTypeMask();
        model2.setFileFilter(mask);
    }

    private void navigateToSelectedUsage(@Nullable AnActionEvent e) {
        Navigatable[] navigatables;
        Navigatable[] navigatableArray = navigatables = e != null ? (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY) : null;
        if (navigatables != null) {
            if (this.canBeClosed()) {
                this.myDialog.doCancelAction();
            }
            OpenSourceUtil.navigate((Navigatable[])navigatables);
            return;
        }
        Map<Integer, Usage> usages = this.getSelectedUsages();
        if (usages != null) {
            if (this.canBeClosed()) {
                this.myDialog.doCancelAction();
            }
            boolean first2 = true;
            for (Usage usage2 : usages.values()) {
                if (first2) {
                    usage2.navigate(true);
                } else {
                    usage2.highlightInEditor();
                }
                first2 = false;
            }
        }
    }

    @Nullable
    private Map<Integer, Usage> getSelectedUsages() {
        int[] rows = this.myResultsPreviewTable.getSelectedRows();
        LinkedHashMap<Integer, UsageInfoAdapter> result2 = null;
        for (int i2 = rows.length - 1; i2 >= 0; --i2) {
            int row = rows[i2];
            Object valueAt = this.myResultsPreviewTable.getModel().getValueAt(row, 0);
            if (!(valueAt instanceof FindPopupItem)) continue;
            if (result2 == null) {
                result2 = new LinkedHashMap<Integer, UsageInfoAdapter>();
            }
            result2.put(row, ((FindPopupItem)valueAt).getUsage());
        }
        return result2;
    }

    @NotNull
    public static ActionToolbarImpl createToolbar(AnAction ... actions) {
        if (actions == null) {
            FindPopupPanel.$$$reportNull$$$0(18);
        }
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        toolbar.setForceMinimumSize(true);
        toolbar.setTargetComponent((JComponent)toolbar);
        toolbar.setLayoutPolicy(0);
        toolbar.setBorder(JBUI.Borders.empty(3));
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            FindPopupPanel.$$$reportNull$$$0(19);
        }
        return actionToolbarImpl;
    }

    @NotNull
    private static ActionToolbarImpl createScopeToolbar(AnAction ... actions) {
        if (actions == null) {
            FindPopupPanel.$$$reportNull$$$0(20);
        }
        ActionToolbarImpl toolbar = new ActionToolbarImpl("EditorToolbar", (ActionGroup)new DefaultActionGroup(actions), true){

            @NotNull
            protected ActionButton createToolbarButton(@NotNull AnAction action2, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation2, Supplier<? extends @NotNull Dimension> minimumSize) {
                if (action2 == null) {
                    19.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    19.$$$reportNull$$$0(1);
                }
                if (presentation2 == null) {
                    19.$$$reportNull$$$0(2);
                }
                if (!ExperimentalUI.isNewUI()) {
                    ActionButton actionButton2 = super.createToolbarButton(action2, look, place, presentation2, minimumSize);
                    if (actionButton2 == null) {
                        19.$$$reportNull$$$0(3);
                    }
                    return actionButton2;
                }
                ActionButtonWithText result2 = new ActionButtonWithText(action2, presentation2, place, minimumSize){

                    @NotNull
                    protected Insets getMargins() {
                        JBInsets jBInsets = JBInsets.addInsets(super.getMargins(), new JBInsets(4, 2, 4, 2));
                        if (jBInsets == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return jBInsets;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel$19$1", "getMargins"));
                    }
                };
                result2.setLook(look);
                result2.setBorder((Border)JBUI.Borders.emptyRight(4));
                result2.setFont((Font)JBFont.medium());
                ActionButtonWithText actionButtonWithText = result2;
                if (actionButtonWithText == null) {
                    19.$$$reportNull$$$0(4);
                }
                return actionButtonWithText;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$19";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$19";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createToolbarButton";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createToolbarButton";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 3, 4 -> new IllegalStateException(string2);
                };
            }
        };
        toolbar.setForceMinimumSize(true);
        toolbar.setTargetComponent((JComponent)toolbar);
        toolbar.setLayoutPolicy(0);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            FindPopupPanel.$$$reportNull$$$0(21);
        }
        return actionToolbarImpl;
    }

    private static void applyFont(@NotNull JBFont font, Component ... components) {
        if (font == null) {
            FindPopupPanel.$$$reportNull$$$0(22);
        }
        if (components == null) {
            FindPopupPanel.$$$reportNull$$$0(23);
        }
        for (Component component2 : components) {
            component2.setFont(font);
        }
    }

    private static void createFileMaskRegExp(@NotNull String filter2) throws PatternSyntaxException {
        List<String> strings2;
        if (filter2 == null) {
            FindPopupPanel.$$$reportNull$$$0(24);
        }
        String pattern = (strings2 = StringUtil.split(filter2, ",")).size() == 1 ? PatternUtil.convertToRegex(filter2.trim()) : StringUtil.join(strings2, s -> "(" + PatternUtil.convertToRegex(s.trim()) + ")", "|");
        Pattern.compile(pattern, 2);
    }

    @NotNull
    private static String getSearchContextName(@NotNull FindModel model2) {
        if (model2 == null) {
            FindPopupPanel.$$$reportNull$$$0(25);
        }
        String searchContext = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        if (model2.isInCommentsOnly()) {
            searchContext = FindBundle.message("find.context.in.comments.scope.label", new Object[0]);
        } else if (model2.isInStringLiteralsOnly()) {
            searchContext = FindBundle.message("find.context.in.literals.scope.label", new Object[0]);
        } else if (model2.isExceptStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.literals.scope.label", new Object[0]);
        } else if (model2.isExceptComments()) {
            searchContext = FindBundle.message("find.context.except.comments.scope.label", new Object[0]);
        } else if (model2.isExceptCommentsAndStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]);
        }
        String string2 = searchContext;
        if (string2 == null) {
            FindPopupPanel.$$$reportNull$$$0(26);
        }
        return string2;
    }

    @NotNull
    private static FindModel.SearchContext parseSearchContext(String presentableName) {
        FindModel.SearchContext searchContext = FindModel.SearchContext.ANY;
        if (FindBundle.message("find.context.in.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_STRING_LITERALS;
        } else if (FindBundle.message("find.context.in.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_COMMENTS;
        } else if (FindBundle.message("find.context.except.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS;
        } else if (FindBundle.message("find.context.except.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_STRING_LITERALS;
        } else if (FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS;
        }
        FindModel.SearchContext searchContext2 = searchContext;
        if (searchContext2 == null) {
            FindPopupPanel.$$$reportNull$$$0(27);
        }
        return searchContext2;
    }

    @NotNull
    private static JBIterable<Component> focusableComponents(@NotNull Component component2) {
        if (component2 == null) {
            FindPopupPanel.$$$reportNull$$$0(28);
        }
        JBIterable<Component> jBIterable = UIUtil.uiTraverser(component2).bfsTraversal().filter(c2 -> c2 instanceof JComboBox || c2 instanceof AbstractButton || c2 instanceof JTextComponent);
        if (jBIterable == null) {
            FindPopupPanel.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 9, 15, 16, 19, 21, 26, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindPopupPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 14: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanClose";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToFind";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToReplace";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeToolbar";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchContextName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSearchContext";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "focusableComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showEmptyText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toggleOption";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onStop";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValidationInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createScopeToolbar";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyFont";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createFileMaskRegExp";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSearchContextName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "focusableComponents";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 9, 15, 16, 19, 21, 26, 27, 29 -> new IllegalStateException(string2);
        };
    }

    private class MyShowFilterPopupAction
    extends DumbAwareAction {
        private final PopupState<JBPopup> myPopupState;
        private final DefaultActionGroup mySwitchContextGroup;

        MyShowFilterPopupAction() {
            super(FindBundle.messagePointer("find.popup.show.filter.popup", new Object[0]), Presentation.NULL_STRING, AllIcons.General.Filter);
            this.myPopupState = PopupState.forPopup();
            KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowFilterPopup");
            if (keyboardShortcut != null) {
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{keyboardShortcut}));
            }
            this.mySwitchContextGroup = new DefaultActionGroup();
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.ANY));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS));
            this.mySwitchContextGroup.setPopup(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowFilterPopupAction.$$$reportNull$$$0(0);
            }
            if (e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) == null) {
                return;
            }
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.mySwitchContextGroup, e.getDataContext(), false, null, 10);
            this.myPopupState.prepareToShow((Object)listPopup);
            listPopup.showUnderneathOf((Component)FindPopupPanel.this.myFilterContextButton);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$MyShowFilterPopupAction", "actionPerformed"));
        }
    }

    private final class MyPinAction
    extends ToggleAction {
        private MyPinAction() {
            super(IdeBundle.messagePointer((String)"action.ToggleAction.text.pin.window", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.ToggleAction.description.pin.window", (Object[])new Object[0]), AllIcons.General.Pin_tab);
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPinAction.$$$reportNull$$$0(0);
            }
            return UISettings.getInstance().getPinFindInPath();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyPinAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyPinAction.$$$reportNull$$$0(2);
            }
            FindPopupPanel.this.myIsPinned.set(state);
            UISettings.getInstance().setPinFindInPath(state);
            FindUsagesCollector.PIN_TOGGLED.log((Object)state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$MyPinAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MyPinAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private final class MyEnterAction
    extends DumbAwareAction {
        private final boolean myEnterAsOK;

        private MyEnterAction(boolean enterAsOK) {
            this.myEnterAsOK = enterAsOK;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEnterAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(e.getData(CommonDataKeys.EDITOR) == null || SwingUtilities.isDescendingFrom((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT), FindPopupPanel.this.header.fileMaskField));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyEnterAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEnterAction.$$$reportNull$$$0(2);
            }
            if (SwingUtilities.isDescendingFrom((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT), FindPopupPanel.this.header.fileMaskField) && FindPopupPanel.this.header.fileMaskField.isPopupVisible()) {
                FindPopupPanel.this.header.fileMaskField.hidePopup();
                return;
            }
            if (FindPopupPanel.this.myScopeUI.hideAllPopups()) {
                return;
            }
            if (this.myEnterAsOK) {
                FindPopupPanel.this.myOkActionListener.actionPerformed(null);
            } else if (FindPopupPanel.this.myHelper.isReplaceState()) {
                FindPopupPanel.this.myReplaceSelectedButton.doClick();
            } else {
                FindPopupPanel.this.navigateToSelectedUsage(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$MyEnterAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MyEnterAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class JBTextAreaWithMixedAccessibleContext
    extends JBTextArea {
        private final AccessibleContext tableContext;

        private JBTextAreaWithMixedAccessibleContext(AccessibleContext context2, @NlsContexts.StatusText String emptyText) {
            this.tableContext = context2;
            this.getEmptyText().setText(emptyText);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TextFieldWithListAccessibleContext((JTextComponent)((Object)this), this.tableContext);
            }
            return this.accessibleContext;
        }
    }

    private final class MySwitchStateToggleAction
    extends DumbAwareToggleAction
    implements TooltipLinkProvider,
    TooltipDescriptionProvider {
        private final ToggleOptionName myOptionName;
        private final AtomicBoolean myState;
        private final TooltipLinkProvider.TooltipLink myTooltipLink;
        final /* synthetic */ FindPopupPanel this$0;

        private MySwitchStateToggleAction(@NotNull FindPopupPanel findPopupPanel, @NotNull String message, @NotNull ToggleOptionName optionName, @NotNull Icon icon2, @NotNull Icon hoveredIcon, @NotNull Icon selectedIcon, AtomicBoolean state) {
            if (message == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(0);
            }
            if (optionName == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(1);
            }
            if (icon2 == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(2);
            }
            if (hoveredIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(3);
            }
            if (selectedIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(4);
            }
            if (state == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(5);
            }
            this(findPopupPanel, message, optionName, icon2, hoveredIcon, selectedIcon, state, null);
        }

        private MySwitchStateToggleAction(@NotNull FindPopupPanel findPopupPanel, @NotNull String message, @NotNull ToggleOptionName optionName, @NotNull Icon icon2, @NotNull Icon hoveredIcon, @NotNull Icon selectedIcon, @Nullable AtomicBoolean state, TooltipLinkProvider.TooltipLink tooltipLink) {
            if (message == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(6);
            }
            if (optionName == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(7);
            }
            if (icon2 == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(8);
            }
            if (hoveredIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(9);
            }
            if (selectedIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(10);
            }
            if (state == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(11);
            }
            this.this$0 = findPopupPanel;
            super(FindBundle.message(message, new Object[0]), null, icon2);
            this.myOptionName = optionName;
            this.myState = state;
            this.myTooltipLink = tooltipLink;
            this.getTemplatePresentation().setHoveredIcon(hoveredIcon);
            this.getTemplatePresentation().setSelectedIcon(selectedIcon);
            ShortcutSet shortcut = ActionUtil.getMnemonicAsShortcut((AnAction)this);
            if (shortcut != null) {
                this.setShortcutSet(shortcut);
                this.registerCustomShortcutSet(shortcut, findPopupPanel);
            }
        }

        @Nullable
        public TooltipLinkProvider.TooltipLink getTooltipLink(@Nullable JComponent owner) {
            return this.myTooltipLink;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(12);
            }
            return this.myState.get();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(13);
            }
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.myState.get());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(14);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean selected) {
            if (e == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(15);
            }
            FindUsagesCollector.CHECK_BOX_TOGGLED.log((Object)"FindInPath", (Object)this.myOptionName, (Object)selected);
            this.myState.set(selected);
            if (this.myState == this.this$0.myRegexState) {
                this.this$0.mySuggestRegexHintForEmptyResults = false;
            }
            this.this$0.scheduleResultsUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionName";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hoveredIcon";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedIcon";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 12: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$MySwitchStateToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySwitchStateToggleAction";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 14 -> new IllegalStateException(string2);
            };
        }
    }

    public static enum ToggleOptionName {
        CaseSensitive,
        PreserveCase,
        WholeWords,
        Regex,
        FileFilter;

    }

    private class MySelectScopeToggleAction
    extends DumbAwareToggleAction {
        private final FindPopupScopeUI.ScopeType myScope;

        MySelectScopeToggleAction(FindPopupScopeUI.ScopeType scope) {
            if (scope == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(0);
            }
            super(scope.textComputable.get(), null, scope.icon);
            this.getTemplatePresentation().setHoveredIcon(scope.icon);
            this.getTemplatePresentation().setDisabledIcon(scope.icon);
            this.myScope = scope;
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(1);
            }
            return FindPopupPanel.this.mySelectedScope == this.myScope;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(3);
            }
            if (state) {
                FindPopupPanel.this.mySelectedScope = this.myScope;
                FindPopupPanel.this.myScopeSelectionToolbar.updateActionsImmediately();
                FindPopupPanel.this.updateScopeDetailsPanel();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$MySelectScopeToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySelectScopeToggleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    static class UsageTableCellRenderer
    extends SelectablePanel
    implements TableCellRenderer {
        private final ColoredTableCellRenderer myUsageRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                UsagePresentation presentation2;
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof FindPopupItem && (presentation2 = ((FindPopupItem)value).getPresentation()) != null) {
                    TextChunk[] text2 = presentation2.getText();
                    for (int i2 = 1; i2 < text2.length; ++i2) {
                        TextChunk textChunk = text2[i2];
                        SimpleTextAttributes attributes = this.getAttributes(textChunk);
                        myUsageRenderer.append(textChunk.getText(), attributes);
                    }
                }
                this.setBorder(null);
            }

            protected boolean shouldPaintBackground() {
                return false;
            }

            @NotNull
            private SimpleTextAttributes getAttributes(@NotNull TextChunk textChunk) {
                SimpleTextAttributes at;
                if (textChunk == null) {
                    1.$$$reportNull$$$0(1);
                }
                boolean highlighted = (at = textChunk.getSimpleAttributesIgnoreBackground()).getFontStyle() == 1;
                SimpleTextAttributes simpleTextAttributes = highlighted ? new SimpleTextAttributes(null, at.getFgColor(), at.getWaveColor(), at.getStyle() & 0xFFFFFFFE | 0x40) : at;
                if (simpleTextAttributes == null) {
                    1.$$$reportNull$$$0(2);
                }
                return simpleTextAttributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textChunk";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAttributes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "customizeCellRenderer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getAttributes";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        public static final SimpleTextAttributes ORDINAL_ATTRIBUTES = new SimpleTextAttributes(0, (Color)JBColor.namedColor("Component.infoForeground", 0x999999, 0x999999));
        public static final SimpleTextAttributes REPEATED_FILE_ATTRIBUTES = new SimpleTextAttributes(0, ColorUtil.withAlpha(JBColor.namedColor("Component.infoForeground", 0xCCCCCC, 0x5E5E5E), 0.5));
        private final ColoredTableCellRenderer myFileAndLineNumber = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                UsagePresentation presentation2;
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value instanceof FindPopupItem && (presentation2 = ((FindPopupItem)value).getPresentation()) != null) {
                    String prevFileString;
                    TextChunk[] text2 = presentation2.getText();
                    String fileString = presentation2.getFileString();
                    SimpleTextAttributes attributes = Objects.equals(fileString, prevFileString = this.findPrevFile(table, row, column)) ? REPEATED_FILE_ATTRIBUTES : ORDINAL_ATTRIBUTES;
                    this.append(StringUtil.trimMiddle(fileString, 60), attributes);
                    if (text2.length > 0) {
                        this.append(" " + text2[0].getText(), ORDINAL_ATTRIBUTES);
                    }
                }
                this.setBorder(null);
            }

            protected boolean shouldPaintBackground() {
                return false;
            }

            @Nullable
            private String findPrevFile(@NotNull JTable table, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (row <= 0) {
                    return null;
                }
                Object prev = table.getValueAt(row - 1, column);
                if (!(prev instanceof FindPopupItem)) {
                    return null;
                }
                UsagePresentation presentation2 = ((FindPopupItem)prev).getPresentation();
                if (presentation2 == null) {
                    return null;
                }
                return presentation2.getFileString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "table";
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customizeCellRenderer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findPrevFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private static final int MARGIN = 2;

        private UsageTableCellRenderer() {
            if (ExperimentalUI.isNewUI()) {
                PopupUtil.configListRendererFixedHeight((SelectablePanel)this);
                RendererPanelsUtilsKt.resetHorizontalInsets((JComponent[])new JComponent[]{this.myUsageRenderer});
                Insets ipad = this.myFileAndLineNumber.getIpad();
                this.myFileAndLineNumber.setIpad(new Insets(ipad.top, JBUI.scale(4), ipad.bottom, 0));
            } else {
                this.setBorder(JBUI.Borders.empty(2, 2, 2, 0));
            }
            this.myUsageRenderer.setOpaque(false);
            this.myFileAndLineNumber.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.myUsageRenderer, "Center");
            this.add((Component)this.myFileAndLineNumber, "East");
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JPanel.AccessibleJPanel(){

                    @Override
                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.UNKNOWN;
                    }

                    @Override
                    public AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet stateSet = new AccessibleStateSet();
                        stateSet.addAll(myUsageRenderer.getAccessibleContext().getAccessibleStateSet().toArray());
                        stateSet.addAll(myFileAndLineNumber.getAccessibleContext().getAccessibleStateSet().toArray());
                        return stateSet;
                    }

                    @Override
                    public int getAccessibleIndexInParent() {
                        return 0;
                    }

                    @Override
                    public int getAccessibleChildrenCount() {
                        return 0;
                    }

                    @Override
                    public Accessible getAccessibleChild(int i2) {
                        return null;
                    }
                };
            }
            return this.accessibleContext;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myUsageRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.myFileAndLineNumber.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(UsageTableCellRenderer.getBackgroundColor(table, value));
            this.setSelectionColor(isSelected ? RenderingUtil.getBackground(table, true) : null);
            this.getAccessibleContext().setAccessibleName(FindBundle.message("find.popup.found.element.accesible.name", this.myUsageRenderer.getAccessibleContext().getAccessibleName(), this.myFileAndLineNumber.getAccessibleContext().getAccessibleName()));
            return this;
        }

        @Nullable
        private static Color getBackgroundColor(JTable table, Object value) {
            UsagePresentation presentation2;
            if (value instanceof FindPopupItem && (presentation2 = ((FindPopupItem)value).getPresentation()) != null) {
                return presentation2.getBackgroundColor();
            }
            return RenderingUtil.getBackground(table, false);
        }
    }

    private class MySwitchContextToggleAction
    extends ToggleAction
    implements DumbAware {
        MySwitchContextToggleAction(FindModel.SearchContext context2) {
            if (context2 == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(0);
            }
            super(FindInProjectUtil.getPresentableName(context2));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(1);
            }
            return Objects.equals(FindPopupPanel.this.mySelectedContextName, this.getTemplatePresentation().getText());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(3);
            }
            if (state) {
                FindPopupPanel.this.mySelectedContextName = this.getTemplatePresentation().getText();
                FindPopupPanel.this.myFilterContextButton.repaint();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$MySwitchContextToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySwitchContextToggleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

