/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindInProjectSearchEngine;
import com.intellij.find.FindModel;
import com.intellij.find.TextSearchService;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class IdeaIndexBasedFindInProjectSearchEngine
implements FindInProjectSearchEngine {
    @NotNull
    public FindInProjectSearchEngine.FindInProjectSearcher createSearcher(@NotNull FindModel findModel, @NotNull Project project2) {
        if (findModel == null) {
            IdeaIndexBasedFindInProjectSearchEngine.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            IdeaIndexBasedFindInProjectSearchEngine.$$$reportNull$$$0(1);
        }
        return new MyFindInProjectSearcher(project2, findModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "findModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/find/impl/IdeaIndexBasedFindInProjectSearchEngine";
        objectArray[2] = "createSearcher";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyFindInProjectSearcher
    implements FindInProjectSearchEngine.FindInProjectSearcher {
        @NotNull
        private final ProjectFileIndex myFileIndex;
        @NotNull
        private final Project myProject;
        @NotNull
        private final FindModel myFindModel;
        @NotNull
        private final TextSearchService myTextSearchService;
        private final boolean myHasTrigrams;
        private final String myStringToFindInIndices;

        MyFindInProjectSearcher(@NotNull Project project2, @NotNull FindModel findModel) {
            if (project2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myFindModel = findModel;
            this.myFileIndex = ProjectFileIndex.getInstance(this.myProject);
            this.myTextSearchService = TextSearchService.getInstance();
            String stringToFind = findModel.getStringToFind();
            if (findModel.isRegularExpressions()) {
                stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, project2);
            }
            this.myStringToFindInIndices = stringToFind;
            this.myHasTrigrams = MyFindInProjectSearcher.hasTrigrams(this.myStringToFindInIndices);
        }

        @NotNull
        public Collection<VirtualFile> searchForOccurrences() {
            Collection collection = ReadAction.nonBlocking(this::doSearchForOccurrences).withDocumentsCommitted(this.myProject).executeSynchronously();
            if (collection == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public Collection<VirtualFile> doSearchForOccurrences() {
            String stringToFind = MyFindInProjectSearcher.getStringToFindInIndexes(this.myFindModel, this.myProject);
            if (stringToFind.isEmpty() || DumbService.getInstance(this.myProject).isDumb() && !FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
                return Collections.emptySet();
            }
            ArrayList hits = new ArrayList();
            GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope(FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel), this.myProject);
            ThrowableComputable findTextComputable = () -> this.myTextSearchService.processFilesWithText(stringToFind, Processors.cancelableCollectProcessor(hits), scope);
            TextSearchService.TextSearchResult result2 = (TextSearchService.TextSearchResult)DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(findTextComputable);
            if (result2 != TextSearchService.TextSearchResult.NO_TRIGRAMS) {
                return Collections.unmodifiableCollection(hits);
            }
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)this.myProject);
            CacheManager cacheManager = CacheManager.getInstance((Project)this.myProject);
            return (Collection)DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> {
                HashSet resultFiles = new HashSet();
                helper.processCandidateFilesForText(scope, (short)255, this.myFindModel.isCaseSensitive(), stringToFind, file2 -> {
                    ContainerUtil.addIfNotNull(resultFiles, file2);
                    return true;
                });
                VirtualFile[] filesWithWord = cacheManager.getVirtualFilesWithWord(stringToFind, (short)255, scope, this.myFindModel.isCaseSensitive());
                Collections.addAll(resultFiles, filesWithWord);
                return Collections.unmodifiableCollection(resultFiles);
            });
        }

        public boolean isReliable() {
            if (DumbService.isDumb(this.myProject)) {
                return false;
            }
            if (this.myFindModel.getCustomScope() instanceof LocalSearchScope) {
                return false;
            }
            if (this.myHasTrigrams) {
                return true;
            }
            return this.myFindModel.isWholeWordsOnly() && this.myStringToFindInIndices.indexOf(36) < 0 && !StringUtil.getWordsIn(this.myStringToFindInIndices).isEmpty();
        }

        public boolean isCovered(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(3);
            }
            return this.myHasTrigrams && this.isCoveredByIndex(file2) && (this.myFileIndex.isInContent(file2) || this.myFileIndex.isInLibrary(file2));
        }

        private boolean isCoveredByIndex(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(4);
            }
            return this.myTextSearchService.isInSearchableScope(file2);
        }

        private static boolean hasTrigrams(@NotNull String text2) {
            if (text2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(5);
            }
            return !TrigramBuilder.getTrigrams(text2).isEmpty();
        }

        @NotNull
        private static String getStringToFindInIndexes(@NotNull FindModel findModel, @NotNull Project project2) {
            if (findModel == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(6);
            }
            if (project2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(7);
            }
            String stringToFind = findModel.getStringToFind();
            if (findModel.isRegularExpressions()) {
                stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, project2);
            }
            String string2 = stringToFind;
            if (string2 == null) {
                MyFindInProjectSearcher.$$$reportNull$$$0(8);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/IdeaIndexBasedFindInProjectSearchEngine$MyFindInProjectSearcher";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/IdeaIndexBasedFindInProjectSearchEngine$MyFindInProjectSearcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "searchForOccurrences";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringToFindInIndexes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isCovered";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isCoveredByIndex";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hasTrigrams";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getStringToFindInIndexes";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 8 -> new IllegalStateException(string2);
            };
        }
    }
}

