/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;

final class PreserveCaseUtil {
    private PreserveCaseUtil() {
    }

    static String replaceWithCaseRespect(String toReplace, String foundString) {
        char replacementChar;
        if (foundString.isEmpty() || toReplace.isEmpty()) {
            return toReplace;
        }
        StringBuilder buffer = new StringBuilder();
        char firstChar = foundString.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            buffer.append(Character.toUpperCase(toReplace.charAt(0)));
        } else {
            buffer.append(Character.toLowerCase(toReplace.charAt(0)));
        }
        if (toReplace.length() == 1) {
            return buffer.toString();
        }
        if (foundString.length() == 1) {
            buffer.append(toReplace.substring(1));
            return buffer.toString();
        }
        boolean isReplacementLowercase = true;
        boolean isReplacementUppercase = true;
        for (int i2 = 1; i2 < toReplace.length() && (!Character.isLetter(replacementChar = toReplace.charAt(i2)) || (isReplacementLowercase &= Character.isLowerCase(replacementChar)) || (isReplacementUppercase &= Character.isUpperCase(replacementChar))); ++i2) {
        }
        boolean isTailUpper = true;
        boolean isTailLower = true;
        boolean isTailChecked = false;
        for (int i3 = 1; i3 < foundString.length(); ++i3) {
            char foundChar = foundString.charAt(i3);
            if (!Character.isLetter(foundChar)) continue;
            isTailChecked = true;
            if (!(isTailUpper &= Character.isUpperCase(foundChar)) && !(isTailLower &= Character.isLowerCase(foundChar))) break;
        }
        if (!isTailChecked) {
            isTailUpper = Character.isLetter(firstChar) && Character.isUpperCase(firstChar);
            boolean bl = isTailLower = Character.isLetter(firstChar) && Character.isLowerCase(firstChar);
        }
        if (isTailUpper && (isReplacementLowercase || !isReplacementUppercase)) {
            buffer.append(StringUtil.toUpperCase(toReplace.substring(1)));
        } else if (isTailLower && (isReplacementLowercase || isReplacementUppercase)) {
            buffer.append(StringUtil.toLowerCase(toReplace.substring(1)));
        } else {
            buffer.append(toReplace.substring(1));
        }
        return buffer.toString();
    }

    public static String applyCase(@NonNls String found2, @NonNls String replacement) {
        if (found2.isEmpty() || replacement.isEmpty()) {
            return replacement;
        }
        List<String> words = PreserveCaseUtil.collectWords(found2);
        if (words.isEmpty()) {
            return replacement;
        }
        StringBuilder result2 = new StringBuilder();
        int index2 = 0;
        int start = -1;
        int length = replacement.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = replacement.charAt(i2);
            if (Character.isLetterOrDigit(c2)) {
                if (start >= 0) continue;
                start = i2;
                continue;
            }
            if (start >= 0) {
                PreserveCaseUtil.buildWord(replacement.substring(start, i2), PreserveCaseUtil.analyze(words.get(index2)), result2);
                start = -1;
                if (index2 < words.size() - 1) {
                    ++index2;
                }
            }
            result2.append(c2);
        }
        if (start >= 0) {
            PreserveCaseUtil.buildWord(replacement.substring(start), PreserveCaseUtil.analyze(words.get(index2)), result2);
        }
        return result2.toString();
    }

    private static WordCase analyze(String word2) {
        boolean upperCase = true;
        boolean lowerCase = true;
        boolean capitalized = true;
        int length = word2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = word2.charAt(i2);
            if (!Character.isLetter(c2)) continue;
            boolean u = Character.isUpperCase(c2);
            boolean l = Character.isLowerCase(c2);
            if (upperCase && lowerCase) {
                capitalized = u;
            }
            upperCase &= u;
            lowerCase &= l;
        }
        return new WordCase(upperCase, lowerCase, capitalized);
    }

    private static List<String> collectWords(String string2) {
        boolean prevIsWordChar = false;
        SmartList<String> result2 = new SmartList<String>();
        StringBuilder word2 = new StringBuilder();
        int length = string2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = string2.charAt(i2);
            if (Character.isLetterOrDigit(c2)) {
                if (!prevIsWordChar) {
                    prevIsWordChar = true;
                }
                word2.append(c2);
                continue;
            }
            if (!prevIsWordChar) continue;
            result2.add(word2.toString());
            word2.setLength(0);
            prevIsWordChar = false;
        }
        if (!word2.isEmpty()) {
            result2.add(word2.toString());
        }
        return result2;
    }

    private static void buildWord(@NonNls String word2, WordCase foundCase, StringBuilder result2) {
        if (foundCase.upperCase && foundCase.lowerCase) {
            result2.append(word2);
            return;
        }
        WordCase replacementCase = PreserveCaseUtil.analyze(word2);
        if (foundCase.upperCase) {
            if (replacementCase.upperCase) {
                result2.append(word2);
            } else {
                result2.append(word2.toUpperCase(Locale.getDefault()));
            }
        } else {
            boolean prevIsWordChar = false;
            int length = word2.length();
            for (int i2 = 0; i2 < length; ++i2) {
                char c2 = word2.charAt(i2);
                if (Character.isLetter(c2)) {
                    if (!prevIsWordChar) {
                        result2.append(foundCase.lowerCase || !foundCase.capitalized ? StringUtil.toLowerCase(c2) : StringUtil.toUpperCase(c2));
                        prevIsWordChar = true;
                        continue;
                    }
                    result2.append(replacementCase.upperCase ? StringUtil.toLowerCase(c2) : c2);
                    continue;
                }
                prevIsWordChar = Character.isDigit(c2);
                result2.append(c2);
            }
        }
    }

    private record WordCase(boolean upperCase, boolean lowerCase, boolean capitalized) {
    }
}

