/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindUsagesCollector;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExHelpPopup
extends JPanel {
    private static final Logger LOG = Logger.getInstance(RegExHelpPopup.class);

    public RegExHelpPopup() {
        String text2;
        this.setLayout(new BorderLayout());
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setEditorKit(HTMLEditorKitBuilder.simple());
        editorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        editorPane.setBackground(HintUtil.getInformationColor());
        try (InputStream stream = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("messages/RegExHelpPopup.html"));){
            text2 = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            LOG.error(e2);
            text2 = LangBundle.message("text.failed.to.load.help.page", e2.getMessage());
        }
        editorPane.setText(text2.replace("LABEL_BACKGROUND", ColorUtil.toHtmlColor(UIUtil.getLabelBackground())));
        editorPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        editorPane.setCaretPosition(0);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)editorPane);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    public static LinkLabel<?> createRegExLink(@NotNull @NlsContexts.LinkLabel String title, @Nullable Component owner) {
        if (title == null) {
            RegExHelpPopup.$$$reportNull$$$0(0);
        }
        return RegExHelpPopup.createRegExLink(title, owner, null);
    }

    @NotNull
    public static LinkLabel<?> createRegExLink(@NotNull @NlsContexts.LinkLabel String title, @Nullable Component owner, @Nullable String place) {
        if (title == null) {
            RegExHelpPopup.$$$reportNull$$$0(1);
        }
        Runnable action2 = RegExHelpPopup.createRegExLinkRunnable(owner);
        return new LinkLabel(title, null, (aSource, aLinkData) -> {
            FindUsagesCollector.triggerRegexHelpClicked(place);
            action2.run();
        });
    }

    @NotNull
    public static Runnable createRegExLinkRunnable(final @Nullable Component owner) {
        return new Runnable(){
            JBPopup helpPopup;

            @Override
            public void run() {
                if (this.helpPopup != null && !this.helpPopup.isDisposed() && this.helpPopup.isVisible()) {
                    return;
                }
                RegExHelpPopup content2 = new RegExHelpPopup();
                ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content2, (JComponent)content2);
                this.helpPopup = builder2.setCancelOnClickOutside(false).setBelongsToGlobalPopupStack(true).setFocusable(true).setRequestFocus(true).setMovable(true).setResizable(true).setCancelOnOtherWindowOpen(false).setCancelButton((IconButton)new MinimizeButton(LangBundle.message("tooltip.hide", new Object[0]))).setTitle(LangBundle.message("popup.title.regular.expressions.syntax", new Object[0])).setDimensionServiceKey(null, "RegExHelpPopup", true).createPopup();
                Disposer.register((Disposable)this.helpPopup, () -> this.destroyPopup());
                if (owner != null) {
                    this.helpPopup.showInCenterOf(owner);
                } else {
                    this.helpPopup.showInFocusCenter();
                }
            }

            private void destroyPopup() {
                this.helpPopup = null;
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size(600, 300);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/impl/RegExHelpPopup", "createRegExLink"));
    }
}

