/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PositionTracker;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreview
implements SearchResults.SearchResultsListener,
SelectionListener,
DocumentListener,
EditorColorsListener {
    private static final Key<RangeHighlighter> IN_SELECTION_KEY = Key.create("LivePreview.IN_SELECTION_KEY");
    private final Disposable myDisposable;
    private boolean mySuppressedUpdate;
    private static final Key<Boolean> MARKER_USED = Key.create("LivePreview.MARKER_USED");
    private static final Key<Boolean> SEARCH_MARKER = Key.create("LivePreview.SEARCH_MARKER");
    public static PrintStream ourTestOutput;
    private String myReplacementPreviewText;
    private static boolean NotFound;
    private final List<RangeHighlighter> myHighlighters;
    private RangeHighlighter myCursorHighlighter;
    private VisibleAreaListener myVisibleAreaListener;
    private Delegate myDelegate;
    private final SearchResults mySearchResults;
    private Balloon myReplacementBalloon;

    public void selectionChanged(@NotNull SelectionEvent e) {
        if (e == null) {
            LivePreview.$$$reportNull$$$0(0);
        }
        this.updateInSelectionHighlighters();
    }

    public static void processNotFound() {
        NotFound = true;
    }

    @Override
    public void searchResultsUpdated(@NotNull SearchResults sr) {
        if (sr == null) {
            LivePreview.$$$reportNull$$$0(1);
        }
        if (this.mySuppressedUpdate) {
            this.mySuppressedUpdate = false;
            return;
        }
        this.highlightUsages();
        this.updateCursorHighlighting();
    }

    private void dumpState() {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTestOutput != null) {
            this.dumpEditorMarkupAndSelection(ourTestOutput);
        }
    }

    private void dumpEditorMarkupAndSelection(PrintStream dumpStream) {
        dumpStream.println(this.mySearchResults.getFindModel());
        if (this.myReplacementPreviewText != null) {
            dumpStream.println("--");
            dumpStream.println("Replacement Preview: " + this.myReplacementPreviewText);
        }
        dumpStream.println("--");
        Editor editor2 = this.mySearchResults.getEditor();
        RangeHighlighter[] highlighters = editor2.getMarkupModel().getAllHighlighters();
        Arrays.sort(highlighters, Segment.BY_START_OFFSET_THEN_END_OFFSET);
        ArrayList<Pair<Integer, Character>> ranges2 = new ArrayList<Pair<Integer, Character>>();
        for (RangeHighlighter highlighter : highlighters) {
            ranges2.add(new Pair<Integer, Character>(highlighter.getStartOffset(), Character.valueOf('[')));
            ranges2.add(new Pair<Integer, Character>(highlighter.getEndOffset(), Character.valueOf(']')));
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (selectionModel.getSelectionStart() != selectionModel.getSelectionEnd()) {
            ranges2.add(new Pair<Integer, Character>(selectionModel.getSelectionStart(), Character.valueOf('<')));
            ranges2.add(new Pair<Integer, Character>(selectionModel.getSelectionEnd(), Character.valueOf('>')));
        }
        ranges2.add(new Pair<Integer, Character>(-1, Character.valueOf('\n')));
        ranges2.add(new Pair<Integer, Character>(editor2.getDocument().getTextLength() + 1, Character.valueOf('\n')));
        ContainerUtil.sort(ranges2, (pair, pair2) -> {
            int res = (Integer)pair.first - (Integer)pair2.first;
            if (res == 0) {
                Character c1 = (Character)pair.second;
                Character c2 = (Character)pair2.second;
                if (c1.charValue() == '<' && c2.charValue() == '[') {
                    return 1;
                }
                if (c1.charValue() == '[' && c2.charValue() == '<') {
                    return -1;
                }
                return c1.compareTo(c2);
            }
            return res;
        });
        Document document = editor2.getDocument();
        for (int i2 = 0; i2 < ranges2.size() - 1; ++i2) {
            Pair pair3 = (Pair)ranges2.get(i2);
            Pair pair1 = (Pair)ranges2.get(i2 + 1);
            dumpStream.print(pair3.second + document.getText(TextRange.create(Math.max((Integer)pair3.first, 0), Math.min((Integer)pair1.first, document.getTextLength()))));
        }
        dumpStream.println("\n--");
        if (NotFound) {
            dumpStream.println("Not Found");
            dumpStream.println("--");
            NotFound = false;
        }
        for (RangeHighlighter highlighter : highlighters) {
            dumpStream.println(highlighter + " : " + highlighter.getTextAttributes(editor2.getColorsScheme()));
        }
        dumpStream.println("------------");
    }

    private void clearUnusedHighlighters() {
        this.myHighlighters.removeIf(h -> {
            if (h.getUserData(MARKER_USED) == null) {
                this.removeHighlighterWithDependent((RangeHighlighter)h);
                return true;
            }
            h.putUserData(MARKER_USED, null);
            return false;
        });
    }

    private void removeHighlighterWithDependent(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            LivePreview.$$$reportNull$$$0(2);
        }
        this.removeHighlighter(highlighter);
        RangeHighlighter additionalHighlighter = (RangeHighlighter)highlighter.getUserData(IN_SELECTION_KEY);
        if (additionalHighlighter != null) {
            this.removeHighlighter(additionalHighlighter);
        }
    }

    @Override
    public void cursorMoved() {
        this.updateInSelectionHighlighters();
        this.updateCursorHighlighting();
    }

    @Override
    public void updateFinished() {
        this.dumpState();
    }

    private void updateCursorHighlighting() {
        this.hideBalloon();
        if (this.myCursorHighlighter != null) {
            this.removeHighlighter(this.myCursorHighlighter);
            this.myCursorHighlighter = null;
        }
        FindResult cursor = this.mySearchResults.getCursor();
        Editor editor2 = this.mySearchResults.getEditor();
        if (cursor != null && cursor.getEndOffset() <= editor2.getDocument().getTextLength()) {
            Color color = editor2.getColorsScheme().getColor(EditorColors.CARET_COLOR);
            this.myCursorHighlighter = this.addHighlighter(cursor.getStartOffset(), cursor.getEndOffset(), new TextAttributes(null, null, color, EffectType.ROUNDED_BOX, 0));
            editor2.getScrollingModel().runActionOnScrollingFinished(() -> this.showReplacementPreview());
        }
    }

    public LivePreview(@NotNull SearchResults searchResults) {
        if (searchResults == null) {
            LivePreview.$$$reportNull$$$0(3);
        }
        this.myDisposable = Disposer.newDisposable("livePreview");
        this.mySuppressedUpdate = false;
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.mySearchResults = searchResults;
        this.searchResultsUpdated(searchResults);
        searchResults.addListener(this);
        EditorUtil.addBulkSelectionListener((Editor)this.mySearchResults.getEditor(), (SelectionListener)this, (Disposable)this.myDisposable);
        ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable).subscribe(EditorColorsManager.TOPIC, this);
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate2) {
        this.myDelegate = delegate2;
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.highlightUsages();
        this.updateCursorHighlighting();
    }

    public void dispose() {
        this.hideBalloon();
        for (RangeHighlighter h : this.myHighlighters) {
            this.removeHighlighterWithDependent(h);
        }
        this.myHighlighters.clear();
        if (this.myCursorHighlighter != null) {
            this.removeHighlighter(this.myCursorHighlighter);
        }
        this.myCursorHighlighter = null;
        Disposer.dispose(this.myDisposable);
        this.mySearchResults.removeListener(this);
    }

    private void highlightUsages() {
        List<Object> newHighlighters = this.mySearchResults.getMatchesCount() < this.mySearchResults.getMatchesLimit() ? this.addNewHighlighters() : Collections.emptyList();
        this.clearUnusedHighlighters();
        this.myHighlighters.addAll(newHighlighters);
        this.updateInSelectionHighlighters();
    }

    private List<RangeHighlighter> addNewHighlighters() {
        List<FindResult> occurrences = this.mySearchResults.getOccurrences();
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>(occurrences.size());
        for (FindResult range : occurrences) {
            if (range.getEndOffset() > this.mySearchResults.getEditor().getDocument().getTextLength()) continue;
            TextAttributes attributes = this.createAttributes(range);
            RangeHighlighter existingHighlighter = this.findExistingHighlighter(range.getStartOffset(), range.getEndOffset(), attributes);
            if (existingHighlighter == null) {
                RangeHighlighter highlighter = this.addHighlighter(range.getStartOffset(), range.getEndOffset(), attributes);
                if (highlighter == null) continue;
                highlighter.putUserData(SEARCH_MARKER, (Object)Boolean.TRUE);
                newHighlighters.add(highlighter);
                continue;
            }
            existingHighlighter.putUserData(MARKER_USED, (Object)Boolean.TRUE);
        }
        return newHighlighters;
    }

    private TextAttributes createAttributes(FindResult range) {
        EditorColorsScheme colorsScheme = this.mySearchResults.getEditor().getColorsScheme();
        if (this.mySearchResults.isExcluded(range)) {
            return new TextAttributes(null, null, colorsScheme.getDefaultForeground(), EffectType.STRIKEOUT, 0);
        }
        TextAttributes attributes = colorsScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        if (range.getLength() == 0) {
            attributes = attributes.clone();
            attributes.setEffectType(EffectType.BOXED);
            attributes.setEffectColor(attributes.getBackgroundColor());
        }
        return attributes;
    }

    private RangeHighlighter findExistingHighlighter(int startOffset, int endOffset, TextAttributes attributes) {
        MarkupModelEx markupModel = (MarkupModelEx)this.mySearchResults.getEditor().getMarkupModel();
        RangeHighlighter[] existing = new RangeHighlighter[1];
        markupModel.processRangeHighlightersOverlappingWith(startOffset, startOffset, highlighter -> {
            if (highlighter.getUserData(SEARCH_MARKER) != null && highlighter.getStartOffset() == startOffset && highlighter.getEndOffset() == endOffset && Objects.equals(highlighter.getTextAttributes(this.mySearchResults.getEditor().getColorsScheme()), attributes)) {
                existing[0] = highlighter;
                return false;
            }
            return true;
        });
        return existing[0];
    }

    private void updateInSelectionHighlighters() {
        SelectionModel selectionModel = this.mySearchResults.getEditor().getSelectionModel();
        int[] starts = selectionModel.getBlockSelectionStarts();
        int[] ends = selectionModel.getBlockSelectionEnds();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            RangeHighlighter inSelectionHighlighter;
            if (!highlighter.isValid()) continue;
            boolean needsAdditionalHighlighting = false;
            FindResult cursor = this.mySearchResults.getCursor();
            if (cursor == null || highlighter.getStartOffset() != cursor.getStartOffset() || highlighter.getEndOffset() != cursor.getEndOffset()) {
                for (int i2 = 0; i2 < starts.length; ++i2) {
                    TextRange selectionRange = new TextRange(starts[i2], ends[i2]);
                    boolean bl = needsAdditionalHighlighting = selectionRange.intersects(highlighter.getStartOffset(), highlighter.getEndOffset()) && selectionRange.getEndOffset() != highlighter.getStartOffset() && highlighter.getEndOffset() != selectionRange.getStartOffset();
                    if (needsAdditionalHighlighting) break;
                }
            }
            if ((inSelectionHighlighter = (RangeHighlighter)highlighter.getUserData(IN_SELECTION_KEY)) != null) {
                if (needsAdditionalHighlighting) continue;
                this.removeHighlighter(inSelectionHighlighter);
                continue;
            }
            if (!needsAdditionalHighlighting) continue;
            RangeHighlighter additionalHighlighter = this.addHighlighter(highlighter.getStartOffset(), highlighter.getEndOffset(), new TextAttributes(null, null, Color.WHITE, EffectType.ROUNDED_BOX, 0));
            highlighter.putUserData(IN_SELECTION_KEY, (Object)additionalHighlighter);
        }
    }

    private void showReplacementPreview() {
        this.hideBalloon();
        if (!this.mySearchResults.isUpToDate()) {
            return;
        }
        FindResult cursor = this.mySearchResults.getCursor();
        Editor editor2 = this.mySearchResults.getEditor();
        FindModel findModel = this.mySearchResults.getFindModel();
        if (this.myDelegate != null && cursor != null && findModel.isReplaceState() && findModel.isRegularExpressions()) {
            String replacementPreviewText;
            try {
                replacementPreviewText = this.myDelegate.getStringToReplace(editor2, cursor);
            }
            catch (FindManager.MalformedReplacementStringException e) {
                return;
            }
            if (replacementPreviewText == null) {
                return;
            }
            if (!replacementPreviewText.equals(findModel.getStringToReplace()) || Registry.is("ide.find.show.replacement.hint.for.simple.regexp")) {
                this.showBalloon(editor2, replacementPreviewText);
            }
        }
    }

    private void showBalloon(Editor editor2, @NotNull @NlsSafe String replacementPreviewText) {
        if (replacementPreviewText == null) {
            LivePreview.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myReplacementPreviewText = replacementPreviewText;
            return;
        }
        this.myReplacementBalloon = UsagePreviewPanel.buildReplacementPreviewBalloon((String)replacementPreviewText);
        EditorUtil.disposeWithEditor((Editor)editor2, (Disposable)this.myReplacementBalloon);
        this.myReplacementBalloon.show((PositionTracker)new ReplacementBalloonPositionTracker(editor2), Balloon.Position.below);
    }

    private void hideBalloon() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myReplacementPreviewText = null;
            return;
        }
        if (this.myReplacementBalloon != null) {
            this.myReplacementBalloon.hide();
            this.myReplacementBalloon = null;
        }
        this.removeVisibleAreaListener();
    }

    private void removeVisibleAreaListener() {
        if (this.myVisibleAreaListener != null) {
            this.mySearchResults.getEditor().getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
            this.myVisibleAreaListener = null;
        }
    }

    private RangeHighlighter addHighlighter(int startOffset, int endOffset, @NotNull TextAttributes attributes) {
        Project project2;
        if (attributes == null) {
            LivePreview.$$$reportNull$$$0(5);
        }
        if ((project2 = this.mySearchResults.getProject()) == null || project2.isDisposed()) {
            return null;
        }
        ArrayList sink = new ArrayList();
        HighlightManager.getInstance((Project)project2).addRangeHighlight(this.mySearchResults.getEditor(), startOffset, endOffset, attributes, false, sink);
        RangeHighlighter result2 = (RangeHighlighter)ContainerUtil.getFirstItem(sink);
        if (result2 instanceof RangeHighlighterEx) {
            ((RangeHighlighterEx)result2).setVisibleIfFolded(true);
        }
        return result2;
    }

    private void removeHighlighter(@NotNull RangeHighlighter highlighter) {
        Project project2;
        if (highlighter == null) {
            LivePreview.$$$reportNull$$$0(6);
        }
        if ((project2 = this.mySearchResults.getProject()) == null || project2.isDisposed()) {
            return;
        }
        HighlightManager.getInstance((Project)project2).removeSegmentHighlighter(this.mySearchResults.getEditor(), highlighter);
    }

    private static void requestBalloonHiding(Balloon balloon) {
        ApplicationManager.getApplication().invokeLater(() -> balloon.hide());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sr";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementPreviewText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/impl/livePreview/LivePreview";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "searchResultsUpdated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHighlighterWithDependent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showBalloon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHighlighter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Delegate {
        @NlsSafe
        @Nullable
        public String getStringToReplace(@NotNull Editor var1, @Nullable FindResult var2) throws FindManager.MalformedReplacementStringException;
    }

    private class ReplacementBalloonPositionTracker
    extends PositionTracker<Balloon> {
        private final Editor myEditor;

        ReplacementBalloonPositionTracker(Editor editor2) {
            super(editor2.getContentComponent());
            this.myEditor = editor2;
        }

        @Override
        public RelativePoint recalculateLocation(@NotNull Balloon balloon) {
            FindResult cursor;
            if (balloon == null) {
                ReplacementBalloonPositionTracker.$$$reportNull$$$0(0);
            }
            if ((cursor = LivePreview.this.mySearchResults.getCursor()) == null) {
                return null;
            }
            FindResult cur = cursor;
            int startOffset = cur.getStartOffset();
            int endOffset = cur.getEndOffset();
            if (endOffset > this.myEditor.getDocument().getTextLength()) {
                if (!balloon.isDisposed()) {
                    LivePreview.requestBalloonHiding(balloon);
                }
                return null;
            }
            if (!SearchResults.insideVisibleArea(this.myEditor, (TextRange)cur)) {
                LivePreview.requestBalloonHiding(balloon);
                LivePreview.this.removeVisibleAreaListener();
                LivePreview.this.myVisibleAreaListener = arg_0 -> this.lambda$recalculateLocation$0((TextRange)cur, arg_0);
                this.myEditor.getScrollingModel().addVisibleAreaListener(LivePreview.this.myVisibleAreaListener);
            }
            Point startPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(startOffset));
            Point endPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(endOffset));
            Point point = new Point((startPoint.x + endPoint.x) / 2, startPoint.y + this.myEditor.getLineHeight());
            return new RelativePoint(this.myEditor.getContentComponent(), point);
        }

        private /* synthetic */ void lambda$recalculateLocation$0(TextRange cur, VisibleAreaEvent e) {
            if (SearchResults.insideVisibleArea(this.myEditor, cur)) {
                LivePreview.this.showReplacementPreview();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/find/impl/livePreview/LivePreview$ReplacementBalloonPositionTracker", "recalculateLocation"));
        }
    }
}

