/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.livePreview.SelectionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchResults
implements DocumentListener,
CaretListener {
    private final List<SearchResultsListener> myListeners;
    @Nullable
    private FindResult myCursor;
    @NotNull
    private List<FindResult> myOccurrences;
    private final Set<RangeMarker> myExcluded;
    @NotNull
    private final Editor myEditor;
    private final Project myProject;
    private FindModel myFindModel;
    private int myMatchesLimit;
    private boolean myNotFoundState;
    private boolean myDisposed;
    private int myStamp;
    private int myLastUpdatedStamp;
    private long myDocumentTimestamp;
    private boolean myUpdating;
    private Direction myPendingSearch;
    private final Stack<Pair<FindModel, FindResult>> myCursorPositions;
    private final SelectionManager mySelectionManager;

    public int getStamp() {
        return ++this.myStamp;
    }

    @Override
    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            SearchResults.$$$reportNull$$$0(0);
        }
        this.myCursorPositions.clear();
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Caret caret;
        if (event == null) {
            SearchResults.$$$reportNull$$$0(1);
        }
        if ((caret = event.getCaret()) != null && this.myEditor.getCaretModel().getCaretCount() == 1) {
            int offset2 = caret.getOffset();
            FindResult occurrenceAtCaret = this.getOccurrenceAtCaret();
            if (occurrenceAtCaret != null && occurrenceAtCaret != this.myCursor) {
                this.moveCursorTo(occurrenceAtCaret, false, false);
                this.myEditor.getCaretModel().moveToOffset(offset2);
                if (this.myFindModel.isGlobal()) {
                    this.myEditor.getSelectionModel().removeSelection();
                }
                this.notifyCursorMoved();
            }
        }
    }

    public SearchResults(@NotNull Editor editor2, Project project2) {
        if (editor2 == null) {
            SearchResults.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOccurrences = new ArrayList<FindResult>();
        this.myExcluded = new HashSet<RangeMarker>();
        this.myMatchesLimit = 100;
        this.myLastUpdatedStamp = -1;
        this.myCursorPositions = new Stack();
        this.myEditor = editor2;
        this.myProject = project2;
        this.myEditor.getDocument().addDocumentListener(this);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this);
        this.mySelectionManager = new SelectionManager(this);
    }

    private void setNotFoundState(boolean isForward) {
        this.myNotFoundState = true;
        FindModel findModel = new FindModel();
        findModel.copyFrom(this.myFindModel);
        findModel.setForward(isForward);
        FindUtil.processNotFound(this.myEditor, findModel.getStringToFind(), findModel, this.getProject());
    }

    public int getMatchesCount() {
        return this.myOccurrences.size();
    }

    public boolean hasMatches() {
        return !this.getOccurrences().isEmpty();
    }

    public FindModel getFindModel() {
        return this.myFindModel;
    }

    public boolean isExcluded(FindResult occurrence) {
        for (RangeMarker rangeMarker : this.myExcluded) {
            if (!TextRange.areSegmentsEqual(rangeMarker, (Segment)occurrence)) continue;
            return true;
        }
        return false;
    }

    public void exclude(FindResult occurrence) {
        boolean include = false;
        for (RangeMarker rangeMarker : this.myExcluded) {
            if (!TextRange.areSegmentsEqual(rangeMarker, (Segment)occurrence)) continue;
            this.myExcluded.remove(rangeMarker);
            rangeMarker.dispose();
            include = true;
            break;
        }
        if (!include) {
            this.myExcluded.add(this.myEditor.getDocument().createRangeMarker(occurrence.getStartOffset(), occurrence.getEndOffset(), true));
        }
        this.notifyChanged();
    }

    public Set<RangeMarker> getExcluded() {
        return this.myExcluded;
    }

    public void addListener(@NotNull SearchResultsListener srl) {
        if (srl == null) {
            SearchResults.$$$reportNull$$$0(3);
        }
        this.myListeners.add(srl);
    }

    public void removeListener(@NotNull SearchResultsListener srl) {
        if (srl == null) {
            SearchResults.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(srl);
    }

    public int getMatchesLimit() {
        return this.myMatchesLimit;
    }

    public void setMatchesLimit(int matchesLimit) {
        this.myMatchesLimit = matchesLimit;
    }

    @Nullable
    public FindResult getCursor() {
        return this.myCursor;
    }

    public int getCursorVisualIndex() {
        FindResult occurrenceAtCaret = this.getOccurrenceAtCaret();
        return occurrenceAtCaret != null ? this.myOccurrences.indexOf(occurrenceAtCaret) + 1 : -1;
    }

    @NotNull
    public List<FindResult> getOccurrences() {
        List<FindResult> list2 = this.myOccurrences;
        if (list2 == null) {
            SearchResults.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.myEditor;
        if (editor2 == null) {
            SearchResults.$$$reportNull$$$0(6);
        }
        return editor2;
    }

    public void clear() {
        this.searchCompleted(new ArrayList<FindResult>(), this.getEditor(), null, false, null, this.getStamp());
    }

    ActionCallback updateThreadSafe(@NotNull FindModel findModel, boolean toChangeSelection, @Nullable TextRange next2, int stamp) {
        if (findModel == null) {
            SearchResults.$$$reportNull$$$0(7);
        }
        if (this.myDisposed) {
            return ActionCallback.DONE;
        }
        ActionCallback result2 = new ActionCallback();
        Editor editor2 = this.getEditor();
        this.updatePreviousFindModel(findModel);
        FutureResult startsRef = new FutureResult();
        FutureResult endsRef = new FutureResult();
        SearchResults.getSelection(editor2, (FutureResult<int[]>)startsRef, (FutureResult<int[]>)endsRef);
        ArrayList results = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            Project project2 = this.getProject();
            if (this.myDisposed || project2 != null && project2.isDisposed()) {
                return;
            }
            int[] starts = new int[]{};
            int[] ends = new int[]{};
            try {
                starts = (int[])startsRef.get();
                ends = (int[])endsRef.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            if (starts.length == 0 || findModel.isGlobal()) {
                this.findInRange(new TextRange(0, Integer.MAX_VALUE), editor2, findModel, results);
            } else {
                for (int i2 = 0; i2 < starts.length; ++i2) {
                    this.findInRange(new TextRange(starts[i2], ends[i2]), editor2, findModel, results);
                }
            }
            long documentTimeStamp = editor2.getDocument().getModificationStamp();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (editor2.getDocument().getModificationStamp() == documentTimeStamp) {
                    this.searchCompleted(results, editor2, findModel, toChangeSelection, next2, stamp);
                    result2.setDone();
                } else {
                    result2.setRejected();
                }
            });
        });
        return result2;
    }

    private void updatePreviousFindModel(@NotNull FindModel model2) {
        FindModel prev;
        if (model2 == null) {
            SearchResults.$$$reportNull$$$0(8);
        }
        if ((prev = FindManager.getInstance((Project)this.getProject()).getPreviousFindModel()) == null) {
            prev = new FindModel();
        }
        if (!model2.getStringToFind().isEmpty()) {
            prev.copyFrom(model2);
            FindManager.getInstance((Project)this.getProject()).setPreviousFindModel(prev);
        }
    }

    private static void getSelection(Editor editor2, FutureResult<int[]> starts, FutureResult<int[]> ends) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            SelectionModel selection = editor2.getSelectionModel();
            starts.set((Object)selection.getBlockSelectionStarts());
            ends.set((Object)selection.getBlockSelectionEnds());
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    SelectionModel selection = editor2.getSelectionModel();
                    starts.set((Object)selection.getBlockSelectionStarts());
                    ends.set((Object)selection.getBlockSelectionEnds());
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    private void findInRange(@NotNull TextRange range, @NotNull Editor editor2, @NotNull FindModel findModel, @NotNull List<? super FindResult> results) {
        if (range == null) {
            SearchResults.$$$reportNull$$$0(9);
        }
        if (editor2 == null) {
            SearchResults.$$$reportNull$$$0(10);
        }
        if (findModel == null) {
            SearchResults.$$$reportNull$$$0(11);
        }
        if (results == null) {
            SearchResults.$$$reportNull$$$0(12);
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        CharSequence charSequence = editor2.getDocument().getImmutableCharSequence();
        int offset2 = range.getStartOffset();
        int maxOffset = Math.min(range.getEndOffset(), charSequence.length());
        FindManager findManager = FindManager.getInstance((Project)this.getProject());
        while (offset2 < maxOffset) {
            int newOffset;
            FindResult result2;
            try {
                CharSequence bombedCharSequence = StringUtil.newBombedCharSequence(charSequence, 3000L);
                result2 = findManager.findString(bombedCharSequence, offset2, findModel, virtualFile2);
                ((StringUtil.BombedCharSequence)bombedCharSequence).defuse();
            }
            catch (ProcessCanceledException | PatternSyntaxException e) {
                result2 = null;
            }
            if (result2 == null || !result2.isStringFound() || (newOffset = result2.getEndOffset()) > maxOffset) break;
            offset2 = offset2 == newOffset ? ++offset2 : newOffset;
            results.add((FindResult)result2);
        }
    }

    public void dispose() {
        this.myDisposed = true;
        this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
        this.myEditor.getDocument().removeDocumentListener(this);
    }

    private void searchCompleted(@NotNull List<FindResult> occurrences, @NotNull Editor editor2, @Nullable FindModel findModel, boolean toChangeSelection, @Nullable TextRange next2, int stamp) {
        if (occurrences == null) {
            SearchResults.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            SearchResults.$$$reportNull$$$0(14);
        }
        if (stamp < this.myLastUpdatedStamp) {
            return;
        }
        this.myLastUpdatedStamp = stamp;
        if (editor2 != this.getEditor() || this.myDisposed || editor2.isDisposed()) {
            return;
        }
        this.setUpdating(false);
        this.myOccurrences = occurrences;
        FindResult oldCursorRange = this.myCursor;
        this.myOccurrences.sort(Comparator.comparingInt(TextRange::getStartOffset));
        this.myFindModel = findModel;
        this.myDocumentTimestamp = this.myEditor.getDocument().getModificationStamp();
        this.updateCursor((TextRange)oldCursorRange, next2);
        this.updateExcluded();
        this.notifyChanged();
        if (this.myCursor == null || !this.myCursor.equals((Object)oldCursorRange)) {
            if (toChangeSelection) {
                this.updateSelection(true, true, true);
            }
            this.notifyCursorMoved();
        }
        this.notifyUpdateFinished();
        Direction dir = this.myPendingSearch;
        if (dir != null && next2 == null) {
            if (dir == Direction.DOWN) {
                this.nextOccurrence(false);
            } else {
                this.prevOccurrence(false);
            }
        }
        this.myPendingSearch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection(boolean removePreviousSelection, boolean removeAllPreviousSelections, boolean adjustScrollPosition) {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.beforeSelectionUpdate();
        }
        try {
            this.mySelectionManager.updateSelection(removePreviousSelection, removeAllPreviousSelections, adjustScrollPosition);
        }
        finally {
            for (SearchResultsListener listener2 : this.myListeners) {
                listener2.afterSelectionUpdate();
            }
        }
    }

    private void notifyUpdateFinished() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.updateFinished();
        }
    }

    private void updateExcluded() {
        HashSet<RangeMarker> invalid = new HashSet<RangeMarker>();
        for (RangeMarker marker : this.myExcluded) {
            if (marker.isValid()) continue;
            invalid.add(marker);
            marker.dispose();
        }
        this.myExcluded.removeAll(invalid);
    }

    private void updateCursor(@Nullable TextRange oldCursorRange, @Nullable TextRange next2) {
        boolean justReplaced = next2 != null;
        boolean toPush = true;
        if ((justReplaced || (toPush = !this.repairCursorFromStack())) && (justReplaced || !this.tryToRepairOldCursor(oldCursorRange))) {
            if (this.myFindModel != null) {
                if (oldCursorRange != null && !this.myFindModel.isGlobal()) {
                    this.myCursor = this.firstOccurrenceAfterOffset(oldCursorRange.getEndOffset());
                } else if (justReplaced) {
                    this.nextOccurrence(false, next2, false, true, false);
                } else {
                    this.myCursor = oldCursorRange == null ? this.firstOccurrenceAtOrAfterCaret() : this.firstOccurrenceAfterCaret();
                }
            } else {
                this.myCursor = null;
            }
        }
        if (!justReplaced && this.myCursor == null && this.hasMatches()) {
            this.nextOccurrence(true, oldCursorRange, false, false, false);
        }
        if (toPush && this.myCursor != null) {
            this.push();
        }
    }

    private boolean repairCursorFromStack() {
        if (this.myCursorPositions.size() >= 2) {
            FindResult newCursor;
            Pair oldPosition = (Pair)this.myCursorPositions.get(this.myCursorPositions.size() - 2);
            if (((FindModel)oldPosition.first).equals((Object)this.myFindModel) && (newCursor = this.findOccurrenceEqualTo((FindResult)oldPosition.second)) != null) {
                this.myCursorPositions.pop();
                this.myCursor = newCursor;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private FindResult findOccurrenceEqualTo(FindResult occurrence) {
        for (FindResult findResult : this.myOccurrences) {
            if (!findResult.equals((Object)occurrence)) continue;
            return findResult;
        }
        return null;
    }

    @Nullable
    private FindResult firstOccurrenceAtOrAfterCaret() {
        FindResult occurrence = this.getOccurrenceAtCaret();
        if (occurrence != null) {
            return occurrence;
        }
        occurrence = this.getFirstOccurrenceInSelection();
        if (occurrence != null) {
            return occurrence;
        }
        return this.firstOccurrenceAfterCaret();
    }

    @Nullable
    private FindResult getOccurrenceAtCaret() {
        int offset2 = this.getEditor().getCaretModel().getOffset();
        for (FindResult occurrence : this.myOccurrences) {
            if (offset2 > occurrence.getEndOffset() || offset2 < occurrence.getStartOffset()) continue;
            return occurrence;
        }
        return null;
    }

    @Nullable
    private FindResult getFirstOccurrenceInSelection() {
        int selectionStartOffset = this.getEditor().getSelectionModel().getSelectionStart();
        int selectionEndOffset = this.getEditor().getSelectionModel().getSelectionEnd();
        for (FindResult occurrence : this.myOccurrences) {
            if (selectionEndOffset < occurrence.getEndOffset() || selectionStartOffset > occurrence.getStartOffset()) continue;
            return occurrence;
        }
        return null;
    }

    private void notifyChanged() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.searchResultsUpdated(this);
        }
    }

    static boolean insideVisibleArea(Editor e, TextRange r) {
        int startOffset = r.getStartOffset();
        if (startOffset > e.getDocument().getTextLength()) {
            return false;
        }
        Rectangle visibleArea = e.getScrollingModel().getVisibleArea();
        Point point = e.logicalPositionToXY(e.offsetToLogicalPosition(startOffset));
        return visibleArea.contains(point);
    }

    @Nullable
    private FindResult firstOccurrenceBeforeCaret() {
        int offset2 = this.getEditor().getCaretModel().getOffset();
        return this.firstOccurrenceBeforeOffset(offset2);
    }

    @Nullable
    private FindResult firstOccurrenceBeforeOffset(int offset2) {
        for (int i2 = this.getOccurrences().size() - 1; i2 >= 0; --i2) {
            if (this.getOccurrences().get(i2).getEndOffset() >= offset2) continue;
            return this.getOccurrences().get(i2);
        }
        return null;
    }

    @Nullable
    private FindResult firstOccurrenceAfterCaret() {
        int caret = this.myEditor.getCaretModel().getOffset();
        return this.firstOccurrenceAfterOffset(caret);
    }

    @Nullable
    private FindResult firstOccurrenceAfterOffset(int offset2) {
        FindResult afterCaret = null;
        for (FindResult occurrence : this.getOccurrences()) {
            if (occurrence.getStartOffset() < offset2 || occurrence.getEndOffset() <= offset2 || afterCaret != null && occurrence.getStartOffset() >= afterCaret.getStartOffset()) continue;
            afterCaret = occurrence;
        }
        return afterCaret;
    }

    private boolean tryToRepairOldCursor(@Nullable TextRange oldCursorRange) {
        if (oldCursorRange == null) {
            return false;
        }
        FindResult mayBeOldCursor = null;
        for (FindResult searchResult : this.getOccurrences()) {
            if (searchResult.intersects(oldCursorRange)) {
                mayBeOldCursor = searchResult;
            }
            if (searchResult.getStartOffset() != oldCursorRange.getStartOffset()) continue;
            break;
        }
        if (mayBeOldCursor != null) {
            this.myCursor = mayBeOldCursor;
            return true;
        }
        return false;
    }

    @Nullable
    private FindResult prevOccurrence(TextRange range) {
        for (int i2 = this.getOccurrences().size() - 1; i2 >= 0; --i2) {
            FindResult occurrence = this.getOccurrences().get(i2);
            if (occurrence.getEndOffset() > range.getStartOffset()) continue;
            return occurrence;
        }
        return null;
    }

    @Nullable
    private FindResult nextOccurrence(TextRange range) {
        for (FindResult occurrence : this.getOccurrences()) {
            if (occurrence.getStartOffset() < range.getEndOffset()) continue;
            return occurrence;
        }
        return null;
    }

    public void prevOccurrence(boolean findSelected) {
        if (findSelected) {
            this.myCursor = this.mySelectionManager.removeCurrentSelection() ? this.firstOccurrenceAtOrAfterCaret() : null;
            this.notifyCursorMoved();
        } else {
            if (this.myFindModel == null) {
                this.myPendingSearch = Direction.UP;
                return;
            }
            boolean processFromTheBeginning = false;
            if (this.myNotFoundState) {
                this.myNotFoundState = false;
                processFromTheBeginning = true;
            }
            FindResult next2 = null;
            if (!this.myFindModel.isGlobal()) {
                if (this.myCursor != null) {
                    next2 = this.prevOccurrence((TextRange)this.myCursor);
                }
            } else {
                next2 = this.firstOccurrenceBeforeCaret();
            }
            if (next2 == null) {
                if (processFromTheBeginning) {
                    if (this.hasMatches()) {
                        next2 = this.getOccurrences().get(this.getOccurrences().size() - 1);
                    }
                } else {
                    this.setNotFoundState(false);
                }
            }
            this.moveCursorTo(next2, false, true);
        }
        this.push();
    }

    private void push() {
        this.myCursorPositions.push(Pair.create(this.myFindModel, this.myCursor));
    }

    public void nextOccurrence(boolean retainOldSelection) {
        if (this.myFindModel == null) {
            this.myPendingSearch = Direction.DOWN;
            return;
        }
        this.nextOccurrence(false, (TextRange)this.myCursor, true, false, retainOldSelection);
        this.push();
    }

    private void nextOccurrence(boolean processFromTheBeginning, TextRange cursor, boolean toNotify, boolean justReplaced, boolean retainOldSelection) {
        FindResult next2;
        if (this.myNotFoundState) {
            this.myNotFoundState = false;
            processFromTheBeginning = true;
        }
        if ((next2 = (!this.myFindModel.isGlobal() || justReplaced) && cursor != null ? this.nextOccurrence(cursor) : this.firstOccurrenceAfterCaret()) == null) {
            if (processFromTheBeginning) {
                if (this.hasMatches()) {
                    next2 = this.getOccurrences().get(0);
                }
            } else {
                this.setNotFoundState(true);
            }
        }
        if (toNotify) {
            this.moveCursorTo(next2, retainOldSelection, true);
        } else {
            this.myCursor = next2;
        }
    }

    private void moveCursorTo(FindResult next2, boolean retainOldSelection, boolean adjustScrollPosition) {
        if (next2 != null && !this.mySelectionManager.isSelected(next2)) {
            boolean bl = this.myCursor != null && this.mySelectionManager.isSelected(this.myCursor);
            this.myCursor = next2;
            this.updateSelection(!(retainOldSelection &= bl), false, adjustScrollPosition);
            this.notifyCursorMoved();
        }
    }

    private void notifyCursorMoved() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.cursorMoved();
            listener2.searchResultsUpdated(this);
        }
    }

    public boolean isUpToDate() {
        return this.myDocumentTimestamp == this.myEditor.getDocument().getModificationStamp();
    }

    void setUpdating(boolean value) {
        this.myUpdating = value;
    }

    public boolean isUpdating() {
        return this.myUpdating;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srl";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/livePreview/SearchResults";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/livePreview/SearchResults";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadSafe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePreviousFindModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findInRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "searchCompleted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }

    public static enum Direction {
        UP,
        DOWN;

    }

    public static interface SearchResultsListener {
        public void searchResultsUpdated(@NotNull SearchResults var1);

        public void cursorMoved();

        default public void updateFinished() {
        }

        default public void beforeSelectionUpdate() {
        }

        default public void afterSelectionUpdate() {
        }
    }
}

