/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectionManager {
    @NotNull
    private final SearchResults mySearchResults;
    private final boolean myHadSelectionInitially;
    private final List<FoldRegion> myRegionsToRestore;

    public SelectionManager(@NotNull SearchResults results) {
        if (results == null) {
            SelectionManager.$$$reportNull$$$0(0);
        }
        this.myRegionsToRestore = new ArrayList<FoldRegion>();
        this.mySearchResults = results;
        this.myHadSelectionInitially = results.getEditor().getSelectionModel().hasSelection();
    }

    public void updateSelection(boolean removePreviousSelection, boolean removeAllPreviousSelections, boolean adjustScrollPosition) {
        Editor editor2 = this.mySearchResults.getEditor();
        if (removeAllPreviousSelections) {
            editor2.getCaretModel().removeSecondaryCarets();
        }
        FindModel findModel = this.mySearchResults.getFindModel();
        FindResult cursor = this.mySearchResults.getCursor();
        if (cursor == null) {
            if (removePreviousSelection && !this.myHadSelectionInitially && findModel.isGlobal()) {
                editor2.getSelectionModel().removeSelection();
            }
            return;
        }
        if (findModel.isGlobal()) {
            if (removePreviousSelection || removeAllPreviousSelections) {
                FoldingModel foldingModel = editor2.getFoldingModel();
                FoldRegion[] allRegions = editor2.getFoldingModel().getAllFoldRegions();
                foldingModel.runBatchFoldingOperation(() -> {
                    for (FoldRegion region : this.myRegionsToRestore) {
                        if (!region.isValid()) continue;
                        region.setExpanded(false);
                    }
                    this.myRegionsToRestore.clear();
                    for (FoldRegion region : allRegions) {
                        if (!region.isValid() || !cursor.intersects((Segment)region) || region.isExpanded()) continue;
                        region.setExpanded(true);
                        this.myRegionsToRestore.add(region);
                    }
                });
                editor2.getCaretModel().moveToOffset(cursor.getEndOffset());
                editor2.getSelectionModel().setSelection(cursor.getStartOffset(), cursor.getEndOffset());
                EditorSearchSession.logSelectionUpdate();
            } else {
                FindUtil.selectSearchResultInEditor(editor2, cursor, -1);
            }
            if (adjustScrollPosition) {
                editor2.getScrollingModel().scrollToCaret(ScrollType.CENTER_CENTER);
            }
        } else if (!SearchResults.insideVisibleArea(editor2, (TextRange)cursor) && adjustScrollPosition) {
            LogicalPosition pos = editor2.offsetToLogicalPosition(cursor.getStartOffset());
            editor2.getScrollingModel().scrollTo(pos, ScrollType.CENTER_CENTER);
        }
    }

    public boolean removeCurrentSelection() {
        Editor editor2 = this.mySearchResults.getEditor();
        CaretModel caretModel = editor2.getCaretModel();
        Caret primaryCaret = caretModel.getPrimaryCaret();
        if (caretModel.getCaretCount() > 1) {
            caretModel.removeCaret(primaryCaret);
            return true;
        }
        primaryCaret.moveToOffset(primaryCaret.getSelectionStart());
        primaryCaret.removeSelection();
        return false;
    }

    public boolean isSelected(@NotNull FindResult result2) {
        if (result2 == null) {
            SelectionManager.$$$reportNull$$$0(1);
        }
        Editor editor2 = this.mySearchResults.getEditor();
        int endOffset = result2.getEndOffset();
        for (Caret caret : editor2.getCaretModel().getAllCarets()) {
            if (caret.getOffset() != endOffset) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/impl/livePreview/SelectionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

