/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.usages.impl;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.DefaultUsageSearchParameters;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.find.usages.impl.PlainTextUsage;
import com.intellij.find.usages.symbol.SearchTargetSymbol;
import com.intellij.find.usages.symbol.SymbolSearchTargetFactory;
import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.impl.TextSearchKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.Usage;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a(\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\fH\u0000\"\u0018\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"SYMBOL_SEARCH_TARGET_EXTENSION", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/find/usages/symbol/SymbolSearchTargetFactory;", "textSearchContexts", "", "Lcom/intellij/model/search/SearchContext;", "buildQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/Usage;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "buildUsageViewQuery", "Lcom/intellij/usages/Usage;", "searchTargets", "", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "symbolSearchTarget", "symbol", "Lcom/intellij/model/Symbol;", "symbolSearchTargets", "targetSymbols", "", "hasTextSearchStrings", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\ncom/intellij/find/usages/impl/ImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1611#2:111\n1855#2:112\n1856#2:114\n1612#2:115\n1620#2,3:116\n1#3:113\n*S KotlinDebug\n*F\n+ 1 impl.kt\ncom/intellij/find/usages/impl/ImplKt\n*L\n32#1:111\n32#1:112\n32#1:114\n32#1:115\n86#1:116,3\n32#1:113\n*E\n"})
public final class ImplKt {
    @NotNull
    private static final ClassExtension<SymbolSearchTargetFactory<?>> SYMBOL_SEARCH_TARGET_EXTENSION = new ClassExtension("com.intellij.lang.symbolSearchTarget");
    @NotNull
    private static final Set<SearchContext> textSearchContexts;

    @ApiStatus.Internal
    @NotNull
    public static final List<SearchTarget> searchTargets(@NotNull PsiFile file2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Collection<Symbol> targetSymbols = TargetsKt.targetSymbols(file2, offset2);
        if (targetSymbols.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        return ImplKt.symbolSearchTargets(project2, targetSymbols);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SearchTarget> symbolSearchTargets(@NotNull Project project2, @NotNull Collection<? extends Symbol> targetSymbols) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(targetSymbols, (String)"targetSymbols");
        Iterable iterable = targetSymbols;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SearchTarget it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Symbol it = (Symbol)element$iv;
            boolean bl2 = false;
            if (ImplKt.symbolSearchTarget(project2, it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return CollectionsKt.toList((Iterable)((Iterable)var3_3));
    }

    @ApiStatus.Internal
    @Nullable
    public static final SearchTarget symbolSearchTarget(@NotNull Project project2, @NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        for (SymbolSearchTargetFactory factory2 : SYMBOL_SEARCH_TARGET_EXTENSION.forKey(symbol.getClass())) {
            Intrinsics.checkNotNull((Object)factory2, (String)"null cannot be cast to non-null type com.intellij.find.usages.symbol.SymbolSearchTargetFactory<com.intellij.model.Symbol>");
            SymbolSearchTargetFactory factory_ = factory2;
            SearchTarget target2 = factory_.searchTarget(project2, symbol);
            if (target2 == null) continue;
            return target2;
        }
        if (symbol instanceof SearchTargetSymbol) {
            return ((SearchTargetSymbol)symbol).getSearchTarget();
        }
        if (symbol instanceof SearchTarget) {
            return (SearchTarget)((Object)symbol);
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Query<? extends Usage> buildUsageViewQuery(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull AllSearchOptions allOptions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        Query query2 = ImplKt.buildQuery(project2, target2, allOptions).transforming(arg_0 -> ImplKt.buildUsageViewQuery$lambda$1(buildUsageViewQuery.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(query2, (String)"buildQuery(project, targ\u2026    emptyList()\n    }\n  }");
        return query2;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final Query<? extends com.intellij.find.usages.api.Usage> buildQuery(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull AllSearchOptions allOptions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)allOptions, (String)"allOptions");
        ArrayList queries = new ArrayList();
        UsageOptions options2 = allOptions.component1();
        Boolean textSearch = allOptions.component2();
        if (options2.isUsages()) {
            Collection collection = queries;
            SearchService searchService = SearchService.getInstance();
            SearchScope searchScope2 = options2.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"options.searchScope");
            collection.add(searchService.searchParameters((SearchParameters)new DefaultUsageSearchParameters(project2, target2, searchScope2)));
        }
        if (Intrinsics.areEqual((Object)textSearch, (Object)true)) {
            Iterable $this$mapTo$iv = target2.getTextSearchRequests();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void searchRequest;
                SearchRequest searchRequest2 = (SearchRequest)item$iv;
                Collection collection = queries;
                boolean bl = false;
                SearchScope searchScope3 = options2.getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)searchScope3, (String)"options.searchScope");
                collection.add(TextSearchKt.buildTextUsageQuery(project2, (SearchRequest)searchRequest, searchScope3, textSearchContexts).mapping(arg_0 -> ImplKt.buildQuery$lambda$3$lambda$2(buildQuery.1.1.INSTANCE, arg_0)));
            }
        }
        Query query2 = SearchService.getInstance().merge((List)queries);
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"getInstance().merge(queries)");
        return query2;
    }

    public static final boolean hasTextSearchStrings(@NotNull SearchTarget $this$hasTextSearchStrings) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTextSearchStrings, (String)"<this>");
        return !$this$hasTextSearchStrings.getTextSearchRequests().isEmpty();
    }

    private static final Collection buildUsageViewQuery$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Collection)$tmp0.invoke(p0);
    }

    private static final PlainTextUsage buildQuery$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PlainTextUsage)$tmp0.invoke(p0);
    }

    static {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)SearchContext.IN_COMMENTS, (Enum)SearchContext.IN_STRINGS, (Enum)SearchContext.IN_PLAIN_TEXT);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(\n  SearchContext.IN_C\u2026chContext.IN_PLAIN_TEXT\n)");
        textSearchContexts = enumSet;
    }
}

