/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.CodeStyleBundle;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingStateId;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormattingProgressTask
extends SequentialModalProgressTask
implements FormattingProgressCallback {
    private static final double MAX_PROGRESS_VALUE = 1.0;
    private static final double TOTAL_WEIGHT = Arrays.stream(FormattingStateId.values()).mapToDouble(FormattingStateId::getProgressWeight).sum();
    private final WeakReference<VirtualFile> myFile;
    private final WeakReference<Document> myDocument;
    private final int myFileTextLength;
    @NotNull
    private FormattingStateId myLastState;
    private long myDocumentModificationStampBefore;
    private int myBlocksToModifyNumber;
    private int myModifiedBlocksNumber;

    public FormattingProgressTask(@Nullable Project project2, @NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(0);
        }
        if (document == null) {
            FormattingProgressTask.$$$reportNull$$$0(1);
        }
        super(project2, FormattingProgressTask.getTitle(file2));
        this.myLastState = FormattingStateId.WRAPPING_BLOCKS;
        this.myDocumentModificationStampBefore = -1L;
        this.myFile = new WeakReference<VirtualFile>(file2.getVirtualFile());
        this.myDocument = new WeakReference<Document>(document);
        this.myFileTextLength = file2.getTextLength();
    }

    @NotNull
    @NlsContexts.DialogTitle
    private static String getTitle(@NotNull PsiFile file2) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(2);
        }
        if ((virtualFile2 = file2.getOriginalFile().getVirtualFile()) == null) {
            String string2 = CodeStyleBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
            if (string2 == null) {
                FormattingProgressTask.$$$reportNull$$$0(3);
            }
            return string2;
        }
        String string3 = CodeStyleBundle.message((String)"reformat.progress.file.with.known.name.text", (Object[])new Object[]{virtualFile2.getName()});
        if (string3 == null) {
            FormattingProgressTask.$$$reportNull$$$0(4);
        }
        return string3;
    }

    @Override
    protected void prepare(@NotNull SequentialTask task2) {
        if (task2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(5);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            Document document = (Document)this.myDocument.get();
            if (document != null) {
                this.myDocumentModificationStampBefore = document.getModificationStamp();
            }
            task2.prepare();
        });
    }

    @Override
    public void onCancel() {
        this.cancelled();
    }

    @Override
    public void onThrowable(@NotNull Throwable error2) {
        if (error2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(6);
        }
        super.onThrowable(error2);
        this.cancelled();
    }

    public void afterWrappingBlock(@NotNull LeafBlockWrapper wrapped) {
        if (wrapped == null) {
            FormattingProgressTask.$$$reportNull$$$0(7);
        }
        this.update(FormattingStateId.WRAPPING_BLOCKS, 1.0 * (double)wrapped.getEndOffset() / (double)this.myFileTextLength);
    }

    public void afterProcessingBlock(@NotNull LeafBlockWrapper block) {
        if (block == null) {
            FormattingProgressTask.$$$reportNull$$$0(8);
        }
        this.update(FormattingStateId.PROCESSING_BLOCKS, 1.0 * (double)block.getEndOffset() / (double)this.myFileTextLength);
    }

    public void beforeApplyingFormatChanges(@NotNull Collection<LeafBlockWrapper> modifiedBlocks) {
        if (modifiedBlocks == null) {
            FormattingProgressTask.$$$reportNull$$$0(9);
        }
        this.myBlocksToModifyNumber = modifiedBlocks.size();
        this.updateTextIfNecessary(FormattingStateId.APPLYING_CHANGES);
        this.setCancelText(CodeStyleBundle.message((String)"action.stop", (Object[])new Object[0]));
    }

    public void afterApplyingChange(@NotNull LeafBlockWrapper block) {
        if (block == null) {
            FormattingProgressTask.$$$reportNull$$$0(10);
        }
        if (this.myModifiedBlocksNumber++ >= this.myBlocksToModifyNumber) {
            return;
        }
        this.update(FormattingStateId.APPLYING_CHANGES, 1.0 * (double)this.myModifiedBlocksNumber / (double)this.myBlocksToModifyNumber);
    }

    private void update(@NotNull FormattingStateId state, double completionRate) {
        double currentFraction;
        ProgressIndicator indicator;
        if (state == null) {
            FormattingProgressTask.$$$reportNull$$$0(11);
        }
        if ((indicator = this.getIndicator()) == null) {
            return;
        }
        this.updateTextIfNecessary(state);
        this.myLastState = state;
        double newFraction = 0.0;
        for (FormattingStateId prevState : state.getPreviousStates()) {
            newFraction += 1.0 * prevState.getProgressWeight() / TOTAL_WEIGHT;
        }
        if ((newFraction += completionRate * state.getProgressWeight() / TOTAL_WEIGHT) - (currentFraction = indicator.getFraction()) < 0.01) {
            return;
        }
        indicator.setFraction(newFraction);
    }

    private void updateTextIfNecessary(@NotNull FormattingStateId currentState) {
        if (currentState == null) {
            FormattingProgressTask.$$$reportNull$$$0(12);
        }
        ProgressIndicator indicator = this.getIndicator();
        if (this.myLastState != currentState && indicator != null) {
            indicator.setText(currentState.getDescription());
        }
    }

    public void cancelled() {
        CodeFormatterFacade.FORMATTING_CANCELLED_FLAG.set(true);
        VirtualFile file2 = (VirtualFile)this.myFile.get();
        Document document = (Document)this.myDocument.get();
        if (file2 == null || document == null || this.myDocumentModificationStampBefore < 0L) {
            return;
        }
        FileEditor editor2 = FileEditorManager.getInstance(this.myProject).getSelectedEditor(file2);
        if (editor2 == null) {
            return;
        }
        UndoManager manager = UndoManager.getInstance(this.myProject);
        while (manager.isUndoAvailable(editor2) && document.getModificationStamp() != this.myDocumentModificationStampBefore) {
            manager.undo(editor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/FormattingProgressTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedBlocks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/FormattingProgressTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onThrowable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "afterWrappingBlock";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "afterProcessingBlock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "beforeApplyingFormatChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "afterApplyingChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateTextIfNecessary";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

