/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.commandLine.FileSetCodeStyleProcessor;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.PlatformUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PROJECT_DIR_PREFIX", "", "PROJECT_DIR_SUFFIX", "RESULT_MESSAGE_BINARY_FILE", "RESULT_MESSAGE_DRY_FAIL", "RESULT_MESSAGE_DRY_OK", "RESULT_MESSAGE_FAILED", "RESULT_MESSAGE_NOT_SUPPORTED", "RESULT_MESSAGE_OK", "RESULT_MESSAGE_REJECTED_BY_FORMATTER", "createProject", "Lcom/intellij/openapi/project/Project;", "projectUID", "createProjectDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "isFormattingSupported", "", "Lcom/intellij/psi/PsiFile;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFileSetCodeStyleProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSetCodeStyleProcessor.kt\ncom/intellij/formatting/commandLine/FileSetCodeStyleProcessorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n1#2:269\n*E\n"})
public final class FileSetCodeStyleProcessorKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RESULT_MESSAGE_OK = "OK";
    @NotNull
    private static final String RESULT_MESSAGE_FAILED = "Failed";
    @NotNull
    private static final String RESULT_MESSAGE_NOT_SUPPORTED = "Skipped, not supported.";
    @NotNull
    private static final String RESULT_MESSAGE_REJECTED_BY_FORMATTER = "Skipped, rejected by formatter.";
    @NotNull
    private static final String RESULT_MESSAGE_BINARY_FILE = "Skipped, binary file.";
    @NotNull
    private static final String RESULT_MESSAGE_DRY_OK = "Formatted well";
    @NotNull
    private static final String RESULT_MESSAGE_DRY_FAIL = "Needs reformatting";
    @NotNull
    private static final String PROJECT_DIR_PREFIX;
    @NotNull
    private static final String PROJECT_DIR_SUFFIX = ".tmp";

    private static final Path createProjectDir(String projectUID) {
        Path path2;
        Path it = path2 = FileUtil.createTempDirectory(PROJECT_DIR_PREFIX, projectUID + PROJECT_DIR_SUFFIX).toPath().resolve(".idea");
        boolean bl = false;
        Files.createDirectories(it, new FileAttribute[0]);
        return path2;
    }

    private static final Project createProject(String projectUID) {
        Project project2;
        ProjectManagerEx projectManagerEx = ProjectManagerEx.Companion.getInstanceEx();
        Path path2 = FileSetCodeStyleProcessorKt.createProjectDir(projectUID);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createProjectDir(projectUID)");
        Project project3 = projectManagerEx.openProject(path2, new OpenProjectTask(false, null, true, false, 11, null));
        if (project3 == null) {
            throw new RuntimeException("Failed to create temporary project " + projectUID);
        }
        Project it = project2 = project3;
        boolean bl = false;
        CodeStyle.setMainProjectSettings((Project)it, (CodeStyleSettings)CodeStyleSettingsManager.getInstance().createSettings());
        return project2;
    }

    private static final boolean isFormattingSupported(PsiFile $this$isFormattingSupported) {
        FormattingService formattingService = FormattingServiceUtil.findService((PsiFile)$this$isFormattingSupported, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)formattingService, (String)"findService(this, true, true)");
        FormattingService formattingService2 = formattingService;
        return !(formattingService2 instanceof CoreFormattingService) || LanguageFormatting.INSTANCE.forContext((PsiElement)$this$isFormattingSupported) != null;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isFormattingSupported(PsiFile $receiver) {
        return FileSetCodeStyleProcessorKt.isFormattingSupported($receiver);
    }

    public static final /* synthetic */ Project access$createProject(String projectUID) {
        return FileSetCodeStyleProcessorKt.createProject(projectUID);
    }

    static {
        Logger logger = Logger.getInstance(FileSetCodeStyleProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(FileSetCodeStyleProcessor::class.java)");
        LOG = logger;
        PROJECT_DIR_PREFIX = PlatformUtils.getPlatformPrefix() + ".format.";
    }
}

