/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.formatting.contextConfiguration.SelectedTextFormatter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCodeFragmentFilter;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtilRt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CodeFragmentCodeStyleSettingsPanel
extends TabbedLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(CodeFragmentCodeStyleSettingsPanel.class);
    private final CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow mySettingsToShow;
    @NotNull
    private final LanguageCodeStyleSettingsProvider mySettingsProvider;
    private final SelectedTextFormatter mySelectedTextFormatter;
    private SpacesPanelWithoutPreview mySpacesPanel;
    private WrappingAndBracesPanelWithoutPreview myWrappingPanel;
    private Runnable mySomethingChangedCallback;

    CodeFragmentCodeStyleSettingsPanel(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow, @NotNull LanguageCodeStyleSettingsProvider settingsProvider, @NotNull SelectedTextFormatter selectedTextFormatter) {
        if (settings == null) {
            CodeFragmentCodeStyleSettingsPanel.$$$reportNull$$$0(0);
        }
        if (settingsToShow == null) {
            CodeFragmentCodeStyleSettingsPanel.$$$reportNull$$$0(1);
        }
        if (settingsProvider == null) {
            CodeFragmentCodeStyleSettingsPanel.$$$reportNull$$$0(2);
        }
        if (selectedTextFormatter == null) {
            CodeFragmentCodeStyleSettingsPanel.$$$reportNull$$$0(3);
        }
        super(settingsProvider.getLanguage(), settings, settings.clone());
        this.mySettingsToShow = settingsToShow;
        this.mySettingsProvider = settingsProvider;
        this.mySelectedTextFormatter = selectedTextFormatter;
        this.ensureTabs();
    }

    public void setOnSomethingChangedCallback(Runnable runnable) {
        this.mySomethingChangedCallback = runnable;
    }

    @Override
    protected void somethingChanged() {
        if (this.mySomethingChangedCallback != null) {
            this.mySomethingChangedCallback.run();
        }
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    protected void updatePreview(boolean useDefaultSample) {
    }

    @Override
    protected void initTabs(CodeStyleSettings settings) {
        SpacesPanelWithoutPreview panel2 = this.getSpacesPanel(settings);
        if (panel2 != null) {
            this.mySpacesPanel = panel2;
            this.addTab(this.mySpacesPanel);
        }
        this.myWrappingPanel = new WrappingAndBracesPanelWithoutPreview(settings);
        this.addTab(this.myWrappingPanel);
        this.reset(this.getSettings());
    }

    @Nullable
    private SpacesPanelWithoutPreview getSpacesPanel(CodeStyleSettings settings) {
        SpacesPanelWithoutPreview spacesPanel = new SpacesPanelWithoutPreview(settings);
        if (spacesPanel.hasSomethingToShow()) {
            return spacesPanel;
        }
        Disposer.dispose(spacesPanel);
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySpacesPanel != null ? this.mySpacesPanel.getPreferredFocusedComponent() : this.myWrappingPanel.getPreferredFocusedComponent();
    }

    public static boolean hasOptionsToShow(LanguageCodeStyleSettingsProvider provider2) {
        LanguageCodeStyleSettingsProvider.SettingsType[] types;
        for (LanguageCodeStyleSettingsProvider.SettingsType type : types = new LanguageCodeStyleSettingsProvider.SettingsType[]{LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS}) {
            if (provider2.getSupportedFields(type).isEmpty()) continue;
            return true;
        }
        return !provider2.getSupportedFields().isEmpty();
    }

    private void reformatSelectedTextWithNewSettings() {
        try {
            this.apply(this.getSettings());
        }
        catch (ConfigurationException e) {
            LOG.debug("Cannot apply code style settings", e);
        }
        CodeStyleSettings clonedSettings = this.getSettings().clone();
        this.mySelectedTextFormatter.reformatSelectedText(clonedSettings);
    }

    @NotNull
    private static CodeStyleSettingsCustomizable getFilteredSettingsConsumer(final @NotNull Collection<String> names, final @NotNull CodeStyleSettingsCustomizable original) {
        if (names == null) {
            CodeFragmentCodeStyleSettingsPanel.$$$reportNull$$$0(4);
        }
        if (original == null) {
            CodeFragmentCodeStyleSettingsPanel.$$$reportNull$$$0(5);
        }
        return new CodeStyleSettingsCustomizable(){

            @Override
            public void showAllStandardOptions() {
                original.showStandardOptions(ArrayUtilRt.toStringArray(names));
            }

            @Override
            public void showStandardOptions(String ... optionNames) {
                String[] toShowOptions = (String[])Arrays.stream(optionNames).filter(names::contains).toArray(String[]::new);
                original.showStandardOptions(toShowOptions);
            }

            @Override
            public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, Object ... options2) {
                if (settingsClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fieldName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (title == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (names.contains(fieldName)) {
                    original.showCustomOption(settingsClass, fieldName, title, groupName, options2);
                }
            }

            @Override
            public void renameStandardOption(@NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String newTitle) {
                if (fieldName == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (newTitle == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (names.contains(fieldName)) {
                    original.renameStandardOption(fieldName, newTitle);
                }
            }

            @Override
            public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @NonNls @Nullable String anchorFieldName, Object ... options2) {
                if (settingsClass == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (fieldName == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (title == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (names.contains(fieldName)) {
                    original.showCustomOption(settingsClass, fieldName, title, groupName, anchor, anchorFieldName, options2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settingsClass";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldName";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newTitle";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showCustomOption";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "renameStandardOption";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsToShow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedTextFormatter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilteredSettingsConsumer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SpacesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MySpacesPanel {
        private JPanel myPanel;

        SpacesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            if (settingNames.isEmpty()) {
                settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getOtherSetting();
            }
            CodeFragmentCodeStyleSettingsPanel.this.mySettingsProvider.customizeSettings(CodeFragmentCodeStyleSettingsPanel.getFilteredSettingsConsumer(settingNames, this), this.getSettingsType());
            this.initTables();
            this.myOptionsTree = this.createOptionsTree();
            this.myOptionsTree.setCellRenderer(new OptionTreeWithPreviewPanel.MyTreeCellRenderer());
            JBScrollPane pane = new JBScrollPane(this.myOptionsTree){

                public Dimension getMinimumSize() {
                    return super.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)pane);
            this.isFirstUpdate = false;
        }

        public boolean hasSomethingToShow() {
            return !this.myKeys.isEmpty();
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myOptionsTree;
        }
    }

    private class WrappingAndBracesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel {
        public JPanel myPanel;

        WrappingAndBracesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            if (settingNames.isEmpty()) {
                settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getOtherSetting();
            }
            this.initTables();
            Collection<String> fields = this.populateWithAssociatedFields(settingNames);
            fields.add("KEEP_LINE_BREAKS");
            CodeFragmentCodeStyleSettingsPanel.this.mySettingsProvider.customizeSettings(CodeFragmentCodeStyleSettingsPanel.getFilteredSettingsConsumer(settingNames, this), this.getSettingsType());
            this.myTreeTable = this.createOptionsTree(this.getSettings());
            JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

                public Dimension getMinimumSize() {
                    return WrappingAndBracesPanelWithoutPreview.this.myTreeTable.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)scrollPane);
            this.isFirstUpdate = false;
        }

        @NotNull
        private Collection<String> populateWithAssociatedFields(Collection<String> settingNames) {
            HashSet<String> commonFields = new HashSet<String>();
            for (String fieldName : settingNames) {
                WrappingAndBracesPanel.SettingsGroup settingsGroup = this.getAssociatedSettingsGroup(fieldName);
                if (settingsGroup == null) {
                    commonFields.add(fieldName);
                    continue;
                }
                if (Strings.areSameInstance(settingsGroup.title(), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP)) continue;
                commonFields.addAll(settingsGroup.commonCodeStyleSettingFieldNames());
            }
            HashSet<String> hashSet = commonFields;
            if (hashSet == null) {
                WrappingAndBracesPanelWithoutPreview.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTreeTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel$WrappingAndBracesPanelWithoutPreview", "populateWithAssociatedFields"));
        }
    }
}

