/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedFrameworkDetector<F extends Facet, C extends FacetConfiguration>
extends FrameworkDetector {
    private static final Logger LOG = Logger.getInstance(FacetBasedFrameworkDetector.class);

    protected FacetBasedFrameworkDetector(@NonNls String detectorId) {
        super(detectorId);
    }

    protected FacetBasedFrameworkDetector(@NonNls @NotNull String detectorId, int detectorVersion) {
        if (detectorId == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(0);
        }
        super(detectorId, detectorVersion);
    }

    @NotNull
    public abstract FacetType<F, C> getFacetType();

    @NotNull
    public List<Pair<C, Collection<VirtualFile>>> createConfigurations(@NotNull Collection<? extends VirtualFile> files2, @NotNull Collection<? extends C> existentFacetConfigurations) {
        C configuration;
        if (files2 == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(1);
        }
        if (existentFacetConfigurations == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(2);
        }
        if ((configuration = this.createConfiguration(files2)) != null) {
            List<Pair<C, Collection<VirtualFile>>> list2 = Collections.singletonList(Pair.create(configuration, files2));
            if (list2 == null) {
                FacetBasedFrameworkDetector.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<Pair<C, Collection<VirtualFile>>> list3 = Collections.emptyList();
        if (list3 == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @Nullable
    protected C createConfiguration(Collection<? extends VirtualFile> files2) {
        return (C)this.getFacetType().createDefaultConfiguration();
    }

    public void setupFacet(@NotNull F facet, ModifiableRootModel model2) {
        if (facet == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(5);
        }
    }

    @Override
    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<? extends VirtualFile> newFiles, @NotNull FrameworkDetectionContext context2) {
        if (newFiles == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(7);
        }
        return context2.createDetectedFacetDescriptions(this, newFiles);
    }

    @Override
    @NotNull
    public FrameworkType getFrameworkType() {
        FacetType<F, C> type = this.getFacetType();
        LOG.assertTrue(type != null, "'getFacetType' returns 'null' in " + this.getClass());
        FrameworkType frameworkType = FacetBasedFrameworkDetector.createFrameworkType(type);
        if (frameworkType == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(8);
        }
        return frameworkType;
    }

    static FrameworkType createFrameworkType(FacetType<?, ?> facetType) {
        return new FacetBasedFrameworkType(facetType);
    }

    @Override
    public FrameworkType getUnderlyingFrameworkType() {
        FacetTypeId underlyingTypeId = this.getFacetType().getUnderlyingFacetType();
        return underlyingTypeId != null ? FacetBasedFrameworkDetector.createFrameworkType(FacetTypeRegistry.getInstance().findFacetType(underlyingTypeId)) : null;
    }

    public boolean isSuitableUnderlyingFacetConfiguration(FacetConfiguration underlying, C configuration, Set<? extends VirtualFile> files2) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existentFacetConfigurations";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/FacetBasedFrameworkDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/FacetBasedFrameworkDetector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurations";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupFacet";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 8 -> new IllegalStateException(string2);
        };
    }

    private static class FacetBasedFrameworkType
    extends FrameworkType {
        private final FacetType<?, ?> myFacetType;

        FacetBasedFrameworkType(@NotNull FacetType<?, ?> facetType) {
            if (facetType == null) {
                FacetBasedFrameworkType.$$$reportNull$$$0(0);
            }
            super(facetType.getStringId());
            this.myFacetType = facetType;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            String string2 = this.myFacetType.getPresentableName();
            if (string2 == null) {
                FacetBasedFrameworkType.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.myFacetType.getIcon();
            Icon icon3 = icon2 != null ? icon2 : EmptyIcon.ICON_16;
            if (icon3 == null) {
                FacetBasedFrameworkType.$$$reportNull$$$0(2);
            }
            return icon3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facetType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/framework/detection/FacetBasedFrameworkDetector$FacetBasedFrameworkType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/framework/detection/FacetBasedFrameworkDetector$FacetBasedFrameworkType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2 -> new IllegalStateException(string2);
            };
        }
    }
}

