/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.XmlFileHeader;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public final class FileContentPattern
extends ObjectPattern<FileContent, FileContentPattern> {
    private FileContentPattern() {
        super(FileContent.class);
    }

    public static FileContentPattern fileContent() {
        return new FileContentPattern();
    }

    public FileContentPattern withName(final @NotNull String name) {
        if (name == null) {
            FileContentPattern.$$$reportNull$$$0(0);
        }
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withName"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context2) {
                if (fileContent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return name.equals(fileContent.getFileName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$1", "accepts"));
            }
        });
    }

    public FileContentPattern withName(final StringPattern namePattern) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withName"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context2) {
                if (fileContent == null) {
                    2.$$$reportNull$$$0(0);
                }
                return namePattern.accepts(fileContent.getFileName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$2", "accepts"));
            }
        });
    }

    public FileContentPattern inDirectory(final @NotNull String name) {
        if (name == null) {
            FileContentPattern.$$$reportNull$$$0(1);
        }
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("inDirectory"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context2) {
                if (fileContent == null) {
                    3.$$$reportNull$$$0(0);
                }
                return name.equals(fileContent.getFile().getParent().getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$3", "accepts"));
            }
        });
    }

    public FileContentPattern xmlWithRootTag(final @NotNull String rootTag) {
        if (rootTag == null) {
            FileContentPattern.$$$reportNull$$$0(2);
        }
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withRootTag"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context2) {
                if (fileContent == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    return rootTag.equals(FileContentPattern.parseHeaderWithException(CharArrayUtil.readerFromCharSequence(fileContent.getContentAsText())).getRootTagLocalName());
                }
                catch (IOException e) {
                    return false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$4", "accepts"));
            }
        });
    }

    public FileContentPattern xmlWithRootTagNamespace(String namespace) {
        return this.xmlWithRootTagNamespace((ElementPattern<String>)StandardPatterns.string().equalTo(namespace));
    }

    public FileContentPattern xmlWithRootTagNamespace(final ElementPattern<String> namespacePattern) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("xmlWithRootTagNamespace"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context2) {
                if (fileContent == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    String rootTagNamespace = FileContentPattern.parseHeaderWithException(CharArrayUtil.readerFromCharSequence(fileContent.getContentAsText())).getRootTagNamespace();
                    return rootTagNamespace != null && namespacePattern.accepts(rootTagNamespace, context2);
                }
                catch (IOException e) {
                    return false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$5", "accepts"));
            }
        });
    }

    @NotNull
    private static XmlFileHeader parseHeaderWithException(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            FileContentPattern.$$$reportNull$$$0(3);
        }
        XmlFileHeader xmlFileHeader = ParseXml.getInstance().parseHeaderWithException(reader);
        if (xmlFileHeader == null) {
            FileContentPattern.$$$reportNull$$$0(4);
        }
        return xmlFileHeader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/FileContentPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/FileContentPattern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHeaderWithException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "xmlWithRootTag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseHeaderWithException";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }

    public static interface ParseXml {
        @NotNull
        public XmlFileHeader parseHeaderWithException(@NotNull Reader var1);

        public static ParseXml getInstance() {
            return ApplicationManager.getApplication().getService(ParseXml.class);
        }
    }
}

