/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DetectedFrameworksData {
    private static final Logger LOG = Logger.getInstance(DetectedFrameworksData.class);
    private PersistentHashMap<String, IntSet> myExistentFrameworkFiles;
    private final MultiMap<String, DetectedFrameworkDescription> myDetectedFrameworks;
    private final Object myLock;

    public DetectedFrameworksData(@NotNull Project project2) {
        if (project2 == null) {
            DetectedFrameworksData.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myDetectedFrameworks = new MultiMap();
        Path file2 = ProjectUtil.getProjectCachePath((Project)project2, (Path)DetectedFrameworksData.getDetectionDirPath(), (boolean)true).resolve("files");
        try {
            this.myExistentFrameworkFiles = new PersistentHashMap<String, IntSet>(file2, EnumeratorStringDescriptor.INSTANCE, new TIntHashSetExternalizer());
        }
        catch (IOException e) {
            LOG.info(e);
            IOUtil.deleteAllFilesStartingWith(file2);
            try {
                this.myExistentFrameworkFiles = new PersistentHashMap<String, IntSet>(file2, EnumeratorStringDescriptor.INSTANCE, new TIntHashSetExternalizer());
            }
            catch (IOException e1) {
                LOG.error(e1);
            }
        }
    }

    public void saveDetected() {
        try {
            this.myExistentFrameworkFiles.close();
        }
        catch (IOException e) {
            LOG.info(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VirtualFile> retainNewFiles(@NotNull String detectorId, @NotNull Collection<? extends VirtualFile> files2) {
        if (detectorId == null) {
            DetectedFrameworksData.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            DetectedFrameworksData.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            IntSet existentFilesSet = null;
            try {
                existentFilesSet = this.myExistentFrameworkFiles.get(detectorId);
            }
            catch (IOException e) {
                LOG.info(e);
            }
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            for (VirtualFile virtualFile2 : files2) {
                int fileId = FileBasedIndex.getFileId((VirtualFile)virtualFile2);
                if (existentFilesSet != null && existentFilesSet.contains(fileId)) continue;
                newFiles.add(virtualFile2);
            }
            return newFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDetectorsForDetectedFrameworks() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<String>(this.myDetectedFrameworks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DetectedFrameworkDescription> updateFrameworksList(String detectorId, Collection<? extends DetectedFrameworkDescription> frameworks) {
        Object object = this.myLock;
        synchronized (object) {
            Collection<DetectedFrameworkDescription> oldFrameworks = this.myDetectedFrameworks.remove(detectorId);
            this.myDetectedFrameworks.putValues(detectorId, frameworks);
            if (oldFrameworks != null && !oldFrameworks.isEmpty() && !frameworks.isEmpty()) {
                return ContainerUtil.subtract(frameworks, oldFrameworks);
            }
            return frameworks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putExistentFrameworkFiles(String id, Collection<? extends VirtualFile> files2) {
        Object object = this.myLock;
        synchronized (object) {
            IntSet set2 = null;
            try {
                set2 = this.myExistentFrameworkFiles.get(id);
            }
            catch (IOException e) {
                LOG.info(e);
            }
            if (set2 == null) {
                set2 = new IntOpenHashSet();
                try {
                    this.myExistentFrameworkFiles.put(id, set2);
                }
                catch (IOException e) {
                    LOG.info(e);
                }
            }
            for (VirtualFile virtualFile2 : files2) {
                set2.add(FileBasedIndex.getFileId((VirtualFile)virtualFile2));
            }
        }
    }

    @NotNull
    private static Path getDetectionDirPath() {
        Path path2 = PathManagerEx.getAppSystemDir().resolve("frameworks").resolve("detection");
        if (path2 == null) {
            DetectedFrameworksData.$$$reportNull$$$0(3);
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/DetectedFrameworksData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/DetectedFrameworksData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectionDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "retainNewFiles";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }

    private static class TIntHashSetExternalizer
    implements DataExternalizer<IntSet> {
        private TIntHashSetExternalizer() {
        }

        @Override
        public void save(@NotNull DataOutput out, IntSet value) throws IOException {
            if (out == null) {
                TIntHashSetExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            IntIterator iterator2 = value.iterator();
            while (iterator2.hasNext()) {
                out.writeInt(iterator2.nextInt());
            }
        }

        @Override
        public IntSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                TIntHashSetExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            IntOpenHashSet set2 = new IntOpenHashSet(size);
            while (size-- > 0) {
                set2.add(in.readInt());
            }
            return set2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/framework/detection/impl/DetectedFrameworksData$TIntHashSetExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

