/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.impl.FacetBasedDetectedFrameworkDescriptionImpl;
import com.intellij.framework.detection.impl.FrameworkDetectionContextBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkDetectionContextImpl
extends FrameworkDetectionContextBase {
    private final Project myProject;

    public FrameworkDetectionContextImpl(@NotNull Project project2) {
        if (project2 == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public <F extends Facet, C extends FacetConfiguration> List<? extends DetectedFrameworkDescription> createDetectedFacetDescriptions(@NotNull FacetBasedFrameworkDetector<F, C> detector, @NotNull Collection<? extends VirtualFile> files2) {
        if (detector == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(2);
        }
        MultiMap<Module, VirtualFile> filesByModule = MultiMap.createSet();
        for (VirtualFile virtualFile2 : files2) {
            Module module2 = ModuleUtilCore.findModuleForFile(virtualFile2, this.myProject);
            if (module2 == null) continue;
            filesByModule.putValue(module2, virtualFile2);
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>> result2 = new ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>>();
        FacetType facetType = detector.getFacetType();
        FacetsProvider provider2 = DefaultFacetsProvider.INSTANCE;
        for (Module module3 : filesByModule.keySet()) {
            Collection facets = provider2.getFacetsByType(module3, facetType.getId());
            if (!facetType.isSuitableModuleType(ModuleType.get((Module)module3)) || facetType.isOnlyOneFacetAllowed() && !facets.isEmpty()) continue;
            ArrayList<FacetConfiguration> existentConfigurations = new ArrayList<FacetConfiguration>();
            for (Facet facet : facets) {
                existentConfigurations.add(facet.getConfiguration());
            }
            Collection moduleFiles = filesByModule.get(module3);
            List pairs = detector.createConfigurations(moduleFiles, existentConfigurations);
            for (Pair pair : pairs) {
                result2.add(new FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>(module3, detector, (FacetConfiguration)pair.getFirst(), new HashSet<VirtualFile>(pair.getSecond())));
            }
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>> arrayList = result2;
        if (arrayList == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public VirtualFile getBaseDir() {
        return this.myProject.getBaseDir();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetectedFacetDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDetectedFacetDescriptions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

