/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.detection.impl.exclude.ExcludeListItem;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;

class InvalidExcludeListItem
extends ExcludeListItem {
    @NlsSafe
    private final String myFileUrl;
    private final String myFrameworkTypeId;

    InvalidExcludeListItem(String frameworkTypeId, @NlsSafe String fileUrl) {
        this.myFrameworkTypeId = frameworkTypeId;
        this.myFileUrl = fileUrl;
    }

    @Override
    public String getFrameworkTypeId() {
        return this.myFrameworkTypeId;
    }

    @Override
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Override
    public void renderItem(ColoredListCellRenderer renderer) {
        if (this.myFrameworkTypeId != null) {
            renderer.append(this.myFrameworkTypeId, SimpleTextAttributes.ERROR_ATTRIBUTES);
            if (this.myFileUrl != null) {
                renderer.append(ProjectBundle.message((String)"framework.detection.in.0", (Object[])new Object[]{this.myFileUrl}), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            renderer.append(this.myFileUrl, SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        renderer.setIcon(EmptyIcon.ICON_16);
    }

    @Override
    public String getPresentableFrameworkName() {
        return this.myFrameworkTypeId;
    }
}

