/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class DetectedFrameworkNode
extends DetectedFrameworkTreeNodeBase {
    private static final Logger LOG = Logger.getInstance(DetectedFrameworkNode.class);
    private final DetectedFrameworkDescription myDescription;
    private final FrameworkDetectionContext myContext;

    DetectedFrameworkNode(DetectedFrameworkDescription description, FrameworkDetectionContext context2) {
        super(description);
        this.myDescription = description;
        this.myContext = context2;
    }

    @Override
    public void renderNode(ColoredTreeCellRenderer renderer) {
        renderer.setIcon(this.myDescription.getDetector().getFrameworkType().getIcon());
        Collection<? extends VirtualFile> files2 = this.myDescription.getRelatedFiles();
        VirtualFile firstFile = ContainerUtil.getFirstItem(files2);
        LOG.assertTrue(firstFile != null);
        if (files2.size() == 1) {
            renderer.append(firstFile.getName());
            this.appendDirectoryPath(renderer, firstFile.getParent());
        } else {
            String commonName = firstFile.getName();
            VirtualFile commonParent = firstFile.getParent();
            for (VirtualFile virtualFile2 : files2) {
                if (commonName != null && !commonName.equals(virtualFile2.getName())) {
                    commonName = null;
                }
                if (commonParent == null || commonParent.equals(virtualFile2.getParent())) continue;
                commonParent = null;
            }
            renderer.append(ProjectBundle.message((String)"comment.0.1.files", (Object[])new Object[]{files2.size(), commonName != null ? commonName : firstFile.getFileType().getDefaultExtension()}));
            if (commonParent != null) {
                this.appendDirectoryPath(renderer, commonParent);
            }
        }
    }

    @Override
    public String getCheckedDescription() {
        return this.myDescription.getSetupText();
    }

    @Override
    public String getUncheckedDescription() {
        return null;
    }

    @Override
    public void disableDetection(DetectionExcludesConfiguration configuration) {
        Collection<? extends VirtualFile> files2 = this.myDescription.getRelatedFiles();
        FrameworkType frameworkType = this.myDescription.getDetector().getFrameworkType();
        if (files2.size() <= 5) {
            for (VirtualFile virtualFile2 : files2) {
                configuration.addExcludedFile(virtualFile2, frameworkType);
            }
        } else {
            VirtualFile commonAncestor = VfsUtil.getCommonAncestor(files2);
            if (commonAncestor != null) {
                configuration.addExcludedFile(commonAncestor, frameworkType);
            } else {
                LOG.info("Cannot find common ancestor for " + files2.size() + " files, disabling detection for " + frameworkType.getId() + " in the whole project");
                configuration.addExcludedFramework(frameworkType);
            }
        }
    }

    private void appendDirectoryPath(ColoredTreeCellRenderer renderer, VirtualFile dir) {
        String path2 = this.getRelativePath(dir);
        renderer.append(" (" + (path2.isEmpty() ? "/" : path2) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    @NlsSafe
    private String getRelativePath(@NotNull VirtualFile file2) {
        String path2;
        VirtualFile dir;
        if (file2 == null) {
            DetectedFrameworkNode.$$$reportNull$$$0(0);
        }
        if ((dir = this.myContext.getBaseDir()) != null && (path2 = VfsUtilCore.getRelativePath(dir, file2, File.separatorChar)) != null) {
            String string2 = path2;
            if (string2 == null) {
                DetectedFrameworkNode.$$$reportNull$$$0(1);
            }
            return string2;
        }
        String string3 = file2.getPresentableUrl();
        if (string3 == null) {
            DetectedFrameworkNode.$$$reportNull$$$0(2);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/ui/DetectedFrameworkNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/ui/DetectedFrameworkNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

