/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class PsiCopyPasteManager {
    private static final Logger LOG = Logger.getInstance(PsiCopyPasteManager.class);
    private MyData myRecentData;
    private final CopyPasteManagerEx myCopyPasteManager = CopyPasteManagerEx.getInstanceEx();
    private static final DataFlavor ourDataFlavor;

    public static PsiCopyPasteManager getInstance() {
        return ApplicationManager.getApplication().getService(PsiCopyPasteManager.class);
    }

    public PsiCopyPasteManager() {
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(ProjectCloseListener.TOPIC, new ProjectCloseListener(){

            @Override
            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(PsiCopyPasteManager.this.myRecentData == null || PsiCopyPasteManager.this.myRecentData.isValid() && PsiCopyPasteManager.this.myRecentData.project != project2)) {
                    PsiCopyPasteManager.this.myRecentData = null;
                }
                Transferable[] contents = PsiCopyPasteManager.this.myCopyPasteManager.getAllContents();
                for (int i2 = contents.length - 1; i2 >= 0; --i2) {
                    MyData myData;
                    Transferable t = contents[i2];
                    if (!(t instanceof MyTransferable) || (myData = ((MyTransferable)t).myDataProxy).isValid() && myData.project != project2) continue;
                    PsiCopyPasteManager.this.myCopyPasteManager.removeContent(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/PsiCopyPasteManager$1", "projectClosing"));
            }
        });
    }

    public PsiElement @Nullable [] getElements(boolean[] isCopied) {
        MyData data2 = (MyData)this.myCopyPasteManager.getContents(ourDataFlavor);
        if (data2 == null || !Comparing.equal(data2, this.myRecentData)) {
            return null;
        }
        if (isCopied != null) {
            isCopied[0] = this.myRecentData.isCopied;
        }
        return this.myRecentData.getElements();
    }

    @NotNull
    public static Transferable newTransferable(PsiElement ... element) {
        if (element == null) {
            PsiCopyPasteManager.$$$reportNull$$$0(0);
        }
        return new MyTransferable(element);
    }

    public static PsiElement @Nullable [] getElements(@Nullable Transferable content2) {
        MyData data2 = PsiCopyPasteManager.getData(content2);
        return data2 == null ? null : data2.getElements();
    }

    @Nullable
    private static MyData getData(@Nullable Transferable content2) {
        Object transferData;
        try {
            transferData = content2 == null ? null : content2.getTransferData(ourDataFlavor);
        }
        catch (UnsupportedFlavorException | InvalidDnDOperationException | IOException e) {
            return null;
        }
        return transferData instanceof MyData ? (MyData)transferData : null;
    }

    public void clear() {
        this.myRecentData = null;
        this.myCopyPasteManager.setContents((Transferable)new StringSelection(""));
    }

    public void setElements(PsiElement @NotNull [] elements, boolean copied) {
        if (elements == null) {
            PsiCopyPasteManager.$$$reportNull$$$0(1);
        }
        this.myRecentData = new MyData(elements, copied);
        this.myCopyPasteManager.setContents((Transferable)new MyTransferable(this.myRecentData));
    }

    public boolean isCutElement(Object element) {
        if (this.myRecentData == null) {
            return false;
        }
        if (this.myRecentData.isCopied) {
            return false;
        }
        PsiElement[] elements = this.myRecentData.getElements();
        if (elements == null) {
            return false;
        }
        return ArrayUtil.contains(element, elements);
    }

    @Nullable
    public static List<File> asFileList(PsiElement[] elements) {
        ArrayList<File> result2 = new ArrayList<File>();
        for (PsiElement element : elements) {
            VirtualFile vFile = PsiCopyPasteManager.asVirtualFile(element);
            if (vFile == null || !(vFile.getFileSystem() instanceof LocalFileSystem)) continue;
            result2.add(new File(vFile.getPath()));
        }
        return result2.isEmpty() ? null : result2;
    }

    @Nullable
    public static VirtualFile asVirtualFile(@Nullable PsiElement element) {
        PsiFileSystemItem psiFile = null;
        if (element instanceof PsiFileSystemItem) {
            psiFile = (PsiFileSystemItem)element;
        } else if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories();
            if (directories.length == 0) {
                LOG.error("No directories for " + element + " of " + element.getClass());
                return null;
            }
            psiFile = directories[0];
        } else if (element != null) {
            psiFile = element.getContainingFile();
        }
        if (psiFile != null) {
            return psiFile.getVirtualFile();
        }
        return null;
    }

    @ApiStatus.Internal
    public void fileMovedOutsideProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiCopyPasteManager.$$$reportNull$$$0(2);
        }
        if (this.myRecentData != null) {
            this.myRecentData.fileMovedOutsideProject(file2);
        }
        this.myCopyPasteManager.removeIf(transferable -> transferable instanceof MyTransferable && !((MyTransferable)transferable).myDataProxy.isValid());
    }

    static {
        try {
            Class<MyData> flavorClass = MyData.class;
            Thread currentThread = Thread.currentThread();
            ClassLoader currentLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(flavorClass.getClassLoader());
                ourDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + flavorClass.getName());
            }
            finally {
                currentThread.setContextClassLoader(currentLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/PsiCopyPasteManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newTransferable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMovedOutsideProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MyData {
        final Project project;
        final boolean isCopied;
        final List<SmartPsiElementPointer<?>> pointers;
        final String names;
        final List<File> files;

        MyData(PsiElement @NotNull [] elements, boolean copied) {
            if (elements == null) {
                MyData.$$$reportNull$$$0(0);
            }
            this.pointers = new ArrayList();
            this.project = elements.length == 0 ? null : elements[0].getProject();
            for (PsiElement element : elements) {
                this.pointers.add(SmartPointerManager.createPointer(element));
            }
            this.isCopied = copied;
            this.names = StringUtil.nullize(Stream.of(elements).filter(PsiNamedElement.class::isInstance).map(e -> StringUtil.nullize(((PsiNamedElement)e).getName(), true)).filter(Objects::nonNull).collect(Collectors.joining("\n")));
            this.files = PsiCopyPasteManager.asFileList(elements);
        }

        public PsiElement[] getElements() {
            return ReadAction.compute(() -> {
                ArrayList result2 = new ArrayList();
                for (SmartPsiElementPointer<?> pointer : this.pointers) {
                    Object element = pointer.getElement();
                    if (element == null) continue;
                    result2.add(element);
                }
                return result2.toArray(PsiElement.EMPTY_ARRAY);
            });
        }

        public boolean isValid() {
            Project expectedProject;
            if (this.pointers.isEmpty()) {
                return false;
            }
            SmartPsiElementPointer<?> pointer = this.pointers.get(0);
            VirtualFile virtualFile2 = pointer.getVirtualFile();
            Project project2 = expectedProject = virtualFile2 == null ? null : ProjectLocator.getInstance().guessProjectForFile(virtualFile2);
            if (expectedProject != null && expectedProject != this.project) {
                return false;
            }
            return pointer.getElement() != null;
        }

        void fileMovedOutsideProject(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyData.$$$reportNull$$$0(1);
            }
            this.pointers.removeIf(pointer -> file2.equals(pointer.getVirtualFile()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/PsiCopyPasteManager$MyData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMovedOutsideProject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Deprecated
    @ApiStatus.Internal
    public static class MyTransferable
    implements Transferable {
        private static final DataFlavor[] DATA_FLAVORS_COPY = new DataFlavor[]{ourDataFlavor, DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor};
        private static final DataFlavor[] DATA_FLAVORS_CUT = new DataFlavor[]{ourDataFlavor, DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor, LinuxDragAndDropSupport.kdeCutMarkFlavor};
        @NotNull
        private final MyData myDataProxy;

        MyTransferable(@NotNull MyData data2) {
            if (data2 == null) {
                MyTransferable.$$$reportNull$$$0(0);
            }
            this.myDataProxy = data2;
        }

        public MyTransferable(PsiElement @NotNull [] selectedValues) {
            if (selectedValues == null) {
                MyTransferable.$$$reportNull$$$0(1);
            }
            this(new MyData(selectedValues, true));
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            Object result2 = this.getTransferDataOrNull(flavor);
            if (result2 == null) {
                throw new IOException();
            }
            return result2;
        }

        @Nullable
        private Object getTransferDataOrNull(DataFlavor flavor) throws UnsupportedFlavorException {
            if (ourDataFlavor.equals(flavor)) {
                return this.myDataProxy;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.myDataProxy.names;
            }
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                return this.myDataProxy.files;
            }
            if (flavor.equals(LinuxDragAndDropSupport.uriListFlavor)) {
                List<File> files2 = this.myDataProxy.files;
                return files2 == null ? null : LinuxDragAndDropSupport.toUriList(files2);
            }
            if (flavor.equals(LinuxDragAndDropSupport.gnomeFileListFlavor)) {
                List<File> files3 = this.myDataProxy.files;
                if (files3 == null) {
                    return null;
                }
                String string2 = (this.myDataProxy.isCopied ? "copy\n" : "cut\n") + LinuxDragAndDropSupport.toUriList(files3);
                return new ByteArrayInputStream(string2.getBytes(StandardCharsets.UTF_8));
            }
            if (flavor.equals(LinuxDragAndDropSupport.kdeCutMarkFlavor) && !this.myDataProxy.isCopied) {
                return new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8));
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = this.myDataProxy.isCopied ? DATA_FLAVORS_COPY : DATA_FLAVORS_CUT;
            return JBIterable.of(flavors).filter(flavor -> {
                try {
                    return this.getTransferDataOrNull((DataFlavor)flavor) != null;
                }
                catch (UnsupportedFlavorException ex) {
                    return false;
                }
            }).toList().toArray(new DataFlavor[0]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ArrayUtilRt.find(this.getTransferDataFlavors(), flavor) != -1;
        }

        public PsiElement[] getElements() {
            return this.myDataProxy.getElements();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedValues";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/PsiCopyPasteManager$MyTransferable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class EscapeHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent event) {
            if (event.isConsumed()) {
                return;
            }
            if (0 != event.getModifiers()) {
                return;
            }
            if (27 != event.getKeyCode()) {
                return;
            }
            boolean[] copied = new boolean[1];
            PsiCopyPasteManager manager = PsiCopyPasteManager.getInstance();
            if (manager.getElements(copied) == null) {
                return;
            }
            if (copied[0]) {
                return;
            }
            manager.clear();
            event.consume();
        }
    }
}

