/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Consumer;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttachDirectoryUtils {
    public static void chooseAndAddDirectoriesWithUndo(@NotNull Project project2, @Nullable Consumer<? super List<VirtualFile>> callback) {
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(0);
        }
        Module module2 = AttachDirectoryUtils.getAttachTargetModule(project2);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project2, null, files2 -> {
            AttachDirectoryUtils.addAndSelectDirectoriesWithUndo(project2, module2, files2);
            if (callback != null) {
                callback.consume((List<VirtualFile>)files2);
            }
        });
    }

    public static void addDirectoriesWithUndo(@NotNull Project project2, @NotNull List<? extends VirtualFile> roots2) {
        Module module2;
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(1);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(2);
        }
        if ((module2 = AttachDirectoryUtils.getAttachTargetModule(project2)) == null) {
            return;
        }
        AttachDirectoryUtils.addAndSelectDirectoriesWithUndo(project2, module2, roots2);
    }

    private static void addAndSelectDirectoriesWithUndo(@NotNull Project project2, @Nullable Module module2, @NotNull List<? extends VirtualFile> roots2) {
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(3);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(4);
        }
        AttachDirectoryUtils.addRemoveEntriesWithUndo(project2, module2, roots2, true);
        VirtualFile file2 = ContainerUtil.getFirstItem(roots2);
        if (file2 != null) {
            ModalityUiUtil.invokeLaterIfNeeded(ModalityState.defaultModalityState(), () -> ProjectViewSelectInTarget.select(project2, file2, "ProjectPane", null, file2, true));
        }
    }

    public static void addRemoveEntriesWithUndo(final @NotNull Project project2, final @Nullable Module module2, @NotNull List<? extends VirtualFile> roots2, final boolean add2) {
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(5);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(6);
        }
        final ArrayList<VirtualFile> adjustedRoots = ContainerUtil.newArrayList(JBIterable.from(roots2).filter(o -> add2 == (ModuleUtilCore.findModuleForFile(o, project2) == null)).filterMap(o -> o.isDirectory() ? o : o.getParent()).unique());
        adjustedRoots.removeIf(r -> ContainerUtil.exists(adjustedRoots, r2 -> VfsUtilCore.isAncestor(r2, r, true)));
        if (adjustedRoots.isEmpty()) {
            return;
        }
        String title = IdeBundle.message((String)"command.name.choice.attach.detach", (Object[])new Object[]{add2 ? 0 : 1, AttachDirectoryUtils.getDisplayName(adjustedRoots)});
        WriteCommandAction.writeCommandAction(project2).withName(title).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            class MyUndoable
            extends GlobalUndoableAction {
                MyUndoable() {
                }

                @Override
                public void undo() {
                    AttachDirectoryUtils.addRemoveEntriesInner(project2, module2, adjustedRoots, !add2);
                }

                @Override
                public void redo() {
                    AttachDirectoryUtils.addRemoveEntriesInner(project2, module2, adjustedRoots, add2);
                }
            }
            MyUndoable undoable = new MyUndoable();
            undoable.redo();
            UndoManager.getInstance(project2).undoableActionPerformed(undoable);
        });
    }

    public static void excludeEntriesWithUndo(@NotNull Project project2, @NotNull List<? extends VirtualFile> roots2, boolean exclude) {
        Module module2;
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(7);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(8);
        }
        if ((module2 = AttachDirectoryUtils.getAttachTargetModule(project2)) != null) {
            AttachDirectoryUtils.excludeEntriesWithUndo(module2, roots2, exclude);
        }
    }

    public static void excludeEntriesWithUndo(final @NotNull Module module2, final @NotNull List<? extends VirtualFile> roots2, final boolean exclude) {
        if (module2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(9);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(10);
        }
        if (roots2.isEmpty()) {
            return;
        }
        Project project2 = module2.getProject();
        String title = IdeBundle.message((String)"command.name.choice.exclude.include", (Object[])new Object[]{exclude ? 0 : 1, AttachDirectoryUtils.getDisplayName(roots2)});
        WriteCommandAction.writeCommandAction(project2).withName(title).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            class MyUndoable
            extends GlobalUndoableAction {
                MyUndoable() {
                }

                @Override
                public void undo() {
                    AttachDirectoryUtils.excludeEntriesInner(module2, roots2, !exclude);
                }

                @Override
                public void redo() {
                    AttachDirectoryUtils.excludeEntriesInner(module2, roots2, exclude);
                }
            }
            MyUndoable undoable = new MyUndoable();
            undoable.redo();
            UndoManager.getInstance(project2).undoableActionPerformed(undoable);
        });
    }

    public static String getDisplayName(@NotNull List<? extends VirtualFile> roots2) {
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(11);
        }
        return roots2.size() == 1 ? "directory '" + roots2.get(0).getName() + "'" : roots2.size() + " " + StringUtil.pluralize("directory", roots2.size());
    }

    private static void addRemoveEntriesInner(@NotNull Project project2, @Nullable Module module2, @NotNull List<? extends VirtualFile> files2, boolean add2) {
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(12);
        }
        if (files2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(13);
        }
        if (module2 == null) {
            module2 = AttachDirectoryUtils.getAttachTargetModule(project2);
        }
        if (module2 == null) {
            module2 = AttachDirectoryUtils.createDefaultModule(project2);
        }
        ModuleRootModificationUtil.updateModel(module2, model2 -> {
            if (add2) {
                for (VirtualFile file2 : files2) {
                    model2.addContentEntry(file2);
                }
            } else {
                for (ContentEntry entry : model2.getContentEntries()) {
                    if (!files2.contains(entry.getFile())) continue;
                    model2.removeContentEntry(entry);
                }
            }
        });
    }

    private static void excludeEntriesInner(@NotNull Module module2, @NotNull List<? extends VirtualFile> files2, boolean exclude) {
        if (module2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(14);
        }
        if (files2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(15);
        }
        ModuleRootModificationUtil.updateModel(module2, model2 -> {
            for (ContentEntry entry : model2.getContentEntries()) {
                VirtualFile root = entry.getFile();
                if (root == null) continue;
                for (VirtualFile file2 : files2) {
                    if (!VfsUtilCore.isAncestor(root, file2, true)) continue;
                    if (exclude) {
                        entry.addExcludeFolder(file2);
                        continue;
                    }
                    entry.removeExcludeFolder(file2.getUrl());
                }
            }
        });
    }

    @Nullable
    private static Module getAttachTargetModule(@NotNull Project project2) {
        Module[] modules2;
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(16);
        }
        return (modules2 = ModuleManager.getInstance(project2).getModules()).length == 0 ? null : modules2[0];
    }

    @NotNull
    private static Module createDefaultModule(@NotNull Project project2) {
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(17);
        }
        IProjectStore store = ProjectKt.getStateStore(project2);
        Path proDir = store.getProjectFilePath().getParent();
        Path modulePath = proDir.resolve(project2.getName() + ".iml");
        ModuleType defType = ModuleTypeManager.getInstance().getDefaultModuleType();
        Module module2 = ModuleManager.getInstance(project2).newModule(modulePath, defType.getId());
        if (module2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(18);
        }
        return module2;
    }

    @NotNull
    public static List<VirtualFile> getAttachedDirectories(@NotNull Project project2) {
        Module module2;
        if (project2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(19);
        }
        List<VirtualFile> list2 = (module2 = AttachDirectoryUtils.getAttachTargetModule(project2)) != null ? Arrays.asList(ModuleRootManager.getInstance(module2).getContentRoots()) : Collections.emptyList();
        if (list2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(20);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/AttachDirectoryUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/AttachDirectoryUtils";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultModule";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndAddDirectoriesWithUndo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoriesWithUndo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAndSelectDirectoriesWithUndo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRemoveEntriesWithUndo";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "excludeEntriesWithUndo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRemoveEntriesInner";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "excludeEntriesInner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAttachTargetModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultModule";
                break;
            }
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedDirectories";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 18, 20 -> new IllegalStateException(string2);
        };
    }
}

