/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.copy.CopyHandler;
import org.jetbrains.annotations.NotNull;

public class CopyElementAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CopyElementAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement[] elements;
        PsiDirectory defaultTargetDirectory;
        DataContext dataContext2;
        Project project2;
        if (e == null) {
            CopyElementAction.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2 = e.getDataContext())) == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        PsiElement targetPsiElement = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext2);
        PsiDirectory psiDirectory = defaultTargetDirectory = targetPsiElement instanceof PsiDirectory ? (PsiDirectory)targetPsiElement : null;
        if (editor2 != null) {
            PsiElement aElement = CopyElementAction.getTargetElement(editor2, project2);
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
            if (file2 == null) {
                return;
            }
            elements = new PsiElement[]{aElement};
            if (aElement == null || !CopyHandler.canCopy(elements)) {
                elements = new PsiElement[]{file2};
            }
        } else {
            elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext2);
        }
        this.doCopy(elements, defaultTargetDirectory);
    }

    protected void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        CopyHandler.doCopy(elements, defaultTargetDirectory);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CopyElementAction.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        presentation2.setEnabled(false);
        if (project2 == null) {
            return;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 != null) {
            this.updateForEditor(dataContext2, presentation2);
        } else {
            this.updateForToolWindow(dataContext2, presentation2);
        }
    }

    protected void updateForEditor(DataContext dataContext2, Presentation presentation2) {
        boolean result2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null) {
            presentation2.setVisible(false);
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        PsiElement element = CopyElementAction.getTargetElement(editor2, project2);
        Ref<@NlsActions.ActionText T> actionName = new Ref();
        boolean bl = result2 = element != null && CopyHandler.canCopy(new PsiElement[]{element}, actionName);
        if (!result2 && file2 != null) {
            result2 = CopyHandler.canCopy(new PsiElement[]{file2}, actionName);
        }
        presentation2.setEnabled(result2);
        presentation2.setVisible(true);
        if (!actionName.isNull()) {
            presentation2.setText((String)actionName.get());
        }
    }

    protected void updateForToolWindow(DataContext dataContext2, Presentation presentation2) {
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext2);
        Ref<@NlsActions.ActionText T> actionName = new Ref();
        presentation2.setEnabled(elements != null && CopyHandler.canCopy(elements, actionName));
        if (!actionName.isNull()) {
            presentation2.setText((String)actionName.get());
        }
    }

    private static PsiElement getTargetElement(Editor editor2, Project project2) {
        int offset2 = editor2.getCaretModel().getOffset();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            return null;
        }
        PsiElement element = file2.findElementAt(offset2);
        if (element == null) {
            element = file2;
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyElementAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyElementAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

