/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyPathProvider;
import com.intellij.ide.actions.CopyReferenceFQNTransferable;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.ide.actions.FqnUtil;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceAction
extends DumbAwareAction {
    public static final DataFlavor ourFlavor = FileCopyPasteUtil.createJvmDataFlavor(CopyReferenceFQNTransferable.class);

    public CopyReferenceAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            CopyReferenceAction.$$$reportNull$$$0(0);
        }
        boolean plural = false;
        boolean paths2 = false;
        DataContext dataContext2 = e.getDataContext();
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        boolean fileWithDocument = editor2 != null && FileDocumentManager.getInstance().getFile(editor2.getDocument()) != null;
        boolean calcQualifiedName = "CopyReferencePopup".equals(e.getPlace());
        try {
            List<PsiElement> elements;
            List<PsiElement> list2 = elements = !fileWithDocument || calcQualifiedName ? this.getPsiElements(dataContext2, editor2) : null;
            if (fileWithDocument) {
                enabled = true;
            } else {
                enabled = !elements.isEmpty();
                plural = elements.size() > 1;
                paths2 = ContainerUtil.and(elements, el -> el instanceof PsiFileSystemItem && CopyReferenceUtil.getQualifiedNameFromProviders((PsiElement)el) == null);
            }
            if (calcQualifiedName) {
                e.getPresentation().putClientProperty(CopyPathProvider.QUALIFIED_NAME, (Object)this.getQualifiedName(editor2, elements));
            }
        }
        catch (IndexNotReadyException ex) {
            enabled = false;
        }
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setText(paths2 ? (plural ? IdeBundle.message((String)"copy.relative.paths", (Object[])new Object[0]) : IdeBundle.message((String)"copy.relative.path", (Object[])new Object[0])) : (plural ? IdeBundle.message((String)"copy.references", (Object[])new Object[0]) : IdeBundle.message((String)"copy.reference", (Object[])new Object[0])));
        if (paths2) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CopyReferenceAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    @NotNull
    protected List<PsiElement> getPsiElements(DataContext dataContext2, Editor editor2) {
        List<PsiElement> list2 = CopyReferenceUtil.getElementsToCopy(editor2, dataContext2);
        if (list2 == null) {
            CopyReferenceAction.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyReferenceAction.$$$reportNull$$$0(3);
        }
        DataContext dataContext2 = e.getDataContext();
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        List<PsiElement> elements = this.getPsiElements(dataContext2, editor2);
        String copy2 = this.getQualifiedName(editor2, elements);
        if (copy2 != null) {
            CopyPasteManager.getInstance().setContents((Transferable)new CopyReferenceFQNTransferable(copy2));
            CopyReferenceUtil.setStatusBarText(project2, IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{copy2}));
        } else if (editor2 != null && project2 != null) {
            Document document = editor2.getDocument();
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getCachedPsiFile(document);
            if (file2 != null) {
                String toCopy = CopyReferenceUtil.getFileFqn((PsiFile)file2) + ":" + (editor2.getCaretModel().getLogicalPosition().line + 1);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(toCopy));
                CopyReferenceUtil.setStatusBarText(project2, LangBundle.message("status.bar.text.reference.has.been.copied", toCopy));
            }
            return;
        }
        CopyReferenceUtil.highlight(editor2, project2, elements);
    }

    @NlsSafe
    protected String getQualifiedName(Editor editor2, List<? extends PsiElement> elements) {
        return CopyReferenceUtil.doCopy(elements, editor2);
    }

    public static boolean doCopy(PsiElement element, Project project2) {
        return CopyReferenceAction.doCopy(Collections.singletonList(element), project2);
    }

    private static boolean doCopy(List<? extends PsiElement> elements, @Nullable Project project2) {
        String toCopy = CopyReferenceUtil.doCopy(elements, null);
        CopyPasteManager.getInstance().setContents((Transferable)new CopyReferenceFQNTransferable(toCopy));
        CopyReferenceUtil.setStatusBarText(project2, IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{toCopy}));
        return true;
    }

    @Nullable
    public static String elementToFqn(@Nullable PsiElement element) {
        return FqnUtil.elementToFqn((PsiElement)element, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyReferenceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyReferenceAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

