/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateDirectoryCompletionContributor;
import com.intellij.ide.actions.CreateDirectoryHandler;
import com.intellij.ide.actions.CreateDirectoryUsageCollector;
import com.intellij.ide.actions.CreateGroupHandler;
import com.intellij.ide.actions.CreatePackageHandler;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemWithTemplatesPopupPanel;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateDirectoryOrPackageAction
extends AnAction
implements DumbAware {
    public static final ExtensionPointName<CreateDirectoryCompletionContributor> EP = new ExtensionPointName("com.intellij.createDirectoryCompletionContributor");
    @TestOnly
    public static final DataKey<String> TEST_DIRECTORY_NAME_KEY = DataKey.create((String)"CreateDirectoryOrPackageAction.testName");

    public CreateDirectoryOrPackageAction() {
        super(IdeBundle.messagePointer((String)"action.create.new.directory.or.package", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.create.new.directory.or.package", (Object[])new Object[0]), null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String testDirectoryName;
        String title;
        String message;
        CreateGroupHandler validator2;
        if (event == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(1);
        }
        IdeView view = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (view == null || project2 == null) {
            return;
        }
        PsiDirectory directory = DirectoryChooserUtil.getOrChooseDirectory(view);
        if (directory == null) {
            return;
        }
        if (PsiDirectoryFactory.getInstance(project2).isPackage(directory)) {
            validator2 = new CreatePackageHandler(project2, directory);
            message = IdeBundle.message((String)"prompt.enter.new.package.name", (Object[])new Object[0]);
            title = IdeBundle.message((String)"title.new.package", (Object[])new Object[0]);
        } else {
            validator2 = new CreateDirectoryHandler(project2, directory);
            message = IdeBundle.message((String)"prompt.enter.new.directory.name", (Object[])new Object[0]);
            title = IdeBundle.message((String)"title.new.directory", (Object[])new Object[0]);
        }
        String initialText = validator2.getInitialText();
        Consumer<List> consumer2 = elements -> {
            for (PsiElement element : ContainerUtil.iterateBackward(elements)) {
                view.selectElement(element);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() && (testDirectoryName = (String)event.getData(TEST_DIRECTORY_NAME_KEY)) != null && validator2.checkInput(testDirectoryName) && validator2.canClose(testDirectoryName)) {
            consumer2.accept(Collections.singletonList(validator2.getCreatedElement()));
            return;
        }
        if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
            this.createLightWeightPopup(project2, title, initialText, directory, validator2, consumer2).showCenteredInCurrentWindow(project2);
        } else {
            Messages.showInputDialog((Project)project2, (String)message, (String)title, null, (String)initialText, (InputValidator)validator2, (TextRange)TextRange.from(initialText.length(), 0));
            consumer2.accept(Collections.singletonList(validator2.getCreatedElement()));
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        IdeView view = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setEnabledAndVisible(true);
        boolean isPackage = false;
        PsiDirectoryFactory factory2 = PsiDirectoryFactory.getInstance(project2);
        for (PsiDirectory directory : directories) {
            if (!factory2.isPackage(directory)) continue;
            isPackage = true;
            break;
        }
        if (isPackage) {
            presentation2.setText(IdeBundle.messagePointer((String)"action.package", (Object[])new Object[0]));
            presentation2.setIcon(AllIcons.Nodes.Package);
        } else {
            presentation2.setText(IdeBundle.messagePointer((String)"action.directory", (Object[])new Object[0]));
            presentation2.setIcon(PlatformIcons.FOLDER_ICON);
        }
    }

    private JBPopup createLightWeightPopup(@Nullable Project project2, @NlsContexts.PopupTitle String title, String initialText, @NotNull PsiDirectory directory, final CreateGroupHandler validator2, Consumer<? super List<PsiElement>> consumer2) {
        if (directory == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(3);
        }
        List<CompletionItem> variants = this.collectSuggestedDirectories(directory);
        final DirectoriesWithCompletionPopupPanel contentPanel = new DirectoriesWithCompletionPopupPanel(variants);
        final JTextField nameField = contentPanel.getTextField();
        nameField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                String text2 = nameField.getText();
                validator2.checkInput(text2);
                String errorText = validator2.getErrorText(text2);
                if (errorText != null) {
                    contentPanel.setError(errorText);
                } else if (contentPanel.hasError()) {
                    contentPanel.setError(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/CreateDirectoryOrPackageAction$1", "textChanged"));
            }
        });
        nameField.setText(initialText);
        JBPopup popup2 = NewItemPopupUtil.createNewItemPopup((String)title, (JComponent)((Object)contentPanel), (JComponent)nameField);
        contentPanel.setApplyAction(event -> {
            List<PsiElement> created;
            for (CompletionItem it : contentPanel.getSelectedItems()) {
                CreateDirectoryUsageCollector.logCompletionVariantChosen(project2, it.contributor.getClass());
            }
            List<Pair> toCreate = ContainerUtil.map(contentPanel.getSelectedItems(), item -> Pair.create(item.relativePath, item.rootType));
            if (toCreate.isEmpty()) {
                toCreate = Collections.singletonList(Pair.create(nameField.getText(), null));
            }
            if ((created = CreateDirectoryOrPackageAction.createDirectories(toCreate, validator2)) != null) {
                popup2.closeOk(event);
                consumer2.accept(created);
            } else {
                for (Pair dir : toCreate) {
                    String errorMessage = validator2.getErrorText((String)dir.first);
                    if (errorMessage == null) continue;
                    contentPanel.setError(errorMessage);
                    break;
                }
            }
        });
        contentPanel.addTemplatesVisibilityListener(visible -> SwingUtilities.invokeLater(() -> popup2.pack(false, true)));
        return popup2;
    }

    @NotNull
    protected List<CompletionItem> collectSuggestedDirectories(@NotNull PsiDirectory directory) {
        if (directory == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(4);
        }
        ArrayList<CompletionItem> variants = new ArrayList<CompletionItem>();
        VirtualFile vDir = directory.getVirtualFile();
        for (CreateDirectoryCompletionContributor contributor : EP.getExtensionList()) {
            for (CreateDirectoryCompletionContributor.Variant variant : contributor.getVariants(directory)) {
                CompletionItem completionItem;
                Icon icon2;
                String relativePath = FileUtil.toSystemIndependentName(variant.path);
                if (FileUtil.isAbsolutePlatformIndependent(relativePath) && (!FileUtil.isAncestor(vDir.getPath(), relativePath, true) || (relativePath = FileUtil.getRelativePath(vDir.getPath(), relativePath, '/')) == null) || vDir.findFileByRelativePath(relativePath) != null) continue;
                ModuleSourceRootEditHandler<?> handler2 = variant.rootType != null ? ModuleSourceRootEditHandler.getEditHandler(variant.rootType) : null;
                Icon icon3 = icon2 = handler2 == null ? null : handler2.getRootIcon();
                if (icon2 == null) {
                    icon2 = AllIcons.Nodes.Folder;
                }
                if (variants.contains(completionItem = new CompletionItem(contributor, relativePath, icon2, variant.rootType))) continue;
                variants.add(completionItem);
            }
        }
        variants.sort((o1, o2) -> {
            int result2 = StringUtil.naturalCompare(o1.contributor.getDescription(), o2.contributor.getDescription());
            if (result2 != 0) {
                return result2;
            }
            return StringUtil.naturalCompare(o1.relativePath, o2.relativePath);
        });
        ArrayList<CompletionItem> arrayList = variants;
        if (arrayList == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static List<PsiElement> createDirectories(List<? extends Pair<String, JpsModuleSourceRootType<?>>> toCreate, CreateGroupHandler validator2) {
        ArrayList<PsiElement> createdDirectories = new ArrayList<PsiElement>(toCreate.size());
        if (!ContainerUtil.all(toCreate, dir -> !((String)dir.first).isEmpty() && validator2.checkInput((String)dir.first))) {
            return null;
        }
        ArrayList<Pair<PsiFileSystemItem, JpsModuleSourceRootType>> toMarkAsRoots = new ArrayList<Pair<PsiFileSystemItem, JpsModuleSourceRootType>>(toCreate.size());
        for (Pair<String, JpsModuleSourceRootType<?>> dir2 : toCreate) {
            if (!validator2.canClose((String)dir2.first)) {
                return null;
            }
            PsiFileSystemItem element = validator2.getCreatedElement();
            if (element == null) continue;
            createdDirectories.add(element);
            JpsModuleSourceRootType rootType = (JpsModuleSourceRootType)dir2.second;
            if (rootType == null) continue;
            toMarkAsRoots.add(Pair.create(element, rootType));
        }
        if (!toMarkAsRoots.isEmpty()) {
            Project project2 = ((PsiFileSystemItem)((Pair)toMarkAsRoots.get((int)0)).first).getProject();
            ProjectFileIndex index2 = ProjectFileIndex.getInstance(project2);
            WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx(project2).mergeRootsChangesDuring(() -> {
                for (Pair each : toMarkAsRoots) {
                    VirtualFile file2 = ((PsiFileSystemItem)each.first).getVirtualFile();
                    JpsModuleSourceRootType rootType = (JpsModuleSourceRootType)each.second;
                    Module module2 = index2.getModuleForFile(file2);
                    if (module2 == null || index2.getContentRootForFile(file2) == null || index2.isInSourceContent(file2)) continue;
                    ModifiableRootModel model2 = ModuleRootManager.getInstance(module2).getModifiableModel();
                    ContentEntry entry = MarkRootActionBase.findContentEntry(model2, file2);
                    if (entry != null) {
                        entry.addSourceFolder(file2, rootType);
                        model2.commit();
                        continue;
                    }
                    model2.dispose();
                }
            }));
        }
        return createdDirectories;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuggestedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLightWeightPopup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSuggestedDirectories";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }

    private static class DirectoriesWithCompletionPopupPanel
    extends NewItemWithTemplatesPopupPanel<CompletionItem> {
        private static final SimpleTextAttributes MATCHED = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), null, 64);
        private MinusculeMatcher currentMatcher;
        private boolean locked;

        protected DirectoriesWithCompletionPopupPanel(final @NotNull List<CompletionItem> items2) {
            if (items2 == null) {
                DirectoriesWithCompletionPopupPanel.$$$reportNull$$$0(0);
            }
            super(items2, (ListCellRenderer)SimpleListCellRenderer.create((String)"", item -> item.displayText), true);
            this.currentMatcher = null;
            this.locked = false;
            this.setupRenderers();
            ScrollingUtil.redirectExpandSelection((JList)this.myTemplatesList, (JComponent)this.myTextField);
            this.myTemplatesList.getSelectionModel().setSelectionMode(2);
            this.myTemplatesList.addListSelectionListener(e -> {
                CompletionItem selected = (CompletionItem)this.myTemplatesList.getSelectedValue();
                if (selected != null) {
                    this.locked = true;
                    try {
                        this.myTextField.setText(selected.displayText);
                    }
                    finally {
                        this.locked = false;
                    }
                }
            });
            this.myTextField.getDocument().addDocumentListener(new DocumentAdapter(){

                @Override
                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!locked) {
                        String input = myTextField.getText();
                        currentMatcher = NameUtil.buildMatcher((String)("*" + input)).build();
                        List<CompletionItem> filtered = ContainerUtil.filter(items2, item -> currentMatcher.matches(item.displayText));
                        this.updateTemplatesList(filtered);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel$1", "textChanged"));
                }
            });
            final ListModel model2 = this.myTemplatesList.getModel();
            model2.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.setTemplatesListVisible(model2.getSize() > 0);
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.setTemplatesListVisible(model2.getSize() > 0);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.setTemplatesListVisible(model2.getSize() > 0);
                }
            });
            this.setTemplatesListVisible(model2.getSize() > 0);
        }

        @NotNull
        List<CompletionItem> getSelectedItems() {
            List<CompletionItem> list2 = this.myTemplatesList.getSelectedValuesList();
            if (list2 == null) {
                DirectoriesWithCompletionPopupPanel.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private void setupRenderers() {
            ColoredListCellRenderer<CompletionItem> itemRenderer = new ColoredListCellRenderer<CompletionItem>(){

                protected void customizeCellRenderer(@NotNull JList<? extends CompletionItem> list2, @Nullable CompletionItem value, int index2, boolean selected, boolean hasFocus) {
                    if (list2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!selected) {
                        this.setBackground(UIUtil.getListBackground());
                    }
                    String text2 = value == null ? "" : value.displayText;
                    FList ranges2 = currentMatcher == null ? FList.emptyList() : currentMatcher.matchingFragments(text2);
                    SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)text2, (Iterable)ranges2, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (SimpleTextAttributes)MATCHED);
                    this.setIcon(value == null ? null : value.icon);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel$3", "customizeCellRenderer"));
                }
            };
            this.myTemplatesList.setCellRenderer((arg_0, arg_1, arg_2, arg_3, arg_4) -> this.lambda$setupRenderers$2((ColoredListCellRenderer)itemRenderer, arg_0, arg_1, arg_2, arg_3, arg_4));
        }

        private /* synthetic */ Component lambda$setupRenderers$2(ColoredListCellRenderer itemRenderer, JList list2, CompletionItem value, int index2, boolean isSelected, boolean cellHasFocus) {
            Component item = itemRenderer.getListCellRendererComponent(list2, (Object)value, index2, isSelected, cellHasFocus);
            JPanel wrapperPanel = new JPanel(new BorderLayout());
            wrapperPanel.setBackground(UIUtil.getListBackground());
            if (index2 == 0 || value.contributor != ((CompletionItem)list2.getModel().getElementAt((int)(index2 - 1))).contributor) {
                SeparatorWithText separator = new SeparatorWithText(){

                    protected void paintLinePart(Graphics g, int xMin, int xMax, int hGap, int y) {
                    }
                };
                separator.setFont(UIUtil.getLabelFont(UIUtil.FontSize.SMALL));
                int vGap = 2;
                separator.setBorder(BorderFactory.createEmptyBorder(vGap * (index2 == 0 ? 1 : 2), 0, vGap, 0));
                separator.setCaption(value.contributor.getDescription());
                separator.setCaptionCentered(false);
                wrapperPanel.add((Component)separator, "North");
            }
            wrapperPanel.add(item, "Center");
            return wrapperPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    protected static final class CompletionItem {
        @NotNull
        final CreateDirectoryCompletionContributor contributor;
        @NotNull
        final String relativePath;
        @Nullable
        final JpsModuleSourceRootType<?> rootType;
        final @NlsContexts.ListItem @NotNull String displayText;
        @Nullable
        final Icon icon;

        private CompletionItem(@NotNull CreateDirectoryCompletionContributor contributor, @NotNull String relativePath, @Nullable Icon icon2, @Nullable JpsModuleSourceRootType<?> rootType) {
            if (contributor == null) {
                CompletionItem.$$$reportNull$$$0(0);
            }
            if (relativePath == null) {
                CompletionItem.$$$reportNull$$$0(1);
            }
            this.contributor = contributor;
            this.relativePath = relativePath;
            this.rootType = rootType;
            this.displayText = FileUtil.toSystemDependentName(relativePath);
            this.icon = icon2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletionItem that = (CompletionItem)o;
            return this.contributor.equals(that.contributor) && this.relativePath.equals(that.relativePath) && Objects.equals(this.rootType, that.rootType) && this.displayText.equals(that.displayText) && Objects.equals(this.icon, that.icon);
        }

        public int hashCode() {
            return Objects.hash(this.contributor, this.relativePath, this.rootType, this.displayText, this.icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "relativePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction$CompletionItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

