/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.TestDialogBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.SlowOperations;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateAction<T extends PsiElement>
extends AnAction
implements WriteActionAware {
    protected static final Logger LOG = Logger.getInstance(CreateFromTemplateAction.class);

    protected CreateFromTemplateAction() {
    }

    public CreateFromTemplateAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, @Nullable Icon icon2) {
        super(text2, description, icon2);
    }

    public CreateFromTemplateAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, @Nullable Icon icon2) {
        if (dynamicText == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext2;
        IdeView view;
        if (e == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(3);
        }
        if ((view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext2 = e.getDataContext())) == null) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        final PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project2 == null) {
            return;
        }
        CreateFileFromTemplateDialog.Builder builder2 = CreateFromTemplateAction.createDialogBuilder(project2, dataContext2);
        this.buildDialog(project2, dir, builder2);
        final Ref<Object> selectedTemplateName = Ref.create(null);
        builder2.show(this.getErrorTitle(), this.getDefaultTemplateName(dir), new CreateFileFromTemplateDialog.FileCreator<T>(){

            @Override
            public T createFile(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (templateName == null) {
                    1.$$$reportNull$$$0(1);
                }
                selectedTemplateName.set(templateName);
                return CreateFromTemplateAction.this.createFile(name, templateName, CreateFromTemplateAction.this.adjustDirectory(dir));
            }

            @Override
            public boolean startInWriteAction() {
                return CreateFromTemplateAction.this.startInWriteAction();
            }

            @Override
            @NotNull
            public String getActionName(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (templateName == null) {
                    1.$$$reportNull$$$0(3);
                }
                String string2 = CreateFromTemplateAction.this.getActionName(dir, name, templateName);
                if (string2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "templateName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/CreateFromTemplateAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/CreateFromTemplateAction$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createFile";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getActionName";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 4 -> new IllegalStateException(string2);
                };
            }
        }, createdElement -> {
            if (createdElement != null) {
                Editor editor2 = FileEditorManager.getInstance(project2).getSelectedTextEditor();
                int offset2 = CreateFromTemplateAction.getOffsetToPreserve(editor2);
                view.selectElement(createdElement);
                if (offset2 != -1 && editor2 != null && !editor2.isDisposed()) {
                    editor2.getCaretModel().moveToOffset(offset2);
                }
                try (AccessToken ignored = SlowOperations.allowSlowOperations("action.perform");){
                    this.postProcess(createdElement, (String)selectedTemplateName.get(), builder2.getCustomProperties());
                }
            }
        });
    }

    protected PsiDirectory adjustDirectory(@NotNull PsiDirectory original) {
        if (original == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(4);
        }
        return original;
    }

    @Nullable
    protected PsiDirectory getDirectory(IdeView view) {
        return view.getOrChooseDirectory();
    }

    private static CreateFileFromTemplateDialog.Builder createDialogBuilder(Project project2, DataContext dataContext2) {
        TestDialogBuilder.TestAnswers answers;
        if (ApplicationManager.getApplication().isUnitTestMode() && (answers = (TestDialogBuilder.TestAnswers)dataContext2.getData(TestDialogBuilder.TestAnswers.KEY)) != null) {
            return new TestDialogBuilder(answers);
        }
        return CreateFileFromTemplateDialog.createDialog(project2);
    }

    protected void postProcess(@NotNull T createdElement, String templateName, Map<String, String> customProperties) {
        if (createdElement == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    protected abstract T createFile(String var1, String var2, PsiDirectory var3);

    protected abstract void buildDialog(@NotNull Project var1, @NotNull PsiDirectory var2, @NotNull CreateFileFromTemplateDialog.Builder var3);

    @NonNls
    @Nullable
    protected String getDefaultTemplateName(@NotNull PsiDirectory dir) {
        String property;
        if (dir == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(6);
        }
        return (property = this.getDefaultTemplateProperty()) == null ? null : PropertiesComponent.getInstance(dir.getProject()).getValue(property);
    }

    @NonNls
    @Nullable
    protected String getDefaultTemplateProperty() {
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(7);
        }
        DataContext dataContext2 = e.getDataContext();
        Presentation presentation2 = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext2);
        presentation2.setEnabledAndVisible(enabled);
    }

    protected boolean isAvailable(DataContext dataContext2) {
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 != null && editor2.getSelectionModel().hasSelection()) {
            return false;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext2);
        return project2 != null && view != null && view.getDirectories().length != 0;
    }

    @NlsContexts.Command
    protected abstract String getActionName(PsiDirectory var1, @NonNls @NotNull String var2, @NonNls String var3);

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected String getErrorTitle() {
        String string2 = CommonBundle.getErrorTitle();
        if (string2 == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private static Integer getOffsetToPreserve(Editor editor2) {
        if (editor2 == null) {
            return -1;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        if (offset2 == 0) {
            return -1;
        }
        return offset2;
    }

    public static void moveCaretAfterNameIdentifier(PsiNameIdentifierOwner createdElement) {
        PsiElement nameIdentifier;
        VirtualFile virtualFile2;
        Project project2 = createdElement.getProject();
        Editor editor2 = FileEditorManager.getInstance(project2).getSelectedTextEditor();
        if (editor2 != null && (virtualFile2 = createdElement.getContainingFile().getVirtualFile()) != null && FileDocumentManager.getInstance().getDocument(virtualFile2) == editor2.getDocument() && (nameIdentifier = createdElement.getNameIdentifier()) != null) {
            editor2.getCaretModel().moveToOffset(nameIdentifier.getTextRange().getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateFromTemplateAction";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateFromTemplateAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplateName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 8 -> new IllegalStateException(string2);
        };
    }
}

