/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class CreateTemplateInPackageAction<T extends PsiElement>
extends CreateFromTemplateAction<T> {
    @Nullable
    private final Set<? extends JpsModuleSourceRootType<?>> mySourceRootTypes;

    protected CreateTemplateInPackageAction(String text2, String description, Icon icon2, Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        this(() -> text2, () -> description, icon2, rootTypes);
    }

    protected CreateTemplateInPackageAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2, @Nullable Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (dynamicText == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon2);
        this.mySourceRootTypes = rootTypes;
    }

    @Override
    @Nullable
    protected T createFile(String name, String templateName, PsiDirectory dir) {
        return this.checkOrCreate(name, dir, templateName);
    }

    @Nullable
    protected abstract PsiElement getNavigationElement(@NotNull T var1);

    @Override
    protected void postProcess(@NotNull T createdElement, String templateName, Map<String, String> customProperties) {
        Editor editor2;
        if (createdElement == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(2);
        }
        super.postProcess(createdElement, templateName, customProperties);
        PsiElement element = this.getNavigationElement(createdElement);
        if (element != null && (editor2 = PsiEditorUtil.findEditor((PsiElement)element)) != null) {
            editor2.getCaretModel().moveToOffset(element.getTextOffset());
        }
    }

    @Override
    protected boolean isAvailable(DataContext dataContext2) {
        return CreateTemplateInPackageAction.isAvailable(dataContext2, this.mySourceRootTypes, this::checkPackageExists);
    }

    @Override
    @NotNull
    protected PsiDirectory adjustDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(3);
        }
        return CreateTemplateInPackageAction.adjustDirectory(directory, this.mySourceRootTypes);
    }

    @NotNull
    public static PsiDirectory adjustDirectory(@NotNull PsiDirectory directory, @Nullable Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (directory == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(4);
        }
        ProjectFileIndex index2 = ProjectRootManager.getInstance(directory.getProject()).getFileIndex();
        if (rootTypes != null && !index2.isUnderSourceRootOfType(directory.getVirtualFile(), rootTypes)) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement(directory);
            if (module2 == null) {
                PsiDirectory psiDirectory = directory;
                if (psiDirectory == null) {
                    CreateTemplateInPackageAction.$$$reportNull$$$0(5);
                }
                return psiDirectory;
            }
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance(module2).getModifiableModel();
            ContentEntry contentEntry = ContainerUtil.find(modifiableModel.getContentEntries(), entry -> entry.getFile() != null && VfsUtilCore.isAncestor(entry.getFile(), directory.getVirtualFile(), false));
            if (contentEntry == null || !Objects.equals(contentEntry.getFile(), directory.getVirtualFile()) || contentEntry.getSourceFolders().length > 0) {
                PsiDirectory psiDirectory = directory;
                if (psiDirectory == null) {
                    CreateTemplateInPackageAction.$$$reportNull$$$0(6);
                }
                return psiDirectory;
            }
            contentEntry.addSourceFolder(directory.getVirtualFile(), false);
            WriteAction.run(() -> modifiableModel.commit());
        }
        PsiDirectory psiDirectory = directory;
        if (psiDirectory == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(7);
        }
        return psiDirectory;
    }

    public static boolean isAvailable(DataContext dataContext2, Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes, Predicate<? super PsiDirectory> checkPackageExists) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext2);
        if (project2 == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        if (sourceRootTypes == null) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), sourceRootTypes) && checkPackageExists.test(dir)) {
                return true;
            }
            if (!CreateTemplateInPackageAction.isInContentRoot(dir.getVirtualFile(), projectFileIndex)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInContentRoot(VirtualFile file2, ProjectFileIndex index2) {
        return file2.equals(index2.getContentRootForFile(file2));
    }

    protected abstract boolean checkPackageExists(PsiDirectory var1);

    @Nullable
    private T checkOrCreate(String newName2, PsiDirectory directory, String templateName) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        String className = this.removeExtension(templateName, newName2);
        if (className.contains(".")) {
            String[] names = className.split("\\.");
            for (int i2 = 0; i2 < names.length - 1; ++i2) {
                dir = CreateFileAction.findOrCreateSubdirectory(dir, names[i2]);
            }
            className = names[names.length - 1];
        }
        DumbService service2 = DumbService.getInstance(dir.getProject());
        PsiDirectory finalDir = dir;
        String finalClassName = className;
        return (T)service2.computeWithAlternativeResolveEnabled(() -> this.doCreate(finalDir, finalClassName, templateName));
    }

    protected String removeExtension(String templateName, String className) {
        String extension2 = StringUtil.getShortName(templateName);
        if (StringUtil.isNotEmpty(extension2)) {
            className = StringUtil.trimEnd(className, "." + extension2);
        }
        return className;
    }

    @Nullable
    protected abstract T doCreate(PsiDirectory var1, String var2, String var3) throws IncorrectOperationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateTemplateInPackageAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateTemplateInPackageAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 7 -> new IllegalStateException(string2);
        };
    }
}

