/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.AttachDirectoryUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DetachDirectoryAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            DetachDirectoryAction.$$$reportNull$$$0(0);
        }
        ProjectFileIndex index2 = (project2 = e.getProject()) == null ? null : ProjectFileIndex.getInstance(project2);
        JBIterable<VirtualFile> files2 = JBIterable.of((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        boolean enabled = index2 != null && files2.isNotEmpty() && files2.filter(o -> !o.equals(index2.getContentRootForFile((VirtualFile)o))).isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            e.getPresentation().setText(this.getTitle(files2.take(2).size()));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DetachDirectoryAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            DetachDirectoryAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        ProjectFileIndex index2 = ProjectFileIndex.getInstance(project2);
        List<VirtualFile> roots2 = JBIterable.of((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)).filter(o -> o.equals(index2.getContentRootForFile((VirtualFile)o))).toList();
        String target2 = AttachDirectoryUtils.getDisplayName(roots2);
        String message = IdeBundle.message((String)"detach.directory.dialog.message.detach.0", (Object[])new Object[]{target2});
        if (Messages.showOkCancelDialog((Project)project2, (String)message, (String)this.getConfirmDetachDialogTitle(), (String)IdeBundle.message((String)"detach.directory.dialog.button.detach", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) == 0) {
            DetachDirectoryAction.detachDirectoriesWithUndo(project2, roots2);
        }
    }

    @NlsSafe
    protected String getTitle(int directoriesAmount) {
        return IdeBundle.message((String)"detach.directory.action.text.detach.0", (Object[])new Object[]{directoriesAmount});
    }

    @NlsSafe
    protected String getConfirmDetachDialogTitle() {
        return IdeBundle.message((String)"detach.directory.dialog.title.detach", (Object[])new Object[0]);
    }

    public static void detachDirectoriesWithUndo(@NotNull Project project2, @NotNull List<? extends VirtualFile> files2) {
        if (project2 == null) {
            DetachDirectoryAction.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            DetachDirectoryAction.$$$reportNull$$$0(4);
        }
        AttachDirectoryUtils.addRemoveEntriesWithUndo(project2, null, files2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/DetachDirectoryAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/DetachDirectoryAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detachDirectoriesWithUndo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

