/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToLinkTargetAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GoToLinkTargetAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoToLinkTargetAction.$$$reportNull$$$0(0);
        }
        Project project2 = GoToLinkTargetAction.getEventProject((AnActionEvent)e);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabledAndVisible(project2 != null && GoToLinkTargetAction.underSymlink(file2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoToLinkTargetAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GoToLinkTargetAction.$$$reportNull$$$0(2);
        }
        Project project2 = GoToLinkTargetAction.getEventProject((AnActionEvent)e);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project2 != null && GoToLinkTargetAction.underSymlink(file2)) {
            VirtualFile target2 = file2.getCanonicalFile();
            PsiFileSystemItem psiFile = PsiUtilCore.findFileSystemItem(project2, target2);
            if (LOG.isDebugEnabled()) {
                LOG.debug(file2 + " -> " + target2 + " (" + psiFile + ")");
            }
            if (psiFile != null) {
                ProjectView.getInstance(project2).select(psiFile, target2, false);
            }
        }
    }

    private static boolean underSymlink(@Nullable VirtualFile file2) {
        return file2 != null && (file2.is(VFileProperty.SYMLINK) || GoToLinkTargetAction.underSymlink(file2.getParent()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GoToLinkTargetAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GoToLinkTargetAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

