/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance(GotoActionBase.class);
    protected static Class myInAction;
    private static final Map<Class, Pair<String, Integer>> ourLastStrings;
    private static final Map<Class, List<String>> ourHistory;
    private int myHistoryIndex;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoActionBase.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!((Object)((Object)this)).getClass().equals(myInAction), "Action should be disabled if it's already in progress: " + ((Object)((Object)this)).getClass());
        try {
            myInAction = ((Object)((Object)this)).getClass();
            List<String> strings2 = ourHistory.get(myInAction);
            this.myHistoryIndex = strings2 == null || strings2.size() <= 1 || !ourLastStrings.containsKey(myInAction) ? 0 : 1;
            this.gotoActionPerformed(e);
        }
        catch (ProcessCanceledException e1) {
            myInAction = null;
        }
        catch (Throwable t) {
            LOG.error(t);
            myInAction = null;
        }
    }

    protected abstract void gotoActionPerformed(@NotNull AnActionEvent var1);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GotoActionBase.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            GotoActionBase.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        boolean hasContributors = this.hasContributors(dataContext2);
        presentation2.setEnabled(!((Object)((Object)this)).getClass().equals(myInAction) && (!this.requiresProject() || project2 != null) && hasContributors);
        presentation2.setVisible(hasContributors);
    }

    protected boolean hasContributors(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            GotoActionBase.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected boolean requiresProject() {
        return true;
    }

    @Nullable
    public static PsiElement getPsiContext(AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file2 != null) {
            return file2;
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        return GotoActionBase.getPsiContext(project2);
    }

    @Nullable
    public static PsiElement getPsiContext(Project project2) {
        if (project2 == null) {
            return null;
        }
        Editor selectedEditor = FileEditorManager.getInstance(project2).getSelectedTextEditor();
        if (selectedEditor == null) {
            return null;
        }
        com.intellij.openapi.editor.Document document = selectedEditor.getDocument();
        return PsiDocumentManager.getInstance(project2).getPsiFile(document);
    }

    protected static Pair<String, Integer> getInitialText(boolean useEditorSelection, AnActionEvent e) {
        Pair<String, Integer> lastString;
        SpeedSearchSupply supply;
        String selectedText;
        String predefined = (String)e.getData(PlatformDataKeys.PREDEFINED_TEXT);
        if (!StringUtil.isEmpty(predefined)) {
            return Pair.create(predefined, 0);
        }
        if (useEditorSelection && (selectedText = GotoActionBase.getInitialTextForNavigation(e)) != null) {
            return new Pair<String, Integer>(selectedText, 0);
        }
        String query2 = (String)e.getData(PlatformDataKeys.SPEED_SEARCH_TEXT);
        if (!StringUtil.isEmpty(query2)) {
            return Pair.create(query2, 0);
        }
        Component focusOwner = IdeFocusManager.getInstance((Project)GotoActionBase.getEventProject((AnActionEvent)e)).getFocusOwner();
        if (focusOwner instanceof JComponent && (supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)focusOwner))) != null) {
            return Pair.create(supply.getEnteredPrefix(), 0);
        }
        if (myInAction != null && (lastString = ourLastStrings.get(myInAction)) != null) {
            return lastString;
        }
        return Pair.create("", 0);
    }

    @Nullable
    public static String getInitialTextForNavigation(@NotNull AnActionEvent e) {
        Editor editor2;
        String selectedText;
        if (e == null) {
            GotoActionBase.$$$reportNull$$$0(4);
        }
        String string2 = selectedText = (editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) != null ? editor2.getSelectionModel().getSelectedText() : null;
        if (selectedText == null) {
            selectedText = (String)e.getData(JBTerminalWidget.SELECTED_TEXT_DATA_KEY);
        }
        return selectedText != null && !selectedText.contains("\n") ? selectedText : null;
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback) {
        this.showNavigationPopup(e, model2, callback, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback, boolean allowMultipleSelection) {
        this.showNavigationPopup(e, model2, callback, null, true, allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor) {
        this.showNavigationPopup(e, model2, callback, findUsagesTitle, useSelectionFromEditor, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection) {
        this.showNavigationPopup(e, model2, callback, findUsagesTitle, useSelectionFromEditor, allowMultipleSelection, ChooseByNameModelEx.getItemProvider(model2, GotoActionBase.getPsiContext(e)));
    }

    @Deprecated(forRemoval=true)
    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection, DefaultChooseByNameItemProvider itemProvider) {
        this.showNavigationPopup(e, model2, callback, findUsagesTitle, useSelectionFromEditor, allowMultipleSelection, (ChooseByNameItemProvider)itemProvider);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection, ChooseByNameItemProvider itemProvider) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean mayRequestOpenInCurrentWindow = model2.willOpenEditor() && FileEditorManagerEx.getInstanceEx((Project)project2).hasSplitOrUndockedWindows();
        Pair<String, Integer> start = GotoActionBase.getInitialText(useSelectionFromEditor, e);
        ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(project2, model2, itemProvider, (String)start.first, mayRequestOpenInCurrentWindow, (int)((Integer)start.second));
        this.showNavigationPopup(callback, findUsagesTitle, popup2, allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(GotoActionCallback<T> callback, @Nullable @Nls String findUsagesTitle, ChooseByNamePopup popup2) {
        this.showNavigationPopup(callback, findUsagesTitle, popup2, true);
    }

    protected <T> void showNavigationPopup(final GotoActionCallback<T> callback, @Nullable @Nls String findUsagesTitle, final ChooseByNamePopup popup2, boolean allowMultipleSelection) {
        final Class startedAction = myInAction;
        LOG.assertTrue(startedAction != null);
        popup2.setCheckBoxShortcut(this.getShortcutSet());
        popup2.setFindUsagesTitle(findUsagesTitle);
        final ChooseByNameFilter<T> filter2 = callback.createFilter(popup2);
        if (GotoActionBase.historyEnabled() && popup2.getAdText() == null) {
            popup2.setAdText(IdeBundle.message((String)"searcheverywhere.history.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE)}));
        }
        popup2.invoke(new ChooseByNamePopupComponent.Callback(){

            @Override
            public void onClose() {
                if (startedAction != null && startedAction.equals(myInAction)) {
                    String text2 = popup2.getEnteredText();
                    ourLastStrings.put(myInAction, Pair.create(text2, popup2.getSelectedIndex()));
                    this.updateHistory(text2);
                    myInAction = null;
                }
                if (filter2 != null) {
                    filter2.close();
                }
            }

            private void updateHistory(@Nullable String text2) {
                if (!StringUtil.isEmptyOrSpaces(text2)) {
                    List<String> history = ourHistory.get(myInAction);
                    if (history == null) {
                        history = new ArrayList<String>();
                    }
                    if (!text2.equals(ContainerUtil.getFirstItem(history))) {
                        history.add(0, text2);
                    }
                    ourHistory.put(myInAction, history);
                }
            }

            @Override
            public void elementChosen(Object element) {
                callback.elementChosen(popup2, element);
            }
        }, ModalityState.current(), allowMultipleSelection);
        final JTextField editor2 = popup2.getTextField();
        final DocumentAdapter historyResetListener = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                GotoActionBase.this.myHistoryIndex = 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$2", "textChanged"));
            }
        };
        editor2.getDocument().addDocumentListener(historyResetListener);
        abstract class HistoryAction
        extends DumbAwareAction {
            final /* synthetic */ JTextField val$editor;
            final /* synthetic */ DocumentAdapter val$historyResetListener;

            HistoryAction() {
                this.val$editor = jTextField;
                this.val$historyResetListener = documentAdapter;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    HistoryAction.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(GotoActionBase.historyEnabled());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    HistoryAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            void setText(@NotNull List<String> strings2) {
                String text2;
                if (strings2 == null) {
                    HistoryAction.$$$reportNull$$$0(2);
                }
                if (Objects.equals(text2 = strings2.get(GotoActionBase.this.myHistoryIndex), this.val$editor.getText())) {
                    return;
                }
                Document document = this.val$editor.getDocument();
                document.removeDocumentListener(this.val$historyResetListener);
                this.val$editor.setText(text2);
                document.addDocumentListener(this.val$historyResetListener);
                this.val$editor.selectAll();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/GotoActionBase$1HistoryAction";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "strings";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/GotoActionBase$1HistoryAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setText";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }
        new HistoryAction(){
            {
                super(GotoActionBase.this, jTextField, documentAdapter);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                List<String> strings2 = ourHistory.get(myInAction);
                this.setText(strings2);
                GotoActionBase.this.myHistoryIndex = GotoActionBase.this.myHistoryIndex >= strings2.size() - 1 ? 0 : GotoActionBase.this.myHistoryIndex + 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$3", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)SearchTextField.ALT_SHOW_HISTORY_SHORTCUT, editor2);
        new HistoryAction(){
            {
                super(GotoActionBase.this, jTextField, documentAdapter);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                List<String> strings2 = ourHistory.get(myInAction);
                this.setText(strings2);
                GotoActionBase.this.myHistoryIndex = GotoActionBase.this.myHistoryIndex <= 0 ? strings2.size() - 1 : GotoActionBase.this.myHistoryIndex - 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$4", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)SearchTextField.SHOW_HISTORY_SHORTCUT, editor2);
    }

    private static boolean historyEnabled() {
        return !ContainerUtil.isEmpty((Collection)ourHistory.get(myInAction));
    }

    static {
        ourLastStrings = new HashMap<Class, Pair<String, Integer>>();
        ourHistory = new HashMap<Class, List<String>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoActionBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoActionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasContributors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInitialTextForNavigation";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    protected static abstract class GotoActionCallback<T> {
        protected GotoActionCallback() {
        }

        @Nullable
        protected ChooseByNameFilter<T> createFilter(@NotNull ChooseByNamePopup popup2) {
            if (popup2 == null) {
                GotoActionCallback.$$$reportNull$$$0(0);
            }
            return null;
        }

        public abstract void elementChosen(ChooseByNamePopup var1, Object var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoActionBase$GotoActionCallback", "createFilter"));
        }
    }
}

